<?php
/**
 * @Packge     : consua
 * @Version    : 1.0
 * @Author     : consua
 * @Author URI : https://themeforest.net/user/validthemes/portfolio
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) && defined('ELEMENTOR_VERSION') ) {
        if( is_page() || is_page_template('template-builder.php') ) {
            $consua_post_id = get_the_ID();

            // Get the page settings manager
            $consua_page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

            // Get the settings model for current post
            $consua_page_settings_model = $consua_page_settings_manager->get_model( $consua_post_id );

            // Retrieve the color we added before
            $consua_header_style = $consua_page_settings_model->get_settings( 'consua_header_style' );
            $consua_header_builder_option = $consua_page_settings_model->get_settings( 'consua_header_builder_option' );

            if( $consua_header_style == 'header_builder'  ) {

                if( !empty( $consua_header_builder_option ) ) {
                    $consuaheader = get_post( $consua_header_builder_option );
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $consuaheader->ID );
                }
            } else {
                // global options
                $consua_header_builder_trigger = consua_opt('consua_header_options');
                if( $consua_header_builder_trigger == '2' ) {
                    $consua_global_header_select = get_post( consua_opt( 'consua_header_select_options' ) );
                    $header_post = get_post( $consua_global_header_select );
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $header_post->ID );
                } else {
                    // wordpress Header
                    consua_global_header_option();
                }
            }
        } else {
            $consua_header_options = consua_opt('consua_header_options');
            if( $consua_header_options == '1' ) {
                consua_global_header_option();
            } else {
                $consua_header_select_options = consua_opt('consua_header_select_options');
                $consuaheader = get_post( $consua_header_select_options );
                echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $consuaheader->ID );
            }
        }
    } else {
        consua_global_header_option();
    }