<?php

/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */

 /**
 * Only return default value if we don't have a post ID (in the 'post' query variable)
 *
 * @param  bool  $default On/Off (true/false)
 * @return mixed          Returns true or '', the blank default
 */
function consua_set_checkbox_default_for_new_post( $default ) {
	return isset( $_GET['post'] ) ? '' : ( $default ? (string) $default : '' );
}

add_action( 'cmb2_admin_init', 'consua_register_metabox' );

/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_admin_init' or 'cmb2_init' hook.
 */

function consua_register_metabox() {

	$prefix = '_consua_';

	$prefixpage = '_consuapage_';
	
	$consua_service_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'service_page_control',
		'title'         => esc_html__( 'Service Page Controller', 'consua' ),
		'object_types'  => array( 'carvis_service' ), // Post type
		'closed'        => true
	) );
	$consua_service_meta->add_field( array(
		'name' => esc_html__( 'Write Flaticon Class', 'consua' ),
	   	'desc' => esc_html__( 'Write Flaticon Class For The Icon', 'consua' ),
	   	'id'   => $prefix . 'flat_icon_class',
		'type' => 'text',
    ) );
	
	$consua_post_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'blog_post_control',
		'title'         => esc_html__( 'Post Thumb Controller', 'consua' ),
		'object_types'  => array( 'post' ), // Post type
		'closed'        => true
	) );
	$consua_post_meta->add_field( array(
		'name' => esc_html__( 'Post Format Video', 'consua' ),
		'desc' => esc_html__( 'Use This Field When Post Format Video', 'consua' ),
		'id'   => $prefix . 'post_format_video',
        'type' => 'text_url',
    ) );
	$consua_post_meta->add_field( array(
		'name' => esc_html__( 'Post Format Audio', 'consua' ),
		'desc' => esc_html__( 'Use This Field When Post Format Audio', 'consua' ),
		'id'   => $prefix . 'post_format_audio',
        'type' => 'oembed',
    ) );
	$consua_post_meta->add_field( array(
		'name' => esc_html__( 'Post Thumbnail For Slider', 'consua' ),
		'desc' => esc_html__( 'Use This Field When You Want A Slider In Post Thumbnail', 'consua' ),
		'id'   => $prefix . 'post_format_slider',
        'type' => 'file_list',
    ) );
	
	$consua_page_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'page_meta_section',
		'title'         => esc_html__( 'Page Meta', 'consua' ),
		'object_types'  => array( 'page' ), // Post type
        'closed'        => true
    ) );


    $consua_page_meta->add_field( array(
		'name' => esc_html__( 'Page Variant', 'consua' ),
		'id'   => $prefix . 'page_variant',
        'type' => 'select',
        'default' => '0',
        'options'   => array(
            '0'   => esc_html__( 'Default', 'consua' ),
            '1'   => esc_html__( 'Solar Energy', 'consua' ),
        )
	) );

    $consua_page_meta->add_field( array(
		'name' => esc_html__( 'Page Breadcrumb Area', 'consua' ),
		'desc' => esc_html__( 'check to display page breadcrumb area.', 'consua' ),
		'id'   => $prefix . 'page_breadcrumb_area',
        'type' => 'select',
        'default' => '1',
        'options'   => array(
            '1'   => esc_html__('Show','consua'),
            '2'     => esc_html__('Hide','consua'),
        )
    ) );


    $consua_page_meta->add_field( array(
		'name' => esc_html__( 'Page Breadcrumb Settings', 'consua' ),
		'id'   => $prefix . 'page_breadcrumb_settings',
        'type' => 'select',
        'default'   => 'global',
        'options'   => array(
            'global'   => esc_html__( 'Global Settings', 'consua' ),
            'page'     => esc_html__( 'Page Settings', 'consua' ),
        )
	) );
	
	$consua_page_meta->add_field( array(
	    'name'    => esc_html__( 'Breadcumb Image', 'consua' ),
	    'desc'    => esc_html__( 'Upload an image or enter an URL.', 'consua' ),
	    'id'      => $prefix . 'breadcumb_image',
	    'type'    => 'file',
	    // Optional:
	    'options' => array(
	        'url' => false, // Hide the text input for the url
	    ),
	    'text'    => array(
	        'add_upload_file_text' => __( 'Add File', 'consua' ) // Change upload button text. Default: "Add or Upload File"
	    ),
	    'preview_size' => 'large', // Image size to use when previewing in the admin.
	) );
	
    $consua_page_meta->add_field( array(
		'name' => esc_html__( 'Page Title', 'consua' ),
		'desc' => esc_html__( 'check to display Page Title.', 'consua' ),
		'id'   => $prefix . 'page_title',
        'type' => 'select',
        'default' => '1',
        'options'   => array(
            '1'   	=> esc_html__( 'Show','consua'),
            '2'     => esc_html__( 'Hide','consua'),
        )
	) );

    $consua_page_meta->add_field( array(
		'name' => esc_html__( 'Page Title Settings', 'consua' ),
		'id'   => $prefix . 'page_title_settings',
        'type' => 'select',
        'options'   => array(
            'default'  => esc_html__('Default Title','consua'),
            'custom'  => esc_html__('Custom Title','consua'),
        ),
        'default'   => 'default'
    ) );

    $consua_page_meta->add_field( array(
		'name' => esc_html__( 'Custom Page Title', 'consua' ),
		'id'   => $prefix . 'custom_page_title',
        'type' => 'text'
    ) );

    $consua_page_meta->add_field( array(
		'name' => esc_html__( 'Breadcrumb', 'consua' ),
		'desc' => esc_html__( 'Select Show to display breadcrumb area', 'consua' ),
		'id'   => $prefix . 'page_breadcrumb_trigger',
        'type' => 'switch_btn',
        'default' => consua_set_checkbox_default_for_new_post( true ),
    ) );

    $consua_layout_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'page_layout_section',
		'title'         => esc_html__( 'Page Layout', 'consua' ),
        'context' 		=> 'side',
        'priority' 		=> 'high',
        'object_types'  => array( 'page' ), // Post type
        'closed'        => true
	) );

	$consua_layout_meta->add_field( array(
		'desc'       => esc_html__( 'Set page layout container,container fluid,fullwidth or both. It\'s work only in template builder page.', 'consua' ),
		'id'         => $prefix . 'custom_page_layout',
		'type'       => 'radio',
        'options' => array(
            '1' => esc_html__( 'Container', 'consua' ),
            '2' => esc_html__( 'Container Fluid', 'consua' ),
            '3' => esc_html__( 'Fullwidth', 'consua' ),
        ),
	) );

	$consua_product_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'product_meta_section',
		'title'         => esc_html__( 'Swap Image', 'consua' ),
		'object_types'  => array( 'product' ), // Post type
		'closed'        => true,
		'context'		=> 'side',
		'priority'		=> 'default'
	) );

	$consua_product_meta->add_field( array(
		'name' 		=> esc_html__( 'Product Swap Image', 'consua' ),
		'desc' 		=> esc_html__( 'Set Product Swap Image', 'consua' ),
		'id'   		=> $prefix.'product_swap_image',
		'type'    	=> 'file',
		// Optional:
		'options' 	=> array(
			'url' 		=> false, // Hide the text input for the url
		),
		'text'    	=> array(
			'add_upload_file_text' => __( 'Add Swap Image', 'consua' ) // Change upload button text. Default: "Add or Upload File"
		),
	) );
}

add_action( 'cmb2_admin_init', 'consua_register_taxonomy_metabox' );
/**
 * Hook in and add a metabox to add fields to taxonomy terms
 */
function consua_register_taxonomy_metabox() {

    $prefix = '_consua_';
	/**
	 * Metabox to add fields to categories and tags
	 */
	$consua_term_meta = new_cmb2_box( array(
		'id'               => $prefix.'term_edit',
		'title'            => esc_html__( 'Category Metabox', 'consua' ),
		'object_types'     => array( 'term' ),
		'taxonomies'       => array( 'category'),
	) );
	$consua_term_meta->add_field( array(
		'name'     => esc_html__( 'Extra Info', 'consua' ),
		'id'       => $prefix.'term_extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );
	$consua_term_meta->add_field( array(
		'name' => esc_html__( 'Category Image', 'consua' ),
		'desc' => esc_html__( 'Set Category Image', 'consua' ),
		'id'   => $prefix.'term_avatar',
        'type' => 'file',
        'text'    => array(
			'add_upload_file_text' => esc_html__('Add Image','consua') // Change upload button text. Default: "Add or Upload File"
		),
	) );


	/**
	 * Metabox for the user profile screen
	 */
	$consua_user = new_cmb2_box( array(
		'id'               => $prefix.'user_edit',
		'title'            => esc_html__( 'User Profile Metabox', 'consua' ), // Doesn't output for user boxes
		'object_types'     => array( 'user' ), // Tells CMB2 to use user_meta vs post_meta
		'show_names'       => true,
		'new_user_section' => 'add-new-user', // where form will show on new user page. 'add-existing-user' is only other valid option.
	) );
	$consua_user->add_field( array(
		'name'     => esc_html__( 'Social Profile', 'consua' ),
		'id'       => $prefix.'user_extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );

	$group_field_id = $consua_user->add_field( array(
        'id'          => $prefix .'social_profile_group',
        'type'        => 'group',
        'description' => __( 'Social Profile', 'consua' ),
        'options'     => array(
            'group_title'       => __( 'Social Profile {#}', 'consua' ), // since version 1.1.4, {#} gets replaced by row number
            'add_button'        => __( 'Add Another Social Profile', 'consua' ),
            'remove_button'     => __( 'Remove Social Profile', 'consua' ),
            'closed'         => true
        ),
    ) );

    $consua_user->add_group_field( $group_field_id, array(
        'name'        => __( 'Select Icon', 'consua' ),
        'id'          => $prefix .'social_profile_icon',
        'type'        => 'fontawesome_icon', // This field type
    ) );

    $consua_user->add_group_field( $group_field_id, array(
        'desc'       => esc_html__( 'Set social profile link.', 'consua' ),
        'id'         => $prefix . 'lawyer_social_profile_link',
        'name'       => esc_html__( 'Social Profile link', 'consua' ),
        'type'       => 'text'
    ) );
}