<?php

/**
 * @Packge     : consua
 * @Version    : 1.0
 * @Author     : consua
 * @Author URI : https://themeforest.net/user/validthemes/portfolio
 *
 */

// Block direct access
if (!defined('ABSPATH')) {
    exit();
}

if (class_exists('ReduxFramework')) {
    $consua404title        = consua_opt('consua_fof_title');
    $consua404subtitle     = consua_opt('consua_fof_subtitle');
    $consua404description  = consua_opt('consua_fof_description');
    $consua404btntext      = consua_opt('consua_fof_btn_text');
} else {
    $consua404title        = __('404', 'consua');
    $consua404subtitle     = __('Oops! That page can’t be found', 'consua');
    $consua404description  = __('Sorry, but the page you are looking for does not existing', 'consua');
    $consua404btntext      = __('Back To Home', 'consua');
}

global $consua_opt;

// get header
get_header();

echo '<div class="error-page-area text-center default-padding">';
if (!empty($consua_opt['consua_404_shape_one']['url'])) :
    echo '<div class="shape-left" style="background: url(' . $consua_opt['consua_404_shape_one']['url'] . ');"></div>';
endif;
if (!empty($consua_opt['consua_404_shape_two']['url'])) :
    echo '<div class="shape-right" style="background: url(' . $consua_opt['consua_404_shape_two']['url'] . ');"></div>';
endif;
echo '<div class="container">';
    echo '<div class="row align-center">';
        echo '<div class="col-lg-8 offset-lg-2">';
            echo '<div class="error-box">';
                echo '<h1>' . esc_html($consua404title) . '</h1>';
                    echo '<h2>' . esc_html($consua404subtitle) . '</h2>';
                    echo '<p>' . esc_html($consua404description) . '</p>';
                    echo '<a class="btn circle btn-theme effect btn-md" href="' . esc_url(home_url('/')) . '">' . esc_html($consua404btntext) . '</a>';
                    echo '</div>';
            echo '</div>';
        echo '</div>';
    echo '</div>';
echo '</div>';

//footer
get_footer();
