<?php
/**
 * The template for displaying product widget entries.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-widget-product.php.
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.5
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;

if ( ! is_a( $product, 'WC_Product' ) ) {
	return;
}

?>
<li class="clearfix">
    <?php do_action( 'woocommerce_widget_product_item_start', $args ); ?>
        <div class="product_widget_item">
            <div class="widproThumb">
                <img src="<?php echo bepro_post_thumbnail($product->get_id(), 65, 70); ?>" alt="<?php the_title_attribute() ?>">
            </div>
            <div class="widProContent">
                <?php if ( $product->get_average_rating() > 0 ) : ?>
                <div class="ratings">
                    <?php echo wc_get_rating_html( $product->get_average_rating() ); ?>
                </div>
                <?php endif; ?>
                <h3><a href="<?php echo esc_url($product->get_permalink()); ?>"><?php echo substr(wp_strip_all_tags($product->get_name()), 0, 14); ?></a></h3>
                <div class="pi01Price clearfix">
                    <?php echo bepro_kses($product->get_price_html()); ?>
                </div>
            </div>
        </div>
    <?php do_action( 'woocommerce_widget_product_item_end', $args ); ?>
</li>
