<?php
$blog_view       = get_theme_mod('blog_view', 1);
$blog_sidebar    = get_theme_mod('blog_sidebar', 3);
$blog_str_limit  = get_theme_mod('blog_str_limit', 227);


$blog_readmore  = get_theme_mod('blog_readmore_label', esc_html__('See More', 'bepro'));

$blog_sidebar = ($blog_sidebar == 1 || !is_active_sidebar('sidebar-1') ? '1' : $blog_sidebar);

$post_category = get_the_category();

if($blog_sidebar == 1){
    $col = 'col-lg-4 col-md-6'; 
}else {
   $col = 'col-lg-6 col-md-6'; 
}

$dateFormat = (get_option('date_format') != '' ? get_option('date_format') : 'j M, Y');

if($blog_view == 2):
?>
<div class="col-md-12">
    <div class="blogItem02 bireverse">
        <div class="row d-flex align-items-center">
            <div class="col-lg-8">
                <div class="blogThumb02">
                    <a class="bmeta" href="<?php echo get_the_permalink(); ?>"><i class="twi-clock1"></i><?php echo get_the_time('j M, Y'); ?></a>
                    <img src="<?php echo bepro_post_thumbnail(get_the_ID(), 776, 362); ?>" alt="<?php the_title_attribute() ?>">
                </div>
            </div>
            <div class="col-lg-4">
                <div class="blogContent">
                    <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
                    <?php if($blog_str_limit > 0): ?>
                        <p>
                            <?php 
                                echo substr(wp_strip_all_tags(get_the_excerpt()), 0, $blog_str_limit);
                            ?>
                        </p>
                    <?php endif; ?>
                    <?php if($blog_readmore != ''): ?>
                        <a class="berpo_btn with_icon" href="<?php echo get_the_permalink(); ?>">
                            <span class="bp-shape"></span>
                            <span class="bp-shape"></span>
                            <span class="bp-shape"></span>
                            <span class="bp-shape"></span>
                            <span class="bp-text"><?php echo wp_kses_post($blog_readmore); ?> <i class="twi-arrow-right"></i></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php elseif($blog_view == 3): ?>
<div class="col-md-12">
    <div class="blogItem06">
        <div class="row">
            <div class="col-lg-6">
                <div class="blogThumb02">
                    <img src="<?php echo bepro_post_thumbnail(get_the_ID(), 592, 592); ?>" alt="<?php the_title_attribute() ?>">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="blogContent">
                    <p class="pmeta"><a class="cat" href="<?php echo esc_url(get_category_link($post_category[0]->term_id)); ?>"><?php echo esc_html($post_category[0]->name); ?></a>  /  <?php echo get_the_time('M j, Y'); ?>  <?php echo esc_html__('/  By', 'bepro'); ?> <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><?php echo get_the_author(); ?></a></p>
                    <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
                    <?php if($blog_str_limit > 0): ?>
                        <p>
                            <?php 
                                echo substr(wp_strip_all_tags(get_the_excerpt()), 0, $blog_str_limit);
                            ?>
                        </p>
                    <?php endif; ?>
                    <?php if($blog_readmore != ''): ?>
                        <a class="berpo_btn with_icon04" href="<?php echo get_the_permalink(); ?>">
                            <span class="bp-shape"></span>
                            <span class="bp-shape"></span>
                            <span class="bp-shape"></span>
                            <span class="bp-shape"></span>
                            <span class="bp-text"><?php echo wp_kses_post($blog_readmore); ?> <i class="twi-arrow-right"></i></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php elseif($blog_view == 4): 
if($blog_sidebar != 1){
    $c = 'col-lg-12'; 
    $w = 797;
    $h = 465;
}else{
    $c = 'col-lg-9'; 
    $w = 901;
    $h = 528;
}
?>
<div class="<?php echo esc_attr($c); ?>">
    <div class="blogItem03">
        <img src="<?php echo bepro_post_thumbnail(get_the_ID(), $w, $h); ?>" alt="<?php the_title_attribute() ?>">
        <div class="blogContent02">
            <p class="bmeta"><i class="twi-calendar-alt1"></i></i><?php echo get_the_time('F j, Y'); ?> <?php echo esc_html__('/ By', 'bepro'); ?> <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><?php echo get_the_author(); ?></a></p>
            <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
        </div>
        <?php if($blog_readmore != ''): ?>
            <a class="berpo_btn with_icon03" href="<?php echo get_the_permalink(); ?>"><?php echo wp_kses_post($blog_readmore); ?><i class="twi-arrow-right1"></i></a>
        <?php endif; ?>
    </div>
</div>
<?php elseif($blog_view == 5): ?>
<div class="<?php echo esc_attr($col); ?>">
    <div class="blogItem01">
        <div class="blogThumb">
            <img src="<?php echo bepro_post_thumbnail(get_the_ID(), 386, 241); ?>" alt="<?php the_title_attribute() ?>">
        </div>
        <div class="blogContent">
            <a class="bmeta" href="<?php echo get_the_permalink(); ?>"><i class="twi-calendar-alt1"></i><?php echo get_the_time('j F, Y'); ?></a>
            <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
            <div class="bpcon">
                <a class="author" href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><img src="<?php echo esc_url(bepro_get_author_avater_url(get_the_author_meta('ID'))); ?>" alt="<?php echo get_the_author(); ?>"><?php echo get_the_author(); ?></a>
                <a href="<?php echo get_the_permalink(); ?>"><i class="twi-comment2"></i></a>
            </div>
        </div>
    </div>
</div>
<?php elseif($blog_view == 6): ?>
<div class="<?php echo esc_attr($col); ?>">
    <div class="blogItem04">
        <img src="<?php echo bepro_post_thumbnail(get_the_ID(), 386, 241); ?>" alt="<?php the_title_attribute() ?>">
        <div class="blogContent03">
            <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
            <div class="bmeta"><a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><i class="twi-user1"></i><?php echo get_the_author(); ?></a><span><?php echo human_time_diff(get_the_time('U'), current_time( 'U' )).' '.esc_html__('ago', 'bepro'); ?></span></div>
            <?php if($blog_str_limit > 0): ?>
                <p class="pcon">
                    <?php 
                        echo substr(wp_strip_all_tags(get_the_excerpt()), 0, $blog_str_limit);
                    ?>
                </p>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php elseif($blog_view == 7): ?>
<div class="<?php echo esc_attr($col); ?>">
    <div class="blogItem05">
        <div class="blogThumb">
            <img src="<?php echo bepro_post_thumbnail(get_the_ID(), 386, 242); ?>" alt="<?php the_title_attribute() ?>">
        </div>
        <div class="blogContent04">
            <a class="bmeta" href="<?php echo get_the_permalink(); ?>"><i class="twi-calendar-alt1"></i><?php echo get_the_time('j M, Y'); ?></a>
            <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
            <?php if($blog_str_limit > 0): ?>
                <p class="pcon">
                    <?php 
                        echo substr(wp_strip_all_tags(get_the_excerpt()), 0, $blog_str_limit);
                    ?>
                </p>
            <?php endif; ?>
            <a class="rmb" href="<?php echo get_the_permalink(); ?>"><i class="twi-long-arrow-right1"></i></a>
        </div>
    </div>
</div>
<?php else:  
if($blog_sidebar != 1){
    $c = 'col-lg-12'; 
    $w = 797;
    $h = 465;
}else{
    $c = 'col-lg-9'; 
    $w = 906;
    $h = 525;
}
?>
<div class="<?php echo esc_attr($c); ?>">
    <div class="blogList01 bil <?php if(is_sticky()){ echo 'featured_post';} ?> <?php if(!has_post_thumbnail()): ?>noThumb<?php endif; ?>">
        <?php if(has_post_thumbnail()): ?>
            <img src="<?php echo bepro_post_thumbnail(get_the_ID(), $w, $h); ?>" alt="<?php the_title_attribute() ?>">
        <?php endif; ?>
        <div class="listCon">
            <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
            <div class="bmeta"><a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><i class="twi-user1"></i><?php echo get_the_author(); ?></a>/<?php if(get_post_type( get_the_ID() ) == 'product'): $product = wc_get_product(get_the_ID() ); echo '<span class="price">'.bepro_kses($product->get_price_html()).'</span>';
            else: ?><span><?php echo get_the_time($dateFormat); ?></span><?php endif; ?></div>
            <?php if($blog_str_limit > 0): ?>
                <p>
                    <?php 
                        echo substr(wp_strip_all_tags(get_the_excerpt()), 0, $blog_str_limit);
                    ?>
                </p>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php endif; ?>