<?php
/**
 * Displays Defeault header navigation
 */

$header_is_topbar = get_theme_mod('header_is_topbar', 2);

$header_info_boxes   = get_theme_mod('header_info_boxes', array());
$header_social_links = get_theme_mod('header_social_links', array());

$header_is_search = get_theme_mod('header_is_search', 2);
$header_is_cart   = get_theme_mod('header_is_cart', 2);

$header_is_btn    = get_theme_mod('header_is_btn', 2);
$btn_label        = get_theme_mod('btn_label', esc_html__('Get A Quote', 'bepro'));
$btn_url          = get_theme_mod('btn_url', '');

$header_is_sticky = get_theme_mod('header_is_sticky', 2);
$header_logo      = get_theme_mod('header_logo', '');

$right = '';
if ($header_is_cart != 1 && $header_is_search != 1 && $header_is_btn != 1) {
    $right = 'dRight';
}

?>
<?php if ($header_is_topbar == 1): ?>
    <!-- Header Topbar -->
    <section class="topbar01">
        <div class="container largeContainer">
            <div class="row">
                <div class="col-md-9">
                    <?php if (is_array($header_info_boxes) && !empty($header_info_boxes)): ?>
                        <?php foreach ($header_info_boxes as $key => $item): ?>
                            <p><i class="<?php echo esc_attr($item['info_box_type']) ?>"></i><?php echo esc_html($item['info_box_content']) ?></p>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                <div class="col-md-3">
                    <?php if (is_array($header_social_links) && !empty($header_social_links)): ?>
                        <div class="topsocial">
                            <?php foreach ($header_social_links as $key => $item): ?>
                                <a href="<?php echo esc_url($item['social_url']) ?>"><i class="<?php echo esc_attr($item['social_profile']) ?>"></i></a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    <!-- Header Topbar -->
<?php endif; ?>
<!-- Header Start -->
<header class="header01 <?php if ($header_is_topbar != 1): ?>noTp<?php endif; ?> <?php echo esc_attr($header_is_sticky == 1 ? 'isSticky' : ''); ?>">
    <div class="container largeContainer">
        <div class="row">
            <div class="col-lg-12">
                <div class="navbar01 <?php echo esc_attr($right); ?>">
                    <div class="logo">
                        <?php if (!empty($header_logo)): ?>
                            <a href="<?php echo esc_url(home_url('/')); ?>">
                                <img src="<?php echo esc_url($header_logo); ?>" alt="<?php echo get_bloginfo(); ?>"/>
                            </a>
                        <?php else: ?>
                            <a class="text" href="<?php echo esc_url(home_url('/')); ?>"><?php echo get_bloginfo('name'); ?></a>
                        <?php endif; ?>
                    </div>
                    <a href="javascript:void(0)" class="menu_btn"><i class="twi-bars2"></i></a>
                    <nav class="mainMenu">
                        <?php
                        if (has_nav_menu('primary-menu')) {
                            wp_nav_menu(array(
                                'theme_location' => 'primary-menu',
                                'container'      => FALSE,
                                'menu_class'     => '',
                                'menu_id'        => '',
                                'echo'           => true
                            ));
                        } else {
                            echo '<ul>';
                                echo '<li><a href="javascript:void(0)">' . esc_html__('No Menu', 'bepro') . '</a></li>';
                            echo '</ul>';
                        }
                        ?>
                    </nav>
                    <?php if ($header_is_cart == 1 || $header_is_search == 1 || $header_is_btn == 1): ?>
                    <div class="accessNav">
                        <?php if($header_is_search == 1): ?>
                            <a class="search_btn" href="javascript:void(0);"><i class="twi-search1"></i></a>
                        <?php endif; ?>
                        <?php if ($header_is_cart == 1 && class_exists('woocommerce')): global $woocommerce; ?>
                            <div class="shoping_cart">
                                <a class="cartBtn bepro_aj_cart" href="javascript:void(0);"><i class="twi-shopping-bag1"></i><span><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'bepro'), $woocommerce->cart->cart_contents_count); ?></span></a>
                                <div class="show_cart_area">
                                    <div class="mini_cart widget_shopping_cart_content">
                                        <?php
                                        if (function_exists('woocommerce_mini_cart')):
                                            woocommerce_mini_cart();
                                        endif;
                                        ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if($header_is_btn == 1): ?>
                            <a class="berpo_btn" href="<?php echo esc_url($btn_url); ?>">
                                <span class="bp-shape"></span>
                                <span class="bp-shape"></span>
                                <span class="bp-shape"></span>
                                <span class="bp-shape"></span>
                                <span class="bp-text"><?php echo esc_html($btn_label) ?></span>
                            </a>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- Header End -->
<?php if($header_is_search == 1): ?>
<!-- Search Popup Start -->
<section class="popup_search_sec">
    <div class="popup_search_overlay"></div>
    <div class="pop_search_background">
        <div class="middle_search">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 text-center">
                        <div class="popup_search_form">
                            <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                                <input type="search" name="s" value="<?php echo get_search_query(); ?>" placeholder="<?php echo esc_attr_x( 'Type Words and Hit Enter', 'placeholder', 'bepro' ); ?>">
                                <button type="submit"><i class="twi-search1"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Search Popup End -->
<?php endif; ?>