<?php
    $folio_single_banner_title          = get_theme_mod('folio_single_banner_title', get_the_title());
    $folio_single_is_breadcrumb         = get_theme_mod('folio_single_is_breadcrumb', 1);
    $folio_single_banner_alignment      = get_theme_mod('folio_single_banner_alignment', 'center');
    $folio_single_banner_title          = ($folio_single_banner_title != '' ? $folio_single_banner_title : get_the_title());
    
    $obc_css = '';
    $bgi_css = '';
    $bgc_css = '';
    if(defined('FW')):
        $srv_is_settings = fw_get_db_post_option(get_the_ID(), 'srv_is_settings', 2);
    
        $fls_banner_bg          = fw_get_db_post_option(get_the_ID(), 'fls_banner_bg', array());
        $fls_banner_color       = fw_get_db_post_option(get_the_ID(), 'fls_banner_color', '');
        $fls_banner_overlay     = fw_get_db_post_option(get_the_ID(), 'fls_banner_overlay', '');
        $fls_banner_title       = fw_get_db_post_option(get_the_ID(), 'fls_banner_title', '');
        $fls_is_breadcrumb      = fw_get_db_post_option(get_the_ID(), 'fls_is_breadcrumb', 1);
        $fls_banner_alignment   = fw_get_db_post_option(get_the_ID(), 'fls_banner_alignment', 'center');
        
        if($srv_is_settings == 1):
            $folio_single_banner_title = ($fls_banner_title != '' ? $fls_banner_title : $folio_single_banner_title);
            $folio_single_is_breadcrumb = ($fls_is_breadcrumb > 0 ? $fls_is_breadcrumb : $folio_single_is_breadcrumb);
            $folio_single_banner_alignment   = ($fls_banner_alignment != '' ? $fls_banner_alignment : $folio_single_banner_alignment);
            
            if(isset($fls_banner_bg['url']) && $fls_banner_bg['url'] != ''):
                $bgi_css = 'background-image: url('.$fls_banner_bg['url'].');';
            endif;
            if(isset($fls_banner_color) && $fls_banner_color != ''):
                $bgc_css = 'background-color: '.$fls_banner_color.';';
            endif;
            if(isset($fls_banner_overlay) && $fls_banner_overlay != ''):
                $obc_css = 'background: '.$fls_banner_overlay.';';
            endif;
        endif;
    endif;
    
    ?>
    <!-- Begin:: Banner Section -->
    <section class="page_banner folio_single_banner" style="<?php echo esc_attr($bgi_css.$bgc_css) ?>">
        <div class="overlay" style="<?php echo esc_attr($obc_css) ?>"></div>
        <div class="container largeContainer">
            <div class="row">
                <div class="col-md-12 text-<?php echo esc_attr($folio_single_banner_alignment); ?>">
                    <h2 class="banner-title"><?php echo esc_html($folio_single_banner_title); ?></h2>
                    <?php if($folio_single_is_breadcrumb == 1): ?>
                        <?php echo bepro_kses(bepro_breadcrumbs()); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    <!-- End:: Banner Section -->