<?php
    $folio_cat_banner_title         = get_theme_mod('folio_cat_banner_title', '');
    $folio_cat_is_breadcrumb        = get_theme_mod('folio_cat_is_breadcrumb', 1);
    $folio_cat_banner_alignment     = get_theme_mod('folio_cat_banner_alignment', 'center');
    
    $ov_css = '';
    $bg_css  = '';
    $bc_css  = '';
    if(defined('FW')):
        $category = get_queried_object();
        $category_id = $category->term_id;
        $folio_cats_is_settings = fw_get_db_term_option($category_id, 'folio_cat', 'folio_cats_is_settings', 2);
        if($folio_cats_is_settings == 1):
            $folio_cats_banner_bg        = fw_get_db_term_option($category_id, 'category', 'folio_cats_banner_bg', array());
            $folio_cats_banner_bg        = fw_get_db_term_option($category_id, 'category', 'folio_cats_banner_bg', '');
            $folio_cats_banner_overlay   = fw_get_db_term_option($category_id, 'category', 'folio_cats_banner_overlay', '');
            $folio_cats_banner_title     = fw_get_db_term_option($category_id, 'category', 'folio_cats_banner_title', '');
            $folio_cats_is_breadcrumb    = fw_get_db_term_option($category_id, 'category', 'folio_cats_is_breadcrumb', 1);
            $folio_cats_banner_alignment = fw_get_db_term_option($category_id, 'category', 'folio_cats_banner_alignment', 'center');
            
            $folio_cat_banner_title      = ($folio_cats_banner_title != '' ? $folio_cats_banner_title : $folio_cat_banner_title);
            $folio_cat_is_breadcrumb     = ($folio_cats_is_breadcrumb  > 0 ? $folio_cats_is_breadcrumb : $folio_cat_is_breadcrumb);
            $folio_cat_banner_alignment  = ($folio_cats_banner_alignment != '' ? $folio_cats_banner_alignment : $folio_cat_banner_alignment);
            
            if(isset($folio_cats_banner_bg['url']) && $folio_cats_banner_bg['url'] != ''):
                $bg_css = 'background-image: url('.$folio_cats_banner_bg['url'].');';
            endif;
            if(isset($folio_cats_banner_bg) && $folio_cats_banner_bg != ''):
                $bc_css = 'background-color: '.$folio_cats_banner_bg.';';
            endif;
            if(isset($folio_cats_banner_overlay) && $folio_cats_banner_overlay != ''):
                $ov_css = 'background: '.$folio_cats_banner_overlay.';';
            endif;
        endif;
    endif;
    
    $folio_cat_banner_title = ($folio_cat_banner_title != '' ? $folio_cat_banner_title : get_the_archive_title());
    $folio_cat_banner_title = wp_strip_all_tags($folio_cat_banner_title);
    $folio_cat_banner_title = str_replace('Category:', '', $folio_cat_banner_title);
    
    ?>
    <section class="page_banner folio_cate_banner" style="<?php echo esc_attr($bg_css.$bc_css) ?>">
        <div class="overlay" style="<?php echo esc_attr($ov_css) ?>"></div>
        <div class="container largeContainer">
            <div class="row">
                <div class="col-md-12 text-<?php echo esc_attr($folio_cat_banner_alignment); ?>">
                    <h2 class="banner-title"><?php echo esc_html($folio_cat_banner_title); ?></h2>
                    <?php if($folio_cat_is_breadcrumb == 1): ?>
                        <?php echo bepro_kses(bepro_breadcrumbs()); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>