<?php
$bloks = array(
    'post_type' => 'blocks',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'orderby' => 'title',
    'order' => 'ASC'
);
$all_bloks = array(
    'none' => esc_html__('None', 'bepro')
);
$blok = new WP_Query($bloks);
if ($blok->have_posts()):
    while ($blok->have_posts()):
        $blok->the_post();
        $all_bloks[get_the_ID()] = get_the_title();
    endwhile;
endif;
wp_reset_postdata();


$fields[] = array(
    'type' => 'custom',
    'settings' => 'shop_custom_01',
    'priority' => 1,
    'label' => FALSE,
    'section' => 'shop_settings',
    'default' => '<div class="customizer_label">' . esc_html__('Banner Settings', 'bepro') . '</div>',
);
$fields[] = array(
    'type' => 'switch',
    'priority'    => 2,
    'settings' => 'shop_is_banner',
    'label' => esc_html__('Is Banner?', 'bepro'),
    'section' => 'shop_settings',
    'default' => '1',
    'choices' => [
        'on' => esc_html__('Enable ', 'bepro'),
        'off' => esc_html__('Disable ', 'bepro'),
    ],
);
$fields[] = array(
    'type' => 'background',
    'priority'    => 3,
    'settings' => 'shop_banner_bg',
    'label' => esc_html__('Banner Background', 'bepro'),
    'description' => esc_html__('Setup you shop listing page banner BG.', 'bepro'),
    'section' => 'shop_settings',
    'default' => [
        'background-color' => '',
        'background-image' => '',
        'background-repeat' => 'no-repeat',
        'background-position' => 'center center',
        'background-size' => 'cover',
        'background-attachment' => 'scroll',
    ],
    'transport' => 'auto',
    'output' => [
        [
            'element' => '.page_banner.shop_page_banner',
        ]
    ],
    'active_callback' => [
        [
            'setting' => 'shop_is_banner',
            'operator' => '==',
            'value' => true,
        ]
    ],
);
$fields[] = array(
    'type' => 'color',
    'priority'    => 4,
    'settings' => 'shop_banner_overlay_color',
    'label' => esc_html__('Banner Overlay Color', 'bepro'),
    'section' => 'shop_settings',
    'default' => '',
    'transport' => 'auto',
    'output' => [
        [
            'element' => '.shop_page_banner .overlay',
            'property' => 'background'
        ],
    ],
    'active_callback' => [
        [
            'setting' => 'shop_is_banner',
            'operator' => '==',
            'value' => true,
        ],
    ],
);
$fields[] = array(
    'type' => 'text',
    'settings' => 'shop_banner_title',
    'priority'    => 5,
    'label' => esc_html__('Banner Title', 'bepro'),
    'section' => 'shop_settings',
    'default' => esc_html__('Product Page', 'bepro'),
    'transport' => 'postMessage',
    'js_vars' => array(
        array(
            'element' => '.shop_page_banner .banner-title',
            'function' => 'html'
        ),
    ),
    'active_callback' => [
        [
            'setting' => 'shop_is_banner',
            'operator' => '==',
            'value' => true,
        ],
    ],
);
$fields[] = array(
    'type' => 'switch',
    'priority'    => 6,
    'settings' => 'shop_is_breadcrumb',
    'label' => esc_html__('Is Breadcrumb?', 'bepro'),
    'section' => 'shop_settings',
    'default' => '1',
    'choices' => [
        'on' => esc_html__('Show', 'bepro'),
        'off' => esc_html__('Hide', 'bepro'),
    ],
    'active_callback' => [
        [
            'setting' => 'shop_is_banner',
            'operator' => '==',
            'value' => true,
        ]
    ],
);
$fields[] = array(
    'type' => 'radio-buttonset',
    'settings' => 'shop_banner_alignment',
    'priority'    => 7,
    'label' => esc_html__('Choose your banner text alignment.', 'bepro'),
    'section' => 'shop_settings',
    'default' => 'center',
    'choices' => [
        'left' => esc_html__('Left', 'bepro'),
        'center' => esc_html__('Center', 'bepro'),
        'right' => esc_html__('Right', 'bepro'),
    ],
    'active_callback' => [
        [
            'setting' => 'shop_is_banner',
            'operator' => '==',
            'value' => true,
        ],
    ],
);

$fields[] = array(
    'type' => 'custom',
    'settings' => 'repeater_settings',
    'label' => FALSE,
    'priority'    => 8,
    'section' => 'shop_settings',
    'default' => '<div class="customizer_label mt40">' . esc_html__('Top Block Settings', 'bepro') . '</div>',
);
$fields[] = array(
    'type' => 'repeater',
    'settings' => 'top_shop_block_setttings',
    'label' => esc_html__('Add Top Blocks', 'bepro'),
    'section' => 'shop_settings',
    'priority' => 9,
    'button_label' => esc_html__('Add New Block', 'bepro'),
    'default' => [],
    'fields' => [
        'top_blocks_ids' => [
            'type' => 'select',
            'label' => esc_html__('Block', 'bepro'),
            'default' => 'none',
            'choices' => $all_bloks
        ]
    ]
);

$fields[] = array(
    'type' => 'custom',
    'settings' => 'shop_custom_03',
    'label' => FALSE,
    'priority'    => 10,
    'section' => 'shop_settings',
    'default' => '<div class="customizer_label mt40">' . esc_html__('Content Settings', 'bepro') . '</div>',
);
$fields[] = array(
    'type' => 'switch',
    'settings' => 'shop_is_title',
    'priority'    => 11,
    'label' => esc_html__('Is Area Title?', 'bepro'),
    'section' => 'shop_settings',
    'default' => 'off',
    'choices' => [
        'on' => esc_html__('Show', 'bepro'),
        'off' => esc_html__('Hide', 'bepro'),
    ],
);
$fields[] = array(
    'type' => 'text',
    'settings' => 'shop_product_label',
    'priority'    => 12,
    'label' => esc_html__('Title', 'bepro'),
    'section' => 'shop_settings',
    'default' => esc_html__('Popular Products', 'bepro'),
    'active_callback' => [
        [
            'setting' => 'shop_is_title',
            'operator' => '==',
            'value' => true,
        ]
    ],
);
$fields[] = array(
    'type' => 'switch',
    'settings' => 'shop_is_res_count',
    'priority'    => 13,
    'label' => esc_html__('Is Result Count?', 'bepro'),
    'section' => 'shop_settings',
    'default' => 'off',
    'choices' => [
        'on' => esc_html__('Show', 'bepro'),
        'off' => esc_html__('Hide', 'bepro'),
    ],
);
$fields[] = array(
    'type' => 'switch',
    'settings' => 'shop_is_sort',
    'priority'    => 14,
    'label' => esc_html__('Is Sort?', 'bepro'),
    'section' => 'shop_settings',
    'default' => 'on',
    'choices' => [
        'on' => esc_html__('Show', 'bepro'),
        'off' => esc_html__('Hide', 'bepro'),
    ],
);
$fields[] = array(
    'type' => 'text',
    'settings' => 'shop_sort_label',
    'priority'    => 15,
    'label' => esc_html__('Sort Label', 'bepro'),
    'section' => 'shop_settings',
    'default' => esc_html__('Sort By:', 'bepro'),
    'active_callback' => [
        [
            'setting' => 'shop_is_sort',
            'operator' => '==',
            'value' => true,
        ]
    ],
);
$fields[] = array(
    'type' => 'switch',
    'priority'    => 16,
    'settings' => 'shop_is_category_dropdown',
    'label' => esc_html__('Is Category Dropdown?', 'bepro'),
    'section' => 'shop_settings',
    'default' => 'on',
    'choices' => [
        'on' => esc_html__('Show', 'bepro'),
        'off' => esc_html__('Hide', 'bepro'),
    ],
);
$fields[] = array(
    'type' => 'text',
    'settings' => 'shop_dropdown_label',
    'priority'    => 17,
    'label' => esc_html__('Dropdown Label', 'bepro'),
    'section' => 'shop_settings',
    'default' => esc_html__('Categories', 'bepro'),
    'active_callback' => [
        [
            'setting' => 'shop_is_category_dropdown',
            'operator' => '==',
            'value' => true,
        ]
    ],
);
$fields[] = array(
    'type' => 'repeater',
    'priority'    => 17,
    'label' => esc_html__('Dropdown Categories', 'bepro'),
    'section' => 'shop_settings',
    'settings' => 'shop_categories',
    'button_label' => esc_html__('Add New Category', 'bepro'),
    'default' => [],
    'fields' => [
        'cat_id' => [
            'type' => 'select',
            'label' => esc_html__('Category', 'bepro'),
            'default' => '0',
            'choices' => bepro_category_array('product_cat'),
        ]
    ],
    'active_callback' => [
        [
            'setting' => 'shop_is_category_dropdown',
            'operator' => '==',
            'value' => true,
        ]
    ],
);
$fields[] = array(
    'type' => 'custom',
    'priority'    => 19,
    'settings' => 'shop_custom_hr_1',
    'label' => FALSE,
    'section' => 'shop_settings',
    'default' => '<div class="customizer_devider"></div>',
    'active_callback' => [
        [
            'setting' => 'shop_is_category_dropdown',
            'operator' => '==',
            'value' => true,
        ]
    ],
);
$fields[] = array(
    'type' => 'select',
    'priority'    => 20,
    'settings' => 'shop_sidebar',
    'label' => esc_html__('Sidebar Position', 'bepro'),
    'section' => 'shop_settings',
    'default' => '1',
    'choices' => array(
        '1' => esc_html__('Full Width', 'bepro'),
        '2' => esc_html__('Left Sidebar', 'bepro'),
        '3' => esc_html__('Right Sidebar', 'bepro'),
    ),
);
$fields[] = array(
    'type' => 'slider',
    'priority'    => 21,
    'settings' => 'shop_numof_product',
    'label' => esc_html__('Number Of Products', 'bepro'),
    'section' => 'shop_settings',
    'default' => 8,
    'choices' => [
        'min' => 1,
        'max' => 1000,
        'step' => 1,
    ],
);
$fields[] = array(
    'type' => 'switch',
    'settings' => 'shop_is_flashlabels',
    'priority'    => 22,
    'label' => esc_html__('Is Flash Lebels?', 'bepro'),
    'section' => 'shop_settings',
    'default' => 'off',
    'choices' => [
        'on' => esc_html__('Show', 'bepro'),
        'off' => esc_html__('Hide', 'bepro'),
    ],
);
$fields[] = array(
    'type' => 'switch',
    'priority'    => 23,
    'settings' => 'shop_is_wishlist',
    'label' => esc_html__('Is Wishlist?', 'bepro'),
    'section' => 'shop_settings',
    'default' => 'off',
    'choices' => [
        'on' => esc_html__('Show', 'bepro'),
        'off' => esc_html__('Hide', 'bepro'),
    ],
);
$fields[] = array(
    'type' => 'slider',
    'priority'    => 24,
    'settings' => 'shop_paging_margin',
    'label' => esc_html__('Pagination Gapping', 'bepro'),
    'section' => 'shop_settings',
    'default' => 48,
    'choices' => [
        'min' => 0,
        'max' => 200,
        'step' => 1,
    ],
    'transport' => 'auto',
    'output' => [
        [
            'element' => '.bepro_pagination.shop_pagination',
            'property' => 'margin-top',
            'suffix' => 'px'
        ]
    ],
);
$fields[] = array(
    'type' => 'background',
    'priority'    => 25,
    'settings' => 'pagination_banner_bg',
    'label' => esc_html__('Pagination Background', 'bepro'),
    'description' => esc_html__('Setup you pagination background.', 'bepro'),
    'section' => 'shop_settings',
    'default' => [
        'background-color' => '',
        'background-image' => '',
        'background-repeat' => 'no-repeat',
        'background-position' => 'center center',
        'background-size' => 'cover',
        'background-attachment' => 'scroll',
    ],
    'transport' => 'auto',
    'output' => [
        [
            'element' => '.bepro_pagination.shop_pagination .woocommerce-pagination',
        ]
    ],
);

$fields[] = array(
    'type' => 'custom',
    'priority'    => 26,
    'settings' => 'shop_custom_04',
    'label' => FALSE,
    'section' => 'shop_settings',
    'default' => '<div class="customizer_label mt40">' . esc_html__('Bottom Blocks Settings', 'bepro') . '</div>',
);
$fields[] = array(
    'type' => 'repeater',
    'priority'    => 27,
    'label' => esc_html__('Add Bottom Blocks', 'bepro'),
    'section' => 'shop_settings',
    'settings' => 'shop_bottom_bloks',
    'button_label' => esc_html__('Add New Block', 'bepro'),
    'default' => [],
    'fields' => [
        'bottom_block_ids' => [
            'type' => 'select',
            'label' => esc_html__('Block', 'bepro'),
            'default' => 'none',
            'choices' => $all_bloks
        ]
    ]
);