<?php
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'team_custom_01',
	'label'       => FALSE,
	'section'     => 'member_single_settings',
	'default'     => '<div class="customizer_label">'.esc_html__('Banner Settings', 'bepro').'</div>',
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'team_is_banner',
	'label'       => esc_html__( 'Is Banner?', 'bepro' ),
	'section'     => 'member_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Enable ', 'bepro' ),
		'off'     => esc_html__( 'Disable ', 'bepro' ),
	],
);
$fields[] = array(
        'type'        => 'background',
	'settings'    => 'team_banner_bg',
	'label'       => esc_html__( 'Banner Background', 'bepro' ),
	'section'     => 'member_single_settings',
	'default'     => [
		'background-color'      => '',
		'background-image'      => '',
		'background-repeat'     => 'no-repeat',
		'background-position'   => 'center center',
		'background-size'       => 'cover',
		'background-attachment' => 'scroll',
	],
    'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner.team_single_banner',
		]
	],
    'active_callback' => [
            [
                    'setting'  => 'team_is_banner',
                    'operator' => '==',
                    'value'    => TRUE,
            ]
    ],
);
$fields[]= array(
	'type'        => 'color',
	'settings'    => 'team_banner_overlay_color',
	'label'       => esc_html__( 'Banner Overlay Color', 'bepro' ),
	'section'     => 'member_single_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.team_single_banner .overlay',
			'property' => 'background'
		],
	],
	'active_callback' => [
		[
				'setting'  => 'team_is_banner',
				'operator' => '==',
				'value'    => true,
		],
	],
);
$fields[] = array(
        'type'          => 'text',
	'settings'      => 'team_banner_title',
	'label'         => esc_html__('Banner Title', 'bepro'),
	'section'       => 'member_single_settings',
	'default'       => esc_html__('Member Details', 'bepro'),
        'transport'     => 'postMessage',
        'js_vars'       => array(
            array(
                'element'  => '.page_banner.team_single_banner .banner-title',
                'function' => 'html'
            ),
        ),
        'active_callback' => [
                [
                        'setting'  => 'team_is_banner',
                        'operator' => '==',
                        'value'    => TRUE,
                ]
        ],
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'team_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb?', 'bepro' ),
	'section'     => 'member_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Show', 'bepro' ),
		'off'     => esc_html__( 'Hide', 'bepro' ),
	],
    'active_callback' => [
            [
                    'setting'  => 'team_is_banner',
                    'operator' => '==',
                    'value'    => TRUE,
            ]
    ],
);
$fields[]= array(
    'type'        => 'radio-buttonset',
	'settings'    => 'team_banner_alignment',
	'label'       => esc_html__( 'Choose your banner text alignment.', 'bepro' ),
	'section'     => 'member_single_settings',
	'default'     => 'center',
	'choices'     => [
		'left'   => esc_html__( 'Left', 'bepro' ),
		'center' => esc_html__( 'Center', 'bepro' ),
		'right'  => esc_html__( 'Right', 'bepro' ),
	],
    'active_callback' => [
        [
                'setting'  => 'team_is_banner',
                'operator' => '==',
                'value'    => true,
        ],
    ],
);
