<?php
$header = array(
    'post_type'       => 'tw-header-builder',
    'post_status'     => 'publish',
    'posts_per_page'  => -1,
    'orderby'         => 'title',
    'order'           => 'ASC'
);
$all_header = array(
    '0' => esc_html__('Default Header', 'bepro')
);
$headers = new WP_Query($header);
if($headers->have_posts()):
    while($headers->have_posts()):
    $headers->the_post();
    $all_header[get_the_ID()] = get_the_title();
    endwhile;
endif;
wp_reset_postdata();

$fields[]       = array(
    'type'      => 'custom',
    'settings'  => 'header_custom_01',
    'label'     => FALSE,
    'section'   => 'header_settings',
    'default'   => '<div class="customizer_label">' . esc_html__('Header Settings', 'bepro') . '</div>',
);
$fields[] = array(
    'type'      => 'select',
    'settings'  => 'header_style',
    'label'     => esc_html__('Header Style', 'bepro'),
    'section'   => 'header_settings',
    'default'   => '0',
    'choices'   => $all_header,
);
//Tobar Settings
$fields[]       = array(
    'type'      => 'custom',
    'settings'  => 'header_custom_02',
    'label'     => FALSE,
    'section'   => 'header_settings',
    'default'   => '<div class="customizer_label">' . esc_html__('Topbar Settings', 'bepro') . '</div>',
    'active_callback' => array(
        array(
            'setting'   => 'header_style',
            'operator'  => '==',
            'value'     => ['0']
        )
    ),
);
$fields[]       = array(
    'type'      => 'switch',
    'settings'  => 'header_is_topbar',
    'label'     => esc_html__('Is Topbar?', 'bepro'),
    'section'   => 'header_settings',
    'default'   => '2',
    'choices'   => [
        'on'    => esc_html__('Enable ', 'bepro'),
        'off'   => esc_html__('Disable ', 'bepro'),
    ],
    'active_callback' => array(
        array(
            'setting'   => 'header_style',
            'operator'  => '==',
            'value'     => ['0']
        )
    ),
);
$fields[] = array(
    'type' => 'repeater',
    'label' => esc_html__('Topbar Info Item', 'bepro'),
    'section' => 'header_settings',
    'settings' => 'header_info_boxes',
    'row_label' => [
        'type' => 'text',
        'value' => esc_html__('Info Boxes', 'bepro'),
    ],
    'button_label' => esc_html__('Add New Box', 'bepro'),
    'default' => [],
    'fields'  => [
        'info_box_type' => [
            'type' => 'select',
            'label' => esc_html__('Info Type', 'bepro'),
            'default' => 'bpro-mail-2',
            'choices' => array(
                'bpro-mail-2'           => esc_html__('Email', 'bepro'),
                'bpro-phone-ringing'    => esc_html__('Phone', 'bepro'),
            ),
        ],
        'info_box_content'  => [
            'type'          => 'text',
            'label'         => esc_html__('Box Content', 'bepro'),
            'default'       => '',
        ],
    ],
    'active_callback' => array(
        array(
            'setting'   => 'header_style',
            'operator'  => '==',
            'value'     => ['0']
        ),
        array(
            'setting'  => 'header_is_topbar',
            'operator' => '==',
            'value'    => true,
        ),
    ),
);
$fields[] = array(
    'type' => 'repeater',
    'label' => esc_html__('Topbar Social Icon', 'bepro'),
    'section' => 'header_settings',
    'settings' => 'header_social_links',
    'row_label' => [
        'type' => 'text',
        'value' => esc_html__('Profile', 'bepro'),
    ],
    'button_label' => esc_html__('Add New Social', 'bepro'),
    'default' => [],
    'fields' => [
        'social_profile' => [
            'type' => 'select',
            'label' => esc_html__('Social Site', 'bepro'),
            'default' => 'twi-facebook-square',
            'choices' => array(
                'twi-facebook-square'   => esc_html__('Facebook', 'bepro'),
                'twi-pinterest'         => esc_html__('Pinterest', 'bepro'),
                'twi-twitter-square'    => esc_html__('Twitter', 'bepro'),
                'twi-instagram'         => esc_html__('Instagram', 'bepro'),
                'twi-youtube'           => esc_html__('Youtbee', 'bepro'),
                'twi-snapchat'          => esc_html__('Snapchat', 'bepro'),
                'twi-dribbble'          => esc_html__('Dribbble', 'bepro'),
                'twi-linkedin'          => esc_html__('Linkedin', 'bepro'),
                'twi-reddit'            => esc_html__('Reddit', 'bepro'),
                'twi-tumblr'            => esc_html__('Tumblr', 'bepro'),
                'twi-xing'              => esc_html__('Xing', 'bepro'),
                'twi-behance'           => esc_html__('Behance', 'bepro'),
                'twi-envira'            => esc_html__('Envato', 'bepro'),
                'twi-skype'             => esc_html__('Skype', 'bepro'),
                'twi-rss'               => esc_html__('Rss', 'bepro'),
                'twi-github'            => esc_html__('Github', 'bepro'),
                'twi-digg'              => esc_html__('Digg', 'bepro'),
                'twi-vk'                => esc_html__('VK', 'bepro'),
                'twi-vimeo'             => esc_html__('Vimeo', 'bepro'),
            ),
        ],
        'social_url' => [
            'type' => 'text',
            'label' => esc_html__('Profile URL', 'bepro'),
            'default' => '',
        ],
    ],
    'active_callback' => array(
        array(
            'setting'   => 'header_style',
            'operator'  => '==',
            'value'     => ['0']
        ),
        array(
            'setting'  => 'header_is_topbar',
            'operator' => '==',
            'value'    => true,
        ),
    ),
);

//Main Header Settings
$fields[]       = array(
    'type'      => 'custom',
    'settings'  => 'header_custom_04',
    'label'     => FALSE,
    'section'   => 'header_settings',
    'default'   => '<div class="customizer_label">' . esc_html__('Main Header Settings', 'bepro') . '</div>',
    'active_callback' => array(
        array(
            'setting'   => 'header_style',
            'operator'  => '==',
            'value'     => ['0']
        ),
    ),
);
$fields[]       = array(
    'type'      => 'switch',
    'settings'  => 'header_is_sticky',
    'label'     => esc_html__('Is Sticky?', 'bepro'),
    'section'   => 'header_settings',
    'default'   => '2',
    'choices'   => [
        'on'    => esc_html__('Enable ', 'bepro'),
        'off'   => esc_html__('Disable ', 'bepro'),
    ],
    'active_callback' => array(
        array(
            'setting'   => 'header_style',
            'operator'  => '==',
            'value'     => ['0']
        ),
    ),
);
$fields[]           = array(
    'type'          => 'image',
    'settings'      => 'header_logo',
    'label'         => esc_html__('Logo', 'bepro'),
    'description'   => esc_html__('Upload your site logo. Default logo size 193x55px.', 'bepro'),
    'section'       => 'header_settings',
    'default'       => '',
    'active_callback' => array(
        array(
            'setting'   => 'header_style',
            'operator'  => '==',
            'value'     => ['0']
        ),
    ),
);
$fields[]       = array(
    'type'      => 'switch',
    'settings'  => 'header_is_search',
    'label'     => esc_html__('Is Search Btn?', 'bepro'),
    'section' => 'header_settings',
    'default' => '2',
    'choices' => [
        'on'  => esc_html__('Enable ', 'bepro'),
        'off' => esc_html__('Disable ', 'bepro'),
    ],
    'active_callback' => array(
        array(
            'setting'   => 'header_style',
            'operator'  => '==',
            'value'     => ['0']
        ),
    ),
);
$fields[]       = array(
    'type'      => 'switch',
    'settings'  => 'header_is_cart',
    'label'     => esc_html__('Is Cart Btn?', 'bepro'),
    'section' => 'header_settings',
    'default' => '2',
    'choices' => [
        'on'  => esc_html__('Enable ', 'bepro'),
        'off' => esc_html__('Disable ', 'bepro'),
    ],
    'active_callback' => array(
        array(
            'setting'   => 'header_style',
            'operator'  => '==',
            'value'     => ['0']
        ),
    ),
);
$fields[] = array(
    'type'      => 'switch',
    'settings'  => 'header_is_btn',
    'label'     => esc_html__('Is Contact Btn?', 'bepro'),
    'description' => esc_html__('Do you want to show contact button? ', 'bepro'),
    'section' => 'header_settings',
    'default' => '2',
    'choices' => [
        'on'  => esc_html__('Enable ', 'bepro'),
        'off' => esc_html__('Disable ', 'bepro'),
    ],
    'active_callback' => array(
        array(
            'setting'   => 'header_style',
            'operator'  => '==',
            'value'     => ['0']
        ),
    ),
);
$fields[]       = array(
    'type'      => 'text',
    'settings'  => 'btn_label',
    'label'     => esc_html__('Btn Label', 'bepro'),
    'section'   => 'header_settings',
    'default'   => esc_html__('Get A Quote', 'bepro'),
    'transport' => 'postMessage',
    'js_vars'   => array(
        array(
            'element' => '.berpo_btn .bp-text',
            'function' => 'html'
        ),
    ),
    'active_callback' => array(
        array(
            'setting'   => 'header_style',
            'operator'  => '==',
            'value'     => ['0']
        ),
        array(
            'setting' => 'header_is_btn',
            'operator' => '==',
            'value' => true,
        ),
    ),
);
$fields[]      = array(
    'type'     => 'text',
    'settings' => 'btn_url',
    'label'    => esc_html__('Btn Url', 'bepro'),
    'section'  => 'header_settings',
    'default'  => '#',
    'active_callback' => array(
        array(
            'setting'   => 'header_style',
            'operator'  => '==',
            'value'     => ['0']
        ),
        array(
            'setting' => 'header_is_btn',
            'operator' => '==',
            'value' => true,
        ),
    ),
);



