<?php
$bloks = array(
    'post_type'     => 'blocks',
    'post_status'   => 'publish',
    'posts_per_page'  => -1,
    'orderby'        => 'title',
    'order'          => 'ASC'
);
$all_bloks = array(
    'none' => esc_html__('None', 'bepro')
);
$blok = new WP_Query($bloks);
if($blok->have_posts()):
    while($blok->have_posts()):
    $blok->the_post();
    $all_bloks[get_the_ID()] = get_the_title();
    endwhile;
endif;
wp_reset_postdata();

$fields[] = array(
    'type'        => 'custom',
	'settings'    => 'blog_single_custom_01',
	'label'       => FALSE,
	'section'     => 'blog_single_settings',
	'default'     => '<div class="customizer_label">'.esc_html__('Banner Settings', 'bepro').'</div>',
);
$fields[]= array(
    'type'    => 'switch',
	'settings'    => 'blog_single_is_banner',
	'label'       => esc_html__( 'Is Banner?', 'bepro' ),
	'section'     => 'blog_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Enable ', 'bepro' ),
		'off'     => esc_html__( 'Disable ', 'bepro' ),
	],
);
$fields[] = array(
    'type'        => 'background',
	'settings'    => 'blog_single_banner_bg',
	'label'       => esc_html__( 'Banner Background', 'bepro' ),
	'description' => esc_html__( 'Setup you single post page banner BG.', 'bepro' ),
	'section'     => 'blog_single_settings',
	'default'     => [
		'background-color'      => '',
		'background-image'      => '',
		'background-repeat'     => 'no-repeat',
		'background-position'   => 'center center',
		'background-size'       => 'cover',
		'background-attachment' => 'scroll',
	],
    'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner.sb_banner',
		]
	],
    'active_callback' => [
            [
                    'setting'  => 'blog_single_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ],
    ],
);
$fields[]= array(
    'type'        => 'color',
    'settings'    => 'blog_single_banner_overlay_color',
    'label'       => esc_html__( 'Banner Overlay Color', 'bepro' ),
    'section'     => 'blog_single_settings',
    'default'     => '',
    'transport'   => 'auto',
    'output'      => [
        [
            'element' => '.sb_banner .overlay',
            'property' => 'background'
        ],
    ],
    'active_callback' => [
        [
                'setting'  => 'blog_single_is_banner',
                'operator' => '==',
                'value'    => true,
        ],
    ],
);
$fields[] = array(
    'type'          => 'text',
	'settings'      => 'blog_single_banner_title',
	'label'         => esc_html__('Banner Title', 'bepro'),
	'section'       => 'blog_single_settings',
	'default'       => '',
    'transport'     => 'postMessage',
    'js_vars'       => array(
        array(
            'element'  => '.page_banner.sb_banner .banner-title',
            'function' => 'html'
        )
    ),
    'active_callback' => [
            [
                    'setting'  => 'blog_single_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
    'type'        => 'switch',
	'settings'    => 'blog_single_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb?', 'bepro' ),
	'section'     => 'blog_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Show', 'bepro' ),
		'off'     => esc_html__( 'Hide', 'bepro' ),
	],
    'active_callback' => [
            [
                    'setting'  => 'blog_single_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ],
    ],
);

$fields[]= array(
    'type'        => 'radio-buttonset',
	'settings'    => 'blog_single_banner_alignment',
	'label'       => esc_html__( 'Choose your banner text alignment.', 'bepro' ),
	'section'     => 'blog_single_settings',
	'default'     => 'center',
	'choices'     => [
		'left'   => esc_html__( 'Left', 'bepro' ),
		'center' => esc_html__( 'Center', 'bepro' ),
		'right'  => esc_html__( 'Right', 'bepro' ),
	],
    'active_callback' => [
            [
                    'setting'  => 'blog_single_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);

$fields[] = array(
    'type'        => 'custom',
	'settings'    => 'blog_single_custom_02',
	'label'       => FALSE,
	'section'     => 'blog_single_settings',
	'default'     => '<div class="customizer_label mt40">'.esc_html__('Content Settings', 'bepro').'</div>',
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'blog_single_sidebar',
        'label'       => esc_html__( 'Sidebar Position', 'bepro' ),
        'section'     => 'blog_single_settings',
        'default'     => '3',
        'choices'     => array(
                '1'      => esc_html__('None','bepro'),
                '2'      => esc_html__('Left','bepro'),
                '3'      => esc_html__('Right','bepro'),
        ),
);
$fields[]= array(
        'type'        => 'switch',
        'settings'    => 'blog_single_is_author',
        'label'       => esc_html__( 'Is Post Author?', 'bepro' ),
        'section'     => 'blog_single_settings',
        'default'     => '1',
        'choices'     => array(
            'on'  => esc_html__( 'Show', 'bepro' ),
            'off' => esc_html__( 'Hide', 'bepro' ),
        ),
);
$fields[]= array(
        'type'        => 'switch',
        'settings'    => 'blog_single_is_tag',
        'label'       => esc_html__( 'Is Tags?', 'bepro' ),
        'section'     => 'blog_single_settings',
        'default'     => '1',
        'choices'     => array(
            'on'  => esc_html__( 'Show', 'bepro' ),
            'off' => esc_html__( 'Hide', 'bepro' ),
        ),
);
$fields[]= array(
        'type'        => 'switch',
        'settings'    => 'blog_single_is_share',
        'label'       => esc_html__( 'Is Social Share?', 'bepro' ),
        'section'     => 'blog_single_settings',
        'default'     => '2',
        'choices'     => array(
            'on'  => esc_html__( 'Show', 'bepro' ),
            'off' => esc_html__( 'Hide', 'bepro' ),
        ),
);
$fields[]= array(
        'type'        => 'multicheck',
        'settings'    => 'blog_single_socials',
        'label'       => esc_html__( 'Select Social Media', 'bepro' ),
        'section'     => 'blog_single_settings',
        'default'     => array(1, 2, 3, 4),
        'choices'     => [
                '1'   => esc_html__( 'Facebook', 'bepro' ),
                '2'   => esc_html__( 'Twitter', 'bepro' ),
                '3'   => esc_html__( 'Email', 'bepro' ),
                '4'   => esc_html__( 'LinkedIn', 'bepro' ),
                '5'   => esc_html__( 'Pinterest', 'bepro' ),
                '6'   => esc_html__( 'Whatsapp', 'bepro' ),
                '7'   => esc_html__( 'Digg', 'bepro' ),
                '8'   => esc_html__( 'Tumblr', 'bepro' ),
                '9'   => esc_html__( 'Reddit', 'bepro' ),
        ],
        'active_callback' => [
                [
                        'setting'  => 'blog_single_is_share',
                        'operator' => '==',
                        'value'    => '1',
                ]
        ],
);
$fields[]= array(
        'type'        => 'switch',
        'settings'    => 'blog_single_is_author_box',
        'label'       => esc_html__( 'Is Author Info?', 'bepro' ),
        'section'     => 'blog_single_settings',
        'default'     => '2',
        'choices'     => array(
            'on'  => esc_html__( 'Show', 'bepro' ),
            'off' => esc_html__( 'Hide', 'bepro' ),
        ),
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'blog_single_custom_03',
	'label'       => FALSE,
	'section'     => 'blog_single_settings',
	'default'     => '<div class="customizer_label mt40">'.esc_html__('Blocks Settings', 'bepro').'</div>',
);
$fields[] = array(
    'type'              => 'repeater',
	'label'         => esc_html__( 'Add Blocks', 'bepro' ),
	'section'       => 'blog_single_settings',
	'settings'      => 'blog_single_bloks',
	'row_label' => [
		'type'  => 'text',
		'value' => esc_html__('Block', 'bepro' ),
	],
	'button_label' => esc_html__('Add New Block', 'bepro' ),
	'default'      => [],
	'fields' => [
		'block_ids' => [
			'type'        => 'select',
                        'label'       => esc_html__( 'Block', 'bepro' ),
                        'default'     => 'none',
                        'choices'     => $all_bloks
		]
	]
);
