<?php
/**
 * Creates widget with recent post thumbnail
 */

class Tw_Category_Widgets extends WP_Widget
{
    function __construct(){
        $widget_opt = array(
            'classname'     => 'widget_categories cusCat',
            'description'   => 'Bepro Category Widgets.'
        );
        parent::__construct('bep-categories', esc_html__('Bepro Custome Category', 'themewar'), $widget_opt);
    }
    
    function widget( $args, $instance ){
        $title = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__( 'Categories', 'themewar' );
        $number = (isset($instance['number']) && !empty($instance['number'])) ? $instance['number'] : 5;
        $orderby = (isset($instance['orderby']) && !empty($instance['orderby'])) ? $instance['orderby'] : 'name';
        $order = (isset($instance['order']) && !empty($instance['order'])) ? $instance['order'] : 'ASC';
        $hide_empty = (isset($instance['hide_empty']) && $instance['hide_empty'] > 0) ? $instance['hide_empty'] : 0;
        $show_count = (isset($instance['show_count']) && $instance['show_count'] > 0 && $instance['show_count'] == 1) ? TRUE : FALSE;
        
        $title = apply_filters( 'widget_title', $title );
        echo wp_kses_post($args['before_widget']);
        ?>
            <?php if($title != ''): ?>
                <h3 class="widget_title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>
            <?php
                $argsu = array(
                    'taxonomy'              => 'category',
                    'number'                => $number,
                    'orderby'               => $orderby,
                    'order'                 => $order,
                    'count'                 => $show_count,
                    'hide_empty'            => $hide_empty,
                );

                $categories = get_categories($argsu);
            ?>
            <?php if(!empty($categories)): ?>
                <ul class="clearfix">
                    <?php
                        foreach($categories as $cat):
                            ?>
                            <li class="clearfix <?php echo (!$show_count ? 'noCount' : ''); ?>">
                                <a href="<?php echo get_category_link($cat->term_id); ?>"><?php echo esc_html($cat->name) ?></a>
                                <?php if($show_count): ?>
                                    <span><?php echo esc_html($cat->count); ?></span>
                                <?php endif; ?>
                            </li>
                            <?php
                        endforeach;
                    ?>
                </ul>
            <?php endif; ?>
        <?php
        echo wp_kses_post($args['after_widget']);
    }
    
    
    function update ( $new_instance, $old_instance ) 
    {
        return $new_instance;
    }
    
    function form($instance)
    {
        $title = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__( 'Categories', 'themewar' );
        $number = (isset($instance['number']) && !empty($instance['number'])) ? $instance['number'] : 5;
        $orderby = (isset($instance['orderby']) && !empty($instance['orderby'])) ? $instance['orderby'] : 'name';
        $order = (isset($instance['order']) && !empty($instance['order'])) ? $instance['order'] : 'ASC';
        $hide_empty = (isset($instance['hide_empty']) && !empty($instance['hide_empty'])) ? $instance['hide_empty'] : 0;
        $show_count = (isset($instance['show_count']) && !empty($instance['show_count'])) ? $instance['show_count'] : 0;
        
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e( 'Title:', 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'number' )); ?>"><?php _e( 'Number of Item:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number' )); ?>" type="number" value="<?php echo esc_attr( $number ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'orderby' )); ?>"><?php _e( 'Order By:' , 'themewar' ); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'orderby' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'orderby' )); ?>">
                <option value="name" <?php if($orderby == 'name'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Name', 'themewar'); ?></option>
                <option value="term_id" <?php if($orderby == 'term_id'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('ID', 'themewar'); ?></option>
                <option value="count" <?php if($orderby == 'count'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Count', 'themewar'); ?></option>
                <option value="include" <?php if($orderby == 'include'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Include', 'themewar'); ?></option>
            </select>
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'order' )); ?>"><?php _e( 'Order:' , 'themewar' ); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'order' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'order' )); ?>">
                <option value="ASC" <?php if($order == 'ASC'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Ascending', 'themewar'); ?></option>
                <option value="DESC" <?php if($order == 'DESC'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Descending', 'themewar'); ?></option>
            </select>
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'hide_empty' )); ?>"><?php _e( 'Hide Empty:', 'themewar' ); ?></label>
            <input <?php echo ($hide_empty == 1 ? ' checked="checked" ' : '') ?> id="<?php echo esc_attr($this->get_field_id( 'hide_empty' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'hide_empty' )); ?>" type="checkbox" value="1" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'show_count' )); ?>"><?php _e( 'Show Count:', 'themewar' ); ?></label>
            <input <?php echo ($show_count == 1 ? ' checked="checked" ' : '') ?> id="<?php echo esc_attr($this->get_field_id( 'show_count' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_count' )); ?>" type="checkbox" value="1" />
	</p>
        <?php
    }
}