<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Text_Widget extends Widget_Base {

    public function get_name() {
        return 'tw-text';
    }

    public function get_title() {
        return esc_html__( 'Paragraph', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-text';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab_1', [
                'label'     => esc_html__('Paragraph', 'themewar'),
            ]
        );
        $this->add_control(
            'para_content', [
                'label'             => esc_html__( 'Content', 'themewar' ),
                'type'		        => Controls_Manager::TEXTAREA,
                'label_block'       => true,
                'description'       => esc_html__('Use {} for link text.', 'themewar'),
                'default'	        => esc_html__( 'Your text should gose here', 'themewar' ),
            ]
        );
        $this->add_control(
                'para_url', [
                    'label'             => esc_html__( '{} Text URL', 'themewar' ),
                    'type'              => Controls_Manager::URL,
                    'input_type'        => 'url',
                    'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                    'show_external'     => true,
                    'default'           => [
                            'url'            => '',
                            'is_external'    => true,
                            'nofollow'       => true,
                    ],
                ]
        );
        $this->add_control(
                'is_gradian',
                [
                        'label'             => esc_html__( 'Is Link Gradian Color?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to make this link text gradina color?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                ]
        );
        $this->add_responsive_control(
            'para_align', [
                'label'			=> esc_html__( 'Alignment', 'themewar' ),
                'type'			=> Controls_Manager::CHOOSE,
                'options'                   => [
                        'left'       => [
                                'title'  => esc_html__( 'Left', 'themewar' ),
                                'icon'   => 'eicon-text-align-left',
                        ],
                        'center'     => [
                                'title'  => esc_html__( 'Center', 'themewar' ),
                                'icon'   => 'eicon-text-align-center',
                        ],
                        'right'      => [
                                'title'  => esc_html__( 'Right', 'themewar' ),
                                'icon'   => 'eicon-text-align-right',
                        ]
                ],
                'default'		     => 'left',
                'prefix_class'       => 'pr_paragraphs elementor%s-align-',
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2', [
                'label'	 => esc_html__( 'Pagraph Styling', 'themewar' ),
                'tab'	 => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'para_color',
                [
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .bep_paragraph' => 'color: {{VALUE}}'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'para_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .bep_paragraph',
                ]
        );
        $this->add_responsive_control(
                'para_padding',
                [
                        'label'      => esc_html__( 'Paddings', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .bep_paragraph' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->add_responsive_control(
                'para_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .bep_paragraph' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'text_border',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .bep_paragraph',
                ]
        );
        $this->add_control(
                'border_radius',
                [
                        'label'      => esc_html__( 'Border Radius', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .bep_paragraph' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_3', [
                'label'  => esc_html__( 'Link Text Styling', 'themewar' ),
                'tab'    => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'icon_label_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .bep_paragraph a'   => 'color: {{VALUE}}'
                        ],
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'is_gradian',
                                            'operator'  => '!=',
                                            'value'     => 'yes',
                                    ]
                                ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_label_hover_color',
                [
                        'label' => esc_html__( 'Hover Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .bep_paragraph a:hover'   => 'color: {{VALUE}}'
                        ],
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'is_gradian',
                                            'operator'  => '!=',
                                            'value'     => 'yes',
                                    ]
                                ],
                        ],
                ]
        );
        $this->add_control(
            'heading_icon_gradian',
            [
                'label'     => esc_html__( 'Gradian Color', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after',
                'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'is_gradian',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                            ]
                        ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'icon_icon_bg',
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'types' => ['gradient'],
                        'selector' => '{{WRAPPER}} .gra_link a',
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'is_gradian',
                                            'operator'  => '==',
                                            'value'     => 'yes',
                                    ]
                                ],
                        ],
                ]
        );
        $this->add_control(
            'heading_icon_hover_gradian',
            [
                'label'     => esc_html__( 'Gradian Hover Color', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after',
                'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'is_gradian',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                            ]
                        ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'icon_icon_hover_bg',
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'types' => ['gradient'],
                        'selector' => '{{WRAPPER}} .gra_link a:hover',
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'is_gradian',
                                            'operator'  => '==',
                                            'value'     => 'yes',
                                    ]
                                ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'link_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .bep_paragraph a',
                ]
        );
        $this->add_control(
            'border_headding',
            [
                'label'     => esc_html__( 'Border Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'border_bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .bep_paragraph a:before',
                ]
        );
        $this->add_responsive_control(
                'border_width',
                [
                        'label' => esc_html__( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .bep_paragraph a:before' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'border_height',
                [
                        'label' => esc_html__( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .bep_paragraph a:before' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
            'btn_icon_positioning',
            [
                    'label' => esc_html__( 'Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['top', 'bottom'],
                    'selectors' => [
                            '{{WRAPPER}} .bep_paragraph a:before' => 'top: {{TOP}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();
        
    }

    protected function render() {
        $settings       = $this->get_settings_for_display();
        $paras          = (isset($settings['para_content']) && $settings['para_content'] != '') ? $settings['para_content'] : esc_html__( 'Your text should gose here', 'themewar' );
        $is_gradian      = (isset($settings['is_gradian']) && $settings['is_gradian'] != '' ? $settings['is_gradian'] : 'no');
        $url             = (isset($settings['para_url']['url']) && $settings['para_url']['url'] != '') ? $settings['para_url']['url'] : '';
        $para            = str_replace(['{', '}'], ['<a target="_blank" href="'.esc_url($url).'">', '</a>'], $paras);
        
        if($para != ''): ?><p class="bep_paragraph <?php if($is_gradian == 'yes'): ?>gra_link<?php endif; ?>"><?php echo wp_kses_post($para); ?></p><?php endif;
    }

    protected function content_template() {

    }
}

