<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Team_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-team';
    }

    public function get_title() {
        return esc_html__( 'Team', 'themewar' );
    }

    public function get_icon() {
        return ' eicon-person';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {

        $tm = array(
            'post_type'         => 'team',
            'post_status'       => 'publish',
            'order_by'          => 'date',
            'order'             => 'DESC',
            'posts_per_page'    => -1
        );
        $tms = array();
        query_posts($tm);
            if(have_posts()):
                while (have_posts()):
                    the_post();
                    $tms[get_the_ID()] = get_the_title();
                endwhile;
            endif;
        wp_reset_query();

        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Team Member', 'themewar' ),
            ]
        );
            $this->add_control(
                    'team_mode_style',
                    [
                            'label'     => esc_html__( 'View Mode', 'themewar' ),
                            'type'      => Controls_Manager::SELECT,
                            'default'   => 1,
                            'options'   => [
                                    1       => esc_html__( 'Grid View', 'themewar' ),
                                    2       => esc_html__( 'Slide View', 'themewar' ),
                            ],
                    ]
            );
            $this->add_control(
                    'team_view_style',
                    [
                            'label'     => esc_html__( 'View Style', 'themewar' ),
                            'type'      => Controls_Manager::SELECT,
                            'default'   => 1,
                            'options'   => [
                                    1       => esc_html__( 'Style 01', 'themewar' ),
                                    2       => esc_html__( 'Style 02', 'themewar' ),
                                    3       => esc_html__( 'Style 03', 'themewar' ),
                                    4       => esc_html__( 'Style 04', 'themewar' ),
                                    5       => esc_html__( 'Style 05', 'themewar' ),
                                    6       => esc_html__( 'Style 06', 'themewar' ),
                                    7       => esc_html__( 'Style 07', 'themewar' ),
                            ],
                    ]
            );
            $this->add_control(
                    'order_by',
                    [
                            'label'     => esc_html__( 'Order By', 'themewar' ),
                            'type'      => Controls_Manager::SELECT,
                            'default'   => 'date',
                            'options'   => [
                                    'ID'       => esc_html__( 'ID', 'themewar' ),
                                    'title'    => esc_html__( 'Title', 'themewar' ),
                                    'date'     => esc_html__( 'Date', 'themewar' ),
                                    'rand'     => esc_html__( 'Random', 'themewar' ),
                            ],
                    ]
            );
            $this->add_control(
                    'order',
                    [
                            'label'     => esc_html__( 'Order', 'themewar' ),
                            'type'      => Controls_Manager::SELECT,
                            'default'   => 'DESC',
                            'options'   => [
                                    'ASC'       => esc_html__( 'Ascending', 'themewar' ),
                                    'DESC'      => esc_html__( 'Descending', 'themewar' ),
                            ],
                    ]
            );
            $this->add_control(
                    'no_of_items',
                    [
                            'label'     => esc_html__( 'Number of Items', 'themewar' ),
                            'type'      => Controls_Manager::NUMBER,
                            'min'       => 1,
                            'max'       => 100,
                            'step'      => 1,
                            'default'   => 4,
                    ]
            );
            $this->add_control(
                    'team_specific',
                    [
                            'label'         => esc_html__( 'Specific Team', 'themewar' ),
                            'type'          => Controls_Manager::SELECT2,
                            'label_block'   => TRUE,
                            'multiple'      => true,
                            'default'       => array('0'),
                            'options'       => $tms,
                    ]
            );
            $this->add_control(
                    'grid_xl_col',
                    [
                            'label'     => esc_html__( 'Select XL Col', 'themewar' ),
                            'type'      => Controls_Manager::SELECT,
                            'default'   => 2,
                            'options'   => [
                                    1       => esc_html__( 'Col-Xl-3', 'themewar' ),
                                    2       => esc_html__( 'Col-Xl-4', 'themewar' ),
                                    3       => esc_html__( 'Col-Xl-6', 'themewar' ),
                            ],
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'team_mode_style',
                                            'operator'  => 'in',
                                            'value'     => ['1'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_control(
                    'grid_lg_col',
                    [
                            'label'     => esc_html__( 'Select LG Col', 'themewar' ),
                            'type'      => Controls_Manager::SELECT,
                            'default'   => 2,
                            'options'   => [
                                    1       => esc_html__( 'Col-Lg-3', 'themewar' ),
                                    2       => esc_html__( 'Col-Lg-4', 'themewar' ),
                                    3       => esc_html__( 'Col-Lg-6', 'themewar' ),
                            ],
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'team_mode_style',
                                            'operator'  => 'in',
                                            'value'     => ['1'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_control(
                    'grid_md_col',
                    [
                            'label'     => esc_html__( 'Select MD Col', 'themewar' ),
                            'type'      => Controls_Manager::SELECT,
                            'default'   => 2,
                            'options'   => [
                                    1       => esc_html__( 'Col-Md-4', 'themewar' ),
                                    2       => esc_html__( 'Col-Md-6', 'themewar' ),
                                    3       => esc_html__( 'Col-Md-12', 'themewar' ),
                            ],
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'team_mode_style',
                                            'operator'  => 'in',
                                            'value'     => ['1'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_control(
                    'team_is_details',
                    [
                            'label'             => esc_html__( 'Is Details Page Exist?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to linked team member with details page? Then turn it to Yes.', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'yes'
                    ]
            );
            $this->add_control(
                    'team_is_masnry',
                    [
                            'label'             => esc_html__( 'Is Masonry?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to active masonry view?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'no',
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'team_mode_style',
                                            'operator'  => 'in',
                                            'value'     => ['1'],
                                    ],
                                    [
                                            'name'      => 'team_view_style',
                                            'operator'  => '==',
                                            'value'     => '5',
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_control(
                    'team_slide_autoplay',
                    [
                            'label'             => esc_html__( 'Is Autoplay?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to make this slider auto play?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'no',
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'team_mode_style',
                                            'operator'  => 'in',
                                            'value'     => ['2'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_control(
                    'team_slide_loop',
                    [
                            'label'             => esc_html__( 'Is Loop?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to make this slider item loop?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'no',
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'team_mode_style',
                                            'operator'  => 'in',
                                            'value'     => ['2'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_control(
                    'team_slide_nav',
                    [
                            'label'             => esc_html__( 'Is Nav?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to show slider arrow navigation?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'no',
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'team_mode_style',
                                            'operator'  => 'in',
                                            'value'     => ['2'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_control(
                    'team_slide_dots',
                    [
                            'label'             => esc_html__( 'Is Dots?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to show slider bullets item?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'no',
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'team_mode_style',
                                            'operator'  => 'in',
                                            'value'     => ['2'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_control( 'tw_item_per_row_1', [
                    'label' => esc_html__('Items XL Device', 'themewar'),
                    'type' => Controls_Manager::SELECT,
                    'description' => esc_html__('How many item you want to show per row on Extra Large Screen?', 'themewar'),
                    'default' => '3',
                    'multiple' => false,
                    'options' => [
                        2 => esc_html__('2 Items', 'themewar'),
                        3 => esc_html__('3 Items', 'themewar'),
                        4 => esc_html__('4 Items', 'themewar'),
                        6 => esc_html__('6 Items', 'themewar'),
                    ],
                    'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'team_mode_style',
                                    'operator'  => 'in',
                                    'value'     => ['2'],
                            ]
                        ],
                    ],
                ]
            );
            $this->add_control( 'tw_item_per_row_2', [
                    'label' => esc_html__('Items LG Device', 'themewar'),
                    'type' => Controls_Manager::SELECT,
                    'description' => esc_html__('How many item you want to show per row on Large Screen?', 'themewar'),
                    'default' => '3',
                    'multiple' => false,
                    'options' => [
                        2 => esc_html__('2 Items', 'themewar'),
                        3 => esc_html__('3 Items', 'themewar'),
                        4 => esc_html__('4 Items', 'themewar')
                    ],
                    'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'team_mode_style',
                                    'operator'  => 'in',
                                    'value'     => ['2'],
                            ]
                        ],
                    ],
                ]
            );
            $this->add_control( 'tw_item_per_row_3', [
                    'label' => esc_html__('Items MD Device', 'themewar'),
                    'type' => Controls_Manager::SELECT,
                    'description' => esc_html__('How many item you want to show per row on Medium Screen?', 'themewar'),
                    'default' => '2',
                    'multiple' => false,
                    'options' => [
                        2 => esc_html__('2 Items', 'themewar'),
                        3 => esc_html__('3 Items', 'themewar'),
                        4 => esc_html__('4 Items', 'themewar')
                    ],
                    'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'team_mode_style',
                                    'operator'  => 'in',
                                    'value'     => ['2'],
                            ]
                        ],
                    ],
                ]
            );
            $this->add_control(
                    'tw_gapping',
                    [
                            'label' => esc_html__( 'Items Gapping', 'themewar' ),
                            'type' => Controls_Manager::NUMBER,
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                            'default' => 0,
                            'description'   => esc_html__('Insert items gapping if you want.', 'themewar'),
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'team_mode_style',
                                            'operator'  => 'in',
                                            'value'     => ['2'],
                                    ]
                                ],
                            ],
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_1',
            [
                'label'         => esc_html__('Team Member Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_responsive_control(
                'icon_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cmTeam' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cmTeam' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_image', [
                'label'     => esc_html__( 'Image Styling', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'      => 'ab_img_shadow',
                        'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmTeam img',
                ]
        );
        $this->add_responsive_control(
            'ab_img_radius',
            [
                    'label'      => esc_html__( 'Border Radius', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .cmTeam img'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
                'tm_image_width',
                [
                        'label' => esc_html__( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .cmTeam img' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'tm_image_height',
                [
                        'label' => esc_html__( 'Height', 'themewar' ),
                        'type'  => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .cmTeam img' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_overlay', [
                'label'     => esc_html__( 'Overlay Style Styling', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms' => [
                        [
                                'name'      => 'team_view_style',
                                'operator'  => 'in',
                                'value'     => ['1', '2', '5', '6'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'overlay_color',
                    'label' => esc_html__( 'Background', 'themewar' ),
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .tm_thumb:after, {{WRAPPER}} .team_02:after, {{WRAPPER}} .team_05:after, {{WRAPPER}} .team_06:after'
                ]
        );
        $this->add_responsive_control(
            'overlay_img_radius',
            [
                    'label'      => esc_html__( 'Border Radius', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .tm_thumb:after'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .team_02:after'    => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .team_05:after'    => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .team_06:after'    => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_content_area', [
                'label'     => esc_html__( 'Content Area Styling', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms' => [
                        [
                                'name'      => 'team_view_style',
                                'operator'  => 'in',
                                'value'     => ['4'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'area_color',
                    'label' => esc_html__( 'Background', 'themewar' ),
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .tmcontent'
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'      => 'area_shadow',
                        'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .tmcontent',
                ]
        );
        $this->add_responsive_control(
            'area_border_radius',
            [
                    'label'      => esc_html__( 'Border Radius', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .tmcontent'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
                'con_area_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .tmcontent' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'con_area_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .tmcontent' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2',
            [
                'label'         => esc_html__('Social Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_responsive_control(
                'icon_width',
                [
                        'label' => esc_html__( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .tmscm a' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_height',
                [
                        'label' => esc_html__( 'Height', 'themewar' ),
                        'type'  => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .tmscm a' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .tmscm a',
                ]
        );
        $this->start_controls_tabs( 'ib_box_tot' );
            $this->start_controls_tab(
                'ib_box_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
            $this->add_responsive_control(
                    'icon_color',[
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .tmscm a' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .team_03 .tm_social a' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_bg_color',[
                            'label'     => esc_html__( 'BG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .tmscm a' => 'background: {{VALUE}}',
                                    '{{WRAPPER}} .team_03 .tm_social' => 'background: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_radius',
                    [
                            'label' => esc_html__( 'Radius', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .tmscm a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .team_03 .tm_social' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Css_Filter::get_type(),
                    [
                            'name'      => 'icon_filter',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .tmscm a, {{WRAPPER}} .team_03 .tm_social a',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'icon_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .tmscm a, {{WRAPPER}} .team_03 .tm_social a',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_box_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_responsive_control(
                    'icon_hover_color',[
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .tmscm a:hover' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .team_03 .tm_social a:hover' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_hover_bg_color',[
                            'label'     => esc_html__( 'BG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .tmscm a:hover' => 'background: {{VALUE}}',
                                    '{{WRAPPER}} .team_03 .tm_social:hover' => 'background: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_hover_box_radius',
                    [
                            'label' => esc_html__( 'Radius', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .tmscm a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .team_03 .tm_social' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Css_Filter::get_type(),
                    [
                            'name'      => 'icon_hover_filter',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .tmscm a:hover, {{WRAPPER}} .team_03 .tm_social a:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'icon_hover_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .tmscm a:hover, {{WRAPPER}} .team_03 .tm_social a:hover',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_author',
            [
                'label'         => esc_html__('Author Name Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_responsive_control(
                'au_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmTeam h3' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'au_hover_color',[
                        'label'     => esc_html__( 'Hover Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmTeam h3 a:hover' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'au_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmTeam h3',
                ]
        );
        $this->add_responsive_control(
                'au_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmTeam h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_designation',
            [
                'label'         => esc_html__('Designation Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_responsive_control(
                'dg_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmTeam p' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'dg_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmTeam p',
                ]
        );
        $this->add_responsive_control(
                'dg_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cmTeam p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_nav', [
                    'label'             => esc_html__('Nav Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'team_view_style',
                                    'operator'  => '!in',
                                    'value'     => ['3'],
                            ],
                            [
                                    'name'      => 'team_slide_nav',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'nav_i_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-nav button'
                ]
        );
        $this->add_responsive_control(
                'bl_nav_radius',
                [
                        'label' => esc_html__( 'Nav  Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-nav button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .gradianNav.owl-carousel .owl-nav button:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'nav_styling_tab' );
            $this->start_controls_tab(
                    'nav_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_color',
                    [
                            'label' => esc_html__( 'Nav Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-nav button' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'bl_nav_bg',
                        'label' => esc_html__( 'Nav Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-nav button',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'bl_nav_bg_shadow',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-nav button',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'bl_nav_bg_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-nav button',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'nav_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_color_hover',
                    [
                            'label' => esc_html__( 'Nav Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-nav button:hover' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'bl_nav_bg_hover',
                        'label' => esc_html__( 'Nav Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-nav button:hover, {{WRAPPER}} .gradianNav.owl-carousel .owl-nav button:after',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'bl_nav_bg_shadow_hover',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-nav button:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'bl_nav_bg_border_hover',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-nav button:hover',
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'left_nav_margin',
                    [
                            'label'      => esc_html__( 'Left Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-nav button.owl-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'right_nav_margin',
                    [
                            'label'      => esc_html__( 'Right Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-nav button.owl-next' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_svg_nav', [
                    'label'             => esc_html__('Nav Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'team_view_style',
                                    'operator'  => 'in',
                                    'value'     => ['3'],
                            ],
                            [
                                    'name'      => 'team_slide_nav',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'nav_svg_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .tmSlider_wrap .serArrows a'
                ]
        );
        $this->start_controls_tabs( 'nav_svg_styling_tab' );
            $this->start_controls_tab(
                    'nav_svg_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_color',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .tmSlider_wrap .tmArrows a' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_bg_color',
                    [
                            'label' => esc_html__( 'BG Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .tmSlider_wrap .tmArrows a svg path' => 'fill: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Css_Filter::get_type(),
                    [
                            'name'      => 'box_svg_filter',
                            'label'     => esc_html__( 'BG Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .tmSlider_wrap .tmArrows a svg',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'nav_svg_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_color_hover',
                    [
                            'label' => esc_html__( 'Nav Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .tmSlider_wrap .tmArrows a:hover' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_hover_bg_color',
                    [
                            'label' => esc_html__( 'BG Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .tmSlider_wrap .tmArrows a:hover svg path' => 'fill: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Css_Filter::get_type(),
                    [
                            'name'      => 'box_hover_svg_filter',
                            'label'     => esc_html__( 'BG Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .tmSlider_wrap .tmArrows a:hover svg',
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'left_svg_nav_margin',
                    [
                            'label'      => esc_html__( 'Left Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .tmSlider_wrap .tmArrows a.prevArrow' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'right_svg_nav_margin',
                    [
                            'label'      => esc_html__( 'Right Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .tmSlider_wrap .tmArrows a.nextArrow' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_04', [
                    'label'             => esc_html__('Dots Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'condition'         => ['team_slide_dots' => 'yes']
                ]
        );
            $this->add_responsive_control(
                    'dots_width',
                    [
                            'label' => esc_html__( 'Dots Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 50,
                                            'step' => 1,
                                    ]
                            ],
                            'default' => [
                                    'unit' => 'px',
                                    'size' => '',
                            ],
                            'selectors' => [
                                    '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button' => 'width: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'dots_height',
                    [
                            'label' => esc_html__( 'Dots Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 50,
                                            'step' => 1,
                                    ]
                            ],
                            'default' => [
                                    'unit' => 'px',
                                    'size' => '',
                            ],
                            'selectors' => [
                                    '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button' => 'height: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
            $this->start_controls_tabs( 'dot_styling_tab' );
                $this->start_controls_tab(
                        'dot_styling_tab_normal',
                        [
                                'label' => esc_html__( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'bl_dot_bg',
                            'label' => esc_html__( 'Nav Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'bl_dot_shadow',
                                'label' => esc_html__( 'Dots Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'bl_dot_bg_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button',
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'dot_styling_tab_hover',
                        [
                                'label' => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'bl_dot_hover_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button:hover, {{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button.active',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'bl_dot_hover_shadow',
                                'label' => esc_html__( 'Dots Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button:hover, {{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button.active',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'bl_dot_hover_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button:after',
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'bl_dot_radius',
                    [
                            'label' => esc_html__( 'Dots  Radius', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_dot_margin',
                    [
                            'label' => esc_html__( 'Dots  Gapping', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_dots_margin',
                    [
                            'label' => esc_html__( 'Dot Area Margins', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .tmSlider_wrap .owl-carousel .owl-dots' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings      = $this->get_settings_for_display();
        $styles        = (isset($settings['team_view_style']) && $settings['team_view_style'] > 0) ? $settings['team_view_style'] : 1;
        $team_mode     = (isset($settings['team_mode_style']) && $settings['team_mode_style'] > 0) ? $settings['team_mode_style'] : 1;
        $column        = (isset($settings['column']) && $settings['column'] > 0) ? $settings['column'] : 4;

        $grid_xl_col        = (isset($settings['grid_xl_col']) && $settings['grid_xl_col'] > 0) ? $settings['grid_xl_col'] : 2;
        $grid_lg_col        = (isset($settings['grid_lg_col']) && $settings['grid_lg_col'] > 0) ? $settings['grid_lg_col'] : 2;
        $grid_md_col        = (isset($settings['grid_md_col']) && $settings['grid_md_col'] > 0) ? $settings['grid_md_col'] : 2;
        $team_specific      = (isset($settings['team_specific']) && !empty($settings['team_specific'])? $settings['team_specific'] : array());
        
        $is_linked     = (isset($settings['team_is_details']) && $settings['team_is_details'] != '') ? $settings['team_is_details'] : 'yes';
        
        $autoplay       = (isset($settings['team_slide_autoplay']) && $settings['team_slide_autoplay'] != '') ? $settings['team_slide_autoplay'] : 'no';
        $loop           = (isset($settings['team_slide_loop']) && $settings['team_slide_loop'] != '') ? $settings['team_slide_loop'] : 'no';
        $nav            = (isset($settings['team_slide_nav']) && $settings['team_slide_nav'] != '') ? $settings['team_slide_nav'] : 'no';
        $dots           = (isset($settings['team_slide_dots']) && $settings['team_slide_dots'] != '') ? $settings['team_slide_dots'] : 'no';
        $team_is_masnry = (isset($settings['team_is_masnry']) && $settings['team_is_masnry'] != '') ? $settings['team_is_masnry'] : 'no';

        $tw_item_per_row_1 = (isset($settings['tw_item_per_row_1']) && $settings['tw_item_per_row_1'] > 0 ? $settings['tw_item_per_row_1'] : 3);
        $tw_item_per_row_2 = (isset($settings['tw_item_per_row_2']) && $settings['tw_item_per_row_2'] > 0 ? $settings['tw_item_per_row_2'] : 3);
        $tw_item_per_row_3 = (isset($settings['tw_item_per_row_3']) && $settings['tw_item_per_row_3'] > 0 ? $settings['tw_item_per_row_3'] : 2);
        $tw_gapping        = (isset($settings['tw_gapping']) && $settings['tw_gapping'] != '' ? $settings['tw_gapping'] : 0);
        
        $order          = (isset($settings['order']) && $settings['order'] != '') ? $settings['order'] : 'DESC';
        $order_by       = (isset($settings['order_by']) && $settings['order_by'] != '') ? $settings['order_by'] : 'date';
        $no_of_items    = (isset($settings['no_of_items']) && $settings['no_of_items'] > 0) ? $settings['no_of_items'] : 4;

        if($grid_xl_col == 1):
            $xl = 'col-xl-3 ';
        elseif($grid_xl_col == 3):
            $xl = 'col-xl-6 ';
        else:
            $xl = 'col-xl-4 ';
        endif;

        if($grid_lg_col == 1):
            $lg = 'col-lg-3';
        elseif($grid_lg_col == 3):
            $lg = 'col-lg-6';
        else:
            $lg = 'col-lg-4';
        endif;

        if($grid_md_col == 1):
            $md = ' col-md-4';
        elseif($grid_md_col == 3):
            $md = ' col-md-12';
        else:
            $md = ' col-md-6';
        endif;
        
        include  dirname(__FILE__).'/style/team/style'.$styles.'.php';
    
    }
    
    protected function content_template() {}
}