<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Tabs_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-tabs';
    }
    
    public function get_title() {
        return esc_html__( 'Tabs Block', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-tabs';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        global $wpdb;
        $table = $wpdb->prefix.'posts';
        $result = $wpdb->get_results( 'SELECT * FROM '.$table.' WHERE post_type="blocks" AND post_status="publish" ORDER BY post_title ASC', OBJECT );
        $shortcodes = array('0' => esc_html__('None', 'themewar'));
        if(is_array($result) && count($result) > 0){
            foreach($result as $r){
                $shortcodes[$r->ID] = $r->post_title;
            }
        }
        $this->start_controls_section(
            'section_tab_1', [
                'label'     => esc_html__( 'Tabs Block', 'themewar' ),
            ]
        );
        $this->add_control(
                'tabs_style',
                [
                        'label'     => esc_html__( 'Tabs Block Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'label_block'   => TRUE,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Tab 01', 'themewar' ),
                                2       => esc_html__( 'Tab 02', 'themewar' ),
                                3       => esc_html__( 'Tab 03', 'themewar' ),
                                4       => esc_html__( 'Tab 04', 'themewar' ),
                                5       => esc_html__( 'Tab 05', 'themewar' ),
                        ],
                ]
        );
        $repeater = new \Elementor\Repeater();
            $repeater->add_control(
                    'tab_icons',
                    [
                            'label'         => esc_html__( 'Icon', 'themewar' ),
                            'type'          => Controls_Manager::ICON,
                            'label_block'   => TRUE,
                            'description'   => esc_html__('this option not work tab style 03 and 05.', 'themewar'),
                    ]
            );
            $repeater->add_control(
                    'tab_title',
                    [
                            'label'         => esc_html__( 'Tab Title Text', 'themewar' ),
                            'type'          => Controls_Manager::TEXT,
                            'default'       => '',
                            'label_block'   => true,
                            'placeholder'   => esc_html__('Insert tab title', 'themewar')
                    ]
            );
            $repeater->add_control(
                    'tab_stitle',
                    [
                            'label'         => esc_html__( 'Tab Sub Title Text', 'themewar' ),
                            'type'          => Controls_Manager::TEXT,
                            'default'       => '',
                            'label_block'   => true,
                            'placeholder'   => esc_html__('Insert tab sub title', 'themewar'),
                            'description'   => esc_html__('this option work only tab style 03 and 05.', 'themewar'),

                    ]
            );
            $repeater->add_control(
                'tab_block',
                [
                        'label'         => esc_html__( 'Select Block', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'default'       => '0',
                        'label_block'   => true,
                        'options'       => $shortcodes,
                        'description'   => esc_html__('create block from blocks post.', 'themewar'),
                ]
            );
        $this->add_control(
            'list',
            [
                    'label'         => esc_html__( 'Tab Block Item', 'themewar' ),
                    'type'          => Controls_Manager::REPEATER,
                    'fields'        => $repeater->get_controls(),
                    'default'       => [
                            [
                                    'tab_icons'       => esc_html__( '', 'themewar' ),
                                    'tab_stitle'      => esc_html__( '', 'themewar' ),
                                    'tab_title'       => esc_html__( '', 'themewar' ),
                                    'tab_block'       => esc_html__( '0', 'themewar' ),

                            ],
                    ],
                    'title_field' => '{{{ tab_title }}}',
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2',
            [
                'label'     => esc_html__('Tab Title Style', 'themewar'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'title_typography',
                        'label' => esc_html__( 'Title Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .bpcmtab li a',
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'          => 'subtitle_typography',
                        'label'         => esc_html__( 'Sub Title Typography', 'themewar' ),
                        'selector'      => '{{WRAPPER}} .bpcmtab li a span',
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'tabs_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'title_icon_typography',
                        'label' => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .bpcmtab li a i, {{WRAPPER}} .pricingTab04 li a:after, {{WRAPPER}} .pricingTab05 li a:before',
                ]
        );
        $this->add_responsive_control(
                't_title_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .bpcmtab li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
            't_title_margin',
            [
                    'label' => esc_html__( 'Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                            '{{WRAPPER}} .bpcmtab li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
                't_stitle_padding',
                [
                        'label' => esc_html__( 'Sub Title Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .bpcmtab li a span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'tabs_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
            't_title_icon_margin',
            [
                    'label' => esc_html__( 'Icon Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                            '{{WRAPPER}} .bpcmtab li a i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTab04 li a:after' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTab05 li a:before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
                'hover_active_title_border_color',
                [
                        'label'     => esc_html__( 'Hover / Active Border Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .bpcmtab li a:after' => 'background: {{VALUE}}',
                                '{{WRAPPER}} .beproTab03 li a:after' => 'background: {{VALUE}}',
                        ],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'tabs_style',
                                        'operator'  => 'in',
                                        'value'     => ['1', '4'],
                                ]
                            ],
                        ],
                ]
        );
        $this->start_controls_tabs( 'style_tabs_3' );
            $this->start_controls_tab(
                    'title_style_normal',
                    [
                            'label'     => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'title_color',
                    [
                            'label'     => esc_html__( 'Title Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .bpcmtab li a' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'stitle_color',
                    [
                            'label'     => esc_html__( 'Sub Title Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .bpcmtab li a span' => 'color: {{VALUE}}',
                            ],
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'tabs_style',
                                            'operator'  => '==',
                                            'value'     => '3',
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'title_icon_color',
                    [
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .bpcmtab li a i' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .pricingTab04 li a:after' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .pricingTab05 li a:before' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'title_icon_bg_color',
                    [
                            'label'     => esc_html__( 'Icon BG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .beproTab03 li a i' => 'background: {{VALUE}}',
                            ],
                            'conditions'    => [
                                'terms'     => [
                                    [
                                            'name'      => 'tabs_style',
                                            'operator'  => '==',
                                            'value'     => '4',
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'title__bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .bpcmtab li a',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'title__border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .bpcmtab li a',
                    ]
            );
            $this->add_responsive_control(
                'title_border_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .bpcmtab li a'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'title_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .bpcmtab li a',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'title_style_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_icon_hover_gradina',
                            'label' => esc_html__( 'Gradian Color', 'themewar' ),
                            'types' => ['gradient'],
                            'selector' => '{{WRAPPER}} .pricingTab04 li a:hover',
                            'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'tabs_style',
                                                'operator'  => '==',
                                                'value'     => '3',
                                        ]
                                    ],
                            ],
                    ]
            );
            $this->add_control(
                'heading_hover_gradian',
                [
                    'label'     => esc_html__( 'All Title Gradian Color', 'themewar' ),
                    'type'      => Controls_Manager::HEADING,
                    'separator' => 'after',
                    'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'tabs_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                    ],
                ]
            );
            $this->add_responsive_control(
                    'hover_title_color',
                    [
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .bpcmtab li a:hover' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'title_icon_hover_color',
                    [
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .bpcmtab li a:hover i' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .pricingTab05 li a:hover:before' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'title_icon_hover_bg_color',
                    [
                            'label'     => esc_html__( 'Icon BG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .beproTab03 li a:hover i' => 'background: {{VALUE}}',
                            ],
                            'conditions'    => [
                                'terms'     => [
                                    [
                                            'name'      => 'tabs_style',
                                            'operator'  => '==',
                                            'value'     => '4',
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'hover_title__bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .bpcmtab li a:hover, {{WRAPPER}} .pricingTab05 li a:hover:after',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'hover_title__border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .bpcmtab li a:hover, {{WRAPPER}} .pricingTab05 li a:after',
                    ]
            );
            $this->add_responsive_control(
                'hover_title_border_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .bpcmtab li a:hover'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTab05 li a:after'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'title_hover_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .bpcmtab li a:hover',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'title_style_active',
                    [
                            'label' => esc_html__( 'Active', 'themewar' ),
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_icon_active_gradina',
                            'label' => esc_html__( 'Gradian Color', 'themewar' ),
                            'types' => ['gradient'],
                            'selector' => '{{WRAPPER}} .pricingTab04 li a.active',
                            'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'tabs_style',
                                                'operator'  => '==',
                                                'value'     => '3',
                                        ]
                                    ],
                            ],
                    ]
            );
            $this->add_control(
                'heading_active_gradian',
                [
                    'label'     => esc_html__( 'All Title Gradian Color', 'themewar' ),
                    'type'      => Controls_Manager::HEADING,
                    'separator' => 'after',
                    'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'tabs_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                    ],
                ]
            );
            $this->add_responsive_control(
                    'active_title_color',
                    [
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .bpcmtab li a.active' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'title_icon_active_color',
                    [
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .bpcmtab li a.active i' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .pricingTab05 li a.active:after' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'title_icon_active_bg_color',
                    [
                            'label'     => esc_html__( 'Icon BG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .beproTab03 li a.active i' => 'background: {{VALUE}}',
                            ],
                            'conditions'    => [
                                'terms'     => [
                                    [
                                            'name'      => 'tabs_style',
                                            'operator'  => '==',
                                            'value'     => '4',
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'active_title__bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .bpcmtab li a.active, {{WRAPPER}} .pricingTab05 li a.active:after',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'active_title__border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .bpcmtab li a.active',
                    ]
            );
            $this->add_responsive_control(
                'active_title_border_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .bpcmtab li a.active'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTab05 li a:after'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'active_title_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .bpcmtab li a.active',
                    ]
            );
            $this->add_responsive_control(
                'actvive_tab_title_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .bpcmtab.beproTab02 li a.active' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'tabs_style',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'tab_area_style',
            [
                'label'     => esc_html__( 'Tab Area Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'tab_area__bg',
                    'label' => esc_html__( 'Background', 'themewar' ),
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .bpcmtab',
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'tab_area__border',
                        'label'     => esc_html__( 'Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .bpcmtab',
                ]
        );
        $this->add_responsive_control(
            'tab_area_border_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .bpcmtab'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'      => 'tab_area_shadow',
                        'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .bpcmtab',
                ]
        );
        $this->add_responsive_control(
            'tab_area_padding',
            [
                    'label' => esc_html__( 'Paddings', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .bpcmtab' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_margin',
            [
                    'label' => esc_html__( 'Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .bpcmtab' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_tp_positioning',
            [
                    'label' => esc_html__( 'Top Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['top'],
                    'selectors' => [
                        '{{WRAPPER}} .bpcmtab'   => 'top: {{TOP}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_rp_positioning',
            [
                    'label' => esc_html__( 'Right Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['right'],
                    'selectors' => [
                        '{{WRAPPER}} .bpcmtab'   => 'right: {{RIGHT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_bp_positioning',
            [
                    'label' => esc_html__( 'Bottom Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['bottom'],
                    'selectors' => [
                        '{{WRAPPER}} .bpcmtab' => 'bottom: {{BOTTOM}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_lp_positioning',
            [
                    'label' => esc_html__( 'Left Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['left'],
                    'selectors' => [
                        '{{WRAPPER}} .bpcmtab' => 'left: {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();

    }
    
    protected function render() {
        $settings       = $this->get_settings_for_display();
        $tabs_style     = (isset($settings['tabs_style']) && $settings['tabs_style'] !='') ? $settings['tabs_style'] : 1;
        
        $list           = (isset($settings['list']) && !empty($settings['list'])) ? $settings['list'] : array();
        
        include dirname(__FILE__).'/style/tabs/style'.$tabs_style.'.php';
    }
    
    protected function content_template() {
        
    }
}