<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Socail_Share_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-social-share';
    }
    
    public function get_title() {
        return esc_html__( 'Post Socail Share', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-social-icons';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Socail Share', 'themewar' ),
            ]
        );
        $this->add_control(
                'important_note',
                [
                        'label' => esc_html__( 'Important Note', 'themewar' ),
                        'type'  => Controls_Manager::RAW_HTML,
                        'raw'  => esc_html__( 'This shortcode specialy build for <strong> Portfolio, Service and Team </strong> details post socail share icon.', 'themewar' ),
                        'content_classes' => 'alert alert-warning',
                ]
        );
        $this->add_control(
                'is_inline',
                [
                        'label'             => esc_html__( 'Is Inline Share?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to inline this social icon and title?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                ]
        );
        $this->add_control(
                'title',
                [
                        'label'         => esc_html__( 'Social Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                ]
        );
        $this->add_control(
                'social_links',
                [
                        'label'         => esc_html__( 'Social Share', 'themewar' ),
                        'type'          => Controls_Manager::SELECT2,
                        'label_block'   => TRUE,
                        'multiple'      => true,
                        'default'       => array(),
                        'options'       => [
                            1       => esc_html__( 'Facebook', 'themewar' ),
                            2       => esc_html__( 'Twitter', 'themewar' ),
                            3       => esc_html__( 'Reddit', 'themewar' ),
                            4       => esc_html__( 'Linkedin', 'themewar' ),
                            5       => esc_html__( 'Tumblr', 'themewar' ),
                            6       => esc_html__( 'Pinterest', 'themewar' ),
                            7       => esc_html__( 'Digg', 'themewar' ),
                        ],
                ]
        );
        $this->add_responsive_control(
            'list_align', [
                    'label'                     => esc_html__( 'Alignment', 'themewar' ),
                    'type'                      => Controls_Manager::CHOOSE,
                    'options'                   => [
                            'left'       => [
                                    'title'  => esc_html__( 'Left', 'themewar' ),
                                    'icon'   => 'eicon-text-align-left',
                            ],
                            'center'     => [
                                    'title'  => esc_html__( 'Center', 'themewar' ),
                                    'icon'   => 'eicon-text-align-center',
                            ],
                            'right'      => [
                                    'title'  => esc_html__( 'Right', 'themewar' ),
                                    'icon'   => 'eicon-text-align-right',
                            ]
                    ],
                    'default'                   => 'left',
                    'prefix_class'              => 'social_align elementor%s-align-',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_3',[
                    'label'         => esc_html__('Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_control(
                'icon_box_title_color',[
                        'label'     => esc_html__( 'Title Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .socail_share h5' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_title_typo',
                        'label'     => esc_html__( 'Title Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .socail_share h5',
                ]
        );
        $this->add_control(
                'icon_box_title_margin',
                [
                        'label'      => esc_html__( 'Title Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .socail_share h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_4',
            [
                'label'         => esc_html__('Social Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_responsive_control(
                'icon_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .socail_share a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ]
                ]
        );
        $this->add_responsive_control(
                'icon_width',
                [
                        'label' => esc_html__( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .socail_share a' => 'width: {{SIZE}}{{UNIT}};'
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_height',
                [
                        'label' => esc_html__( 'Height', 'themewar' ),
                        'type'  => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .socail_share a' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .socail_share a',
                ]
        );
        $this->start_controls_tabs( 'ib_box_tot' );
            $this->start_controls_tab(
                'ib_box_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
            $this->add_responsive_control(
                    'icon_color',[
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .socail_share a' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_bg_color',[
                            'label'     => esc_html__( 'BG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .socail_share a' => 'background: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_radius',
                    [
                            'label' => esc_html__( 'Radius', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .socail_share a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .socail_share a',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'icon_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .socail_share a',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_box_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_responsive_control(
                    'icon_hover_color',[
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .socail_share a:hover' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_hover_bg_color',[
                            'label'     => esc_html__( 'BG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .socail_share a:hover' => 'background: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_hover_box_radius',
                    [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .socail_share a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_hover_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .socail_share a:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'icon_hover_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .socail_share a:hover',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings           = $this->get_settings_for_display();
        $title              = $settings['title'];
        $is_inline          = $settings['is_inline'];
        $social_links       = (isset($settings['social_links']) && !empty($settings['social_links'])) ? $settings['social_links'] : array();
        
        if(is_singular()):
            global $post;
            $post_id = $post->ID;
            if (get_post_type($post_id) == 'folio' || get_post_type($post_id) == 'service' || get_post_type($post_id) == 'team' || get_post_type($post_id) == 'post'):
                $post_type = get_post_type($post_id);
                if(!empty($social_links)):
                    ?>
                    <div class="socail_share <?php if($is_inline == 'yes'): ?>ssInline<?php endif; ?>">
                        <?php if($title != ''): ?><h5><?php echo wp_kses_post($title); ?></h5><?php endif; ?>
                        <?php
                            if(in_array(1, $social_links)){ echo '<a target="_blank" href="https://www.facebook.com/sharer.php?u='.get_the_permalink($post_id).'&title='.esc_url(get_the_title($post_id)).'"><i class="twi-facebook-f"></i></a>'; }
                            if(in_array(2, $social_links)){ echo '<a target="_blank" href="https://twitter.com/intent/tweet?url='.get_the_permalink($post_id).'&text='.esc_url(get_the_title($post_id)).'"><i class="twi-twitter"></i></a>'; }
                            if(in_array(3, $social_links)){ echo '<a target="_blank" href="https://reddit.com/submit?url='.get_the_permalink($post_id).'&title='.esc_url(get_the_title($post_id)).'"><i class="twi-reddit-alien"></i></a>'; }
                            if(in_array(4, $social_links)){ echo '<a target="_blank" href="https://www.linkedin.com/shareArticle?mini=true&url='.get_the_permalink($post_id).'&title='.esc_url(get_the_title($post_id)).'"><i class="twi-linkedin-in"></i></a>'; }
                            if(in_array(5, $social_links)){ echo '<a target="_blank" href="https://www.tumblr.com/widgets/share/tool?canonicalUrl='.get_the_permalink($post_id).'&title='.esc_url(get_the_title($post_id)).'"><i class="twi-tumblr"></i></a>'; }
                            if(in_array(6, $social_links)){ echo '<a target="_blank" href="https://pinterest.com/pin/create/bookmarklet/?media='.get_the_post_thumbnail_url($post_id, 'full').'&url='.get_the_permalink().'&is_video=false&description='.esc_url(get_the_title($post_id)).'"><i class="twi-pinterest-p"></i></a>'; }
                            if(in_array(7, $social_links)){ echo '<a target="_blank" href="https://digg.com/submit?url='.get_the_permalink($post_id).'&title='.esc_url(get_the_title($post_id)).'"><i class="twi-digg"></i></a>'; }
                        ?>
                    </div>
                    <?php
                endif;
            else:
                echo '<div class="alert alert-warning">'.__('This shortcode specialy build for <strong>Service, Follio, Team Or Post</strong> details page content.', 'themewar').'</div>';
            endif;
        else:
            echo '<div class="alert alert-warning">'.__('This shortcode specialy build for <strong>Service, Follio, Team Or Post</strong> details page content.', 'themewar').'</div>';
        endif;
        
    }
    
    protected function content_template() {}
    
}