<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Skill_Bar_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-skill-bar';
    }
    
    public function get_title() {
        return esc_html__( 'Skills Bar', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-skill-bar';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab_1', [
                'label' => esc_html__( 'Skills', 'themewar' ),
            ]
        );
        $this->add_control(
                'skstyle',
                [
                        'label'     => esc_html__( 'Skills Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'label_block'   => TRUE,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'without Icon / Image', 'themewar' ),
                                2       => esc_html__( 'With Icon / Image', 'themewar' ),
                                3       => esc_html__( 'With Icon', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'icon_or_image',
                [
                        'label'     => esc_html__( 'Icon Or Image', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 2,
                        'options'   => [
                                1       => esc_html__( 'Icon', 'themewar' ),
                                2       => esc_html__( 'Image', 'themewar' ),
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'skstyle',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'icons',
                [
                        'label'     => esc_html__( 'Icon', 'themewar' ),
                        'type'      => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'skstyle',
                                        'operator'  => 'in',
                                        'value'     => ['2', '3'],
                                ],
                                [
                                        'name'      => 'icon_or_image',
                                        'operator'  => '==',
                                        'value'     => '1',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'images',
                [
                        'label' => esc_html__( 'Choose Image', 'themewar' ),
                        'label_block'   => TRUE,
                        'type' => Controls_Manager::MEDIA,
                        'default' => [],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'skstyle',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ],
                                [
                                        'name'      => 'icon_or_image',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'sk_title',
                [
                        'label'         => esc_html__( 'Skill Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => esc_html__('Consulting', 'themewar'),
                        'placeholder'   => esc_html__('sk title', 'themewar')
                ]
        );
        $this->add_control(
                'percent',
                [
                        'label'         => esc_html__( 'Precent', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'default'       => 88,
                        'placeholder'   => esc_html__('Precent', 'themewar')
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_4', [
                    'label'         => esc_html__('Skill Area Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'      => 'bar_area_normal_background',
                        'label'     => esc_html__( 'Background', 'themewar' ),
                        'types'     => [ 'classic', 'gradient'],
                        'selector'  => '{{WRAPPER}} .cmskbar',
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'sk_area_border',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .cmskbar',
                ]
        );
        $this->add_control(
                'sk_area_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cmskbar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'sk_area_box_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .cmskbar',
                ]
        );
        $this->add_control(
                'sk_area_padding',
                [
                        'label'      => esc_html__( 'Padding', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmskbar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'sk_area_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmskbar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_iimage',[
                    'label'         => esc_html__('Icon / Image Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'skstyle',
                                    'operator'  => '==',
                                    'value'     => '2',
                            ],
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_i_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .skThumb'
                ]
        );
        $this->add_control(
                'icon_box_i_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .skThumb' => 'color: {{VALUE}}',
                        ]
                ]
        );
        $this->add_control(
                'icon_box_i_bgcolor',[
                        'label'     => esc_html__( 'BG Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .skThumb' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
            'icon_box_i_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .skThumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
                'icon_box_i_width',
                [
                        'label' => __( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .skThumb' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_i_height',
                [
                        'label' => __( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .skThumb' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'icon_box_i_border_hr',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .skThumb',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_i__shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .skThumb',
                ]
        );
        $this->add_control(
                'icon_box_i_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .skThumb' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->add_control(
                'icon_box_i_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .skThumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_5',[
                    'label'     => esc_html__('Skill Title & Percent Number Style', 'themewar'),
                    'tab'       => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_control(
            'count_title_icon_style',
            [
                'label'     => esc_html__( 'Title Icon Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions'    => [
                    'terms' => [
                        [
                                'name'      => 'skstyle',
                                'operator'  => '==',
                                'value'     => '3',
                        ],
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'sk_title_icon_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmskbar h5 i',
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'skstyle',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ],
                            ],
                        ],
                ]
        );
        $this->add_control(
                'sk_title_icon_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .cmskbar h5 i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'skstyle',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ],
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'      => 'ti_cion_background',
                        'label'     => esc_html__( 'Background', 'themewar' ),
                        'types'     => [ 'classic', 'gradient'],
                        'selector'  => '{{WRAPPER}} .cmskbar h5 i',
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'skstyle',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ],
                            ],
                        ],
                ]
        );
        $this->add_control(
            'sk_title_style',
            [
                'label'     => esc_html__( 'Skill Title Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
                'sk_title_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmskbar h5' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'sk_title_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmskbar h5',
                ]
        );
        $this->add_control(
                'sk_title_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .cmskbar h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'count_precent_style',
            [
                'label'     => esc_html__( 'Percent Number Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
                    'percent_color',[
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .ss_parent span' => 'color: {{VALUE}}',
                            ],
                    ]
          );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'percent_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ss_parent span',
                ]
        );
        $this->add_control(
                'percent_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .ss_parent span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_7', [
                    'label'         => esc_html__('Skill Bar Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        ); 
        $this->add_control(
            'width',
            [
                    'label' => __( 'Bar Width', 'themewar' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                            'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                    'step' => 1,
                            ],
                            '%' => [
                                    'min' => 0,
                                    'max' => 100,
                            ],
                    ],
                    'default' => [],
                    'selectors' => [
                            '{{WRAPPER}} .ss_parent' => 'width: {{SIZE}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
                'height',
                [
                        'label' => __( 'Bar Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .ss_parent' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'style_tabs_10' );
            $this->start_controls_tab(
                    's_5_style_normal',
                    [
                            'label' => esc_html__( 'Normal Color', 'themewar' ),
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'bar_normal_background',
                            'label'     => esc_html__( 'Background', 'themewar' ),
                            'types'     => [ 'classic', 'gradient'],
                            'selector'  => '{{WRAPPER}} .ss_parent',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'sk_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ss_parent',
                    ]
            );
            $this->add_control(
                    'sk_radius',
                    [
                            'label' => esc_html__( 'Border Radius', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .ss_parent' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'sk_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ss_parent',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    's_5_style_hover',
                    [
                            'label' => esc_html__( 'Foreground Color', 'themewar' ),
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'bar_forground_background',
                            'label'     => esc_html__( 'Background', 'themewar' ),
                            'types'     => [ 'classic', 'gradient'],
                            'selector'  => '{{WRAPPER}} .ss_child',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'sk_f_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ss_child',
                    ]
            );
            $this->add_control(
                    'sk_f_radius',
                    [
                            'label' => esc_html__( 'Border Radius', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .ss_child' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'sk_f_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ss_child',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings       = $this->get_settings_for_display();
        $skstyle        = (isset($settings['skstyle']) && $settings['skstyle'] > 0) ? $settings['skstyle'] : 1;
        $icon_or_image  = (isset($settings['icon_or_image']) && $settings['icon_or_image'] > 0 ) ? $settings['icon_or_image'] : 1;
        $icons          = (isset($settings['icons']) && $settings['icons'] != '') ? $settings['icons'] : '';
        $images         = (isset($settings['images']['url']) && $settings['images']['url'] != '') ? $settings['images']['url'] : '';

        $sk_title       = (isset($settings['sk_title']) && $settings['sk_title'] != '') ? $settings['sk_title'] : esc_html__('Consulting', 'themewar');
        $percent        = (isset($settings['percent']) && $settings['percent'] != '') ? $settings['percent'] : '88';
       
        if($skstyle == 2):
        ?>
        <div class="skItem02 cmskbar">
            <div class="skThumb">
                <?php 
                    if($icon_or_image == 2 && $images != ''):
                        echo '<img src="'.esc_url($images).'" alt="'.esc_html__('Icon Image ', 'themewar').'"/>';
                    else:
                        echo '<i class="'. esc_attr($icons).'"></i>';
                    endif;
                ?>
            </div>
            <div class="single_skill" data-parcent="<?php echo esc_attr($percent); ?>">
                <?php if($sk_title != ''): ?>
                    <h5><?php echo esc_html($sk_title); ?></h5>
                <?php endif; ?>
                <div class="ss_parent"><div class="ss_child"></div><span class="runing"><?php echo esc_html($percent).''.esc_html__('%', 'themewar'); ?></span></div>
            </div>
        </div>
        <?php
        elseif($skstyle == 3):
        ?>
        <div class="single_skill cmskbar sk03" data-parcent="<?php echo esc_attr($percent); ?>">
            <?php if($sk_title != ''): ?>
            <h5><i class="<?php echo esc_attr($icons); ?>"></i><?php echo esc_html($sk_title); ?></h5>
            <?php endif; ?>
            <div class="ss_parent"><div class="ss_child"></div><span><?php echo esc_html($percent).''.esc_html__('%', 'themewar'); ?></span></div>
        </div>
        <?php
        else:
            ?>
            <div class="single_skill cmskbar" data-parcent="<?php echo esc_attr($percent); ?>">
                <?php if($sk_title != ''): ?>
                    <h5><?php echo esc_html($sk_title); ?></h5>
                <?php endif; ?>
                <div class="ss_parent"><div class="ss_child"></div><span class="runing"><?php echo esc_html($percent).''.esc_html__('%', 'themewar'); ?></span></div>
            </div>
            <?php
        endif;
    }
    
    protected function content_template() {

    }
}