<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Navigation_Service_Widgets extends Widget_Base {

    public function get_name() {
        return 'tw-navigation-service.php';
    }

    public function get_title() {
        return esc_html__( 'Service Nav List', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-nav-menu';
    }

    public function get_categories() {
        return ['bepro-elements'];
    }

    protected function register_controls() {
        
        $menu = wp_get_nav_menus();
        $menulist = array('0' => esc_html__('None', 'themewar'));
        if(!empty($menu)){
            foreach ($menu as $mn){
                $menulist[$mn->term_id] = $mn->name;
            }
        }
        $this->start_controls_section(
            'section_tab_1', [
                'label'     => esc_html__( 'Navigation', 'themewar' ),
            ]
        );
        $this->add_control(
                'ser_list_style',
                [
                        'label'     => esc_html__( 'Service Nav Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Style 01', 'themewar' ),
                                2       => esc_html__( 'Style 02', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'images',
                [
                        'label'         => esc_html__( 'Widget Title Image', 'themewar' ),
                        'label_block'   => TRUE,
                        'type'          => Controls_Manager::MEDIA,
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'ser_list_style',
                                        'operator'  => 'in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'widget_title',
                [
                        'label'         => esc_html__( 'Widget Title Text', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('insert your widget title.', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'ser_list_style',
                                        'operator'  => 'in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'navigation_select',
                [
                        'label'     => esc_html__( 'Select Navigation', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => '0',
                        'options'   => $menulist,
                ]
        );
        $this->add_responsive_control(
            'menu_align', [
                'label'			=> esc_html__( 'Alignment', 'themewar' ),
                'type'			=> Controls_Manager::CHOOSE,
                'options'                => [
                        'left'           => [
                                'title'  => esc_html__( 'Left', 'themewar' ),
                                'icon'   => 'eicon-text-align-left',
                        ],
                        'center'         => [
                                'title'  => esc_html__( 'Center', 'themewar' ),
                                'icon'   => 'eicon-text-align-center',
                        ],
                        'right'          => [
                                'title'  => esc_html__( 'Right', 'themewar' ),
                                'icon'   => 'eicon-text-align-right',
                        ]
                ],
                'default'		=> 'left',
                'prefix_class'          => 'menu_nav elementor%s-align-',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_ntitle',[
                    'label'         => esc_html__('Widget Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'ser_list_style',
                                    'operator'  => 'in',
                                    'value'     => ['2'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_bnumber_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .service_list .widget_title' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_bnumber_bg_color',[
                        'label'     => esc_html__( 'BG Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .service_list .widget_title' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_bnumber_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .service_list .widget_title',
                ]
        );
        $this->add_responsive_control(
                'icon_box_bnumber_padding',
                [
                        'label'      => esc_html__( 'Paddings', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .service_list .widget_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_bnumber_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .service_list .widget_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'      => 'icon_box_shadow_hr',
                        'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .service_list .widget_title',
                ]
        );
        $this->add_responsive_control(
                'icon_box_radius',
                [
                        'label'      => esc_html__( 'Radius', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .service_list .widget_title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'heading_image_gradian',
            [
                'label'     => esc_html__( 'Title Image Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_responsive_control(
                'icon_box_img_width',
                [
                        'label' => __( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .service_list .widget_title img' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_img_height',
                [
                        'label' => __( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .service_list .widget_title img' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'area_img_magrins',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .service_list .widget_title img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_3',
            [
                'label'         => esc_html__('Navigation Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'area_paddings',
                [
                        'label'      => esc_html__( 'Area Paddings', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .service_widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .service_list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'area_magrins',
                [
                        'label'      => esc_html__( 'Area Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .service_widget' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .service_list'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'area_bg_color',
                [
                        'label' => esc_html__( 'Area BG Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .service_widget' => 'background: {{VALUE}}',
                                '{{WRAPPER}} .service_list'   => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'box_border_hr',
                        'label' => esc_html__( 'Area Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .service_widget, {{WRAPPER}} .service_list',
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'btn_typography',
                        'label'     => esc_html__( 'Text Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .service_widget ul li a, {{WRAPPER}} .service_list ul.menu li a',
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'btn_icon_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .service_widget ul.menu li a::after',
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'ser_list_style',
                                        'operator'  => '!in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'list_paddings',
                [
                        'label'      => esc_html__( 'List Item Paddings', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .service_widget ul.menu li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .service_list ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'list_magrins',
                [
                        'label'      => esc_html__( 'List Item Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .service_widget ul.menu li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .service_list ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'widget_list_item',
                        'label'     => esc_html__( 'Item Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .service_list ul li, {{WRAPPER}} .service_widget ul.menu li',
                ]
        );
        $this->start_controls_tabs( 'style_tabs_1' );
                $this->start_controls_tab(
                        'btn_1_button_style_normal',
                        [
                                'label' => esc_html__( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_responsive_control(
                        'btn_1_label_color',
                        [
                                'label' => esc_html__( 'Text Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .service_widget ul.menu li a' => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .service_list ul.menu li a' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'btn_dots_bg_color',
                        [
                                'label' => esc_html__( 'Dots BG Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .service_list ul li a:before' => 'background: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'ser_list_style',
                                                'operator'  => '!in',
                                                'value'     => ['1'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'btn_1_bg_color',
                        [
                                'label' => esc_html__( 'BG Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .service_widget ul.menu li a' => 'background: {{VALUE}}',
                                        '{{WRAPPER}} .service_list ul.menu li a' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'btn_1_button_style_hover',
                        [
                                'label' => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_responsive_control(
                        'btn_label_hover_color',
                        [
                                'label' => esc_html__( 'Color', 'themewar' ),
                                'type'  => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .service_list ul.menu li:hover a'   => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .service_widget ul.menu li:hover a'   => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .service_widget ul.menu li.current-menu-item a'  => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .service_list ul.menu li.current-menu-item a'  => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'btn_dots_hover_bg_color',
                        [
                                'label' => esc_html__( 'Dots BG Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .service_list ul li.current-menu-item a:before' => 'background: {{VALUE}}',
                                        '{{WRAPPER}} .service_list ul li a:hover:before' => 'background: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'ser_list_style',
                                                'operator'  => '!in',
                                                'value'     => ['1'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'btn_1_hover_icon_color',
                        [
                                'label' => esc_html__( 'Icon Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .service_widget ul.menu li a::after' => 'color: {{VALUE}}',

                                ],
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'ser_list_style',
                                                'operator'  => '!in',
                                                'value'     => ['2'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'btn_1_bg_hover_color',
                        [
                                'label' => esc_html__( 'BG Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .service_list ul.menu li:hover a' => 'background: {{VALUE}}',
                                    '{{WRAPPER}} .service_widget ul.menu li:hover a' => 'background: {{VALUE}}',
                                    '{{WRAPPER}} .service_widget ul.menu li.current-menu-item a' => 'background: {{VALUE}}',
                                    '{{WRAPPER}} .service_list ul.menu li.current-menu-item a' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings               = $this->get_settings_for_display();
        $ser_list_style         = (isset($settings['ser_list_style']) && $settings['ser_list_style'] > 0) ? $settings['ser_list_style'] : 1;
        $navigation_select      = (isset($settings['navigation_select']) && $settings['navigation_select'] != '') ? $settings['navigation_select'] : 0;
        $widget_title           = (isset($settings['widget_title']) && $settings['widget_title'] != '') ? $settings['widget_title'] : '';
        $images                 = (isset($settings['images']['url']) && $settings['images']['url'] != '') ? $settings['images']['url'] : '';
        
        if($navigation_select > 0){
            if($ser_list_style == 2):
                ?>
                <aside class="service_list">
                    <?php if($widget_title != ''): ?>
                        <h3 class="widget_title"><?php if($images != ''): ?><img src="<?php echo esc_url($images); ?>" alt="<?php echo esc_attr($widget_title) ?>"><?php endif; ?><?php echo wp_kses_post($widget_title); ?></h3>
                    <?php endif; ?>
                    <?php wp_nav_menu(array('menu' => $navigation_select)); ?>
                </aside>
                <?php
            else:
                ?>
                <aside class="service_widget">
                    <?php wp_nav_menu(array('menu' => $navigation_select)); ?>
                </aside>
                <?php
            endif;
        }
        
    }

    protected function content_template() {}    
}