<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Image_Carousel_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-image-carousel';
    }
    
    public function get_title() {
        return esc_html__( 'Image Slider', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-slider-push';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Image Slider', 'themewar' ),
            ]
        );
        $this->add_control(
                'slider_style',
                [
                        'label'     => esc_html__( 'Image Slider Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Style 01', 'themewar' ),
                                2       => esc_html__( 'Style 02', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'gallery_list',
                [
                        'label' => esc_html__( 'Choose Images', 'themewar' ),
                        'type' => Controls_Manager::GALLERY
                ]
        );
        $this->add_control(
                'gl_width',
                [
                        'label' => esc_html__( 'Image Width', 'themewar' ),
                        'type' => Controls_Manager::NUMBER,
                        'min' => 1,
                        'max' => 1920,
                        'step' => 1,
                        'default' => 737,
                        'conditions'    => [
                                'terms' => [
                                        [
                                                'name'      => 'slider_style',
                                                'operator'  => '==',
                                                'value'     => '2',
                                        ]
                                ],
                        ],
                ]
        );
        $this->add_control(
                'gl_height',
                [
                        'label' => esc_html__( 'Image Height', 'themewar' ),
                        'type' => Controls_Manager::NUMBER,
                        'min' => 1,
                        'max' => 1000,
                        'step' => 1,
                        'default' => 544,
                        'conditions'    => [
                                'terms' => [
                                        [
                                                'name'      => 'slider_style',
                                                'operator'  => '==',
                                                'value'     => '2',
                                        ]
                                ],
                        ],
                ]
        );
        $this->add_control(
                'pr_slide_autoplay',
                [
                        'label'             => esc_html__( 'Is Autoplay?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to make this slider auto play?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'yes',
                        'conditions'    => [
                                'terms' => [
                                        [
                                                'name'      => 'slider_style',
                                                'operator'  => '==',
                                                'value'     => '2',
                                        ]
                                ],
                        ],
                ]
        );
        $this->add_control(
                'pr_slide_loop',
                [
                        'label'             => esc_html__( 'Is Loop?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to make this slider item loop?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'yes',
                        'conditions'    => [
                                'terms' => [
                                        [
                                                'name'      => 'slider_style',
                                                'operator'  => '==',
                                                'value'     => '2',
                                        ]
                                ],
                        ],
                ]
        );
        $this->add_control(
                'pr_slide_nav',
                [
                        'label'             => esc_html__( 'Is Nav?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show slider arrow navigation?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                        'conditions'    => [
                                'terms' => [
                                        [
                                                'name'      => 'slider_style',
                                                'operator'  => '==',
                                                'value'     => '2',
                                        ]
                                ],
                        ],
                ]
        );
        $this->add_control(
                'pr_slide_dots',
                [
                        'label'             => esc_html__( 'Is Dots?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show slider bullets item?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                        'conditions'    => [
                                'terms' => [
                                        [
                                                'name'      => 'slider_style',
                                                'operator'  => '==',
                                                'value'     => '2',
                                        ]
                                ],
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_100', [
                'label'         => esc_html__( 'Nav Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'        => [
                    'terms'         => [
                        [
                                'name'      => 'pr_slide_nav',
                                'operator'  => '==',
                                'value'     => 'yes',
                        ]
                    ],
                ],
            ]
            );
            $this->add_control(
                'serv_nav_radius',
                [
                        'label'      => esc_html__( 'Border Radius', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .imageGallery.owl-carousel .owl-nav button'       => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->start_controls_tabs( 
                    'box_style_tab'
            );
            $this->start_controls_tab(
                    'serv_arr_normal_tab',
                    [
                            'label'         => esc_html__( 'Arrow BTN Normal', 'themewar' ),
                    ]
            );
                $this->add_control(
                        'serv_btn_color',
                        [
                                'label'     => esc_html__( 'Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .imageGallery.owl-carousel .owl-nav button' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'serv_btn_bg',
                        [
                                'label'     => esc_html__( 'BG Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .imageGallery.owl-carousel .owl-nav button' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'serv_btn_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .imageGallery.owl-carousel .owl-nav button',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name'      => 'serv_btn_shadow',
                                'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector'  => '{{WRAPPER}} .imageGallery.owl-carousel .owl-nav button',
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'serv_arr_hover_tab',
                        [
                                'label'         => esc_html__( 'Arrow BTN Hover', 'themewar' ),
                        ]
                );
                    $this->add_control(
                            'serv_btn_color_hvr',
                            [
                                    'label'     => esc_html__( 'Color', 'themewar' ),
                                    'type'      => Controls_Manager::COLOR,
                                    'selectors' => [
                                            '{{WRAPPER}} .imageGallery.owl-carousel .owl-nav button:hover' => 'color: {{VALUE}}'
                                    ],
                            ]
                    );
                    $this->add_control(
                            'serv_btn_bg_hvr',
                            [
                                    'label'     => esc_html__( 'BG Color', 'themewar' ),
                                    'type'      => Controls_Manager::COLOR,
                                    'selectors' => [
                                            '{{WRAPPER}} .imageGallery.owl-carousel .owl-nav button:hover' => 'background: {{VALUE}}',
                                    ],
                            ]
                    );
                    $this->add_group_control(
                            Group_Control_Border::get_type(),
                            [
                                    'name' => 'serv_btn_border_hvr',
                                    'label' => esc_html__( 'Border', 'themewar' ),
                                    'selector' => '{{WRAPPER}} .imageGallery.owl-carousel .owl-nav button:hover',
                            ]
                    );
                    $this->add_group_control(
                            Group_Control_Box_Shadow::get_type(),
                            [
                                    'name'      => 'serv_btn_shadow_hvr',
                                    'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                                    'selector'  => '{{WRAPPER}} .imageGallery.owl-carousel .owl-nav button:hover',
                            ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_20', [
                'label'         => esc_html__( 'Dot Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'        => [
                    'terms'         => [
                        [
                                'name'      => 'pr_slide_dots',
                                'operator'  => '==',
                                'value'     => 'yes',
                        ]
                    ],
                ],
            ]
        );
        $this->add_control(
            'serv_dot_area_margin',
            [
                    'label'      => esc_html__( 'Bullets Area Margin', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                            '{{WRAPPER}} .imageGallery.owl-carousel .owl-dots'       => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
                'serv_dot_width',
                [
                        'label' => esc_html__( 'Bullets Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        'default' => [
                                'unit' => 'px',
                                'size' => '',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .imageGallery.owl-carousel .owl-dots button' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'serv_dot_height',
                [
                        'label' => esc_html__( 'Bullets Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        'default' => [
                                'unit' => 'px',
                                'size' => '',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .imageGallery.owl-carousel .owl-dots button' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'serv_dot_radius',
            [
                    'label'      => esc_html__( 'Bullets Border Radius', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                            '{{WRAPPER}} .imageGallery.owl-carousel .owl-dots button'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
            'serv_dot_margin',
            [
                    'label'      => esc_html__( 'Bullets Margin', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                            '{{WRAPPER}} .imageGallery.owl-carousel .owl-dots button'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->start_controls_tabs( 
                'box_style_tab_2'
        );
            $this->start_controls_tab(
                    'serv_dot_normal_tab',
                    [
                            'label'         => esc_html__( 'Bullets Normal', 'themewar' ),
                    ]
            );
                $this->add_control(
                        'serv_dot_bg',
                        [
                                'label'     => esc_html__( 'BG Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .imageGallery.owl-carousel .owl-dots button' => 'background: {{VALUE}}',
                                ],
                        ]
                );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'serv_dot_hover_tab',
                    [
                            'label'         => esc_html__( 'Bullets Hover', 'themewar' ),
                    ]
            );
                $this->add_control(
                        'serv_dot_bg_hvr',
                        [
                                'label'     => esc_html__( 'BG Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .imageGallery.owl-carousel .owl-dots button:hover' => 'background: {{VALUE}}',
                                        '{{WRAPPER}} .imageGallery.owl-carousel .owl-dots button.active' => 'background: {{VALUE}}'
                                ],
                        ]
                );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings           = $this->get_settings_for_display();

        $slider_style       = (isset($settings['slider_style']) && $settings['slider_style'] > 0) ? $settings['slider_style'] : 1;
        
        $gallery_list       = (isset($settings['gallery_list']) && !empty($settings['gallery_list'])) ? $settings['gallery_list'] : array();
        $gl_width           = (isset($settings['gl_width']) && $settings['gl_width'] > 0 ? $settings['gl_width'] : 737);
        $gl_height          = (isset($settings['gl_height']) && $settings['gl_height'] > 0 ? $settings['gl_height'] : 544);
        
        $autoplay           = (isset($settings['pr_slide_autoplay']) && $settings['pr_slide_autoplay'] != '') ? $settings['pr_slide_autoplay'] : 'yes';
        $loop               = (isset($settings['pr_slide_loop']) && $settings['pr_slide_loop'] != '') ? $settings['pr_slide_loop'] : 'yes';
        $nav                = (isset($settings['pr_slide_nav']) && $settings['pr_slide_nav'] != '') ? $settings['pr_slide_nav'] : 'no';
        $dots               = (isset($settings['pr_slide_dots']) && $settings['pr_slide_dots'] != '') ? $settings['pr_slide_dots'] : 'no';

        if($slider_style == 2):
            if(!empty($gallery_list)): ?>
            <div class="gallerSliderWraper" 
                data-autoplay="<?php echo ($autoplay == 'yes' ? '1' : '0'); ?>" 
                data-loop="<?php echo ($loop == 'yes' ? '1' : '0'); ?>" 
                data-nav="<?php echo ($nav == 'yes' ? '1' : '0'); ?>" 
                data-dots="<?php echo ($dots == 'yes' ? '1' : '0'); ?>" 
                >
                <div class="imageGallery owl-carousel"><?php
                foreach($gallery_list as $list):
                    if(isset($list['id']) && $list['id'] > 0): 
                    $gall_img = bepro_attachment_url($list['id'], $gl_width, $gl_height);
                    ?>
                    <div class="galImg"> 
                        <img src="<?php echo esc_url($gall_img) ?>" alt="<?php echo esc_html('Gallery', 'themewar'); ?>"/>
                    </div>
                    <?php 
                    endif;
                endforeach; ?>
                </div>
            </div><?php
            endif;
        else:
            if(!empty($gallery_list)): ?>
            <div class="gallerSliderWraper">
                <ul id="gallerSlider" class="gallerSlider cS-hidden">
                <?php foreach($gallery_list as $list):
                    if(isset($list['id']) && $list['id'] > 0): 
                        $gall_img  = bepro_attachment_url($list['id'], 993, 570);
                        $gall_img1 = bepro_attachment_url($list['id'], 195, 170);
                        ?>
                        <li data-thumb="<?php echo esc_url($gall_img1) ?>"> 
                            <div class="gallThumb"><img src="<?php echo esc_url($gall_img) ?>" alt="<?php echo esc_html('Gallery', 'themewar'); ?>"/></div>
                        </li>
                        <?php 
                        endif;
                    endforeach; ?>
                </ul>
            </div><?php
            endif;
        endif;
    }
    
    protected function content_template() {}
    
}