<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Icon_Box_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-icon-box';
    }
    
    public function get_title() {
        return esc_html__( 'Icon Box', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-icon-box';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' => esc_html__( 'Icon Box', 'themewar' ),
            ]
        );
        $this->add_control(
                'icon_box_style',
                [
                        'label'     => esc_html__( 'Box Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Style 01', 'themewar' ),
                                2       => esc_html__( 'Style 02', 'themewar' ),
                                3       => esc_html__( 'Style 03', 'themewar' ),
                                4       => esc_html__( 'Style 04', 'themewar' ),
                                5       => esc_html__( 'Style 05', 'themewar' ),
                                6       => esc_html__( 'Style 06', 'themewar' ),
                                7       => esc_html__( 'Style 07', 'themewar' ),
                                8       => esc_html__( 'Style 08', 'themewar' ),
                                9       => esc_html__( 'Style 09', 'themewar' ),
                                10      => esc_html__( 'Style 10', 'themewar' ),
                                11      => esc_html__( 'Style 11', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'box_number',
                [
                        'label'         => esc_html__( 'Box Number', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('insert your icon box number', 'themewar'),
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'icon_box_style',
                                        'operator'  => '==',
                                        'value'     => '5',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'icon_or_image',
                [
                        'label'     => esc_html__( 'Icon Or Image', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Icon', 'themewar' ),
                                2       => esc_html__( 'Image', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'icons',
                [
                        'label'     => esc_html__( 'Icon', 'themewar' ),
                        'type'      => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'icon_or_image',
                                        'operator'  => '==',
                                        'value'     => '1',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'images',
                [
                        'label' => esc_html__( 'Choose Image', 'themewar' ),
                        'label_block'   => TRUE,
                        'type' => Controls_Manager::MEDIA,
                        'default' => [],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'icon_or_image',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'box_title',
                [
                        'label'         => esc_html__( 'Box Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('Box Title', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'icon_box_style',
                                        'operator'  => '!in',
                                        'value'     => ['9'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'is_link',
                [
                        'label'             => esc_html__( 'Title Is Link?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to link this title?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'icon_box_style',
                                        'operator'  => '!in',
                                        'value'     => ['9'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'b_title_url', [
                    'label'             => esc_html__( 'URL', 'themewar' ),
                    'type'              => Controls_Manager::URL,
                    'input_type'        => 'url',
                    'condition'         => ['is_link' => 'yes'],
                    'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                    'show_external'     => true,
                    'default'           => [
                            'url'            => '',
                            'is_external'    => true,
                            'nofollow'       => true,
                    ],
                ]
        );
        $this->add_control(
                'box_desc',
                [
                        'label'         => esc_html__( 'Box Content', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Content Here. use {} for different color', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'icon_box_style',
                                        'operator'  => '!in',
                                        'value'     => ['4', '11'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'box_images',
                [
                        'label' => esc_html__( 'Box Image', 'themewar' ),
                        'label_block'   => TRUE,
                        'type' => Controls_Manager::MEDIA,
                        'default' => [],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'icon_box_style',
                                        'operator'  => 'in',
                                        'value'     => ['1', '4', '11'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'is_rmbtn',
                [
                        'label'             => esc_html__( 'Is Read More Btn?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show read more btn?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'icon_box_style',
                                        'operator'  => 'in',
                                        'value'     => ['8', '11'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'rm_label',
                [
                        'label'         => esc_html__( 'Read More Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('Book For Consultation', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'icon_box_style',
                                        'operator'  => 'in',
                                        'value'     => ['11'],
                                ],
                                [
                                        'name'      => 'is_rmbtn',
                                        'operator'  => '==',
                                        'value'     => 'yes',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'rmbtn_url', [
                    'label'             => esc_html__( 'URL', 'themewar' ),
                    'type'              => Controls_Manager::URL,
                    'input_type'        => 'url',
                    'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                    'show_external'     => true,
                    'default'           => [
                            'url'            => '',
                            'is_external'    => true,
                            'nofollow'       => true,
                    ],
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'icon_box_style',
                                    'operator'  => 'in',
                                    'value'     => ['8', '11'],
                            ],
                            [
                                    'name'      => 'is_rmbtn',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'box_alignment', [
                        'label'                     =>esc_html__( 'Box Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'       => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'     => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'      => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'                   => 'left',
                        'prefix_class'              => 'box_holder elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_1', [
                    'label'         => esc_html__('Box Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
                'icon_box_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cmIconBxstyle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .icon_box_03' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmIconBxstyle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .icon_box_03' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmIconBxstyle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .icon_box_03' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'ib_box_tot' );
            $this->start_controls_tab(
                'ib_box_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_bg',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .cmIconBxstyle, {{WRAPPER}} .icon_box_03',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .cmIconBxstyle, {{WRAPPER}} .icon_box_03',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'box_border',
                            'label' => esc_html__( 'Box Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .cmIconBxstyle, {{WRAPPER}} .icon_box_03',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_box_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_bg_hr',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .cmIconBxstyle:hover, {{WRAPPER}} .icon_box_03:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_shadow_hr',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .cmIconBxstyle:hover, {{WRAPPER}} .icon_box_03:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'box_border_hr',
                            'label' => esc_html__( 'Box Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .cmIconBxstyle:hover, {{WRAPPER}} .icon_box_03:hover',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
                'icon_box_hover_all_con_color',[
                        'label'     => esc_html__( 'Hover All Content Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmIconBxstyle:hover *' => 'color: {{VALUE}}',
                        ]
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_bnumber',[
                    'label'         => esc_html__('Box Number Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'icon_box_style',
                                        'operator'  => '==',
                                        'value'     => '5',
                                ]
                            ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_bnumber_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_03 > span' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_bnumber_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .icon_box_03 > span',
                ]
        );
        $this->add_responsive_control(
                'icon_box_bnumber_margin',
                [
                        'label'      => esc_html__( 'Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .icon_box_03 > span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_2',[
                    'label'         => esc_html__('Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'icon_or_image',
                                    'operator'  => '!in',
                                    'value'     => ['2'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_i_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ibMeta'
                ]
        );
        $this->start_controls_tabs( 'ib_icon_tot' );
            $this->start_controls_tab(
                'ib_icon_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_icon_gradina',
                            'label' => esc_html__( 'Gradian Color', 'themewar' ),
                            'types' => ['gradient'],
                            'selector' => '{{WRAPPER}} .ibMeta i',
                            'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'icon_box_style',
                                                'operator'  => 'in',
                                                'value'     => ['5', '6'],
                                        ]
                                    ],
                            ],
                    ]
            );
            $this->add_control(
                'heading_gradian',
                [
                    'label'     => esc_html__( 'Icon Gradian Color', 'themewar' ),
                    'type'      => Controls_Manager::HEADING,
                    'separator' => 'after',
                    'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'icon_box_style',
                                        'operator'  => 'in',
                                        'value'     => ['5', '6'],
                                ]
                            ],
                    ],
                ]
            );
            $this->add_responsive_control(
                    'icon_box_i_color',[
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta' => 'color: {{VALUE}}',
                            ],
                            'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'icon_box_style',
                                                'operator'  => '!in',
                                                'value'     => ['5', '6'],
                                        ]
                                    ],
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_i_bg_color',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .ibMeta, {{WRAPPER}} .ibMeta',
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_i_bgsvgcolor',[
                            'label'     => esc_html__( 'Icon BG SVG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta svg' => 'fill: {{VALUE}}',
                                    '{{WRAPPER}} .ibMeta svg path' => 'fill: {{VALUE}}',
                            ],
                            'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'icon_box_style',
                                                'operator'  => 'in',
                                                'value'     => ['2', '5'],
                                        ]
                                    ],
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_icon_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_icon_hover_gradina',
                            'label' => esc_html__( 'Gradian Color', 'themewar' ),
                            'types' => ['gradient'],
                            'selector' => '{{WRAPPER}} .cmIconBxstyle:hover .ibMeta i',
                            'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'icon_box_style',
                                                'operator'  => 'in',
                                                'value'     => ['5', '6'],
                                        ]
                                    ],
                            ],
                    ]
            );
            $this->add_control(
                'heading_hover_gradian',
                [
                    'label'     => esc_html__( 'Icon Gradian Color', 'themewar' ),
                    'type'      => Controls_Manager::HEADING,
                    'separator' => 'after',
                    'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'icon_box_style',
                                        'operator'  => 'in',
                                        'value'     => ['5', '6'],
                                ]
                            ],
                    ],
                ]
            );
            $this->add_control(
                    'icon_box_i_color_hr',[
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .cmIconBxstyle:hover .ibMeta' => 'color: {{VALUE}}',
                            ],
                            'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'icon_box_style',
                                                'operator'  => '!in',
                                                'value'     => ['5', '6'],
                                        ]
                                    ],
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_i_bgcolor_hr',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .cmIconBxstyle:hover .ibMetayle:hover .ibMeta',
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_i_hover_bgsvgcolor',[
                            'label'     => esc_html__( 'Icon BG SVG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .cmIconBxstyle:hover .ibMeta svg' => 'fill: {{VALUE}}',
                                    '{{WRAPPER}} .cmIconBxstyle:hover .ibMeta svg path' => 'fill: {{VALUE}}',
                            ],
                            'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'icon_box_style',
                                                'operator'  => 'in',
                                                'value'     => ['2', '5'],
                                        ]
                                    ],
                                ],
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
                'icon_box_i_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ibMeta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_responsive_control(
                    'icon_box_i_width',
                    [
                            'label' => __( 'Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_i_height',
                    [
                            'label' => __( 'Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'icon_box_i_border_hr',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ibMeta, {{WRAPPER}} .icon_box_04:hover, {{WRAPPER}} .icon_box_05:hover, {{WRAPPER}} .icon_box_06:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_i__shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ibMeta',
                    ]
            );
            $this->add_control(
                    'icon_box_i_padding',
                    [
                            'label' => esc_html__( 'Paddings', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .ibMeta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
            $this->add_control(
                    'icon_box_i_margin',
                    [
                            'label' => esc_html__( 'Margins', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                    '{{WRAPPER}} .ibMeta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_img',[
                    'label'         => esc_html__('Image Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'icon_or_image',
                                    'operator'  => '!in',
                                    'value'     => ['1'],
                            ]
                        ],
                    ],
                ]
        );
        $this->start_controls_tabs( 'ib_img_tot' );
            $this->start_controls_tab(
                'ib_img_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_img_bgcolor',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .ibMeta, {{WRAPPER}} .ibMeta',
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_img_bgsvgcolor',[
                            'label'     => esc_html__( 'BG SVG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta svg' => 'fill: {{VALUE}}',
                                    '{{WRAPPER}} .ibMeta svg path' => 'fill: {{VALUE}}',
                            ],
                            'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'icon_box_style',
                                                'operator'  => 'in',
                                                'value'     => ['2', '5'],
                                        ]
                                    ],
                                ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_img_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_img_bgcolor_hr',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .cmIconBxstyle:hover .ibMeta',
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_img_hover_bgsvgcolor',[
                            'label'     => esc_html__( 'BG SVG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .cmIconBxstyle:hover .ibMeta svg' => 'fill: {{VALUE}}',
                                    '{{WRAPPER}} .cmIconBxstyle:hover .ibMeta svg path' => 'fill: {{VALUE}}',
                            ],
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'icon_box_style',
                                            'operator'  => 'in',
                                            'value'     => ['2', '5'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'icon_box_area_img_width',
                    [
                            'label' => esc_html__( 'Area Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_area_img_height',
                    [
                            'label' => esc_html__( 'Area Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_img_width',
                    [
                            'label' => esc_html__( 'Image Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta img' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_img_height',
                    [
                            'label' => esc_html__( 'Image Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta img' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_img_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ibMeta',
                    ]
            );
            $this->add_control(
                    'icon_box_img_radius',
                    [
                            'label' => esc_html__( 'Border Radius', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .ibMeta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
            $this->add_control(
                    'icon_box_img_padding',
                    [
                            'label' => esc_html__( 'Paddings', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .ibMeta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
            $this->add_control(
                    'icon_box_img_margin',
                    [
                            'label' => esc_html__( 'Margins', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_3',[
                    'label'         => esc_html__('Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'icon_box_style',
                                    'operator'  => '!in',
                                    'value'     => ['9'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_control(
                'icon_box_title_color',[
                        'label'     => esc_html__( 'Title Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmIconBxstyle h3' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
                'icon_box_hover_title_color',[
                        'label'     => esc_html__( 'Linked Title Hover Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmIconBxstyle h3 a:hover' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_title_typo',
                        'label'     => esc_html__( 'Title Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmIconBxstyle h3, {{WRAPPER}} .icon_box_01 h3',
                ]
        );
        $this->add_control(
                'icon_box_title_margin',
                [
                        'label'      => esc_html__( 'Title Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmIconBxstyle h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_4', [
                    'label'         => esc_html__('Box Content Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'icon_box_style',
                                    'operator'  => '!in',
                                    'value'     => ['11'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_control(
                'icon_box_content_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmIconBxstyle p' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .cmIconBxstyle h3 span' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_content_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmIconBxstyle p, {{WRAPPER}} .cmIconBxstyle h3 span, {{WRAPPER}} .icon_box_03 p',
                ]
        );
        $this->add_control(
                'icon_box_content_margin',
                [
                        'label'      => esc_html__( 'Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmIconBxstyle p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .cmIconBxstyle h3 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'differnt_text_headding',
            [
                'label'     => esc_html__( 'Different Text Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
                'diff_content_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmIconBxstyle p span' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .cmIconBxstyle h3 span span' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'diff_content_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmIconBxstyle p span, {{WRAPPER}} .cmIconBxstyle h3 span span',
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_box_img',[
                    'label'         => esc_html__('Box Image Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'icon_box_style',
                                    'operator'  => 'in',
                                    'value'     => ['1', '11'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_control(
                'image_overlay_color',[
                        'label'     => esc_html__( 'Overlay Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ctaboxItem:after' => 'background: {{VALUE}}',
                        ],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'icon_box_style',
                                        'operator'  => '==',
                                        'value'     => '11',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_width',
                [
                        'label' => esc_html__( 'Image Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .siThumb img' => 'max-width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .ctaboxItem > img' => 'max-width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_height',
                [
                        'label' => esc_html__( 'Image Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .siThumb img' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .ctaboxItem > img' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_fimg_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .siThumb, {{WRAPPER}} .ctaboxItem > img',
                ]
        );
        $this->add_control(
                'icon_box_fimg_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .siThumb img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .ctaboxItem > img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .ctaboxItem:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->add_control(
                'icon_box_fimg_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .siThumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .ctaboxItem > img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_rmbtn', [
                    'label'             => esc_html__('Read More Btn Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'icon_box_style',
                                    'operator'  => 'in',
                                    'value'     => ['8', '11'],
                            ],
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'rmbtn_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .srm'
                ]
        );
        $this->add_control(
                'rmbtn_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .srm' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'rmbtn_styling_tab' );
            $this->start_controls_tab(
                    'rmbtn_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'rmbtn_nav_color',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .srm' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_control(
                    'rm_icon_color',[
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .srm i' => 'color: {{VALUE}}',
                            ],
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'icon_box_style',
                                            'operator'  => '==',
                                            'value'     => '11',
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'rmbtn_bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .srm'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'rmbtn_bg_shadow',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .srm'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'rmbtn_bg_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .srm'
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'rmbtn_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'rmbtn_color_hover',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .srm:hover' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_control(
                    'rm_icon_hover_color',[
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .srm:hover i' => 'color: {{VALUE}}',
                            ],
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'icon_box_style',
                                            'operator'  => '==',
                                            'value'     => '11',
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'rmbtn_bg_hover',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .srm:hover'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'rmbtn_bg_shadow_hover',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'rmbtn_bg_border_hover',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .srm:hover'
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                'rmbtn_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .srm' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_responsive_control(
                'rmbtn_icon_margin',
                [
                        'label'      => esc_html__( 'Icon Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .srm i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'icon_box_style',
                                        'operator'  => '==',
                                        'value'     => '11',
                                ]
                            ],
                        ],
                ]
            );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings        = $this->get_settings_for_display();
        $icon_box_style  = (isset($settings['icon_box_style']) && $settings['icon_box_style'] > 0) ? $settings['icon_box_style'] : 1;
        $icon_or_image   = (isset($settings['icon_or_image']) && $settings['icon_or_image'] > 0 ) ? $settings['icon_or_image'] : 1;
        $icons          = (isset($settings['icons']) && $settings['icons'] != '') ? $settings['icons'] : 'icon-truck';
        $images         = (isset($settings['images']['url']) && $settings['images']['url'] != '') ? $settings['images']['url'] : '';
        $box_images     = (isset($settings['box_images']['url']) && $settings['box_images']['url'] != '') ? $settings['box_images']['url'] : '';
        $box_title      = (isset($settings['box_title']) && $settings['box_title'] != '') ? $settings['box_title'] : esc_html__('Box Title', 'themewar');
        $desc           = (isset($settings['box_desc']) && $settings['box_desc'] != '') ? $settings['box_desc'] : '';
        $box_desc       = str_replace(['{', '}'], ['<span">', '</span>'], $desc);
        $box_number     = (isset($settings['box_number']) && $settings['box_number'] != '') ? $settings['box_number'] : '';

        $is_link     = (isset($settings['is_link']) && $settings['is_link'] != '') ? $settings['is_link'] : 'no';
        $target      = isset($settings['b_title_url']['is_external']) ? ' target="_blank"' : '' ;
        $nofollow    = isset($settings['b_title_url']['nofollow']) ? ' rel="nofollow"' : '' ;
        $url         = (isset($settings['b_title_url']['url']) && $settings['b_title_url']['url'] != '') ? $settings['b_title_url']['url'] : '';

        $is_rmbtn   = (isset($settings['is_rmbtn']) && $settings['is_rmbtn'] != '') ? $settings['is_rmbtn'] : '';
        $target2         = isset($settings['rmbtn_url']['is_external']) ? ' target="_blank"' : '' ;
        $nofollow2       = isset($settings['rmbtn_url']['nofollow']) ? ' rel="nofollow"' : '' ;
        $rmbtn_url        = (isset($settings['rmbtn_url']['url']) && $settings['rmbtn_url']['url'] != '') ? $settings['rmbtn_url']['url'] : '';

        $rm_label  = (isset($settings['rm_label']) && $settings['rm_label'] != '') ? $settings['rm_label'] : esc_html__('Book For Consultation', 'themewar');
        
        include dirname(__FILE__).'/style/icon-box/style'.$icon_box_style.'.php';
        
    }
    
    protected function content_template() {

    }
    
    
}