<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Gallery_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-gallery';
    }
    
    public function get_title() {
        return esc_html__( 'Gallery', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-gallery-grid';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Gallery', 'themewar' ),
            ]
        );
        $this->add_control(
                'grid_style',
                [
                        'label'     => esc_html__( 'Gallery Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Grid Style', 'themewar' ),
                                2       => esc_html__( 'Slider Style', 'themewar' ),
                        ],
                ]
        );
        $repeater = new Repeater();
        $repeater->add_control(
                'gl_img',
                [
                        'label'         => esc_html__( 'Gallery Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('Image size should be 476x320px.', 'themewar'),
                ]
        );
        $repeater->add_control(
                'gl_popup_img',
                [
                        'label'         => esc_html__( 'Gallery Popup Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('Image size should be large.', 'themewar'),
                ]
        );
        $repeater->add_control(
                'is_link',
                [
                        'label'             => esc_html__( 'Is Link Btn?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show link btn?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                ]
        );
        $repeater->add_control(
                'gl_url', [
                    'label'             => esc_html__( 'Link URL', 'themewar' ),
                    'type'              => Controls_Manager::URL,
                    'input_type'        => 'url',
                    'condition'         => ['is_link' => 'yes'],
                    'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                    'show_external'     => true,
                    'default'           => [
                            'url'            => '',
                            'is_external'    => true,
                            'nofollow'       => true,
                    ],
                ]
        );
        $this->add_control(
                'gl_list',
                [
                        'label'   => esc_html__( 'Gallery Item', 'themewar' ),
                        'type'    => Controls_Manager::REPEATER,
                        'fields'  => $repeater->get_controls(),
                        'default' => [
                                [
                                        'gl_img'        => '',
                                        'gl_popup_img'  => '',
                                        'is_link'       => '',
                                        'gl_url'        => '',
                                ]
                        ],
                        'title_field' => '{{{ "Gallery Item" }}}',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_2', [
                    'label'         => esc_html__('Folio Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
            'folio_item_margin',
            [
                    'label' => esc_html__( 'Item Margins', 'themewar' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                            '{{WRAPPER}} .gallerItem' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'box_border',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .gallerItem',
                ]
        );
        $this->add_control(
                'overlay_color',
                [
                        'label'     => esc_html__( 'Overlay Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .gallerItem'    => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_100', [
                'label'         => esc_html__( 'Hover Btn Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
            );
            $this->add_control(
                'serv_nav_radius',
                [
                        'label'      => esc_html__( 'Border Radius', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .galleryItem_btn a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->start_controls_tabs( 
                    'box_style_tab'
            );
            $this->start_controls_tab(
                    'serv_arr_normal_tab',
                    [
                            'label'         => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
                $this->add_control(
                        'serv_btn_color',
                        [
                                'label'     => esc_html__( 'Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .galleryItem_btn a' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'serv_btn_bg',
                        [
                                'label'     => esc_html__( 'BG Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .galleryItem_btn a' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'serv_btn_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .galleryItem_btn a',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name'      => 'serv_btn_shadow',
                                'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector'  => '{{WRAPPER}} .galleryItem_btn a',
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'serv_arr_hover_tab',
                        [
                                'label'         => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                    $this->add_control(
                            'serv_btn_color_hvr',
                            [
                                    'label'     => esc_html__( 'Color', 'themewar' ),
                                    'type'      => Controls_Manager::COLOR,
                                    'selectors' => [
                                            '{{WRAPPER}} .galleryItem_btn a:hover' => 'color: {{VALUE}}'
                                    ],
                            ]
                    );
                    $this->add_control(
                            'serv_btn_bg_hvr',
                            [
                                    'label'     => esc_html__( 'BG Color', 'themewar' ),
                                    'type'      => Controls_Manager::COLOR,
                                    'selectors' => [
                                            '{{WRAPPER}} .galleryItem_btn a:hover' => 'background-color: {{VALUE}}',
                                    ],
                            ]
                    );
                    $this->add_group_control(
                            Group_Control_Border::get_type(),
                            [
                                    'name' => 'serv_btn_border_hvr',
                                    'label' => esc_html__( 'Border', 'themewar' ),
                                    'selector' => '{{WRAPPER}} .galleryItem_btn a:hover',
                            ]
                    );
                    $this->add_group_control(
                            Group_Control_Box_Shadow::get_type(),
                            [
                                    'name'      => 'serv_btn_shadow_hvr',
                                    'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                                    'selector'  => '{{WRAPPER}} .galleryItem_btn a:hover',
                            ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings        = $this->get_settings_for_display();//
        $grid_style      = (isset($settings['grid_style']) && $settings['grid_style'] > 0) ? $settings['grid_style'] : 1;
        
        $gl_list         = (isset($settings['gl_list']) && !empty($settings['gl_list'])) ? $settings['gl_list'] : array();

        if($grid_style == 2):
            if(!empty($gl_list)):
            ?>
            <div class="gallerySlider owl-carousel">
                <?php foreach($gl_list as $gl): 
                $gl_img       = (isset($gl['gl_img']['url']) && $gl['gl_img']['url'] != '') ? $gl['gl_img']['url'] : 'https://via.placeholder.com/476x320.jpg';
                $gl_popup_img      = (isset($gl['gl_popup_img']['url']) && $gl['gl_popup_img']['url'] != '') ? $gl['gl_popup_img']['url'] : 'https://via.placeholder.com/1600x1600.jpg';
                $url        = (isset($gl['gl_url']['url'])) ? $gl['gl_url']['url'] : 'javascript:void(0);';
                $is_link    = (isset($gl['is_link'])) ? $gl['is_link'] : 'no';

                ?>
                <div class="gallerItem">
                    <img src="<?php echo esc_url($gl_img); ?>" alt="<?php echo esc_attr__('gallery', 'themewar'); ?>">
                    <div class="galleryItem_btn">
                        <a class="popup_img" href="<?php echo esc_url($gl_popup_img); ?>"><i class="twi-search2"></i></a>
                        <?php if($is_link == 'yes'): ?>
                            <a href="<?php echo $url; ?>"><i class="twi-link2"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            <?php
            endif;
        else:
            if(!empty($gl_list)):
            ?>
            <div class="row">
                <?php foreach($gl_list as $gl): 
                $gl_img       = (isset($gl['gl_img']['url']) && $gl['gl_img']['url'] != '') ? $gl['gl_img']['url'] : 'https://via.placeholder.com/476x320.jpg';
                $gl_popup_img      = (isset($gl['gl_popup_img']['url']) && $gl['gl_popup_img']['url'] != '') ? $gl['gl_popup_img']['url'] : 'https://via.placeholder.com/1600x1600.jpg';
                $url        = (isset($gl['gl_url']['url'])) ? $gl['gl_url']['url'] : 'javascript:void(0);';
                $is_link    = (isset($gl['is_link'])) ? $gl['is_link'] : 'no';

                ?>
                <div class="col-xl-3 col-lg-4 col-md-6">
                    <div class="gallerItem">
                        <img src="<?php echo esc_url($gl_img); ?>" alt="<?php echo esc_attr__('gallery', 'themewar'); ?>">
                        <div class="galleryItem_btn">
                            <a class="popup_img" href="<?php echo esc_url($gl_popup_img); ?>"><i class="twi-search2"></i></a>
                            <?php if($is_link == 'yes'): ?>
                                <a href="<?php echo $url; ?>"><i class="twi-link2"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            <?php
            endif;
        endif;
    }
    
    protected function content_template() {}
    
}