<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Clients_Slider_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-clients-slider';
    }
    
    public function get_title() {
        return esc_html__( 'Client Logo Slider', 'themewar' );
    }

    public function get_icon() {
        return ' eicon-logo';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab_1',
            [
                'label'     => esc_html__('Client Logo', 'themewar')
            ]
        );
            $this->add_control(
                    'client_slide_autoplay',
                    [
                            'label'             => esc_html__( 'Is Autoplay?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to make this slider auto play?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'yes',
                    ]
            );
            $this->add_control(
                    'client_slide_loop',
                    [
                            'label'             => esc_html__( 'Is Loop?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to make this slider item loop?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'yes',
                    ]
            );
            $this->add_control(
                    'client_slide_nav',
                    [
                            'label'             => esc_html__( 'Is Nav?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to show slider arrow navigation?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'no',
                    ]
            );
            $this->add_control(
                    'client_slide_dots',
                    [
                            'label'             => esc_html__( 'Is Dots?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to show slider bullets item?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'no',
                    ]
            );
            $this->add_control(
                    'items_number',
                    [
                            'label' => esc_html__( 'Number of Item (Desktop)', 'themewar' ),
                            'type' => Controls_Manager::NUMBER,
                            'min' => 1,
                            'max' => 60,
                            'step' => 1,
                            'default' => 4,
                            'description'       => esc_html__('How many logo item you want to show desktop device.', 'themewar'),
                    ]
            );
            $this->add_control(
                    'items_number2',
                    [
                            'label' => esc_html__( 'Number of Item (Ipad Pro)', 'themewar' ),
                            'type' => Controls_Manager::NUMBER,
                            'min' => 1,
                            'max' => 60,
                            'step' => 1,
                            'default' => 3,
                            'description'       => esc_html__('How many logo item you want to show ipad pro device.', 'themewar'),
                    ]
            );
            $this->add_control(
                    'items_number3',
                    [
                            'label' => esc_html__( 'Number of Item (Ipad / Tab)', 'themewar' ),
                            'type' => Controls_Manager::NUMBER,
                            'min' => 1,
                            'max' => 60,
                            'step' => 1,
                            'default' => 2,
                            'description'       => esc_html__('How many logo item you want to show ipad or tab device.', 'themewar'),
                    ]
            );
            $this->add_control(
                    'items_gapping',
                    [
                            'label' => esc_html__( 'Items Gapping', 'themewar' ),
                            'type' => Controls_Manager::NUMBER,
                            'min' => 0,
                            'max' => 60,
                            'step' => 1,
                            'default' => 0,
                            'description'       => esc_html__('Insert items gapping if you want.', 'themewar'),
                    ]
            );
            $repeater = new \Elementor\Repeater();
                $repeater->add_control(
                    'client_logo',
                    [
                            'label'         => esc_html__( 'Normal Logo', 'themewar' ),
                            'type'          => Controls_Manager::MEDIA,
                            'description'   => esc_html__('Upload your client normal logo.', 'themewar'),
                    ]
                );
                $repeater->add_control(
                        'clinet_url', [
                            'label'             => esc_html__( 'Logo URL', 'themewar' ),
                            'type'              => Controls_Manager::URL,
                            'input_type'        => 'url',
                            'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                            'show_external'     => true,
                            'default'           => [
                                    'url'            => '',
                                    'is_external'    => true,
                                    'nofollow'       => true,
                            ],
                        ]
                );
                $this->add_control(
                    'list',
                    [
                            'label'   => esc_html__( 'Client Logo', 'themewar' ),
                            'type'    => Controls_Manager::REPEATER,
                            'fields'  => $repeater->get_controls(),
                            'default' => [
                                    [
                                            'client_logo'        => esc_html__( 'Normal', 'themewar' ),
                                            'clinet_url'         => esc_html__( 'Single Logo', 'themewar' )

                                    ],
                            ],
                            'title_field' => '{{{ "Single Logo" }}}',
                    ]
                );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_02', [
                    'label'             => esc_html__('Item Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE
                ]
        );
            $this->start_controls_tabs( 'item_styling_tab' );
                $this->start_controls_tab(
                        'item_styling_tab_normal',
                        [
                                'label' => esc_html__( 'Normal', 'themewar' ),
                        ]
                );
                    $this->add_responsive_control(
                            'cl_img_opacity',
                            [
                                    'label' => esc_html__( 'IMG Opacity', 'themewar' ),
                                    'type' => Controls_Manager::NUMBER,
                                    'min' => 0,
                                    'max' => 1,
                                    'step' => .10,
                                    'default' => '',
                                    'selectors' => [
                                            '{{WRAPPER}} .brandSlider.owl-carousel a.brandItem img' => 'opacity: {{VALUE}}',
                                    ],
                            ]
                    );
                    $this->add_responsive_control(
                            'cl_item_bg',
                            [
                                    'label' => esc_html__( 'Item BG Color', 'themewar' ),
                                    'type'  => Controls_Manager::COLOR,
                                    'selectors' => [
                                            '{{WRAPPER}} .brandSlider.owl-carousel a' => 'background: {{VALUE}}',
                                    ],
                            ]
                    );
                    $this->add_group_control(
                            Group_Control_Box_Shadow::get_type(),
                            [
                                    'name' => 'cl_item_shadow',
                                    'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                                    'selector' => '{{WRAPPER}} .brandSlider.owl-carousel a',
                            ]
                    );
                    $this->add_group_control(
                            Group_Control_Border::get_type(),
                            [
                                    'name' => 'cl_item_border',
                                    'label' => esc_html__( 'Border', 'themewar' ),
                                    'selector' => '{{WRAPPER}} .brandSlider.owl-carousel a',
                            ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'item_styling_tab_hover',
                        [
                                'label' => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                    $this->add_responsive_control(
                            'cl_img_opacity_hover',
                            [
                                    'label' => esc_html__( 'IMG Opacity', 'themewar' ),
                                    'type' => Controls_Manager::NUMBER,
                                    'min' => 0,
                                    'max' => 1,
                                    'step' => .10,
                                    'default' => 1,
                                    'selectors' => [
                                            '{{WRAPPER}} .brandSlider.owl-carousel a.brandItem:hover img' => 'opacity: {{VALUE}}',
                                    ],
                            ]
                    );
                    $this->add_responsive_control(
                            'cl_item_bg_hover',
                            [
                                    'label' => esc_html__( 'Item BG Color', 'themewar' ),
                                    'type'  => Controls_Manager::COLOR,
                                    'selectors' => [
                                            '{{WRAPPER}} .brandSlider.owl-carousel a:hover' => 'background: {{VALUE}}',
                                    ],
                            ]
                    );
                    $this->add_group_control(
                            Group_Control_Box_Shadow::get_type(),
                            [
                                    'name' => 'cl_item_shadow_hover',
                                    'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                                    'selector' => '{{WRAPPER}} .brandSlider.owl-carousel a:hover',
                            ]
                    );
                    $this->add_group_control(
                            Group_Control_Border::get_type(),
                            [
                                    'name' => 'cl_item_border_hover',
                                    'label' => esc_html__( 'Border', 'themewar' ),
                                    'selector' => '{{WRAPPER}} .brandSlider.owl-carousel a:hover',
                            ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'logo_width', [
                            'label' => esc_html__( 'Logo Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                    'px' => [
                                            'min' => 1,
                                            'max' => 1000,
                                            'step' => 1,
                                    ]
                            ],
                            'default' => [
                                    'size' => '',
                            ],
                            'selectors' => [
                                    '{{WRAPPER}} .brandSlider.owl-carousel a.brandItem img' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'logo_height', [
                            'label' => esc_html__( 'Logo Hight', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                    'px' => [
                                            'min' => 1,
                                            'max' => 1000,
                                            'step' => 1,
                                    ]
                            ],
                            'default' => [
                                    'size' => '',
                            ],
                            'selectors' => [
                                    '{{WRAPPER}} .brandSlider.owl-carousel a.brandItem img' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'cl_item_padding',
                    [
                            'label' => esc_html__( 'Item Padding', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .brandSlider.owl-carousel a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'cl_item_margin',
                    [
                            'label' => esc_html__( 'Item Margin', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .brandSlider.owl-carousel a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_nav', [
                    'label'             => esc_html__('Nav Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'condition'         => ['client_slide_nav' => 'yes']
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'nav_i_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-nav button'
                ]
        );
        $this->add_responsive_control(
                'bl_nav_radius',
                [
                        'label' => esc_html__( 'Nav  Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-nav button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->start_controls_tabs( 'nav_styling_tab' );
            $this->start_controls_tab(
                    'nav_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_color',
                    [
                            'label' => esc_html__( 'Nav Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-nav button' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'bl_nav_bg',
                        'label' => esc_html__( 'Nav Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-nav button',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'bl_nav_bg_shadow',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-nav button',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'bl_nav_bg_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-nav button',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'nav_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_color_hover',
                    [
                            'label' => esc_html__( 'Nav Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-nav button:hover' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'bl_nav_bg_hover',
                        'label' => esc_html__( 'Nav Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-nav button:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'bl_nav_bg_shadow_hover',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-nav button:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'bl_nav_bg_border_hover',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-nav button:hover',
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'left_nav_margin',
                    [
                            'label'      => esc_html__( 'Left Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-nav button.owl-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'right_nav_margin',
                    [
                            'label'      => esc_html__( 'Right Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-nav button.owl-next' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_04', [
                    'label'             => esc_html__('Dots Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'condition'         => ['client_slide_dots' => 'yes']
                ]
        );
            $this->add_responsive_control(
                    'dots_width',
                    [
                            'label' => esc_html__( 'Dots Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 50,
                                            'step' => 1,
                                    ]
                            ],
                            'default' => [
                                    'unit' => 'px',
                                    'size' => '',
                            ],
                            'selectors' => [
                                    '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button' => 'width: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'dots_height',
                    [
                            'label' => esc_html__( 'Dots Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 50,
                                            'step' => 1,
                                    ]
                            ],
                            'default' => [
                                    'unit' => 'px',
                                    'size' => '',
                            ],
                            'selectors' => [
                                    '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button' => 'height: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
            $this->start_controls_tabs( 'dot_styling_tab' );
                $this->start_controls_tab(
                        'dot_styling_tab_normal',
                        [
                                'label' => esc_html__( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'bl_dot_bg',
                            'label' => esc_html__( 'Nav Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'bl_dot_shadow',
                                'label' => esc_html__( 'Dots Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'bl_dot_bg_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button',
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'dot_styling_tab_hover',
                        [
                                'label' => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'bl_dot_hover_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button:hover, {{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button.active',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'bl_dot_hover_shadow',
                                'label' => esc_html__( 'Dots Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button:hover, {{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button.active',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'bl_dot_hover_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button:after',
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'bl_dot_radius',
                    [
                            'label' => esc_html__( 'Dots  Radius', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_dot_margin',
                    [
                            'label' => esc_html__( 'Dots  Gapping', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_dots_margin',
                    [
                            'label' => esc_html__( 'Dot Area Margins', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .clslider_wrap .owl-carousel .owl-dots' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings       = $this->get_settings_for_display();
        $logo_style  = (isset($settings['logo_style']) && $settings['logo_style'] > 0) ? $settings['logo_style'] : 2;

        $autoplay = (isset($settings['client_slide_autoplay']) && $settings['client_slide_autoplay'] != '' ? $settings['client_slide_autoplay'] : 'yes');
        $loop = (isset($settings['client_slide_loop']) && $settings['client_slide_loop'] != '' ? $settings['client_slide_loop'] : 'yes');
        $nav = (isset($settings['client_slide_nav']) && $settings['client_slide_nav'] != '' ? $settings['client_slide_nav'] : 'no');
        $dots = (isset($settings['client_slide_dots']) && $settings['client_slide_dots'] != '' ? $settings['client_slide_dots'] : 'no');
        
        $items_number   = (isset($settings['items_number']) && $settings['items_number'] > 0 ? $settings['items_number'] : 4);
        $items_number2  = (isset($settings['items_number2']) && $settings['items_number2'] > 0 ? $settings['items_number2'] : 3);
        $items_number3  = (isset($settings['items_number3']) && $settings['items_number3'] > 0 ? $settings['items_number3'] : 2);
        $gapping        = (isset($settings['items_gapping']) && $settings['items_gapping'] > 0 ? $settings['items_gapping'] : 0);
        
        $client         = (isset($settings['list']) && !empty($settings['list'])) ? $settings['list'] : array();
        
        if(!empty($client)):
            ?>
            <div class="clslider_wrap" 
                 data-autoplay="<?php echo ($autoplay == 'yes' ? '1' : '0'); ?>" 
                 data-loop="<?php echo ($loop == 'yes' ? '1' : '0'); ?>" 
                 data-nav="<?php echo ($nav == 'yes' ? '1' : '0'); ?>" 
                 data-dots="<?php echo ($dots == 'yes' ? '1' : '0'); ?>" 
                 data-item="<?php echo esc_attr($items_number); ?>"
                 data-item2="<?php echo esc_attr($items_number2); ?>"
                 data-item3="<?php echo esc_attr($items_number3); ?>"
                 data-gapping="<?php echo esc_attr($gapping); ?>"
                 >
                <div class="brandSlider owl-carousel">
                    <?php
                        foreach($client as $item):
                            $logo       = (isset($item['client_logo']['url'])) ? $item['client_logo']['url'] : '';
                            $url        = (isset($item['clinet_url']['url'])) ? $item['clinet_url']['url'] : '#';
                            $target     = (isset($item['clinet_url']['is_external'])) ? ' target="_blank"' : '' ;
                            $nofollow   = (isset($item['clinet_url']['nofollow'])) ? ' rel="nofollow"' : '' ;
                            if($logo != ''):
                                ?>
                                <a class="brandItem" href="<?php echo $url; ?>" <?php echo $target.' '.$nofollow; ?>>
                                    <img src="<?php echo esc_url($logo); ?>" alt="<?php the_title_attribute(); ?>"/>
                                </a>
                                <?php
                            endif;
                        endforeach;
                    ?>
                </div>
            </div>
            <?php
        endif; 
    }
        
    protected function content_template() {}
}