<?php
    $filter_cat = array(
        'orderby'       => 'ID',
        'order'         => 'DESC', 
        'hide_empty'    => 1,
        'hierarchical'  => 1,
        'taxonomy'      => 'product_cat'
    );
    $categories = get_categories( $filter_cat );
?>
<?php if(!empty($categories)): ?>
    <div class="product_filer_wrap">
        <div class="row">
            <div class="col-lg-12">
                <ul class="filter_menu02 shaff_filter clearfix text-<?php echo esc_attr($text_align); ?>">
                    <li class="active" data-group="all"><?php echo esc_html__('All', 'themewar'); ?></li>
                    <?php 
                        foreach($categories as $cat):
                            ?><li class="filter" data-group="<?php echo esc_attr($cat->slug); ?>"><?php echo esc_html($cat->name); ?></li><?php
                        endforeach;
                    ?>
                </ul>
            </div>
        </div>
        <?php
        $pro = array(
            'post_type'         => array('product'),
            'post_status'       => array('publish'),
            'posts_per_page'    => $post_item
        );

        if($product_type == 2){
            if(isset($pro['tax_query'])):
                $pro['tax_query'][] = array(
                        'taxonomy' => 'product_visibility', 
                        'field' => 'name', 
                        'terms' => 'featured',
                        'operator' => 'IN',
                );
            else:
                $pro['tax_query']   = array(
                    'relation' => 'AND', 
                    array(
                        'taxonomy' => 'product_visibility', 
                        'field' => 'name', 
                        'terms' => 'featured',
                        'operator' => 'IN',
                    ) 
                );
            endif;
            $pro['orderby'] = 'date';
            $pro['order']   = 'DESC';
        }
        elseif($product_type == 3){
            $pro['meta_query'] = array(
                array(
                    'key' => '_sale_price',
                    'value' => '',
                    'compare' => '!='
                ),
            );
            $pro['orderby'] = 'date';
            $pro['order'] = 'DESC';
        }
        elseif($product_type == 4){
            $pro['meta_key']  = '_bepro_post_view';
            $pro['orderby'] = 'meta_value_num';
            $pro['order'] = 'DESC';
        }
        elseif($product_type == 5){
            $pro['meta_query'] = array(
                array(
                    'key' => 'total_sales',
                    'value' => 0,
                    'compare' => '>',
                    'type' => 'DECIMAL',
                ),
            );
            $pro['orderby'] = 'meta_value_num';
            $pro['order'] = 'DESC';
        }
        elseif($product_type == 6){
            $pro['meta_query'] = array(
                array(
                    'key' => '_wc_average_rating',
                    'value' => 0,
                    'compare' => '>',
                    'type' => 'DECIMAL',
                ),
            );
            $pro['orderby'] = 'meta_value_num';
            $pro['order'] = 'DESC';
        }
        elseif($product_type == 7){
            $pro['orderby'] = 'rand';
        }
        else{
            $pro['orderby']           = 'date';
            $pro['order']             = 'DESC';
        }

        $pros = new WP_Query($pro);
        if($pros->have_posts()): ?>
            <div class="row woocommerce shaff_grid">
                <?php
                    $i = 1;
                    while($pros->have_posts()):
                        $pros->the_post();
                        $product = wc_get_product(get_the_ID());
                        $terms = get_the_terms(get_the_ID(), 'product_cat');
                        $data_groups = '["all", ';
                        $cats = '';
                        if (is_array($terms) && count($terms) > 0) 
                        {
                            $p = 1;
                            $c = count($terms);
                            foreach ($terms as $term) 
                            {
                                if($p == $c)
                                {
                                    $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                                    $data_groups .= '"'.$term->slug.'"';
                                }
                                else
                                {
                                    $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>'. ' ,';
                                    $data_groups .= '"'.$term->slug.'", ';
                                }
                                $p++;
                            }
                        }
                        $data_groups .= ']';
                            ?>
                            <div class="col-xl-<?php echo (12 / $pr_column); ?> col-lg-4 col-md-6 shaff_item" data-groups="<?php echo esc_attr($data_groups); ?>">
                                <div <?php wc_product_class('bepro_product_wrapper', $product); ?>>
                                    <div class="productItem01">
                                        <div class="proThumb">
                                            <img src="<?php echo bepro_post_thumbnail(get_the_ID(), 386, 400); ?>" alt="<?php echo get_the_title(); ?>">
                                            <?php if ($show_flashlabels == 'yes'): ?>
                                            <?php echo(function_exists('bepro_product_flash_notice_label') ? bepro_product_flash_notice_label() : '') ?>
                                            <?php endif; ?>
                                            <div class="piActionBtns">
                                                <?php if (shortcode_exists('yith_wcwl_add_to_wishlist') && $shop_is_wishlist_btn == 'yes'): ?>
                                                    <?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
                                                <?php endif; ?>
                                                <?php function_exists('bepro_add_to_cart') ? bepro_add_to_cart() : '' ?>
                                                <a class="quickview" href="<?php echo get_the_permalink() ?>"><i class="bpro-search-icon"></i></a>
                                            </div>
                                        </div>
                                        <div class="product_content">
                                            <div class="ratings">
                                                <?php if (function_exists('woocommerce_template_loop_rating')): ?>
                                                    <?php echo woocommerce_template_loop_rating(); ?>
                                                <?php endif; ?>
                                            </div>
                                            <h3><a href="<?php echo get_the_permalink() ?>"><?php echo get_the_title() ?></a></h3>
                                            <div class="pi01Price">
                                                <?php echo bepro_kses($product->get_price_html()); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php
                        $i++;
                    endwhile;
                ?>
            </div>
        <?php endif; ?>
    </div>
<?php endif; wp_reset_postdata(); ?>