<?php $tabs_id        = uniqid('tw-tabs-'); if(!empty($list_item03)): ?>
<ul class="nav pricingTab03" role="tablist">
    <?php 
    if(!empty($list_item03)):
    $i = 1; 
    foreach ($list_item03 as $key => $item):
        $tab_title    = (isset($item['tab_title']) && $item['tab_title'] != '') ? $item['tab_title'] : ''; ?>
        <li role="presentation">
            <a href="#<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" aria-controls="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" class="nav-link <?php if($i == 1){ echo 'active'; } ?>" role="tab" data-toggle="tab"><?php echo esc_html($tab_title); ?></a>
        </li>
        <?php 
        $i++;
    endforeach;
    endif; ?>
</ul>
<div class="row">
    <div class="col-xl-6 col-lg-7">
        <div class="tab-content">
            <?php 
                if(!empty($list_item03)):
                $i = 1; 
                foreach ($list_item03 as $key => $item):
                    $price_img        = (isset($item['price_img']['url']) && $item['price_img']['url'] != '') ? $item['price_img']['url'] : '';
                    $price_name       = (isset($item['price_name']) && $item['price_name'] != '') ? $item['price_name'] : '';
                    $tp_currency      = (isset($item['tp_currency']) && $item['tp_currency'] != '') ? $item['tp_currency'] : '';
                    $tp_price         = (isset($item['tp_price']) && $item['tp_price'] != '') ? $item['tp_price'] : '';
                    $pr_period        = (isset($item['pr_period']) && $item['pr_period'] != '') ? $item['pr_period'] : '';
                    $list_items       = (isset($item['list_items']) && $item['list_items'] != '') ? preg_split('/\n|\r\n?/', $item['list_items']): '';

                    $pricing_btns     = (isset($item['pricing_btns']) && $item['pricing_btns'] != '') ? $item['pricing_btns'] : '';
                    $btns_url         = (isset($item['btns_url']['url']) && $item['btns_url']['url'] != '') ? $item['btns_url']['url'] : '#';
                    ?>
                    <div class="tab-pane fade <?php if($i == 1): ?> show active <?php endif; ?>" id="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" role="tabpanel">
                        <div class="tabContent03">
                            <?php if($price_img != ''): ?>
                                <img src="<?php echo esc_url($price_img); ?>" alt="<?php echo esc_attr__('pricing_image', 'themewar'); ?>">
                            <?php endif; ?>
                            <div class="pricing-item-02 cmpriceItem text-center">
                                <?php if($price_name != ''): ?>
                                    <h4 class="p-title"><?php echo esc_html($price_name); ?></h4>
                                <?php endif; ?>
                                <?php if($tp_price != ''): ?>
                                    <h3 class="p-price">
                                        <sup class="currency"><?php echo wp_kses_post($tp_currency); ?></sup><?php echo wp_kses_post($tp_price); ?>
                                    </h3>
                                <?php endif; ?>
                                <?php if($pr_period != ''): ?>
                                    <p class="prperiod"><?php echo wp_kses_post($pr_period); ?></p>
                                <?php endif; ?>
                                <?php if(is_array($list_items) && !empty($list_items)): ?>
                                    <ul class="ptlist">
                                        <?php foreach ($list_items as $items) {
                                            if(strpos($items, 'disable:') !== false){
                                                echo '<li class="disable"><i class="twi-check-circle1"></i>'.str_replace('disable:', '', $items).'</li>';
                                            }else{
                                                echo '<li><i class="twi-check-circle1"></i>'.$items.'</li>';
                                            }
                                        } ?>
                                    </ul>
                                <?php endif; ?>
                                <?php if($pricing_btns != ''): ?>
                                    <a class="berpo_btn" href="<?php echo esc_url($btns_url); ?>">
                                        <span class="bp-shape"></span>
                                        <span class="bp-shape"></span>
                                        <span class="bp-shape"></span>
                                        <span class="bp-shape"></span>
                                        <span class="bp-text"><?php echo esc_html($pricing_btns); ?></span>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php 
                    $i++;
                endforeach;
                endif; 
            ?>
        </div>
    </div>
    <div class="col-xl-6 col-lg-5">
        <div class="priceCon">
            <?php if($sub_title != ''): ?>
                <div class="subTitle prcolor3 font_600"><i class="twi-star-of-life"></i><?php echo wp_kses_post($sub_title); ?></div>
            <?php endif; ?>
            <?php if($main_title != ''): ?>
                <h2 class="secTitle hcolor font_600"><?php echo wp_kses_post($main_title); ?></h2>
            <?php endif; ?>
            <?php if($description != ''): ?>
                <p><?php echo wp_kses_post($description); ?></p>
            <?php endif; ?>
            <div class="icon_box_01">
                <i class="<?php echo $icons; ?>"></i>
                <h5>
                    <?php echo wp_kses_post($box_title); ?>
                    <span><?php echo wp_kses_post($desc); ?></span>
                </h5>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>