<?php
    if (($key = array_search(0, $folio_category)) !== false) {
        unset($folio_category[$key]);
    }
    if (($key = array_search(0, $pfs_folio)) !== false) {
        unset($pfs_folio[$key]);
    }
    $cat_args = array(
        'orderby'       => 'ID',
        'order'         => 'DESC', 
        'hide_empty'    => 1,
        'hierarchical'  => 1,
        'taxonomy'      => 'folio_cat'
    );
    if(!empty($folio_category)):
        $cat_args['include'] = $folio_category;
    endif;
    $categories = get_categories( $cat_args );
if($is_filter == 'yes' && !empty($categories)): ?>
<div class="row">
    <div class="col-md-12">
        <ul class="filter_menu03 shaff_filter clearfix text-<?php echo esc_attr($filtr_alignment); ?>">
            <li class="active" data-group="all"><?php echo esc_html__('All', 'themewar'); ?><span><?php echo esc_html(count($categories)); ?></span></li>
            <?php 
                foreach($categories as $cat):
                    ?><li class="filter" data-group="<?php echo esc_attr($cat->slug); ?>"><?php echo esc_html($cat->name); ?><span><?php if($cat->name < 10): echo '0'; endif; echo esc_html($cat->count); ?></span></li><?php
                endforeach;
            ?>
        </ul>
    </div>
</div>
<?php endif; ?>
<?php
    $page = (get_query_var('paged') != '') ? get_query_var('paged') : 1;
    $fargs = array(
        'post_type'         => 'folio',
        'post_status'       => 'publish',
        'posts_per_page'    => $folio_no_item,
        'orderby'           => $folio_order_by,
        'order'             => $folio_order,
        'paged'             => $page
    );
    if(!empty($folio_category)){
        $fargs['tax_query']   = array(
            'relation'      => 'AND', 
            array(
                'taxonomy'  => 'folio_cat', 
                'field'     => 'id', 
                'terms'     => $folio_category,
                'operator'  => 'IN'
            )
        );
    }
    if(!empty($pfs_folio)){
        $fargs['post__in'] = $pfs_folio;
    }
    query_posts($fargs);
    if(have_posts()): ?>
        <div class="row cusCol <?php echo ($is_filter == 'yes' ? 'shaff_grid' : ''); ?>">
            <?php
            $i = 1;
            $lg_img = array(3, 7, 11, 15, 19);
            $sm_img = array(4, 8, 12, 16, 20);
            while(have_posts()):
                the_post();
                $video_src       = '';
                $folio_sub_title = '';
                if(defined('FW')){
                    $video_src        = fw_get_db_post_option(get_the_ID(), 'video_src', '');
                    $folio_sub_title  = fw_get_db_post_option(get_the_ID(), 'folio_sub_title', '');
                }
                $terms  = get_the_terms(get_the_ID(), 'folio_cat');
                $groups = '["all", ';
                $cats   = '';
                if (is_array($terms) && count($terms) > 0){
                    $p = 1;
                    $c = count($terms);
                    foreach ($terms as $term){
                        if($p == $c){
                            $groups .= '"'.$term->slug.'"';
                            $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                        }else{
                            $groups .= '"'.$term->slug.'", ';
                            $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a> , ';
                        }
                        $p++;
                    }
                }
                if(in_array($i, $lg_img)):
                    $w = '932';
                    $h = '506';
                    $c = 'col-lg-8';
                elseif(in_array($i, $sm_img)):
                    $w = '460';
                    $h = '506';
                    $c = 'col-lg-4';
                else:
                    $w = '696';
                    $h = '506';
                    $c = 'col-lg-6';
                endif;
                $groups .= ']';

                $ws = ($tw_thumb_width > 0 ? $tw_thumb_width : $w);
                $hs = ($tw_thumb_height > 0 ? $tw_thumb_height : $h);

                ?>
                <div class="<?php if($is_cus_col == 'yes'): echo esc_attr($xl.$lg.$md); else: echo esc_attr($c); endif; ?> noPadding <?php if($is_filter == 'yes'): ?>shaff_item<?php endif; ?>" <?php if($is_filter == 'yes'): ?>data-groups='<?php echo esc_attr($groups); ?>'<?php endif; ?>>
                    <div class="folioItem05 cmfoliItem">
                        <img src="<?php echo bepro_post_thumbnail(get_the_ID(), $ws, $hs); ?>" alt="<?php echo get_the_title(); ?>">
                        <div class="folioHover05">
                            <p><?php echo wp_kses_post($cats); ?></p>
                            <h4><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h4>
                            <a href="<?php echo get_the_permalink(); ?>" class="crm"><i class="twi-arrow-right1"></i></a>
                        </div>
                    </div>
                </div>
                <?php
                $i++;
            endwhile;
            ?>
            <?php if($is_filter == 'yes'): ?><div class="col-md-1 shaff_size"></div><?php endif; ?>
        </div>
        <?php if($is_pagination == 'yes'): ?>
        <div class="row">
            <div class="col-lg-12">
                <div class="bepro_pagination folio_list_pagin">
                    <?php
                        the_posts_pagination(
                            array(
                                'prev_text'        => bepro_kses('<i class="twi-angle-left"></i>').'<span>'.esc_html__( 'Prev Page', 'themewar').'</span>',
                                'next_text'        => '<span>'.esc_html__( 'Next Page', 'themewar').'</span>'.bepro_kses('<i class="twi-angle-right"></i>'),
                                'before_page_number' => '',
                            )
                        );
                    ?>
                </div>
            </div>  
        </div>
        <?php endif; ?>
<?php
endif;
wp_reset_query(); 