<?php
    if (($key = array_search(0, $folio_category)) !== false) {
        unset($folio_category[$key]);
    }
    if (($key = array_search(0, $pfs_folio)) !== false) {
        unset($pfs_folio[$key]);
    }
    $cat_args = array(
        'orderby'       => 'ID',
        'order'         => 'DESC', 
        'hide_empty'    => 1,
        'hierarchical'  => 1,
        'taxonomy'      => 'folio_cat'
    );
    if(!empty($folio_category)):
        $cat_args['include'] = $folio_category;
    endif;
    $categories = get_categories( $cat_args );
if($is_filter == 'yes' && !empty($categories)): ?>
<div class="container largeContainer">
    <div class="row">
        <div class="col-md-12">
            <ul class="filter_menu02 shaff_filter clearfix text-<?php echo esc_attr($filtr_alignment); ?>">
                <li class="active" data-group="all"><?php echo esc_html__('All', 'themewar'); ?></li>
                <?php 
                    foreach($categories as $cat):
                        ?><li class="filter" data-group="<?php echo esc_attr($cat->slug); ?>"><?php echo esc_html($cat->name); ?></li><?php
                    endforeach;
                ?>
            </ul>
        </div>
    </div>
</div>
<?php endif; ?>
<?php
    $page = (get_query_var('paged') != '') ? get_query_var('paged') : 1;
    $fargs = array(
        'post_type'         => 'folio',
        'post_status'       => 'publish',
        'posts_per_page'    => $folio_no_item,
        'orderby'           => $folio_order_by,
        'order'             => $folio_order,
        'paged'             => $page
    );
    if(!empty($folio_category)){
        $fargs['tax_query']   = array(
            'relation'      => 'AND', 
            array(
                'taxonomy'  => 'folio_cat', 
                'field'     => 'id', 
                'terms'     => $folio_category,
                'operator'  => 'IN'
            )
        );
    }
    if(!empty($pfs_folio)){
        $fargs['post__in'] = $pfs_folio;
    }
    query_posts($fargs);
    if(have_posts()): ?>
        <div class="row grid_row <?php echo ($is_filter == 'yes' ? 'shaff_grid' : ''); ?>">
            <?php
            $i = 1;
            while(have_posts()):
                the_post();
                $video_src       = '';
                $folio_sub_title = '';
                if(defined('FW')){
                    $video_src        = fw_get_db_post_option(get_the_ID(), 'video_src', '');
                    $folio_sub_title  = fw_get_db_post_option(get_the_ID(), 'folio_sub_title', '');
                }
                $terms  = get_the_terms(get_the_ID(), 'folio_cat');
                $groups = '["all", ';
                $cats   = '';
                if (is_array($terms) && count($terms) > 0){
                    $p = 1;
                    $c = count($terms);
                    foreach ($terms as $term){
                        if($p == $c){
                            $groups .= '"'.$term->slug.'"';
                            $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                        }else{
                            $groups .= '"'.$term->slug.'", ';
                            $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a> , ';
                        }
                        $p++;
                    }
                }
                $groups .= ']';

                $ws = ($tw_thumb_width > 0 ? $tw_thumb_width : 480);
                $hs = ($tw_thumb_height > 0 ? $tw_thumb_height : 447);

                ?>
                <div class="<?php if($is_cus_col == 'yes'): echo esc_attr($xl.$lg.$md); else: ?>col-xl-3 col-md-6<?php endif; ?> noPadding <?php if($is_filter == 'yes'): ?>shaff_item<?php endif; ?>" <?php if($is_filter == 'yes'): ?>data-groups='<?php echo esc_attr($groups); ?>'<?php endif; ?>>
                    <div class="folioItem03 cmfoliItem">
                        <img src="<?php echo bepro_post_thumbnail(get_the_ID(), $ws, $hs); ?>" alt="<?php echo get_the_title(); ?>">
                        <div class="folioHover03">
                            <p><?php echo wp_kses_post($cats); ?></p>
                            <h4><a href="<?php echo get_the_permalink(); ?>"><?php echo substr(wp_strip_all_tags(get_the_title()), 0, 20); ?></a></h4>
                            <?php if($video_src != ''): ?>
                                <a href="<?php echo esc_url($video_src) ?>" class="popup_video"><i class="twi-play"></i></a>
                            <?php endif; ?>
                            <a class="crm" href="<?php echo get_the_permalink(); ?>"><i class="twi-link"></i></a>
                        </div>
                    </div>
                </div>
                <?php
                $i++;
            endwhile;
            ?>
            <?php if($is_filter == 'yes'): ?><div class="col-md-1 shaff_size"></div><?php endif; ?>
        </div>
        <?php if($is_pagination == 'yes'): ?>
        <div class="row">
            <div class="col-lg-12">
                <div class="bepro_pagination folio_list_pagin">
                    <?php
                        the_posts_pagination(
                            array(
                                'prev_text'        => bepro_kses('<i class="twi-angle-left"></i>').'<span>'.esc_html__( 'Prev Page', 'themewar').'</span>',
                                'next_text'        => '<span>'.esc_html__( 'Next Page', 'themewar').'</span>'.bepro_kses('<i class="twi-angle-right"></i>'),
                                'before_page_number' => '',
                            )
                        );
                    ?>
                </div>
            </div>  
        </div>
        <?php endif; ?>
<?php
endif;
wp_reset_query(); 