<?php if ($is_header == 'yes'): ?>
    <!-- Header Start -->
    <header class="header04 <?php if ($is_sticky == 'yes'): ?>isSticky<?php endif; ?>">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="navbar01">
                        <div class="logo">
                            <?php if (!empty($logo)): ?>
                                <a href="<?php echo esc_url(home_url('/')); ?>">
                                    <img src="<?php echo esc_url($logo); ?>" alt="<?php echo get_bloginfo(); ?>"/>
                                    <?php if (!empty($sticky_logo)): ?>
                                        <img class="stickyLogo" src="<?php echo esc_url($sticky_logo); ?>" alt="<?php echo get_bloginfo(); ?>"/>
                                    <?php endif; ?>
                                </a>
                            <?php else: ?>
                                <a class="text" href="<?php echo esc_url(home_url('/')); ?>"><?php echo get_bloginfo('name'); ?></a>
                            <?php endif; ?>
                        </div>
                        <div class="accessNav">
                            <a class="popup_togggle_menu" href="javascript:void(0);">
                                <span></span>
                                <span></span>
                                <span></span>
                                <span></span>
                            </a>
                            <?php if ($is_serch == 'yes'): ?>
                                <a class="search_btn" href="javascript:void(0);"><i class="twi-search1"></i></a>
                            <?php endif; ?>
                            <?php if($is_cart == 'yes' && class_exists('woocommerce')): global $woocommerce; ?>
                            <div class="shoping_cart">
                                <a class="cartBtn bepro_aj_cart" href="javascript:void(0);"><i class="twi-shopping-bag1"></i><span><?php echo Tw_Assistance_Helpers::mini_cart_count();?></span></a>
                                    <?php if($is_mini_cart == 'yes'): ?>
                                        <div class="show_cart_area">
                                            <div class="mini_cart widget_shopping_cart_content">
                                                <?php
                                                if(function_exists('woocommerce_mini_cart')):
                                                    if ( ! empty( WC()->cart) ) {
                                                         woocommerce_mini_cart(); 
                                                    }
                                                endif;
                                                ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header End -->
<?php endif; ?>

<!-- Popup Menu -->
<div class="popup_menu">
    <a href="javascript:void(0);" class="close-popup" id="close_menu"></a>
    <div class="menu_middle">
        <div class="menu_popup">
            <?php
                if (has_nav_menu('primary-popup-menu')) {
                    wp_nav_menu(array(
                        'theme_location' => 'primary-popup-menu',
                        'container'      => FALSE,
                        'menu_class'     => '',
                        'menu_id'        => '',
                        'echo'           => true,
                        'walker'         => new Bepro_Popup_Menu_Walker()
                    ));
                } else {
                    echo '<ul>';
                        echo '<li><a href="javascript:void(0)">' . esc_html__('Please select popup menu.', 'themewar') . '</a></li>';
                    echo '</ul>';
                }
            ?>
        </div>
    </div>
</div>
<!-- Popup Menu -->

<?php if ($is_serch == 'yes'): ?>
<!-- Search Popup Start -->
<section class="popup_search_sec">
    <div class="popup_search_overlay"></div>
    <div class="pop_search_background">
        <div class="middle_search">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 text-center">
                        <div class="popup_search_form">
                            <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                                <input type="search" name="s" value="<?php echo get_search_query(); ?>" placeholder="<?php echo esc_attr_x( 'Type Words and Hit Enter', 'placeholder', 'themewar' ); ?>">
                                <button type="submit"><i class="twi-search1"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Search Popup End -->
<?php endif; ?>