<?php
/**
 * The Template for displaying products in a product category. Simply includes the archive template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/taxonomy-product-cat.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     4.7.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

get_header('shop');
$shop_cat_is_banner = get_theme_mod('shop_cat_is_banner', 1);
$category = get_queried_object();
$category_id = $category->term_id;
$shop_cats_show_top_blocks = 2;
$shop_cats_top_blocks = array();
if (defined('FW')):
    $shop_cats_is_settings = fw_get_db_term_option($category_id, 'product_cat', 'shop_cats_is_settings', 2);
    $shop_cats_is_banner = fw_get_db_term_option($category_id, 'product_cat', 'shop_cats_is_banner', 1);

    $shop_cat_is_banner = ($shop_cats_is_settings == 1 && $shop_cats_is_banner > 0 ? $shop_cats_is_banner : $shop_cat_is_banner);
endif;
if ($shop_cat_is_banner == 1):
    get_template_part('template-parts/header/shop-cat', 'header');
endif;

/* Shop Top Blocks */
$shop_top_bloks = get_theme_mod('top_shop_block_setttings', []);
$blocks_id = array();
if (!empty($shop_top_bloks)) {
    foreach ($shop_top_bloks as $sb):
        if ($sb['top_blocks_ids'] != '' && $sb['top_blocks_ids'] != 'none'):
            if (class_exists('TW_Assistance')) {
                Tw_Builder::render_template($sb['top_blocks_ids']);
            }
        endif;
    endforeach;
}

/* Shop Top Blocks */

$shop_is_category_dropdown = get_theme_mod('shop_is_category_dropdown', true);
$shop_is_sort = get_theme_mod('shop_is_sort', true);
$shop_sort_label = get_theme_mod('shop_sort_label', esc_html__('Sort By:', 'bepro'));
$shop_sidebar = get_theme_mod('shop_sidebar', 1);
$shop_is_res_count = get_theme_mod('shop_is_res_count', false);
$shop_is_title = get_theme_mod('shop_is_title', 2);
$shop_product_label = get_theme_mod('shop_product_label', esc_html__('Popular Products', 'bepro'));

$colmns = ($shop_sidebar == 1 || !is_active_sidebar('sidebar-3') ? 'col-lg-12' : 'col-xl-9 col-lg-8');
$shop_class = ($shop_sidebar == 1 || !is_active_sidebar('sidebar-3') ? '' : 'withSidebar');
?>
    <section class="shopPage <?php echo esc_attr($shop_class); ?>">
        <div class="container largeContainer">
            <div class="row">
                <div class="col-lg-12 wpc_all_notice_area">
                    <?php echo woocommerce_output_all_notices(); ?>
                </div>
            </div>
            <?php if ($shop_is_category_dropdown || $shop_is_sort || $shop_is_res_count == 1 || $shop_is_title == 1): ?>
                <div class="row shop_sort_count_row">
                    <?php if ($shop_is_title == 1): ?>
                        <div class="col-lg-4">
                            <h3 class="sptitle"><?php echo esc_html($shop_product_label); ?></h3>
                        </div>
                    <?php endif; ?>
                    <div class="<?php if ($shop_is_title == 1): ?>col-lg-8<?php else: ?>col-lg-12 text-left<?php endif; ?>">
                        <div class="shopController">
                            <?php if ($shop_is_res_count == 1 && function_exists('woocommerce_result_count')): ?>
                                <?php echo woocommerce_result_count(); ?>
                            <?php endif; ?>
                            <?php if ($shop_is_sort && function_exists('woocommerce_catalog_ordering')): ?>
                                <?php echo woocommerce_catalog_ordering(); ?>
                            <?php endif; ?>
                            <?php if ($shop_is_category_dropdown == TRUE && function_exists('bepro_shop_category_dropdown')): echo bepro_shop_category_dropdown('product_cat'); else: echo ''; endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="row">
                <?php if (is_active_sidebar('sidebar-3') && $shop_sidebar == 2): ?>
                    <div class="col-xl-3 col-lg-4">
                        <div class="sidebar lsb">
                            <?php dynamic_sidebar('sidebar-3'); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="<?php echo esc_attr($colmns); ?>">
                    <div class="row productRow">
                        <?php if (woocommerce_product_loop()): ?>
                            <?php
                            woocommerce_product_loop_start();
                            if (wc_get_loop_prop('total')):
                                while (have_posts()):
                                    the_post();
                                    do_action('woocommerce_shop_loop');
                                    wc_get_template_part('content', 'product');
                                endwhile;
                            endif;
                            woocommerce_product_loop_end();
                            ?>
                        <?php else: ?>
                            <?php do_action('woocommerce_no_products_found'); ?>
                        <?php endif; ?>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="bepro_pagination shop_pagination">
                                <?php echo woocommerce_pagination(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if (is_active_sidebar('sidebar-3') && $shop_sidebar == 3): ?>
                    <div class="col-xl-3 col-lg-4">
                        <div class="sidebar">
                            <?php dynamic_sidebar('sidebar-3'); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php
$shop_bottom_bloks = get_theme_mod('shop_bottom_bloks', []);
if (!empty($shop_bottom_bloks)) {
    foreach ($shop_bottom_bloks as $sb):
        if ($sb['bottom_block_ids'] != '' && $sb['bottom_block_ids'] != 'none'):
            if (class_exists('TW_Assistance')) {
                Tw_Builder::render_template($sb['bottom_block_ids']);
            }
        endif;
    endforeach;
}
get_footer('shop');
