<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $product;

if ( $related_products ) : ?>
<?php
    $shop_pro_related_sub_title = get_theme_mod('shop_pro_related_sub_title', esc_html__('Bepro Products', 'bepro'));
    $shop_pro_related_title     = get_theme_mod('shop_pro_related_title', esc_html__('Related Products', 'bepro'));

    $product_is_flashlabels     = get_theme_mod('product_is_flashlabels', 2);
    $product_is_wishlist        = get_theme_mod('product_is_wishlist', 2);

    $product_id = get_the_ID();
    if(defined('FW')):
    $shop_pros_enable_settings = fw_get_db_post_option($product_id, 'shop_pros_enable_settings', 2);
    if($shop_pros_enable_settings == 1):
        $shop_pros_related_sub_title = fw_get_db_post_option($product_id, 'shop_pros_related_sub_title', '');
        $shop_pros_related_title = fw_get_db_post_option($product_id, 'shop_pros_related_title', '');

        $shop_pros_is_flashlabels  = fw_get_db_post_option($product_id, 'shop_pros_is_flashlabels', 2);
        $shop_pros_is_wishlist     = fw_get_db_post_option($product_id, 'shop_pros_is_wishlist', 2);
        
        $shop_pro_related_title = (!empty($shop_pros_related_title) ? $shop_pros_related_title : $shop_pro_related_title);
        $shop_pro_related_sub_title = (!empty($shop_pros_related_sub_title) ? $shop_pros_related_sub_title : $shop_pro_related_sub_title);

        $product_is_flashlabels  = ($shop_pros_is_flashlabels > 0 ? $shop_pros_is_flashlabels : $product_is_flashlabels);
        $product_is_wishlist     = ($shop_pros_is_wishlist > 0 ? $shop_pros_is_wishlist : $product_is_wishlist);

    endif;
endif;

?>
<div class="row">
    <div class="col-lg-12">
        <div class="related_area">
            <?php if($shop_pro_related_sub_title != ''): ?>
                <div class="subTitle text-center"><?php echo esc_html( $shop_pro_related_sub_title ); ?></div>
            <?php endif; ?>
            <?php if($shop_pro_related_title != ''): ?>
                <h2 class="secTitle text-center"><?php echo esc_html( $shop_pro_related_title ); ?></h2>
            <?php endif; ?>
            <div class="related_carousel owl-carousel">
                <?php foreach ( $related_products as $related_product ) :
                    $post_object = get_post( $related_product->get_id() );
                    setup_postdata( $GLOBALS['post'] =& $post_object );
                ?>
                <div <?php wc_product_class('bepro_product_wrapper ', $related_product); ?>>
                    <div class="productItem01">
                        <div class="proThumb">
                            <img src="<?php echo bepro_post_thumbnail(get_the_ID(), 282, 287); ?>" alt="<?php echo get_the_title(); ?>">
                            <?php echo(function_exists('bepro_product_flash_notice_label') && $product_is_flashlabels ? bepro_product_flash_notice_label() : '') ?>
                            <div class="piActionBtns">
                                <?php if (shortcode_exists('yith_wcwl_add_to_wishlist') && $product_is_wishlist): ?>
                                    <?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
                                <?php endif; ?>
                                <?php function_exists('bepro_add_to_cart') ? bepro_add_to_cart() : '' ?>
                                <a class="quickview" href="<?php echo get_the_permalink() ?>"><i class="bpro-search-icon"></i></a>
                            </div>
                        </div>
                        <div class="product_content">
                            <div class="ratings">
                                <?php if (function_exists('woocommerce_template_loop_rating')): ?>
                                    <?php echo woocommerce_template_loop_rating(); ?>
                                <?php endif; ?>
                            </div>
                            <h3><a href="<?php echo get_the_permalink() ?>"><?php echo get_the_title() ?></a></h3>
                            <div class="pi01Price">
                                <?php echo bepro_kses($related_product->get_price_html()); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<?php
endif;
wp_reset_postdata();
