<?php
/* 
 * Template Name: Demo Blog Left Sidebar 04
 */
get_header();
$blog_page_ID = get_option('page_for_posts', true);

$blog_is_banner  = get_theme_mod('blog_is_banner', 1);
$blog_str_limit  = get_theme_mod('blog_str_limit', 227);

if(defined('FW') && $blog_page_ID > 0):
    $page_is_settings = fw_get_db_post_option($blog_page_ID, 'page_is_settings', 2);
    $page_is_banner   = fw_get_db_post_option($blog_page_ID, 'page_is_banner', 1);
    $blog_is_banner   = ($page_is_settings == 1 && $page_is_banner > 0 ? $page_is_banner : $blog_is_banner);
endif;

if($blog_is_banner == 1):
    get_template_part('template-parts/header/blog', 'header');
endif;

?>
<section class="blogPage">
    <div class="container largeContainer">
        <div class="row">
            <div class="col-lg-4">
                <div class="sidebar lsb">
                    <?php dynamic_sidebar('sidebar-1'); ?>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="row">
                <?php
                    global $wp_query;
                    $page = (get_query_var('paged') != '') ? get_query_var('paged') : 1;
                    $fargs = array(
                        'post_type'         => 'post',
                        'post_status'       => 'publish',
                        'posts_per_page'    => 6,
                        'orderby'           => 'ID',
                        'order'             => 'DESC',
                        'paged'             => $page
                    );
                    $wp_query = new WP_Query($fargs);
                    if($wp_query->have_posts()):
                        while($wp_query->have_posts()):
                            $wp_query->the_post();
                            ?>
                            <div class="col-lg-6 col-md-6">
                                <div class="blogItem04">
                                    <img src="<?php echo bepro_post_thumbnail(get_the_ID(), 386, 241); ?>" alt="<?php echo get_the_title(); ?>">
                                    <div class="blogContent03">
                                        <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
                                        <div class="bmeta"><a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><i class="twi-user1"></i><?php echo get_the_author(); ?></a><span><?php echo human_time_diff(get_the_time('U'), current_time( 'U' )).' '.esc_html__('ago', 'bepro'); ?></span></div>
                                        <p class="pcon">
                                            <?php 
                                                if(has_excerpt()):
                                                    echo substr(wp_strip_all_tags(get_the_excerpt()), 0, 90);
                                                else:
                                                    echo substr(wp_strip_all_tags(get_the_content()), 0, 90);
                                                endif;
                                            ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <?php
                        endwhile;
                    else:
                        get_template_part('template-parts/post/content', 'none');
                        wp_reset_postdata();
                    endif;
                ?>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="bepro_pagination">
                            <?php
                                the_posts_pagination(
                                    array(
                                        'prev_text'          => bepro_kses('<i class="twi-angle-left"></i>').'<span>'.esc_html__( 'Prev Page', 'bepro').'</span>',
                                        'next_text'          => '<span>'.esc_html__('Next Page', 'bepro').'</span>'.bepro_kses('<i class="twi-angle-right"></i>'),
                                        'before_page_number' => '',
                                        'type'               => 'array'
                                    )
                                );
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php
get_footer(); 