<?php
$bloks = array(
    'post_type'     => 'blocks',
    'post_status'   => 'publish',
    'posts_per_page'  => -1,
    'orderby'        => 'title',
    'order'          => 'ASC'
);
$all_bloks = array(
    'none' => esc_html__('None', 'bepro')
);
$blok = new WP_Query($bloks);
if($blok->have_posts()):
    while($blok->have_posts()):
    $blok->the_post();
    $all_bloks[get_the_ID()] = get_the_title();
    endwhile;
endif;
wp_reset_postdata();


$fields[] = array(
    'type'        => 'custom',
	'settings'    => 'shop_pro_custom_01',
	'label'       => FALSE,
	'section'     => 'shop_product_setting',
	'default'     => '<div class="customizer_label">'.esc_html__('Banner Settings', 'bepro').'</div>',
);
$fields[]= array(
    'type'        => 'switch',
	'settings'    => 'shop_pro_is_banner',
	'label'       => esc_html__( 'Is Banner?', 'bepro' ),
	'section'     => 'shop_product_setting',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Enable ', 'bepro' ),
		'off'     => esc_html__( 'Disable ', 'bepro' ),
	],
);
$fields[] = array(
    'type'        => 'background',
	'settings'    => 'shop_pro_banner_bg',
	'label'       => esc_html__( 'Banner Background', 'bepro' ),
	'description' => esc_html__( 'Setup you product details page banner BG.', 'bepro' ),
	'section'     => 'shop_product_setting',
	'default'     => [
		'background-color'      => '',
		'background-image'      => '',
		'background-repeat'     => 'no-repeat',
		'background-position'   => 'center center',
		'background-size'       => 'cover',
		'background-attachment' => 'scroll',
	],
    'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner.shop_details_page_banner',
		]
	],
    'active_callback' => [
            [
                    'setting'  => 'shop_pro_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
    'type'        => 'color',
    'settings'    => 'shop_pro_banner_overlay_color',
    'label'       => esc_html__( 'Banner Overlay Color', 'bepro' ),
    'section'     => 'shop_product_setting',
    'default'     => '',
    'transport'   => 'auto',
    'output'      => [
        [
            'element' => '.shop_details_page_banner .overlay',
            'property' => 'background'
        ],
    ],
    'active_callback' => [
        [
                'setting'  => 'shop_pro_is_banner',
                'operator' => '==',
                'value'    => true,
        ],
    ],
);
$fields[] = array(
    'type'          => 'text',
    'settings'      => 'shop_pro_banner_title',
    'label'         => esc_html__('Banner Title', 'bepro'),
    'section'       => 'shop_product_setting',
    'default'       => '',
    'transport'     => 'postMessage',
    'js_vars'       => array(
        array(
            'element'  => '.page_banner.shop_details_page_banner .banner-title',
            'function' => 'html'
        )
    ),
    'active_callback' => [
            [
                    'setting'  => 'shop_pro_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ],
    ],
);
$fields[]= array(
    'type'        => 'switch',
	'settings'    => 'shop_pro_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb?', 'bepro' ),
	'section'     => 'shop_product_setting',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Show', 'bepro' ),
		'off'     => esc_html__( 'Hide', 'bepro' ),
	],
    'active_callback' => [
            [
                    'setting'  => 'shop_pro_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
    'type'            => 'radio-buttonset',
	'settings'    => 'shop_pro_banner_alignment',
	'label'       => esc_html__( 'Choose your banner text alignment.', 'bepro' ),
	'section'     => 'shop_product_setting',
	'default'     => 'center',
	'choices'     => [
		'left'   => esc_html__( 'Left', 'bepro' ),
		'center' => esc_html__( 'Center', 'bepro' ),
		'right'  => esc_html__( 'Right', 'bepro' ),
	],
    'active_callback' => [
            [
                    'setting'  => 'shop_pro_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);


$fields[] = array(
    'type'        => 'custom',
	'settings'    => 'shop_pro_custom_02',
	'label'       => FALSE,
	'section'     => 'shop_product_setting',
	'default'     => '<div class="customizer_label mt40">'.esc_html__('Content Settings', 'bepro').'</div>',
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'shop_pro_gal_style',
        'label'       => esc_html__( 'Gallery Style', 'bepro' ),
        'section'     => 'shop_product_setting',
        'default'     => '1',
        'choices'     => array(
                '1'     => esc_html__( 'Gallery In Left', 'bepro' ),
                '2'     => esc_html__( 'Gallery In Right', 'bepro' )
        ),
);
$fields[]= array(
    'type'        => 'switch',
    'settings'    => 'shop_pro_is_cats',
    'label'       => esc_html__( 'Is Categories?', 'bepro' ),
    'section'     => 'shop_product_setting',
    'default'     => '1',
    'choices'     => [
        'on'      => esc_html__( 'Show', 'bepro' ),
        'off'     => esc_html__( 'Hide', 'bepro' ),
    ],
);
$fields[]= array(
    'type'        => 'switch',
    'settings'    => 'shop_pro_is_sku',
    'label'       => esc_html__( 'Is SKU?', 'bepro' ),
    'section'     => 'shop_product_setting',
    'default'     => '2',
    'choices'     => [
        'on'      => esc_html__( 'Show', 'bepro' ),
        'off'     => esc_html__( 'Hide', 'bepro' ),
    ],
);
$fields[]= array(
    'type'        => 'switch',
    'settings'    => 'shop_pro_is_tags',
    'label'       => esc_html__( 'Is Tags?', 'bepro' ),
    'section'     => 'shop_product_setting',
    'default'     => '1',
    'choices'     => [
        'on'      => esc_html__( 'Show', 'bepro' ),
        'off'     => esc_html__( 'Hide', 'bepro' ),
    ],
);
$fields[]= array(
    'type'        => 'switch',
	'settings'    => 'shop_pro_is_share',
	'label'       => esc_html__( 'Is Share?', 'bepro' ),
	'section'     => 'shop_product_setting',
	'default'     => '2',
	'choices'     => [
		'on'      => esc_html__( 'Show', 'bepro' ),
		'off'     => esc_html__( 'Hide', 'bepro' ),
	],
);
$fields[]= array(
    'type'        => 'multicheck',
    'settings'    => 'shop_pro_socials',
    'label'       => esc_html__( 'Select Social Media', 'bepro' ),
    'section'     => 'shop_product_setting',
    'default'     => array('1', '2', '3', '4'),
    'choices'     => [
            '1'   => esc_html__( 'Facebook', 'bepro' ),
            '2'   => esc_html__( 'Twitter', 'bepro' ),
            '3'   => esc_html__( 'Email', 'bepro' ),
            '4'   => esc_html__( 'LinkedIn', 'bepro' ),
            '5'   => esc_html__( 'Pinterest', 'bepro' ),
            '6'   => esc_html__( 'Whatsapp', 'bepro' ),
            '7'   => esc_html__( 'Digg', 'bepro' ),
            '8'   => esc_html__( 'Tumblr', 'bepro' ),
            '9'   => esc_html__( 'Reddit', 'bepro' ),
    ],
    'required'      => array( 
        array( 
            'setting'   => 'shop_pro_is_share',
            'operator'  => '==',
            'value'     => '1' 
        )
    ),
);
$fields[]= array(
    'type'        => 'switch',
    'settings'    => 'shop_pro_is_related',
    'label'       => esc_html__('Is Related Product?', 'bepro'),
    'section'     => 'shop_product_setting',
    'default'     => '2',
    'choices'     => array(
        'on'  => esc_html__('Show', 'bepro'),
        'off' => esc_html__('Hide', 'bepro'),
    ),
);
$fields[] = array(
    'type'          => 'text',
    'settings'      => 'shop_pro_related_sub_title',
    'label'         => esc_html__('Related Sub Title', 'bepro'),
    'section'       => 'shop_product_setting',
    'default'       => esc_html__('Bepro Products', 'bepro'),
    'required'      => array(
        array( 
            'setting'   => 'shop_pro_is_related',
            'operator'  => '==',
            'value'     => TRUE 
        )
    ),
);
$fields[] = array(
    'type'          => 'text',
	'settings'      => 'shop_pro_related_title',
	'label'         => esc_html__('Related Title', 'bepro'),
	'section'       => 'shop_product_setting',
	'default'       => esc_html__('Related Products', 'bepro'),
    'required'      => array(
        array( 
            'setting'   => 'shop_pro_is_related',
            'operator'  => '==',
            'value'     => TRUE 
        )
    ),
);
$fields[]= array(
    'type'        => 'switch',
    'settings'    => 'product_is_flashlabels',
    'label'       => esc_html__( 'Is Flash Lebels?', 'bepro' ),
    'section'     => 'shop_product_setting',
    'default'     => '2',
    'choices'     => [
        'on'     => esc_html__( 'Show', 'bepro' ),
        'off'    => esc_html__( 'Hide', 'bepro' ),
    ],
    'required'      => array(
        array( 
            'setting'   => 'shop_pro_is_related',
            'operator'  => '==',
            'value'     => TRUE 
        )
    ),
);
$fields[]= array(
    'type'        => 'switch',
    'settings'    => 'product_is_wishlist',
    'label'       => esc_html__( 'Is Wishlist?', 'bepro' ),
    'section'     => 'shop_product_setting',
    'default'     => '2',
    'choices'     => [
        'on'     => esc_html__( 'Show', 'bepro' ),
        'off'    => esc_html__( 'Hide', 'bepro' ),
    ],
    'required'      => array(
        array( 
            'setting'   => 'shop_pro_is_related',
            'operator'  => '==',
            'value'     => TRUE 
        )
    ),
);
$fields[] = array(
    'type'        => 'custom',
	'settings'    => 'product_custom_03',
	'label'       => FALSE,
	'section'     => 'shop_product_setting',
	'default'     => '<div class="customizer_label mt40">'.esc_html__('Blocks Settings', 'bepro').'</div>',
);
$fields[] = array(
    'type'          => 'repeater',
	'label'         => esc_html__( 'Add Blocks', 'bepro' ),
	'section'       => 'shop_product_setting',
	'settings'      => 'product_bloks',
	'row_label'     => [
		'type'      => 'text',
		'value'     => esc_html__('Block', 'bepro' ),
	],
	'button_label' => esc_html__('Add New Block', 'bepro' ),
	'default'      => [],
	'fields' => [
		'block_ids' => [
			'type'        => 'select',
                        'label'       => esc_html__( 'Block', 'bepro' ),
                        'default'     => 'none',
                        'choices'     => $all_bloks
		]
	]
);