<?php
$fields[] = array(
    'type'        => 'custom',
	'settings'    => 'folio_cat_custom_01',
	'label'       => FALSE,
	'section'     => 'folio_cat_settings',
	'default'     => '<div class="customizer_label">'.esc_html__('Folio Category Banner Settings', 'bepro').'</div>',
);
$fields[]= array(
    'type'        => 'switch',
	'settings'    => 'folio_cat_is_banner',
	'label'       => esc_html__( 'Is Banner?', 'bepro' ),
	'section'     => 'folio_cat_settings',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Enable ', 'bepro' ),
		'off'     => esc_html__( 'Disable ', 'bepro' ),
	],
);
$fields[] = array(
    'type'        => 'background',
	'settings'    => 'folio_cat_banner_bg',
	'label'       => esc_html__( 'Banner Background', 'bepro' ),
	'description' => esc_html__( 'Setup you folio cetegory page banner BG.', 'bepro' ),
	'section'     => 'folio_cat_settings',
	'default'     => [
		'background-color'      => '',
		'background-image'      => '',
		'background-repeat'     => 'no-repeat',
		'background-position'   => 'center center',
		'background-size'       => 'cover',
		'background-attachment' => 'scroll',
	],
    'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner.folio_cate_banner',
		]
	],
    'active_callback' => [
            [
                    'setting'  => 'folio_cat_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
	'type'        => 'color',
	'settings'    => 'folio_cat_banner_overlay_color',
	'label'       => esc_html__( 'Banner Overlay Color', 'bepro' ),
	'section'     => 'folio_cat_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.folio_cate_banner .overlay',
			'property' => 'background'
		],
	],
	'active_callback' => [
		[
				'setting'  => 'folio_cat_is_banner',
				'operator' => '==',
				'value'    => true,
		],
	],
);
$fields[] = array(
    'type'          => 'text',
	'settings'      => 'folio_cat_banner_title',
	'label'         => esc_html__('Banner Title', 'bepro'),
	'section'       => 'folio_cat_settings',
	'default'       => '',
    'transport'     => 'postMessage',
    'js_vars'       => array(
        array(
            'element'  => '.page_banner.folio_cate_banner .banner-title',
            'function' => 'html'
        ),
    ),
	'active_callback' => [
		[
				'setting'  => 'folio_cat_is_banner',
				'operator' => '==',
				'value'    => true,
		],
	],
);
$fields[]= array(
    'type'        => 'switch',
	'settings'    => 'folio_cat_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb?', 'bepro' ),
	'section'     => 'folio_cat_settings',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Show', 'bepro' ),
		'off'     => esc_html__( 'Hide', 'bepro' ),
	],
	'active_callback' => [
		[
				'setting'  => 'folio_cat_is_banner',
				'operator' => '==',
				'value'    => true,
		],
	],
);
$fields[]= array(
    'type'        => 'radio-buttonset',
	'settings'    => 'folio_cat_banner_alignment',
	'label'       => esc_html__( 'Choose your banner text alignment.', 'bepro' ),
	'section'     => 'folio_cat_settings',
	'default'     => 'center',
	'choices'     => [
		'left'   => esc_html__( 'Left', 'bepro' ),
		'center' => esc_html__( 'Center', 'bepro' ),
		'right'  => esc_html__( 'Right', 'bepro' ),
	],
	'active_callback' => [
		[
				'setting'  => 'folio_cat_is_banner',
				'operator' => '==',
				'value'    => true,
		],
	],
);
$fields[] = array(
    'type'        => 'custom',
	'settings'    => 'folio_cat_custom_02',
	'label'       => FALSE,
	'section'     => 'folio_cat_settings',
	'default'     => '<div class="customizer_label">'.esc_html__('Folio Content Settings', 'bepro').'</div>',
);
$fields[] = array(
    'type'        => 'select',
    'settings'    => 'folio_view_style',
    'label'       => esc_html__( 'Folio View Style', 'bepro' ),
    'section'     => 'folio_cat_settings',
    'default'     => '1',
    'choices'     => array(
            '1'     => esc_html__( 'Style 01', 'bepro' ),
            '2'     => esc_html__( 'Style 02', 'bepro' ),
            '3'     => esc_html__( 'Style 03', 'bepro' ),
            '4'     => esc_html__( 'Style 04', 'bepro' ),
            '5'     => esc_html__( 'Style 05', 'bepro' ),
            '6'     => esc_html__( 'Style 06', 'bepro' ),
            '7'     => esc_html__( 'Style 07', 'bepro' ),
    ),
);
$fields[]= array(
    'type'        => 'switch',
	'settings'    => 'folio_cat_is_pagination',
	'label'       => esc_html__( 'Is Pagination?', 'bepro' ),
	'section'     => 'folio_cat_settings',
	'default'     => '2',
	'choices'     => [
		'on'      => esc_html__( 'Show', 'bepro' ),
		'off'     => esc_html__( 'Hide', 'bepro' ),
	],
);
$fields[] = array(
    'type'        => 'slider',
	'settings'    => 'cate_paging_margin',
	'label'       => esc_html__( 'Pagination Gapping', 'bepro' ),
	'section'     => 'folio_cat_settings',
	'default'     => 30,
	'choices'     => [
		'min'  => 1,
		'max'  => 200,
		'step' => 1,
	],
    'transport'   => 'auto',
	'output'      => [
		[
			'element'  => '.folioCatePage .bepro_pagination',
            'property' => 'margin-top',
            'suffix'   => 'px'
		]       
	],
	'active_callback' => array(
        array(
            'setting' 	=> 'folio_cat_is_pagination',
            'operator'  => '==',
            'value' 	=> '1'
        )
    ),
);
$fields[] = array(
    'type'        => 'background',
	'settings'    => 'folio_cat_pagination_banner_bg',
	'label'       => esc_html__( 'Pagination Background', 'bepro' ),
	'description' => esc_html__( 'Setup you folio cetegory pagination bg.', 'bepro' ),
	'section'     => 'folio_cat_settings',
	'default'     => [
		'background-color'      => '',
		'background-image'      => '',
		'background-repeat'     => 'no-repeat',
		'background-position'   => 'center center',
		'background-size'       => 'cover',
		'background-attachment' => 'scroll',
	],
    'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.folioCatePage .bepro_pagination',
		]
	],
    'active_callback' => [
            [
                    'setting'  => 'folio_cat_is_pagination',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);