<?php
$bloks = array(
    'post_type'     => 'blocks',
    'post_status'   => 'publish',
    'posts_per_page'  => -1,
    'orderby'        => 'title',
    'order'          => 'ASC'
);
$all_bloks = array(
    'none' => esc_html__('None', 'bepro')
);
$blok = new WP_Query($bloks);
if($blok->have_posts()):
    while($blok->have_posts()):
    $blok->the_post();
    $all_bloks[get_the_ID()] = get_the_title();
    endwhile;
endif;
wp_reset_postdata();

$fields[] = array(
    'type'        => 'custom',
	'settings'    => 'blog_custom_01',
	'label'       => FALSE,
	'section'     => 'blog_settings',
	'default'     => '<div class="customizer_label">'.esc_html__('Banner Settings', 'bepro').'</div>',
);
$fields[]= array(
    'type'        => 'switch',
	'settings'    => 'blog_is_banner',
	'label'       => esc_html__( 'Is Banner?', 'bepro' ),
	'section'     => 'blog_settings',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Enable ', 'bepro' ),
		'off'     => esc_html__( 'Disable ', 'bepro' ),
	],
);
$fields[] = array(
    'type'        => 'background',
	'settings'    => 'blog_banner_bg',
	'label'       => esc_html__( 'Banner Background', 'bepro' ),
	'description' => esc_html__( 'Setup you blog page banner BG.', 'bepro' ),
	'section'     => 'blog_settings',
	'default'     => [
		'background-color'      => '',
		'background-image'      => '',
		'background-repeat'     => 'no-repeat',
		'background-position'   => 'center center',
		'background-size'       => 'cover',
		'background-attachment' => 'scroll',
	],
    'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner.blog_page_banner',
		]
	],
    'active_callback' => [
            [
                    'setting'  => 'blog_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
	'type'        => 'color',
	'settings'    => 'blog_banner_overlay_color',
	'label'       => esc_html__( 'Banner Overlay Color', 'bepro' ),
	'section'     => 'blog_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.blog_page_banner .overlay',
			'property' => 'background'
		],
	],
	'active_callback' => [
		[
				'setting'  => 'blog_is_banner',
				'operator' => '==',
				'value'    => true,
		],
	],
);
$fields[] = array(
    'type'          => 'text',
	'settings'      => 'blog_banner_title',
	'label'         => esc_html__('Banner Title', 'bepro'),
	'section'       => 'blog_settings',
	'default'       => esc_html__('Blog Page', 'bepro'),
    'transport'     => 'postMessage',
    'js_vars'       => array(
        array(
            'element'  => '.page_banner.blog_page_banner .banner-title',
            'function' => 'html'
        ),
    ),
    'active_callback' => [
            [
                    'setting'  => 'blog_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
    'type'        => 'switch',
	'settings'    => 'blog_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb?', 'bepro' ),
	'section'     => 'blog_settings',
	'default'     => '1',
	'choices'     => [
		'on'      => esc_html__( 'Show', 'bepro' ),
		'off'     => esc_html__( 'Hide', 'bepro' ),
	],
    'active_callback' => [
            [
                    'setting'  => 'blog_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);
$fields[]= array(
    'type'        => 'radio-buttonset',
	'settings'    => 'blog_banner_alignment',
	'label'       => esc_html__( 'Choose your banner text alignment.', 'bepro' ),
	'section'     => 'blog_settings',
	'default'     => 'center',
	'choices'     => [
		'left'   => esc_html__( 'Left', 'bepro' ),
		'center' => esc_html__( 'Center', 'bepro' ),
		'right'  => esc_html__( 'Right', 'bepro' ),
	],
    'active_callback' => [
            [
                    'setting'  => 'blog_is_banner',
                    'operator' => '==',
                    'value'    => true,
            ]
    ],
);

$fields[] = array(
    'type'        => 'custom',
	'settings'    => 'blog_custom_02',
	'label'       => FALSE,
	'section'     => 'blog_settings',
	'default'     => '<div class="customizer_label mt40">'.esc_html__('Content Settings', 'bepro').'</div>',
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'blog_sidebar',
        'label'       => esc_html__( 'Blog Sidebar Position', 'bepro' ),
        'section'     => 'blog_settings',
        'default'     => '3',
        'choices'     => array(
                '1'      => esc_html__('No Sidebar','bepro'),
                '2'      => esc_html__('Left Sidebar','bepro'),
                '3'      => esc_html__('Right Sidebar','bepro'),
        ),
        'active_callback' => [
	            [
	                    'setting'   => 'blog_view',
	                    'operator'  => 'in',
	                	'value'     => ['1', '4', '5', '6', '7']
	            ]
	    ],
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'blog_view',
        'label'       => esc_html__( 'Post View', 'bepro' ),
        'section'     => 'blog_settings',
        'default'     => '1',
        'choices'     => array(
                '1'     => esc_html__( 'Style 01', 'bepro' ),
                '2'     => esc_html__( 'Style 02', 'bepro' ),
                '3'     => esc_html__( 'Style 03', 'bepro' ),
                '4'     => esc_html__( 'Style 04', 'bepro' ),
                '5'     => esc_html__( 'Style 05', 'bepro' ),
                '6'     => esc_html__( 'Style 06', 'bepro' ),
                '7'     => esc_html__( 'Style 07', 'bepro' ),
        ),
);
$fields[] = array(
    'type'        => 'slider',
	'settings'    => 'blog_str_limit',
	'label'       => esc_html__( 'Excerpt Limit', 'bepro' ),
	'section'     => 'blog_settings',
	'default'     => 227,
	'choices'     => [
		'min'  => 0,
		'max'  => 1000,
		'step' => 1,
	],
	'active_callback' => [
            [
                    'setting'   => 'blog_view',
                    'operator'  => 'in',
                	'value'     => ['1', '2', '3', '6', '7']
            ]
    ],
);
$fields[] = array(
    'type'          => 'text',
	'settings'      => 'blog_readmore_label',
	'label'         => esc_html__('Button Label', 'bepro'),
	'section'       => 'blog_settings',
	'default'       => esc_html__('See More', 'bepro'),
	'active_callback' => [
            [
                    'setting'  => 'blog_view',
                    'operator'  => 'in',
                	'value'     => ['2', '3', '4']
            ]
    ],
);
$fields[] = array(
    'type'        => 'slider',
	'settings'    => 'blog_paging_margin',
	'label'       => esc_html__( 'Pagination Gapping', 'bepro' ),
	'section'     => 'blog_settings',
	'default'     => 35,
	'choices'     => [
		'min'  => 0,
		'max'  => 200,
		'step' => 1,
	],
    'transport'   => 'auto',
	'output'      => [
		[
			'element'  => '.blogPage .bepro_pagination',
            'property' => 'margin-top',
            'suffix'   => 'px'
		]       
	],
);
$fields[] = array(
    'type'        => 'background',
	'settings'    => 'blog_pagination_banner_bg',
	'label'       => esc_html__( 'Pagination Background', 'bepro' ),
	'description' => esc_html__( 'Setup you pagination background.', 'bepro' ),
	'section'     => 'blog_settings',
	'default'     => [
		'background-color'      => '',
		'background-image'      => '',
		'background-repeat'     => 'no-repeat',
		'background-position'   => 'center center',
		'background-size'       => 'cover',
		'background-attachment' => 'scroll',
	],
    'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.blogPage .bepro_pagination .pagination',
		]
	],
);

$fields[] = array(
    'type'        => 'custom',
	'settings'    => 'blog_custom_03',
	'label'       => FALSE,
	'section'     => 'blog_settings',
	'default'     => '<div class="customizer_label mt40">'.esc_html__('Blocks Settings', 'bepro').'</div>',
);
$fields[] = array(
    'type'              => 'repeater',
	'label'         => esc_html__( 'Add Blocks', 'bepro' ),
	'section'       => 'blog_settings',
	'settings'      => 'blog_bloks',
	'row_label'     => [
		'type'  => 'text',
		'value' => esc_html__('Block', 'bepro' ),
	],
	'button_label'  => esc_html__('Add New Block', 'bepro' ),
	'default'       => [],
	'fields'        => [
		'block_ids' => [
			'type'        => 'select',
                        'label'       => esc_html__( 'Block', 'bepro' ),
                        'default'     => 'none',
                        'choices'     => $all_bloks
		]
	]
);