<?php
/*-----------------------------------------------------------------------------------*/
/*	Instagram  Widget Class
/*-----------------------------------------------------------------------------------*/

class Tw_Instagram_Widgets extends WP_Widget {

	var $defaults;

	function __construct() {
		$widget_ops = array( 'classname' => 'bp_insta_widgets', 'description' => esc_html__( 'Instagram Image.', 'themewar' ) );
		$control_ops = array( 'id_base'  => 'bp_instagram_widgets' );
		parent::__construct( 'bp_instagram_widgets', esc_html__( 'Bepro Instagram', 'themewar' ), $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {

		$instance = wp_parse_args( (array) $instance, $this->defaults );
		extract( $args );

		$title      = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__('Instagram', 'themewar');
        $ins_url    = (isset($instance['ins_url']) && $instance['ins_url'] != '') ? $instance['ins_url'] : 'https://www.instagram.com/';
        $gallery_images = (isset($instance['gallery_images']) && $instance['gallery_images'] != '') ? explode(',', $instance['gallery_images']) : array();

		echo wp_kses_post($before_widget);
		if ( ! empty( $title ) ) {
            echo wp_kses_post($before_title) . esc_html($title) . $after_title;
		}
        ?>
        <div class="galleryShots clearfix">
            <?php if(!empty($gallery_images)): ?>
                <?php foreach($gallery_images as $gi): ?>
                    <a target="_blank" href="<?php echo esc_url($ins_url); ?>">
                        <img src="<?php echo bepro_attachment_url($gi, 130, 114) ?>" alt="<?php echo esc_attr__('instagram', 'themewar'); ?>">
                    </a>
                <?php endforeach; ?>
            <?php else: ?>
            <div class="alert alert-warning">
                <?php echo wp_kses_post('Please Navigate <strong>Appearance -> Widgets</strong> and upload images for gallery.'); ?>
            </div>
            <?php endif; ?>
        </div>
        <?php
		echo wp_kses_post($after_widget);
	}

	function update( $new_instance, $old_instance ) {
                return $new_instance;
	}


	function form( $instance ) {
		$title      = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__('Instagram', 'themewar');
        $ins_url    = (isset($instance['ins_url']) && $instance['ins_url'] != '') ? $instance['ins_url'] : 'https://www.instagram.com/';

        $gallery_images = (isset($instance['gallery_images']) && $instance['gallery_images'] != '') ? explode(',', $instance['gallery_images']) : array();
    ?>

	<p>
        <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html__( 'Title:', 'themewar' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
    </p>
	<p>
        <div class="gallery_holders <?php echo (!empty($gallery_images) ? 'show' : ''); ?>">
            <?php
                if(!empty($gallery_images)):
                    foreach($gallery_images as $gi):
                        echo '<img src="' . bepro_attachment_url($gi, 130, 114). '" alt="">';
                    endforeach;
                endif;
            ?>
        </div>
        <button type="button" class="button button-default upload_gallery_images"><?php echo esc_html__('Upload Images', 'themewar') ?></button>
        <input type="hidden" class="gallery_images" value="<?php echo esc_attr(implode(',', $gallery_images)); ?>" name="<?php echo esc_attr($this->get_field_name( 'gallery_images' )); ?>" id="<?php echo esc_attr($this->get_field_id( 'gallery_images' )); ?>"/>
        <button type="button" class="button button-default clear_gallery_images"><?php echo esc_html__('Clear Images', 'themewar') ?></button>
	</p>
	<p>
        <label for="<?php echo esc_attr($this->get_field_id( 'ins_url' )); ?>"><?php esc_html__( 'Instagram url:', 'themewar' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'ins_url' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'ins_url' )); ?>" type="text" value="<?php echo esc_attr( $ins_url ); ?>" />
    </p>	
	<?php
	}
}
