<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Services_Widget extends Widget_Base {
    public function get_name() {
        return 'tw-services';
    }
    public function get_title() {
        return esc_html__('Services', 'themewar');
    }
    public function get_icon() {
        return 'eicon-slider-full-screen';
    }
    public function get_categories() {
        return ['bepro-elements'];
    }
    
    protected function register_controls() {
        
        $serv = array(
            'post_type'         => 'service',
            'post_status'       => 'publish',
            'order_by'          => 'date',
            'order'             => 'DESC',
            'posts_per_page'    => -1
        );
        $servs = array();
        query_posts($serv);
            if(have_posts()):
                while (have_posts()):
                    the_post();
                    $servs[get_the_ID()] = get_the_title();
                endwhile;
            endif;
        wp_reset_query();
        
        $this->start_controls_section(
            'section_tab', [
                'label'         => esc_html__( 'Service Settings', 'themewar' ),
            ]
        );
        $this->add_control(
                'serv_style',
                [
                        'label'     => esc_html__( 'View Mode Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Grid View', 'themewar' ),
                                2       => esc_html__( 'Slide View', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'view_style',
                [
                        'label'     => esc_html__( 'View Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Style 01', 'themewar' ),
                                2       => esc_html__( 'Style 02', 'themewar' ),
                                3       => esc_html__( 'Style 03', 'themewar' ),
                                4       => esc_html__( 'Style 04', 'themewar' ),
                                5       => esc_html__( 'Style 05', 'themewar' ),
                                6       => esc_html__( 'Style 06', 'themewar' ),
                                7       => esc_html__( 'Style 07', 'themewar' ),
                                8       => esc_html__( 'Style 08', 'themewar' ),
                                9       => esc_html__( 'Style 09', 'themewar' ),
                                10      => esc_html__( 'Style 10', 'themewar' ),
                                11      => esc_html__( 'Style 11', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'grid_xl_col',
                [
                        'label'     => esc_html__( 'Select XL Col', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 2,
                        'options'   => [
                                1       => esc_html__( 'Col-Xl-3', 'themewar' ),
                                2       => esc_html__( 'Col-Xl-4', 'themewar' ),
                                3       => esc_html__( 'Col-Xl-6', 'themewar' ),
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'serv_style',
                                        'operator'  => '!in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'grid_lg_col',
                [
                        'label'     => esc_html__( 'Select LG Col', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 2,
                        'options'   => [
                                1       => esc_html__( 'Col-Lg-3', 'themewar' ),
                                2       => esc_html__( 'Col-Lg-4', 'themewar' ),
                                3       => esc_html__( 'Col-Lg-6', 'themewar' ),
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'serv_style',
                                        'operator'  => '!in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'grid_md_col',
                [
                        'label'     => esc_html__( 'Select MD Col', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 2,
                        'options'   => [
                                1       => esc_html__( 'Col-Md-4', 'themewar' ),
                                2       => esc_html__( 'Col-Md-6', 'themewar' ),
                                3       => esc_html__( 'Col-Md-12', 'themewar' ),
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'serv_style',
                                        'operator'  => '!in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'serv_specific',
                [
                        'label'         => esc_html__( 'Specific Services', 'themewar' ),
                        'type'          => Controls_Manager::SELECT2,
                        'label_block'   => TRUE,
                        'multiple'      => true,
                        'default'       => array('0'),
                        'options'       => $servs,
                ]
        );
        $this->add_control(
                'serv_post_item',
                [
                        'label'         => esc_html__( 'Number Of Item', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'min'           => 1,
                        'max'           => 500,
                        'step'          => 1,
                        'default'       => 3,
                        'description'   => esc_html__( 'How many item you want to show.', 'themewar' ),
                ]
        );
        $this->add_control(
                'serv_order_by',
                [
                        'label' => esc_html__( 'Order By', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 'date',
                        'options' => [
                                'date'                  => esc_html__( 'Date', 'themewar' ),
                                'title'                 => esc_html__( 'Title', 'themewar' ),
                                'rand'                  => esc_html__( 'Random', 'themewar' )
                        ],
                ]
        );
        $this->add_control(
                'serv_order',
                [
                        'label' => esc_html__( 'Order', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 'desc',
                        'options' => [
                                'asc'        => esc_html__( 'Ascending', 'themewar' ),
                                'desc'       => esc_html__( 'Descending', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'serv_strlimit',
                [
                        'label'         => esc_html__( 'Content Limit', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'min'           => 0,
                        'max'           => 10000,
                        'step'          => 1,
                        'default'       => 97,
                        'description'   => esc_html__( 'Setup your item description text limit.', 'themewar' ),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'view_style',
                                        'operator'  => 'in',
                                        'value'     => ['2', '4', '5', '6', '7', '9', '10'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'is_read_more',
                [
                        'label'             => esc_html__( 'Is Read More Btn?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show read more btn?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                        'conditions'        => [
                                'terms'     => [
                                    [
                                            'name'      => 'view_style',
                                            'operator'  => 'in',
                                            'value'     => ['7', '8', '9', '10', '11'],
                                    ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'rm_label',
                [
                        'label'         => esc_html__( 'Read More Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('Read More', 'themewar'),
                        'conditions'        => [
                                'terms'     => [
                                    [
                                            'name'      => 'view_style',
                                            'operator'  => 'in',
                                            'value'     => ['8', '9', '11'],
                                    ],
                                    [
                                            'name'      => 'is_read_more',
                                            'operator'  => '==',
                                            'value'     => 'yes',
                                    ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'lb_slide_autoplay',
                [
                        'label'             => esc_html__( 'Is Autoplay?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to make this slider auto play?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'yes',
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'serv_style',
                                        'operator'  => 'in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'lb_slide_loop',
                [
                        'label'             => esc_html__( 'Is Loop?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to make this slider item loop?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'yes',
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'serv_style',
                                        'operator'  => 'in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'lb_slide_nav',
                [
                        'label'             => esc_html__( 'Is Nav?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show slider arrow navigation?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'serv_style',
                                        'operator'  => 'in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'lb_slide_dots',
                [
                        'label'             => esc_html__( 'Is Dots?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to show slider bullets item?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'serv_style',
                                        'operator'  => 'in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control( 'tw_item_per_row_1', [
                'label' => esc_html__('Items XL Device', 'themewar'),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__('How many item you want to show per row on Extra Large Screen?', 'themewar'),
                'default' => '3',
                'multiple' => false,
                'options' => [
                    2 => esc_html__('2 Items', 'themewar'),
                    3 => esc_html__('3 Items', 'themewar'),
                    4 => esc_html__('4 Items', 'themewar'),
                    6 => esc_html__('6 Items', 'themewar'),
                ],
                'conditions'    => [
                    'terms' => [
                        [
                                'name'      => 'serv_style',
                                'operator'  => 'in',
                                'value'     => ['2'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_control( 'tw_item_per_row_2', [
                'label' => esc_html__('Items LG Device', 'themewar'),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__('How many item you want to show per row on Large Screen?', 'themewar'),
                'default' => '3',
                'multiple' => false,
                'options' => [
                    2 => esc_html__('2 Items', 'themewar'),
                    3 => esc_html__('3 Items', 'themewar'),
                    4 => esc_html__('4 Items', 'themewar')
                ],
                'conditions'    => [
                    'terms' => [
                        [
                                'name'      => 'serv_style',
                                'operator'  => 'in',
                                'value'     => ['2'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_control( 'tw_item_per_row_3', [
                'label' => esc_html__('Items MD Device', 'themewar'),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__('How many item you want to show per row on Medium Screen?', 'themewar'),
                'default' => '2',
                'multiple' => false,
                'options' => [
                    1 => esc_html__('1 Items', 'themewar'),
                    2 => esc_html__('2 Items', 'themewar'),
                    3 => esc_html__('3 Items', 'themewar'),
                    4 => esc_html__('4 Items', 'themewar')
                ],
                'conditions'    => [
                    'terms' => [
                        [
                                'name'      => 'serv_style',
                                'operator'  => 'in',
                                'value'     => ['2'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_control(
                'tw_gapping',
                [
                        'label' => esc_html__( 'Items Gapping', 'themewar' ),
                        'type' => Controls_Manager::NUMBER,
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                        'default' => 0,
                        'description'   => esc_html__('Insert items gapping if you want.', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'serv_style',
                                        'operator'  => 'in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_sliderArea', [
                    'label'         => esc_html__('Slider Area Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'serv_style',
                                    'operator'  => 'in',
                                    'value'     => ['2'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'sl_area_box_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .serviceSlider_wrap .owl-carousel' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'sl_area_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .serviceSlider_wrap .owl-carousel' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'sl_area_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .serviceSlider_wrap .owl-carousel' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'sl_area_box_bg_hr',
                        'label' => esc_html__( 'Box Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'sl_area_box_shadow_hr',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel',
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'sl_area_box_hr',
                        'label' => esc_html__( 'Box Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel',
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_bg_svg', [
                    'label'         => esc_html__('Box BG Svg Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'view_style',
                                    'operator'  => '==',
                                    'value'     =>  '5',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_svg_bg',[
                        'label'     => esc_html__( 'BG Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .service_item_05 svg g' => 'fill: {{VALUE}}',
                        ]
                ]
        );
        $this->add_group_control(
                Group_Control_Css_Filter::get_type(),
                [
                        'name'      => 'box_bg_svg_filter',
                        'label'     => esc_html__( 'BG Shadow', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .service_item_05 svg',
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_1', [
                    'label'         => esc_html__('Box Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
                'icon_box_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cmserItem' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .service_item_07' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmserItem' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .service_item_07' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .serInner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmserItem' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .service_item_07' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'ib_box_tot' );
            $this->start_controls_tab(
                'ib_box_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'icon_box_bg',
                                'label' => esc_html__( 'Box Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .cmserItem, {{WRAPPER}} .service_item_07',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'icon_box_shadow',
                                'label' => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .cmserItem, {{WRAPPER}} .service_item_07',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'box_border',
                                'label' => esc_html__( 'Box Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .cmserItem, {{WRAPPER}} .service_item_07',
                        ]
                );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_box_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_bg_hr',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .cmserItem:hover, {{WRAPPER}} .service_item_07:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_shadow_hr',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .cmserItem:hover, {{WRAPPER}} .service_item_07:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'box_border_hr',
                            'label' => esc_html__( 'Box Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .cmserItem:hover, {{WRAPPER}} .service_item_07:hover',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
                'icon_box_hover_all_con_color',[
                        'label'     => esc_html__( 'Hover All Content Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmserItem:hover *' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .service_item_07:hover *' => 'color: {{VALUE}}',
                        ]
                ]
        );
        $this->add_control(
                'heading_box_gradian',
                [
                    'label'     => esc_html__( 'Hover After Box Shadow', 'themewar' ),
                    'type'      => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'view_style',
                                    'operator'  => 'in',
                                    'value'     =>  ['7'],
                            ]
                        ],
                    ],
                ]
            );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_shadow02_hr',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .service_item_07:after',
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'view_style',
                                        'operator'  => 'in',
                                        'value'     =>  ['7'],
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_2',[
                    'label'         => esc_html__('Service Meta Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_i_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ibMeta'
                ]
        );
        $this->start_controls_tabs( 'ib_icon_tot' );
            $this->start_controls_tab(
                'ib_icon_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
            $this->add_responsive_control(
                    'icon_box_i_color',[
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta' => 'color: {{VALUE}}',
                            ],
                            'conditions'    => [
                                'terms'     => [
                                    [
                                            'name'      => 'view_style',
                                            'operator'  => '!in',
                                            'value'     =>  ['5'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_control(
                'heading_gradian',
                [
                    'label'     => esc_html__( 'Icon Gradian Color', 'themewar' ),
                    'type'      => Controls_Manager::HEADING,
                    'separator' => 'after',
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'view_style',
                                    'operator'  => 'in',
                                    'value'     =>  ['5'],
                            ]
                        ],
                    ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'ser_gr_icon_color',
                            'label' => esc_html__( 'Gradian Color', 'themewar' ),
                            'types' => ['gradient'],
                            'selector' => '{{WRAPPER}} .service_item_05 .siIcon i',
                            'conditions'    => [
                                'terms'     => [
                                    [
                                            'name'      => 'view_style',
                                            'operator'  => 'in',
                                            'value'     =>  ['5'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'icon_box_i_bgcolor',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .ibMeta'
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_i_bgsvgcolor',[
                            'label'     => esc_html__( 'Icon BG SVG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta svg' => 'fill: {{VALUE}}',
                            ],
                            'conditions'    => [
                                'terms'     => [
                                    [
                                            'name'      => 'view_style',
                                            'operator'  => 'in',
                                            'value'     => ['2', '4'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_icon_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_control(
                    'icon_box_i_color_hr',[
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .cmserItem:hover .ibMeta' => 'color: {{VALUE}}',
                            ],
                            'conditions'    => [
                                'terms'     => [
                                    [
                                            'name'      => 'view_style',
                                            'operator'  => '!in',
                                            'value'     =>  ['5'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_control(
                'heading_hover_gradian',
                [
                    'label'     => esc_html__( 'Icon Gradian Color', 'themewar' ),
                    'type'      => Controls_Manager::HEADING,
                    'separator' => 'after',
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'view_style',
                                    'operator'  => 'in',
                                    'value'     =>  ['5'],
                            ]
                        ],
                    ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'ser_hover_gr_icon_color',
                            'label' => esc_html__( 'Gradian Color', 'themewar' ),
                            'types' => ['gradient'],
                            'selector' => '{{WRAPPER}} .service_item_05:hover .siIcon i',
                            'conditions'    => [
                                'terms'     => [
                                    [
                                            'name'      => 'view_style',
                                            'operator'  => 'in',
                                            'value'     =>  ['5'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'icon_box_i_bgcolor_hr',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .cmserItem:hover .ibMeta, {{WRAPPER}} .service_item_07:hover .ibImg'
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_i_hover_bgsvgcolor',[
                            'label'     => esc_html__( 'Icon BG SVG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .cmIconBxstyle:hover .ibMeta svg' => 'fill: {{VALUE}}',
                                '{{WRAPPER}} .service_item_09:hover .ibMeta svg g' => 'fill: {{VALUE}}',
                            ],
                            'conditions'    => [
                                'terms'     => [
                                    [
                                            'name'      => 'view_style',
                                            'operator'  => 'in',
                                            'value'     => ['2', '4', '8'],
                                    ]
                                ],
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
                'icon_box_i_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ibMeta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_responsive_control(
                    'icon_box_i_width',
                    [
                            'label' => __( 'Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_i_height',
                    [
                            'label' => __( 'Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ibMeta' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'icon_box_i_border_hr',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ibMeta, {{WRAPPER}} .icon_box_04:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_i__shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ibMeta',
                    ]
            );
            $this->add_control(
                    'icon_box_i_padding',
                    [
                            'label' => esc_html__( 'Paddings', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .ibMeta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
            $this->add_control(
                    'icon_box_i_margin',
                    [
                            'label' => esc_html__( 'Margins', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                    '{{WRAPPER}} .ibMeta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_box_img',[
                    'label'         => esc_html__('Featured Image Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'view_style',
                                    'operator'  => '!in',
                                    'value'     => ['2', '4', '5', '7', '9', '10'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'image_overlay_bg',[
                        'label'     => esc_html__( 'Hover Overlay Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .service_item_11:after' => 'background: {{VALUE}}',
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'view_style',
                                        'operator'  => 'in',
                                        'value'     => ['11'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'image_area_border',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .service_item_06 .ibMeta:before',
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'view_style',
                                        'operator'  => 'in',
                                        'value'     =>  ['6'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_width',
                [
                        'label' => esc_html__( 'Image Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .cmserItem img' => 'max-width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_height',
                [
                        'label' => esc_html__( 'Image Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .cmserItem img' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_fimg_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .cmserItem img',
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmserItem img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .service_item_06 .ibMeta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .service_item_06 .ibMeta:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->add_responsive_control(
                'icon_box_fimg_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .cmserItem img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_5',[
                    'label'         => esc_html__('Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_control(
                'icon_box_title_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmserItem h3' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .service_item_07 h3' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
                'icon_box_bg_title_color',[
                        'label'     => esc_html__( 'BG Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmserItem h3' => 'background: {{VALUE}}',
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'view_style',
                                        'operator'  => 'in',
                                        'value'     =>  ['11'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'heading_title_gradian',
                [
                    'label'     => esc_html__( 'Title Hover Gradian Color', 'themewar' ),
                    'type'      => Controls_Manager::HEADING,
                    'separator' => 'after',
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'view_style',
                                    'operator'  => 'in',
                                    'value'     =>  ['5'],
                            ]
                        ],
                    ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'ser_title_hover_color',
                            'label' => esc_html__( 'Gradian Color', 'themewar' ),
                            'types' => ['gradient'],
                            'selector' => '{{WRAPPER}} .service_item_05 h3 a:hover',
                            'conditions'    => [
                                'terms'     => [
                                    [
                                            'name'      => 'view_style',
                                            'operator'  => 'in',
                                            'value'     =>  ['5'],
                                    ]
                                ],
                            ],
                    ]
            );
        $this->add_control(
                'icon_box_hover_title_color',[
                        'label'     => esc_html__( 'Hover Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmserItem h3 a:hover' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .service_item_07 h3 a:hover' => 'color: {{VALUE}}',
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'view_style',
                                        'operator'  => '!in',
                                        'value'     =>  ['5'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_title_typo',
                        'label'     => esc_html__( 'Title Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmserItem h3, {{WRAPPER}} .service_item_07 h3',
                ]
        );
        $this->add_control(
                'icon_box_title_margin',
                [
                        'label'      => esc_html__( 'Title Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmserItem h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .service_item_07 h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_6', [
                    'label'         => esc_html__('Sub Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'view_style',
                                    'operator'  => 'in',
                                    'value'     => ['1', '3', '7'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_control(
                'icon_box_content_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .cmserItem p' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .service_item_07 h5' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_content_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmserItem p, {{WRAPPER}} .service_item_07 h5',
                ]
        );
        $this->add_control(
                'icon_box_content_margin',
                [
                        'label'      => esc_html__( 'Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmserItem p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .service_item_07 h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_7', [
                    'label'         => esc_html__('Description Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'view_style',
                                    'operator'  => 'in',
                                    'value'     => ['2', '4', '5', '6', '7', '9', '10'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_control(
                'icon_box_desc_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmserItem p' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .service_item_07 p' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_desc_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmserItem p, {{WRAPPER}} .service_item_07 p',
                ]
        );
        $this->add_control(
                'icon_box_desc_margin',
                [
                        'label'      => esc_html__( 'Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmserItem p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .service_item_07 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_rmbtn', [
                    'label'             => esc_html__('Read More Btn Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'view_style',
                                    'operator'  => 'in',
                                    'value'     => ['7', '8', '9', '10', '11'],
                            ],
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'rmbtn_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .srm, {{WRAPPER}} .berpo_btn.with_icon04'
                ]
        );
        $this->add_control(
                'rmbtn_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .srm' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .berpo_btn.with_icon04' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'rmbtn_styling_tab' );
            $this->start_controls_tab(
                    'rmbtn_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'rmbtn_nav_color',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .srm' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .berpo_btn.with_icon04' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'rmbtn_bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .srm, {{WRAPPER}} .berpo_btn.with_icon04'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'rmbtn_bg_shadow',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .srm, {{WRAPPER}} .berpo_btn.with_icon04'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'rmbtn_bg_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .srm, {{WRAPPER}} .berpo_btn.with_icon04'
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'rmbtn_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'rmbtn_color_hover',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .srm:hover' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .berpo_btn.with_icon04:hover' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'rmbtn_bg_hover',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .srm:hover, {{WRAPPER}} .berpo_btn.with_icon04 .bp-shape'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'rmbtn_bg_shadow_hover',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .srm:hover, {{WRAPPER}} .berpo_btn.with_icon04:hover'
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'rmbtn_bg_border_hover',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .srm:hover, {{WRAPPER}} .berpo_btn.with_icon04:hover'
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                'rmbtn_margin',
                [
                        'label'      => esc_html__( 'Margins', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .srm' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .berpo_btn.with_icon04' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_nav', [
                    'label'             => esc_html__('Nav Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'view_style',
                                    'operator'  => '!in',
                                    'value'     => ['4'],
                            ],
                            [
                                    'name'      => 'lb_slide_nav',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'nav_i_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-nav button'
                ]
        );
        $this->add_control(
                'bl_nav_radius',
                [
                        'label' => esc_html__( 'Nav  Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-nav button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->start_controls_tabs( 'nav_styling_tab' );
            $this->start_controls_tab(
                    'nav_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_color',
                    [
                            'label' => esc_html__( 'Nav Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-nav button' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'bl_nav_bg',
                        'label' => esc_html__( 'Nav Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-nav button',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'bl_nav_bg_shadow',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-nav button',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'bl_nav_bg_border',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-nav button',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'nav_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_color_hover',
                    [
                            'label' => esc_html__( 'Nav Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-nav button:hover' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'bl_nav_bg_hover',
                        'label' => esc_html__( 'Nav Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-nav button:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'bl_nav_bg_shadow_hover',
                            'label' => esc_html__( 'Boxs Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-nav button:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'bl_nav_bg_border_hover',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-nav button:hover',
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'left_nav_margin',
                    [
                            'label'      => esc_html__( 'Left Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-nav button.owl-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'right_nav_margin',
                    [
                            'label'      => esc_html__( 'Right Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-nav button.owl-next' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_svg_nav', [
                    'label'             => esc_html__('Nav Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms'     => [
                            [
                                    'name'      => 'view_style',
                                    'operator'  => 'in',
                                    'value'     => ['4'],
                            ],
                            [
                                    'name'      => 'lb_slide_nav',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'nav_svg_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .serviceSlider_wrap .serArrows a'
                ]
        );
        $this->start_controls_tabs( 'nav_svg_styling_tab' );
            $this->start_controls_tab(
                    'nav_svg_styling_tab_normal',
                    [
                            'label' => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_color',
                    [
                            'label' => esc_html__( 'Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .serviceSlider_wrap .serArrows a' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_bg_color',
                    [
                            'label' => esc_html__( 'BG Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .serviceSlider_wrap .serArrows a svg path' => 'fill: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Css_Filter::get_type(),
                    [
                            'name'      => 'box_svg_filter',
                            'label'     => esc_html__( 'BG Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .serviceSlider_wrap .serArrows a svg',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'nav_svg_styling_tab_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_color_hover',
                    [
                            'label' => esc_html__( 'Nav Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .serviceSlider_wrap .serArrows a:hover' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_nav_svg_hover_bg_color',
                    [
                            'label' => esc_html__( 'BG Color', 'themewar' ),
                            'type'  => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .serviceSlider_wrap .serArrows a:hover svg path' => 'fill: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Css_Filter::get_type(),
                    [
                            'name'      => 'box_hover_svg_filter',
                            'label'     => esc_html__( 'BG Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .serviceSlider_wrap .serArrows a:hover svg',
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'left_svg_nav_margin',
                    [
                            'label'      => esc_html__( 'Left Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .serviceSlider_wrap .serArrows a.prevArrow' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'right_svg_nav_margin',
                    [
                            'label'      => esc_html__( 'Right Margin', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .serviceSlider_wrap .serArrows a.nextArrow' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_04', [
                    'label'             => esc_html__('Dots Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'condition'         => ['lb_slide_dots' => 'yes']
                ]
        );
            $this->add_responsive_control(
                    'dots_width',
                    [
                            'label' => esc_html__( 'Dots Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 50,
                                            'step' => 1,
                                    ]
                            ],
                            'default' => [
                                    'unit' => 'px',
                                    'size' => '',
                            ],
                            'selectors' => [
                                    '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button' => 'width: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'dots_height',
                    [
                            'label' => esc_html__( 'Dots Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 50,
                                            'step' => 1,
                                    ]
                            ],
                            'default' => [
                                    'unit' => 'px',
                                    'size' => '',
                            ],
                            'selectors' => [
                                    '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button' => 'height: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
            $this->start_controls_tabs( 'dot_styling_tab' );
                $this->start_controls_tab(
                        'dot_styling_tab_normal',
                        [
                                'label' => esc_html__( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'bl_dot_bg',
                            'label' => esc_html__( 'Nav Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'bl_dot_shadow',
                                'label' => esc_html__( 'Dots Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'bl_dot_bg_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button',
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'dot_styling_tab_hover',
                        [
                                'label' => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'bl_dot_hover_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button:hover, {{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button.active',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'bl_dot_hover_shadow',
                                'label' => esc_html__( 'Dots Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button:hover, {{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button.active',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'bl_dot_hover_border',
                                'label' => esc_html__( 'Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button:after',
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'bl_dot_radius',
                    [
                            'label' => esc_html__( 'Dots  Radius', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_dot_margin',
                    [
                            'label' => esc_html__( 'Dots  Gapping', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'bl_dots_margin',
                    [
                            'label' => esc_html__( 'Dot Area Margins', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .serviceSlider_wrap .owl-carousel .owl-dots' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings           = $this->get_settings_for_display();
        $serv_style         = (isset($settings['serv_style']) && $settings['serv_style'] !='') ? $settings['serv_style'] : 1;
        $view_style         = (isset($settings['view_style']) && $settings['view_style'] !='') ? $settings['view_style'] : 1;
        
        $grid_xl_col        = (isset($settings['grid_xl_col']) && $settings['grid_xl_col'] > 0) ? $settings['grid_xl_col'] : 2;
        $grid_lg_col        = (isset($settings['grid_lg_col']) && $settings['grid_lg_col'] > 0) ? $settings['grid_lg_col'] : 2;
        $grid_md_col        = (isset($settings['grid_md_col']) && $settings['grid_md_col'] > 0) ? $settings['grid_md_col'] : 2;
        $serv_specific      = (isset($settings['serv_specific']) && !empty($settings['serv_specific'])? $settings['serv_specific'] : array());
        
        $serv_post_item     = (isset($settings['serv_post_item']) && $settings['serv_post_item'] > 0 ) ? $settings['serv_post_item'] : 4;
        $serv_order_by      = (isset($settings['serv_order_by']) && $settings['serv_order_by'] != '' ) ? $settings['serv_order_by'] : 'date';
        $serv_order         = (isset($settings['serv_order']) && $settings['serv_order'] != '' ) ? $settings['serv_order'] : 'desc';

        $serv_strlimit      = (isset($settings['serv_strlimit']) && $settings['serv_strlimit'] > 0 ) ? $settings['serv_strlimit'] : 97;

        $autoplay           = (isset($settings['lb_slide_autoplay']) && $settings['lb_slide_autoplay'] != '') ? $settings['lb_slide_autoplay'] : 'yes';
        $loop               = (isset($settings['lb_slide_loop']) && $settings['lb_slide_loop'] != '') ? $settings['lb_slide_loop'] : 'yes';
        $nav                = (isset($settings['lb_slide_nav']) && $settings['lb_slide_nav'] != '') ? $settings['lb_slide_nav'] : 'no';
        $dots               = (isset($settings['lb_slide_dots']) && $settings['lb_slide_dots'] != '') ? $settings['lb_slide_dots'] : 'no';

        $tw_item_per_row_1 = (isset($settings['tw_item_per_row_1']) && $settings['tw_item_per_row_1'] > 0 ? $settings['tw_item_per_row_1'] : 3);
        $tw_item_per_row_2 = (isset($settings['tw_item_per_row_2']) && $settings['tw_item_per_row_2'] > 0 ? $settings['tw_item_per_row_2'] : 3);
        $tw_item_per_row_3 = (isset($settings['tw_item_per_row_3']) && $settings['tw_item_per_row_3'] > 0 ? $settings['tw_item_per_row_3'] : 2);
        $tw_gapping        = (isset($settings['tw_gapping']) && $settings['tw_gapping'] != '' ? $settings['tw_gapping'] : 0);

        $is_read_more      = (isset($settings['is_read_more']) && $settings['is_read_more'] != '' ? $settings['is_read_more'] : 'no');
        $rm_label          = (isset($settings['rm_label']) && $settings['rm_label'] != '') ? $settings['rm_label'] : '';
        
        if($grid_xl_col == 1):
            $xl = 'col-xl-3 ';
        elseif($grid_xl_col == 3):
            $xl = 'col-xl-6 ';
        else:
            $xl = 'col-xl-4 ';
        endif;

        if($grid_lg_col == 1):
            $lg = 'col-lg-3';
        elseif($grid_lg_col == 3):
            $lg = 'col-lg-6';
        else:
            $lg = 'col-lg-4';
        endif;

        if($grid_md_col == 1):
            $md = ' col-md-4';
        elseif($grid_md_col == 3):
            $md = ' col-md-12';
        else:
            $md = ' col-md-6';
        endif;
        
        include dirname(__FILE__).'/style/services/style'.$view_style.'.php';
    }
    
    protected function content_template() {
        
    }
}