<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Sec_Title_Widget extends Widget_Base {
    
    public function get_name() {
        return 'tw-sec-title';
    }

    public function get_title() {
        return esc_html__('Section Title', 'themewar');
    }

    public function get_icon() {
        return 'eicon-site-title';
    }

    public function get_categories() {
        return ['bepro-elements'];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label'         => esc_html__( 'Section Title', 'themewar' ),
            ]
        );
        $this->add_control(
                'sub_text', [
                    'label'             => esc_html__('Sub Title Text', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'label_block'       => TRUE,
                    'default'           => esc_html__('Add Sub Title', 'themewar')
                ]
        );
        $this->add_control(
                'sub_text_tag',
                [
                        'label' => esc_html__( 'Sub Title Tag', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'description'   => esc_html__('Select HTML tag that you want to use.', 'themewar'),
                        'default' => '7',
                        'options' => [
                                '1' => esc_html__( 'H1', 'themewar' ),
                                '2' => esc_html__( 'H2', 'themewar' ),
                                '3' => esc_html__( 'H3', 'themewar' ),
                                '4' => esc_html__( 'H4', 'themewar' ),
                                '5' => esc_html__( 'H5', 'themewar' ),
                                '6' => esc_html__( 'H6', 'themewar' ),
                                '7' => esc_html__( 'DIV', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'icons',
                [
                        'label'         => esc_html__( 'Sub Title Icon', 'themewar' ),
                        'type'          => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                ]
        );
        $this->add_control(
                'icon_postition',
                [
                        'label'   => esc_html__( 'Icon Position', 'themewar' ),
                        'type'    => Controls_Manager::SELECT,
                        'default' => 'in_left',
                        'options' => [
                                'in_left'        => esc_html__( 'Left', 'themewar' ),
                                'in_right'       => esc_html__( 'Right', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'is_gradian',
                [
                        'label'             => esc_html__( 'Is Sub Title Gradian Color?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to make this this sub title gradina color?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                ]
        );
        $this->add_control(
                'title_text', [
                    'label'             => esc_html__('Main Title Text', 'themewar'),
                    'type'              => Controls_Manager::TEXTAREA,
                    'label_block'       => TRUE,
                    'description'       => esc_html__('Use {} for Different color.', 'themewar'),
                    'default'           => esc_html__('Add Main {Title}', 'themewar')
                ]
        );
        $this->add_control(
                'heading_tag',
                [
                        'label' => esc_html__( 'Title Tag', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'description'   => esc_html__('Select HTML tag that you want to use.', 'themewar'),
                        'default' => '2',
                        'options' => [
                                '1' => esc_html__( 'H1', 'themewar' ),
                                '2' => esc_html__( 'H2', 'themewar' ),
                                '3' => esc_html__( 'H3', 'themewar' ),
                                '4' => esc_html__( 'H4', 'themewar' ),
                                '5' => esc_html__( 'H5', 'themewar' ),
                                '6' => esc_html__( 'H6', 'themewar' ),
                        ],
                ]
        );
        $this->add_responsive_control(
                'st_alignment', [
                        'label'                     => esc_html__( 'Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'       => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'     => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'      => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'                   => 'left',
                        'prefix_class'              => 'orga_t_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_3', [
                'label'         => esc_html__( 'Sub Title Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'st_color', [
                        'label'		 => esc_html__( 'Color', 'themewar' ),
                        'type'		 => Controls_Manager::COLOR,
                        'selectors'	 => [
                            '{{WRAPPER}} .subTitle' => 'color: {{VALUE}};'
                        ],
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'is_gradian',
                                            'operator'  => '!=',
                                            'value'     => 'yes',
                                    ]
                                ],
                        ],
                ]
        );
        $this->add_control(
            'heading_gradian',
            [
                'label'     => esc_html__( 'Text Gradian Color', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after',
                'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'is_gradian',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                            ]
                        ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'icon_box_bg',
                        'label' => esc_html__( 'Gradian Color', 'themewar' ),
                        'types' => ['gradient'],
                        'selector' => '{{WRAPPER}} .gradinacolor',
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'is_gradian',
                                            'operator'  => '==',
                                            'value'     => 'yes',
                                    ]
                                ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'st_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .subTitle',
                ]
        );
        $this->add_responsive_control(
                'st_margin',
                [
                        'label' => esc_html__( 'Marign', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .subTitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'heading_icon',
            [
                'label'     => esc_html__( 'Icon Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'btn_icon_typography',
                        'label' => esc_html__( 'Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .subTitle i',
                ]
        );
        $this->add_responsive_control(
                'icon_label_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .subTitle i'   => 'color: {{VALUE}}'
                        ],
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'is_gradian',
                                            'operator'  => '!=',
                                            'value'     => 'yes',
                                    ]
                                ],
                        ],
                ]
        );
        $this->add_control(
            'heading_icon_gradian',
            [
                'label'     => esc_html__( 'Icon Gradian Color', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after',
                'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'is_gradian',
                                    'operator'  => '==',
                                    'value'     => 'yes',
                            ]
                        ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'icon_icon_bg',
                        'label' => esc_html__( 'Icon Color', 'themewar' ),
                        'types' => ['gradient'],
                        'selector' => '{{WRAPPER}} .gradinacolor i',
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'is_gradian',
                                            'operator'  => '==',
                                            'value'     => 'yes',
                                    ]
                                ],
                        ],
                ]
        );
        $this->add_responsive_control(
            'btn_icon_positioning',
            [
                    'label' => esc_html__( 'Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['top', 'bottom'],
                    'selectors' => [
                            '{{WRAPPER}} .subTitle i' => 'top: {{TOP}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_icon_margin',
            [
                    'label' => esc_html__( 'Margin', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['left', 'right'],
                    'selectors' => [
                            '{{WRAPPER}} .subTitle i' => 'margin-right: {{RIGHT}}{{UNIT}}; margin-left: {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_4', [
                'label'         => esc_html__( 'Main Title Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'mt_color', [
                        'label'		 => esc_html__( 'Color', 'themewar' ),
                        'type'		 => Controls_Manager::COLOR,
                        'selectors'	 => [
                            '{{WRAPPER}} .secTitle' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'mt_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .secTitle',
                ]
        );
        $this->add_control(
            'heading_un_one',
            [
                'label'     => esc_html__( 'Different Text Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                'heading1_color', [
                        'label'      => esc_html__( 'Different Text Color', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .secTitle span' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'heading1_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .secTitle span',
                ]
        );
        $this->add_responsive_control(
                'mt_margin',
                [
                        'label' => esc_html__( 'Marign', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .secTitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings        = $this->get_settings_for_display();
        $sub_text        = (isset($settings['sub_text']) && $settings['sub_text'] !='') ? $settings['sub_text'] : '';
        $is_gradian      = (isset($settings['is_gradian']) && $settings['is_gradian'] != '' ? $settings['is_gradian'] : 'no');
        $icons           = (isset($settings['icons']) && $settings['icons'] != '') ? '<i class="'.$settings['icons'].'"></i>' : '';
        $icon_postition  = (isset($settings['icon_postition']) && $settings['icon_postition'] != '' ? $settings['icon_postition'] : 'in_right');
        $sub_text_tag    = (isset($settings['sub_text_tag']) && $settings['sub_text_tag'] !='') ? $settings['sub_text_tag'] : '7';
        
        $btn_html        = ($icon_postition == 'in_left' ? $icons : '');
        $btn_html       .= $sub_text;
        $btn_html       .= ($icon_postition == 'in_right' ? $icons : '');

        $title           = (isset($settings['title_text']) && $settings['title_text'] !='') ? $settings['title_text'] : esc_html__('Add Main {Title}', 'themewar');
        
        $heading_tag     = (isset($settings['heading_tag']) && $settings['heading_tag'] !='') ? $settings['heading_tag'] : '2';
        $title_text      = str_replace(['{', '}'], ['<span>', '</span>'], $title);
        $cl = '';
        if($sub_text_tag == 1):
            $cl = 'h1';
        elseif ($sub_text_tag == 2):
            $cl = 'h2';
        elseif ($sub_text_tag == 3):
            $cl = 'h3';
        elseif ($sub_text_tag == 4):
            $cl = 'h4';
        elseif ($sub_text_tag == 5):
            $cl = 'h5';
        elseif ($sub_text_tag == 6):
            $cl = 'h6';
        else:
            $cl = 'div';
        endif;
        ?>
        <?php if($btn_html != ''): ?>
            <<?php echo $cl; ?> class="subTitle <?php if($is_gradian == 'yes'): ?>gradinacolor<?php endif; ?> <?php echo ($icon_postition != '' && $icons != '' ? $icon_postition : '') ?>"><?php echo wp_kses_post($btn_html); ?></<?php echo $cl; ?>>
        <?php endif; ?>
        <?php if($title_text != ''): ?>
            <h<?php echo $heading_tag; ?> class="secTitle"><?php echo wp_kses_post($title_text); ?></h<?php echo $heading_tag; ?>>
        <?php endif; 
    }
    
    protected function content_template() {
        
    }
}