<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Product_Gallery_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-product-gallery';
    }
    
    public function get_title() {
        return esc_html__( 'Product Gallery', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-products';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        
        $this->start_controls_section(
                'section_tab_1',
                [
                    'label'     => esc_html__('Products', 'themewar')
                ]
        );
        $this->add_control(
                'pr_galley_type',
                [
                        'label'         => esc_html__( 'Gallery Type', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'description'   => esc_html__('Select product gallery type?', 'themewar'),
                        'default'       => 1,
                        'options'       => [
                                1       => esc_html__( 'Fixed Grid', 'themewar' ),
                                2       => esc_html__( 'Filter Grid', 'themewar' ),
                                3       => esc_html__( 'Category Tabs', 'themewar' ),
                                4       => esc_html__( 'Product Type Tabs', 'themewar' ),
                        ],
                ]
        );
        $this->add_responsive_control(
                'text_align', [
                        'label'                     => esc_html__( 'Title Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'       => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'     => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'      => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'           => 'left',
                        'toggle'            => true,
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'pr_galley_type',
                                        'operator'  => '!in',
                                        'value'     => ['1'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'pr_product_type',
                [
                        'label'         => esc_html__( 'Product Type', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'description'   => esc_html__('Select which type of product you want to show.', 'themewar'),
                        'default'       => 1,
                        'options'       => [
                                1       => esc_html__( 'New Product', 'themewar' ),
                                2       => esc_html__( 'Featured Product', 'themewar' ),
                                3       => esc_html__( 'Sale Product', 'themewar' ),
                                4       => esc_html__( 'Popular Product', 'themewar' ),
                                5       => esc_html__( 'Best Seller Product', 'themewar' ),
                                6       => esc_html__( 'Top Rated Product', 'themewar' ),
                                7       => esc_html__( 'Random Product', 'themewar' ),
                        ],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'pr_galley_type',
                                        'operator'  => '!in',
                                        'value'     => ['3', '4'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'pr_product_types',
                [
                        'label'         => esc_html__( 'Product Types', 'themewar' ),
                        'type'          => Controls_Manager::SELECT2,
                        'description'   => esc_html__('Select types.', 'themewar'),
                        'default'       => ['1', '2', '3', '4'],
                        'multiple'      => true,
                        'options'       => [
                                1       => esc_html__( 'New Product', 'themewar' ),
                                2       => esc_html__( 'Featured Product', 'themewar' ),
                                3       => esc_html__( 'Sale Product', 'themewar' ),
                                4       => esc_html__( 'Popular Product', 'themewar' ),
                                5       => esc_html__( 'Best Seller Product', 'themewar' ),
                                6       => esc_html__( 'Top Rated Product', 'themewar' ),
                                7       => esc_html__( 'Random Product', 'themewar' ),
                        ],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'pr_galley_type',
                                        'operator'  => 'in',
                                        'value'     => ['4'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control( 'pr_product_category', [
                'label' => esc_html__('Product Category', 'themewar'),
                'type' => 'tw_autocomplete',
                'description' => esc_html__('Select specific category product.', 'themewar'),
                'action' => 'tw_get_taxonomy',
                'taxonomy' => 'product_cat',
                'multiple' => true,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pr_galley_type',
                                'operator'  => '!in',
                                'value'     => ['2'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_control(
                'show_flashlabels', [
                        'label'             => esc_html__( 'Is Flash Label?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Dow you want to show flash label on loop product? Turn it to Show.', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                ]
        );
        $this->add_control(
                'shop_is_wishlist_btn', [
                        'label'             => esc_html__( 'Is Wishlist Btn?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Dow you want to show wishlist btn on loop product? Turn it to Show.', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                ]
        );
        $this->add_control(
                'pr_post_item', [
                        'label'         => esc_html__( 'Number Of Item', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'min'           => 3,
                        'max'           => 200,
                        'step'          => 1,
                        'default'       => 3,
                        'description'   => esc_html__( 'How many item you want to show?', 'themewar' ),
                ]
        );
        $this->add_control(
                'pr_column', [
                        'label'         => esc_html__( 'Column Per Row', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'options'       => [
                                3       => esc_html__( '3 Column', 'themewar' ),
                                4       => esc_html__( '4 Column', 'themewar' ),
                        ],
                        'default'       => 3,
                        'description'   => esc_html__( 'How many item you want to show per row?', 'themewar' ),
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_navigation',
            [
                'label'         => esc_html__('Filter Navigation Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'        => [
                    'terms'         => [
                        [
                                'name'      => 'pr_galley_type',
                                'operator'  => '!in',
                                'value'     => ['1'],
                        ]
                    ],
                ],
            ]
        );
        $this->start_controls_tabs( 'style_tabs_12' );
                $this->start_controls_tab(
                        'btn_1_button_style_normal',
                        [
                                'label' => esc_html__( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_1_label_color',
                        [
                                'label' => esc_html__( 'Label Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .filter_menu02 li'   => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(), [
                                'name' => 'btn_1_bg',
                                'label' => esc_html__( 'BG', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .filter_menu02 li',
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'btn_1_button_style_hover',
                        [
                                'label' => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_label_hover_color',
                        [
                                'label'     => esc_html__( 'Label Hover Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .filter_menu02 li:hover'    => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .filter_menu02 li.active'   => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .filter_menu02 li a.active'   => 'color: {{VALUE}}',
                                        '{{WRAPPER}} .filter_menu02 li a:hover'   => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(), [
                                'name' => 'btn_1_hover_bg',
                                'label' => esc_html__( 'BG', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .filter_menu02 li:after, {{WRAPPER}} .prodocut_tab .filter_menu02 li a:after',
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
			'btn_1_width',
			[
				'label' => esc_html__( 'Width', 'themewar' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [],
				'selectors' => [
					'{{WRAPPER}} .filter_menu02 li'   => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
            $this->add_control(
			'btn_1_height',
			[
				'label' => esc_html__( 'Height', 'themewar' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [],
				'selectors' => [
                    '{{WRAPPER}} ..filter_menu02  li' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'btn_1_typography',
                        'label' => esc_html__( 'Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .filter_menu02  li',
                ]
        );
        $this->add_control(
            'border_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .filter_menu02 li'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .filter_menu02 li:after'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .filter_menu02 li a'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .filter_menu02 li a:after'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_padding',
            [
                    'label' => esc_html__( 'Paddings', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .filter_menu02 li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_margin',
            [
                    'label' => esc_html__( 'Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .filter_menu02 li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_area_margin',
            [
                    'label' => esc_html__( 'Area Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .filter_menu02' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();
        
    }
    protected function render() {
        $settings           = $this->get_settings_for_display();
        
        $galley_type        = (isset($settings['pr_galley_type']) && $settings['pr_galley_type'] > 0 ? $settings['pr_galley_type'] : 1);
        $product_type       = (isset($settings['pr_product_type']) && $settings['pr_product_type'] > 0 ? $settings['pr_product_type'] : 1);
        $product_types      = (isset($settings['pr_product_types']) && !empty($settings['pr_product_types']) ? $settings['pr_product_types'] : array());
        $product_category   = (isset($settings['pr_product_category']) && !empty($settings['pr_product_category']) ? $settings['pr_product_category'] : array());
        $post_item          = (isset($settings['pr_post_item']) && $settings['pr_product_category'] != '' ? $settings['pr_post_item'] : 3);
        $pr_column          = (isset($settings['pr_column']) && $settings['pr_column'] > 0 ? $settings['pr_column'] : 3);
        
        $shop_is_wishlist_btn   = (isset($settings['shop_is_wishlist_btn']) && $settings['shop_is_wishlist_btn'] != '') ? $settings['shop_is_wishlist_btn'] : 'no';
        $show_flashlabels   = (isset($settings['show_flashlabels']) && $settings['show_flashlabels'] != '') ? $settings['show_flashlabels'] : 'no';
        
        $text_align             = (isset($settings['text_align']) && $settings['text_align'] != '' ? $settings['text_align'] : 'left');
        
        include dirname(__FILE__).'/style/product-gallery/style'.$galley_type.'.php';
    }
}