<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Pricing_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-pricing';
    }
    
    public function get_title() {
        return esc_html__( 'Pricing Table (Tabs)', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-price-table';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' => esc_html__( 'Pricing Table Tab', 'themewar' ),
            ]
        );
        $this->add_control(
                'pricing_style',
                [
                        'label'         => esc_html__( 'Price Package Style', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'label_block'   => TRUE,
                        'default'       => 1,
                        'options'       => [
                                1       => esc_html__( 'Style 01', 'themewar' ),
                                2       => esc_html__( 'Style 02', 'themewar' ),
                                3       => esc_html__( 'Style 03', 'themewar' ),
                                4       => esc_html__( 'Style 04', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'mn_tab_title',
                [
                        'label'         => esc_html__( 'Monthly Tab Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => esc_html__('Monthly', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '1',
                                ],
                            ],
                        ],
                        'placeholder'   => esc_html__('insert your monthly price tab title', 'themewar')
                ]
        );
        $this->add_control(
                'yr_tab_title',
                [
                        'label'         => esc_html__( 'Yearly Tab Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => esc_html__('Annual', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '1',
                                ],
                            ],
                        ],
                        'placeholder'   => esc_html__('insert your anuual price tab title', 'themewar')
                ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
                'pr_img',
                [
                        'label'         => esc_html__( 'Pricing Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('upload pricing image.', 'themewar'),
                ]
        );
        $repeater->add_control(
                'pr_title',
                [
                        'label'         => esc_html__( 'Package Name', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => esc_html__('Basic Plan', 'themewar'),
                        'placeholder'   => esc_html__('Insert Name', 'themewar')
                ]
        );
        $repeater->add_control(
            'mn_price',
            [
                'label'         => esc_html__( 'Monthly Price', 'themewar' ),
                'type'          => Controls_Manager::HEADING,
            ]
        );
        $repeater->add_control(
                'pr_currency',
                [
                        'label'         => esc_html__('Price Currency', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'	    => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                ]
        );
        $repeater->add_control(
                'pr_price',
                [
                        'label'         => esc_html__('Price', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                ]
        );
        $repeater->add_control(
                'pr_unit',
                [
                        'label'         => esc_html__('Price Unit', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price Unit', 'themewar'),
                ]
        );
        $repeater->add_control(
            'yr_price',
            [
                'label'         => esc_html__( 'Yearly Price', 'themewar' ),
                'type'          => Controls_Manager::HEADING,
                'separator'     => 'after',
            ]
        );
        $repeater->add_control(
                'yrpr_currency',
                [
                        'label'         => esc_html__('Price Currency', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                ]
        );
        $repeater->add_control(
                'yrpr_price',
                [
                        'label'         => esc_html__('Price', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                ]
        );
        $repeater->add_control(
                'yrpr_unit',
                [
                        'label'         => esc_html__('Price Unit', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => esc_html__('.99', 'themewar'),
                        'placeholder'   => esc_html__('Insert Price Unit', 'themewar'),
                ]
        );
        $repeater->add_control(
                'list_item',
                [
                        'label'         => esc_html__( 'List Content', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Pricing list text. use new line(Enter) for line break and <b>disable: text</b> for disable item list,', 'themewar'),
                        'description'   => esc_html__('Use new line(Enter) for line break and <b>disable: text</b> for disable item list,', 'themewar'),
                        'label_block'   => TRUE
                ]
        );
        $repeater->add_control(
                'pricing_btn',
                [
                        'label'         => esc_html__( 'BTN Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert BTN Label', 'themewar'),
                ]
        );
        $repeater->add_control(
                'btn_url',
                [
                        'label'             => esc_html__( 'BTN URL', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'show_external'     => true,
                        'default'           => [
                                'url'           => '',
                                'is_external'   => true,
                                'nofollow'      => true,
                        ],
                ]
        );
        $this->add_control(
                'list',
                [
                        'label'     => esc_html__( 'Pricing Item', 'themewar' ),
                        'type'      => Controls_Manager::REPEATER,
                        'fields'    => $repeater->get_controls(),
                        'default'   => [
                                [
                                        'pr_img'          => '',
                                        'pr_title'        => '',
                                        'pr_currency'     => '',
                                        'pr_price'        => '',
                                        'pr_unit'         => '',
                                        'yrpr_currency'   => '',
                                        'yrpr_price'      => '',
                                        'yrpr_unit'       => '',
                                        'list_item'       => '',
                                        'pricing_btn'     => '',
                                        'btn_url'         => '',
                                ],
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '1',
                                ]
                            ],
                        ],
                        'title_field' => '{{{ pr_title }}}',
                ]
        );
        $repeatersss = new \Elementor\Repeater();
        $repeatersss->add_control(
                'tab_title2',
                [
                        'label'         => esc_html__( 'Tab Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => '',
                        'placeholder'   => esc_html__('insert your tab title.', 'themewar')
                ]
        );
        $repeatersss->add_control(
                'price_img2',
                [
                        'label'         => esc_html__( 'Pricing Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('upload pricing image. image size should be 592x140px.', 'themewar'),
                ]
        );
        $repeatersss->add_control(
            'is_inner_tab2',
            [
                    'label'             => esc_html__( 'Is Inner Tab?', 'themewar' ),
                    'type'              => Controls_Manager::SWITCHER,
                    'label_on'          => esc_html__( 'Yes', 'themewar' ),
                    'label_off'         => esc_html__( 'No', 'themewar' ),
                    'description'       => esc_html__('Do you want to show price toggler inner tab?', 'themewar'),
                    'return_value'      => 'yes',
                    'default'           => 'no',
            ]
        );
        $repeatersss->add_control(
                'mn_title2',
                [
                        'label'         => esc_html__( 'Inner Tab Title 01', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => esc_html__('Monthly', 'themewar'),
                        'condition'     => ['is_inner_tab2' => 'yes'],
                        'placeholder'   => esc_html__('insert your monthly price tab title', 'themewar')
                ]
        );
        $repeatersss->add_control(
                'yr_title2',
                [
                        'label'         => esc_html__( 'Inner Tab Title 02', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => esc_html__('Annual', 'themewar'),
                        'condition'     => ['is_inner_tab2' => 'yes'],
                        'placeholder'   => esc_html__('insert your anuual price tab title', 'themewar')
                ]
        );
        $repeatersss->add_control(
                'pakc_offer',
                [
                        'label'         => esc_html__( 'Package Offer', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert package offer', 'themewar')
                ]
        );
        $repeatersss->add_control(
            'mn_head_price2',
            [
                'label'         => esc_html__( 'Monthly Price', 'themewar' ),
                'type'          => Controls_Manager::HEADING,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'is_inner_tab2',
                                'operator'  => '==',
                                'value'     => 'yes',
                        ]
                    ],
                ],
            ]
        );
        $repeatersss->add_control(
                'mn_price2',
                [
                        'label'         => esc_html__('Price', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                ]
        );
        $repeatersss->add_control(
                'mn_period2',
                [
                        'label'         => esc_html__('Period', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Package Period', 'themewar'),
                ]
        );
        $repeatersss->add_control(
            'yr_head_price2',
            [
                'label'         => esc_html__( 'Yearly Price', 'themewar' ),
                'type'          => Controls_Manager::HEADING,
                'separator'     => 'after',
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'is_inner_tab2',
                                'operator'  => '==',
                                'value'     => 'yes',
                        ]
                    ],
                ],
            ]
        );
        $repeatersss->add_control(
                'yr_price2',
                [
                        'label'         => esc_html__('Price', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'is_inner_tab2',
                                        'operator'  => '==',
                                        'value'     => 'yes',
                                ]
                            ],
                        ],
                ]
        );
        $repeatersss->add_control(
                'yr_period2',
                [
                        'label'         => esc_html__('Period', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Package Period', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'is_inner_tab2',
                                        'operator'  => '==',
                                        'value'     => 'yes',
                                ]
                            ],
                        ],
                ]
        );
        $repeatersss->add_control(
                'list_items2',
                [
                        'label'         => esc_html__( 'List Content', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Pricing list text. use new line(Enter) for line break and <b>disable: text</b> for disable item list,', 'themewar'),
                        'description'   => esc_html__('Use new line(Enter) for line break and <b>disable: text</b> for disable item list,', 'themewar'),
                        'label_block'   => TRUE
                ]
        );
        $this->add_control(
                'list02',
                [
                        'label'     => esc_html__( 'Pricing Item', 'themewar' ),
                        'type'      => Controls_Manager::REPEATER,
                        'fields'    => $repeatersss->get_controls(),
                        'default'   => [
                                [
                                        'tab_title2'       => '',
                                        'price_img2'       => '',
                                        'is_inner_tab2'    => '',
                                        'mn_title2'        => '',
                                        'yr_title2'        => '',
                                        'pakc_offer'       => '',
                                        'mn_price2'        => '',
                                        'mn_period2'       => '',
                                        'yr_price2'        => '',
                                        'yr_period2'       => '',
                                        'list_items2'      => '',
                                ],
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                        'title_field' => '{{{ tab_title2 }}}',
                ]
        );
        $this->add_control(
                'pricing_btns2',
                [
                        'label'         => esc_html__( 'BTN Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert BTN Label', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'btns_url2',
                [
                        'label'             => esc_html__( 'BTN URL', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'show_external'     => true,
                        'default'           => [
                                'url'           => '',
                                'is_external'   => true,
                                'nofollow'      => true,
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $repeaters = new \Elementor\Repeater();
        $repeaters->add_control(
                'tab_title',
                [
                        'label'         => esc_html__( 'Tab Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => '',
                        'placeholder'   => esc_html__('insert your tab title.', 'themewar')
                ]
        );
        $repeaters->add_control(
                'price_img',
                [
                        'label'         => esc_html__( 'Pricing Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('upload pricing image. image size should be 468x525px.', 'themewar'),
                ]
        );
        $repeaters->add_control(
                'price_name',
                [
                        'label'         => esc_html__( 'Package Name', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Name', 'themewar')
                ]
        );
        $repeaters->add_control(
                'tp_currency',
                [
                        'label'         => esc_html__('Price Currency', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                ]
        );
        $repeaters->add_control(
                'tp_price',
                [
                        'label'         => esc_html__( 'Package Price', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert your package price.', 'themewar')
                ]
        );
        $repeaters->add_control(
                'pr_period',
                [
                        'label'         => esc_html__( 'Package Period', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert your package period.', 'themewar')
                ]
        );
        $repeaters->add_control(
                'list_items',
                [
                        'label'         => esc_html__( 'List Content', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Pricing list text. use new line(Enter) for line break and <b>disable: text</b> for disable item list,', 'themewar'),
                        'description'   => esc_html__('Use new line(Enter) for line break and <b>disable: text</b> for disable item list,', 'themewar'),
                        'label_block'   => TRUE
                ]
        );
        $repeaters->add_control(
                'pricing_btns',
                [
                        'label'         => esc_html__( 'BTN Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert BTN Label', 'themewar'),
                ]
        );
        $repeaters->add_control(
                'btns_url',
                [
                        'label'             => esc_html__( 'BTN URL', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'show_external'     => true,
                        'default'           => [
                                'url'           => '',
                                'is_external'   => true,
                                'nofollow'      => true,
                        ],
                ]
        );
        $this->add_control(
                'list03',
                [
                        'label'     => esc_html__( 'Pricing Item', 'themewar' ),
                        'type'      => Controls_Manager::REPEATER,
                        'fields'    => $repeaters->get_controls(),
                        'default'   => [
                                [
                                        'tab_title'       => '',
                                        'price_img'       => '',
                                        'price_name'      => '',
                                        'tp_currency'     => '',
                                        'tp_price'        => '',
                                        'pr_period'       => '',
                                        'list_items'      => '',
                                        'pricing_btns'    => '',
                                        'btns_url'        => '',
                                ],
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                        'title_field' => '{{{ tab_title }}}',
                ]
        );
        $repeaterss = new \Elementor\Repeater();
        $repeaterss->add_control(
                'tab_title4',
                [
                        'label'         => esc_html__( 'Tab Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => '',
                        'placeholder'   => esc_html__('insert your tab title.', 'themewar')
                ]
        );
        $repeaterss->add_control(
                'tab_title4_img',
                [
                        'label'         => esc_html__( 'Tab Title Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('upload tab title image. image size should be 77x27px.', 'themewar'),
                ]
        );
        $repeaterss->add_control(
            'is_inner_tab',
            [
                    'label'             => esc_html__( 'Is Inner Tab?', 'themewar' ),
                    'type'              => Controls_Manager::SWITCHER,
                    'label_on'          => esc_html__( 'Yes', 'themewar' ),
                    'label_off'         => esc_html__( 'No', 'themewar' ),
                    'description'       => esc_html__('Do you want to show price monthy / yearly tab?', 'themewar'),
                    'return_value'      => 'yes',
                    'default'           => 'no',
            ]
        );
        $repeaterss->add_control(
                'mn_title4',
                [
                        'label'         => esc_html__( 'Monthly Tab Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => esc_html__('Monthly', 'themewar'),
                        'condition'     => ['is_inner_tab' => 'yes'],
                        'placeholder'   => esc_html__('insert your monthly price tab title', 'themewar')
                ]
        );
        $repeaterss->add_control(
                'yr_title4',
                [
                        'label'         => esc_html__( 'Yearly Tab Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => esc_html__('Annual', 'themewar'),
                        'condition'     => ['is_inner_tab' => 'yes'],
                        'placeholder'   => esc_html__('insert your anuual price tab title', 'themewar')
                ]
        );
        $repeaterss->add_control(
                'price_img4',
                [
                        'label'         => esc_html__( 'Pricing Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('upload pricing image. image size should be 318x238px.', 'themewar'),
                ]
        );
        $repeaterss->add_control(
                'price_name4',
                [
                        'label'         => esc_html__( 'Package Name', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Name', 'themewar')
                ]
        );
        $repeaterss->add_control(
            'mn_price4',
            [
                'label'         => esc_html__( 'Monthly Price', 'themewar' ),
                'type'          => Controls_Manager::HEADING,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'is_inner_tab',
                                'operator'  => '==',
                                'value'     => 'yes',
                        ]
                    ],
                ],
            ]
        );
        $repeaterss->add_control(
                'pr_currency4',
                [
                        'label'         => esc_html__('Price Currency', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                ]
        );
        $repeaterss->add_control(
                'pr_price4',
                [
                        'label'         => esc_html__('Price', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                ]
        );
        $repeaterss->add_control(
                'pr_unit4',
                [
                        'label'         => esc_html__('Price Unit', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price Unit', 'themewar'),
                ]
        );
        $repeaterss->add_control(
            'yr_price4',
            [
                'label'         => esc_html__( 'Yearly Price', 'themewar' ),
                'type'          => Controls_Manager::HEADING,
                'separator'     => 'after',
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'is_inner_tab',
                                'operator'  => '==',
                                'value'     => 'yes',
                        ]
                    ],
                ],
            ]
        );
        $repeaterss->add_control(
                'yrpr_currency4',
                [
                        'label'         => esc_html__('Price Currency', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'is_inner_tab',
                                        'operator'  => '==',
                                        'value'     => 'yes',
                                ]
                            ],
                        ],
                ]
        );
        $repeaterss->add_control(
                'yrpr_price4',
                [
                        'label'         => esc_html__('Price', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'is_inner_tab',
                                        'operator'  => '==',
                                        'value'     => 'yes',
                                ]
                            ],
                        ],
                ]
        );
        $repeaterss->add_control(
                'yrpr_unit4',
                [
                        'label'         => esc_html__('Price Unit', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => esc_html__('.99', 'themewar'),
                        'placeholder'   => esc_html__('Insert Price Unit', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'is_inner_tab',
                                        'operator'  => '==',
                                        'value'     => 'yes',
                                ]
                            ],
                        ],
                ]
        );
        $repeaterss->add_control(
                'list_items4',
                [
                        'label'         => esc_html__( 'List Content', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Pricing list text. use new line(Enter) for line break and <b>disable: text</b> for disable item list,', 'themewar'),
                        'description'   => esc_html__('Use new line(Enter) for line break and <b>disable: text</b> for disable item list,', 'themewar'),
                        'label_block'   => TRUE
                ]
        );
        $repeaterss->add_control(
                'pricing_btns4',
                [
                        'label'         => esc_html__( 'BTN Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert BTN Label', 'themewar'),
                ]
        );
        $repeaterss->add_control(
                'btns_url4',
                [
                        'label'             => esc_html__( 'BTN URL', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'show_external'     => true,
                        'default'           => [
                                'url'           => '',
                                'is_external'   => true,
                                'nofollow'      => true,
                        ],
                ]
        );
        $this->add_control(
                'list04',
                [
                        'label'     => esc_html__( 'Pricing Item', 'themewar' ),
                        'type'      => Controls_Manager::REPEATER,
                        'fields'    => $repeaterss->get_controls(),
                        'default'   => [
                                [
                                        'tab_title4'       => '',
                                        'tab_title4_img'   => '',
                                        'is_inner_tab'     => '',
                                        'mn_title4'        => '',
                                        'yr_title4'        => '',
                                        'price_img4'       => '',
                                        'price_name4'      => '',
                                        'pr_currency4'     => '',
                                        'pr_price4'        => '',
                                        'pr_unit4'         => '',
                                        'yrpr_currency4'   => '',
                                        'yrpr_price4'      => '',
                                        'yrpr_unit4'       => '',
                                        'list_items4'      => '',
                                        'pricing_btns4'    => '',
                                        'btns_url4'        => '',
                                ],
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '4',
                                ]
                            ],
                        ],
                        'title_field' => '{{{ tab_title4 }}}',
                ]
        );
        $this->add_control(
                'sub_title',
                [
                        'label'         => esc_html__( 'Section Sub Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert your price area sub title.', 'themewar'),
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'main_title',
                [
                        'label'         => esc_html__( 'Section Main Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert your price area main title.', 'themewar'),
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'description',
                [
                        'label'         => esc_html__( 'Section Description Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert your price area description.', 'themewar'),
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'icons',
                [
                        'label'     => esc_html__( 'Icon Box Icon', 'themewar' ),
                        'type'      => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'box_title',
                [
                        'label'         => esc_html__( 'Icon Box Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('Box Title', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'box_desc',
                [
                        'label'         => esc_html__( 'Box Content', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Content Here.', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'box_alignment', [
                        'label'                     => esc_html__('Box Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'       => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'     => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'      => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'                   => 'left',
                        'prefix_class'              => '',
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '!in',
                                        'value'     => ['3', '2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_tab',
            [
                'label'     => esc_html__('Tab Title Style', 'themewar'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'title_typography',
                        'label' => esc_html__( 'Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .cmtab_12 a, {{WRAPPER}} .pricingTab03 li a, {{WRAPPER}} .pricingTabInner02 li a',
                ]
        );
        $this->add_responsive_control(
                't_title_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .cmtab_12 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTab03 li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTabInner02 li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
            't_title_margin',
            [
                    'label' => esc_html__( 'Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .cmtab_12 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTab03 li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTabInner02 li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->start_controls_tabs( 'style_tabs_3' );
            $this->start_controls_tab(
                    'title_style_normal',
                    [
                            'label'     => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'title_color',
                    [
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .cmtab_12 a' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .pricingTab03 li a' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .pricingTabInner02 li a' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'title__bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .cmtab_12 a, {{WRAPPER}} .pricingTab03 li a, {{WRAPPER}} .pricingTabInner02 li a',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'title__border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .cmtab_12 a, {{WRAPPER}} .pricingTab03 li a, {{WRAPPER}} .pricingTabInner02 li a',
                    ]
            );
            $this->add_responsive_control(
                'title_border_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cmtab_12 a'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTab03 li a'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTabInner02 li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'title_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .cmtab_12 a, {{WRAPPER}} .pricingTab03 li a, {{WRAPPER}} .pricingTabInner02 li a',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'title_style_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'hover_title_color',
                    [
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .cmtab_12 a:hover' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .pricingTab03 li a:hover' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .pricingTabInner02 li a:hover' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'active_title_icon_hover_color',
                    [
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .pricingTabInner02 li a:hover:before' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .pricingTab03 li a:hover:before' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'hover_title__bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .cmtab_12 a:hover, {{WRAPPER}} .pricingTab03 li a:hover, {{WRAPPER}} .pricingTabInner02 li a:after',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'hover_title__border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .cmtab_12 a:hover, {{WRAPPER}} .pricingTab03 li a:hover, {{WRAPPER}} .pricingTabInner02 li a:hover',
                    ]
            );
            $this->add_responsive_control(
                'hover_title_border_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cmtab_12 a:hover'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTab03 li a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTabInner02 li a:hover:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'title_hover_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .cmtab_12 a:hover, {{WRAPPER}} .pricingTab03 li a:hover, {{WRAPPER}} .pricingTabInner02 li a:hover:after',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'title_style_active',
                    [
                            'label' => esc_html__( 'Active', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'active_title_color',
                    [
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .cmtab_12 a.active' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .pricingTab03 li a.active' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .pricingTabInner02 li a.active' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'active_title_icon_color',
                    [
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .pricingTabInner02 li a.active:before' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .pricingTab03 li a.active:before' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'active_title__bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .cmtab_12 a.active, {{WRAPPER}} .pricingTab03 li a.active, {{WRAPPER}} .pricingTabInner02 li a.active:after',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'active_title__border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .cmtab_12 a.active, {{WRAPPER}} .pricingTab03 li a.active, {{WRAPPER}} .pricingTabInner02 li a.active',
                    ]
            );
            $this->add_responsive_control(
                'active_title_border_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cmtab_12 a.active'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTab03 li a.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTabInner02 li a.active:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'active_title_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .cmtab_12 a.active, {{WRAPPER}} .pricingTab03 li a.active, {{WRAPPER}} .pricingTabInner02 li a.active',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'tab_area_style',
            [
                'label'     => esc_html__( 'Tab Area Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'tab_area__bg',
                    'label' => esc_html__( 'Background', 'themewar' ),
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .cmtab_12, {{WRAPPER}} .pricingTab03, {{WRAPPER}} .pricingTabInner02',
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'tab_area__border',
                        'label'     => esc_html__( 'Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmtab_12, {{WRAPPER}} .pricingTab03, {{WRAPPER}} .pricingTabInner02',
                ]
        );
        $this->add_responsive_control(
            'tab_area_border_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .cmtab_12'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTab03'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTabInner02'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'      => 'tab_area_shadow',
                        'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmtab_12, {{WRAPPER}} .pricingTab03, {{WRAPPER}} .pricingTabInner02',
                ]
        );
        $this->add_responsive_control(
            'tab_area_padding',
            [
                    'label' => esc_html__( 'Paddings', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .cmtab_12' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTab03' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTabInner02' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_margin',
            [
                    'label' => esc_html__( 'Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .cmtab_12' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTab03' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTabInner02' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_tp_positioning',
            [
                    'label' => esc_html__( 'Top Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['top'],
                    'selectors' => [
                        '{{WRAPPER}} .cmtab_12'   => 'top: {{TOP}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTab03' => 'top: {{TOP}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTabInner02' => 'top: {{TOP}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_rp_positioning',
            [
                    'label' => esc_html__( 'Right Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['right'],
                    'selectors' => [
                        '{{WRAPPER}} .cmtab_12'   => 'right: {{RIGHT}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTab03' => 'right: {{RIGHT}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTabInner02' => 'right: {{RIGHT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_bp_positioning',
            [
                    'label' => esc_html__( 'Bottom Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['bottom'],
                    'selectors' => [
                        '{{WRAPPER}} .cmtab_12' => 'bottom: {{BOTTOM}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTab03' => 'bottom: {{BOTTOM}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTabInner02' => 'bottom: {{BOTTOM}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_lp_positioning',
            [
                    'label' => esc_html__( 'Left Position', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'allowed_dimensions' => ['left'],
                    'selectors' => [
                        '{{WRAPPER}} .cmtab_12' => 'left: {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTab03' => 'left: {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .pricingTabInner02' => 'left: {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_inner',
            [
                'label'     => esc_html__('Inner Tab Title Style', 'themewar'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pricing_style',
                                'operator'  => '==',
                                'value'     => '4',
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'title_tab_inner_typography',
                        'label' => esc_html__( 'Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .pcTab03 a',
                ]
        );
        $this->add_responsive_control(
                't_title_tab_inner_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .pcTab03 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
            't_title_tab_inner_margin',
            [
                    'label' => esc_html__( 'Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                            '{{WRAPPER}} .pcTab03 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->start_controls_tabs( 'style_tabs_inner' );
            $this->start_controls_tab(
                    'title_style_tab_inner_normal',
                    [
                            'label'     => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'title_tab_inner_color',
                    [
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .pcTab03 a' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .pricingTab03 li a' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'title_tab_inner_bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .pcTab03 a',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'title__tab_inner_border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .pcTab03 a',
                    ]
            );
            $this->add_responsive_control(
                'title_border_tab_inner_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .pcTab03 a'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTab03 li a'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'title_tab_inner_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .pcTab03 a',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'title_style_tab_inner_hover',
                    [
                            'label' => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_responsive_control(
                    'hover_title_tab_inner_color',
                    [
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .pcTab03 a:hover' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .pcTab03 a:hover' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'hover_tab_inner_title__bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .pcTab03 a:after',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name'      => 'hover_tab_inner_title__border',
                            'label'     => esc_html__( 'Border', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .pcTab03 a:hover, {{WRAPPER}} .pcTab03 a.active',
                    ]
            );
            $this->add_responsive_control(
                'hover_tab_inner_title_border_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .pcTab03 a:after'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pcTab03 a:hover'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pcTab03 a.active'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'title_tab_inner_hover_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .pcTab03 a:hover, {{WRAPPER}} .pcTab03 a.active',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'tab_area_tab_inner_style',
            [
                'label'     => esc_html__( 'Tab Area Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'tab_area_tab_inner_padding',
            [
                    'label' => esc_html__( 'Paddings', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .pcTab03' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'tab_area_tab_inner_margin',
            [
                    'label' => esc_html__( 'Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .pcTab03' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2',
            [
                'label'         => esc_html__('Package Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_responsive_control(
                'icon_box_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmpriceItem' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pricingTable' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmpriceItem' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pricingTable' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_content_box_padding',
                [
                        'label' => esc_html__( 'Content Area Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .price-detils' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => 'in',
                                        'value'     => ['1', '4'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmpriceItem' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pricingTable' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'ib_box_tot' );
            $this->start_controls_tab(
                'ib_box_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'icon_box_bg',
                                'label' => esc_html__( 'Box Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .cmpriceItem, {{WRAPPER}} .pricingTable',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'icon_box_shadow',
                                'label' => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .cmpriceItem, {{WRAPPER}} .pricingTable',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'box_border',
                                'label' => esc_html__( 'Box Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .cmpriceItem, {{WRAPPER}} .pricingTable',
                        ]
                );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_box_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'icon_box_bg_hr',
                                'label' => esc_html__( 'Box Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .cmpriceItem:hover, {{WRAPPER}} .pricingTable:hover',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'icon_box_shadow_hr',
                                'label' => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .cmpriceItem:hover, {{WRAPPER}} .pricingTable:hover',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'box_border_hr',
                                'label' => esc_html__( 'Box Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .cmpriceItem:hover, {{WRAPPER}} .pricingTable:hover',
                        ]
                );
                $this->add_responsive_control(
                        'icon_box_hover_all_con_color',[
                                'label'     => esc_html__( 'Hover All Content Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .cmpriceItem:hover *' => 'color: {{VALUE}}',
                                ]
                        ]
                );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_pt_image', [
                    'label'             => esc_html__('Price Image Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_responsive_control(
                'pt_image_width', [
                        'label' => esc_html__( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 1,
                                        'max' => 1000,
                                        'step' => 1,
                                ]
                        ],
                        'default' => [
                                'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .price-thumb img' => 'width: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .tabContent03 img' => 'width: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTabInner li a img' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pt_image_height', [
                        'label' => esc_html__( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 1,
                                        'max' => 1000,
                                        'step' => 1,
                                ]
                        ],
                        'default' => [
                                'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .price-thumb img' => 'height: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .tabContent03 img' => 'height: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTabInner li a img' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pt_image_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .price-thumb img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .tabContent03 img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTable' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTabInner li a img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTabInner li a:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pt_image_padding',
                [
                        'label' => esc_html__( 'Padding', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .price-thumb' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .tabContent03' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTabInner li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pt_image_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .price-thumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .tabContent03' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTabInner li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'active_Overlay_color',[
                        'label'     => esc_html__( 'Active Overlay Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .pricingTabInner li a:after' => 'background: {{VALUE}}',
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_checkbox',
            [
                'label'         => esc_html__('Checkbox Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pricing_style',
                                'operator'  => '==',
                                'value'     => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
                'checkbox_width',
                [
                        'label' => esc_html__( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default'   => [],
                        'selectors' => [
                            '{{WRAPPER}} .pricingTabInner li a .round' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'checkbox_height',
                [
                        'label' => esc_html__( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default'   => [],
                        'selectors' => [
                            '{{WRAPPER}} .pricingTabInner li a .round' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'checkbox_area_radius',
                [
                        'label' => esc_html__( 'Area Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .pricingTabInner li a .round' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTabInner li a .round:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'checkbox_area_border',
                        'label'     => esc_html__( 'Area Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .pricingTabInner li a .round',
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'  => 'checkbox_area_background',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic' ],
                        'selector' => '{{WRAPPER}} .pricingTabInner li a .round:after',
                ]
        );
        $this->add_responsive_control(
                'checkbox_border_color',[
                        'label'     => esc_html__( 'Active Border Left Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .pricingTabInner li a:before' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_3',
            [
                'label'         => esc_html__('Package Name Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'pr_name_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .p-title' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_name_border_color',[
                        'label'     => esc_html__( 'Border Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .pricing-item-02 .p-title:after' => 'background: {{VALUE}}',
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => 'in',
                                        'value'     => ['3'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'pr_name_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .p-title',
                ]
        );
        $this->add_responsive_control(
                'pr_name_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .p-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_pr_offer',
            [
                'label'         => esc_html__('Package Offer Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pricing_style',
                                'operator'  => '==',
                                'value'     => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'pr_offer_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .p-off',
                ]
        );
        $this->add_responsive_control(
                'pr_offer_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .p-off' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_offer_bg_color',[
                        'label'     => esc_html__( 'BG Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .p-off' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_offer_bg_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .p-off'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_offer_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .p-off' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_offer_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .p-off' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_4',
            [
                'label'         => esc_html__('Price Currency Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pricing_style',
                                'operator'  => '!in',
                                'value'     => ['2'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'price_currency_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .currency',
                ]
        );
        $this->add_responsive_control(
                'price_currency_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .currency' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'price_currency_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .currency' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_5',
            [
                'label'         => esc_html__('Price Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'price_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .p-price',
                ]
        );
        $this->add_responsive_control(
                'price_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .p-price' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'price_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .p-price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_6',
            [
                'label'         => esc_html__('Price Unit Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pricing_style',
                                'operator'  => '!in',
                                'value'     => ['2'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'pr_unit_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .p-price sub',
                ]
        );
        $this->add_responsive_control(
                'pr_unit_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .p-price sub' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_unit_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .p-price sub' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_7',
            [
                'label'         => esc_html__('Period Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pricing_style',
                                'operator'  => 'in',
                                'value'     => ['2', '3'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'period_heading_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .prperiod, {{WRAPPER}} .price_period span',
                ]
        );
        $this->add_responsive_control(
                'period_name_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .prperiod' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .price_period span' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_period_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .prperiod' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .price_period span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_8',
            [
                'label'         => esc_html__('Features Listing Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'f_icon_style',
            [
                'label'     => esc_html__( 'Icon Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'f_icon_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ptlist li i',
                ]
        );
        $this->add_responsive_control(
                'f_icon_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .ptlist li i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'f_disable_icon_color',[
                        'label'     => esc_html__( 'Disable Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .ptlist li.disable i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
            'f_icon_gr_style',
            [
                'label'     => esc_html__( 'Icon Gradiant Color Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pricing_style',
                                'operator'  => '==',
                                'value'     => '4',
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'list_icon_gr_color',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .pricing-item-03 .price-detils ul li i',
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '4',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
            'f_icon_gr_diabel_style',
            [
                'label'     => esc_html__( 'Icon Gradiant Disable Color Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pricing_style',
                                'operator'  => '==',
                                'value'     => '4',
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'list_icon_disable_gr_color',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .pricing-item-03 .price-detils ul li.disable i',
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '4',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'f_icon_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .ptlist li i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->add_control(
            'f_text_style',
            [
                'label'     => esc_html__( 'Text Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'pr_features',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ptlist li',
                ]
        );
        $this->add_responsive_control(
                'pr_features_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .ptlist li' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'f_disable_features_color',[
                        'label'     => esc_html__( 'Disable Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .ptlist li.disable' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'pr_list_border',
                        'label'     => esc_html__( 'Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ptlist li',
                ]
        );
        $this->add_responsive_control(
                'pr_features_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ptlist li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_features_margin',
                [
                        'label' => esc_html__( 'Magins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ptlist li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_features_area_margin',
                [
                        'label' => esc_html__( 'Area Magins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ptlist' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_btn_9',
            [
                'label'         => esc_html__('Button Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs( 'style_tabs_25' );
                $this->start_controls_tab(
                        'btn_1_button_style_normal',
                        [
                                'label' => esc_html__( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_responsive_control(
                        'btn_1_label_color',
                        [
                                'label' => esc_html__( 'Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .berpo_btn'   => 'color: {{VALUE}}'
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'btn_1_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .berpo_btn',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name'      => 'btn_border',
                                'label'     => esc_html__( 'Border', 'themewar' ),
                                'selector'  => '{{WRAPPER}} .berpo_btn',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name'      => 'btn_box_shadow',
                                'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector'  => '{{WRAPPER}} .berpo_btn',
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'btn_1_button_style_hover',
                        [
                                'label' => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_responsive_control(
                        'btn_label_hover_color',
                        [
                                'label'     => esc_html__( 'Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .berpo_btn:hover'   => 'color: {{VALUE}}'
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'btn_1_hover_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .berpo_btn .bp-shape, {{WRAPPER}} .berpo_btn.with_icon03:after',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name'      => 'btn_hover_border',
                                'label'     => esc_html__( 'Border', 'themewar' ),
                                'selector'  => '{{WRAPPER}} .berpo_btn:hover',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name'      => 'btn_hover_box_shadow',
                                'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector'  => '{{WRAPPER}} .berpo_btn:hover',
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
			'btn_1_width',
			     [
    				'label' => esc_html__( 'Width', 'themewar' ),
    				'type' => Controls_Manager::SLIDER,
    				'size_units' => [ 'px', '%' ],
    				'range' => [
    					'px' => [
    						'min' => 0,
    						'max' => 1000,
    						'step' => 1,
    					],
    					'%' => [
    						'min' => 0,
    						'max' => 100,
    					],
    				],
    				'default' => [],
    				'selectors' => [
    					'{{WRAPPER}} .berpo_btn' => 'width: {{SIZE}}{{UNIT}};'
    				],
    			]
		);
        $this->add_responsive_control(
			'btn_1_height',
			[
				'label' => esc_html__( 'Height', 'themewar' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [],
				'selectors' => [
                    '{{WRAPPER}} .berpo_btn' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'btn_1_typography',
                        'label' => esc_html__( 'Button Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .berpo_btn',
                ]
        );
        $this->add_responsive_control(
            'border_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .berpo_btn'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .berpo_btn.with_icon03:after'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_padding',
            [
                    'label' => esc_html__( 'Paddings', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .berpo_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_margin',
            [
                    'label' => esc_html__( 'Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .berpo_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_subtitle', [
                    'label'             => esc_html__('Price Area Sub Title Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'pricing_style',
                                    'operator'  => '==',
                                    'value'     => '3',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'tst_subtitle_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .subTitle'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_subtitle_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .subTitle',
                ]
        );
        $this->add_responsive_control(
                'tst_subtitle_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .subTitle'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_title', [
                    'label'             => esc_html__('Price Area Title Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'pricing_style',
                                    'operator'  => '==',
                                    'value'     => '3',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'tst_title_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .secTitle'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_title_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .secTitle',
                ]
        );
        $this->add_responsive_control(
                'tst_title_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .secTitle '  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_desc', [
                    'label'             => esc_html__('Price Area Description Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'pricing_style',
                                    'operator'  => '==',
                                    'value'     => '3',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'tst_desc_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .priceCon p'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_desc_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .priceCon p',
                ]
        );
        $this->add_responsive_control(
                'tst_desc_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .priceCon p '  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_ib_iconstyle',[
                    'label'         => esc_html__('Icon Box Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'pricing_style',
                                    'operator'  => '==',
                                    'value'     => '3',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_ib_i_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .priceCon .icon_box_01 i'
                ]
        );
        $this->add_responsive_control(
                'icon_box_ib_i_color',[
                        'label'     => esc_html__( 'Icon Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .priceCon .icon_box_01 i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'icon_box_ib_i_bg_color',
                        'label' => esc_html__( 'Box Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .priceCon .icon_box_01 i',
                ]
        );
        $this->add_control(
            'icon_box_ib_i_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .priceCon .icon_box_01 i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
                'icon_box_ib_i_width',
                [
                        'label' => __( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .priceCon .icon_box_01 ia' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_ib_i_height',
                [
                        'label' => __( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .priceCon .icon_box_01 i' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'icon_box_ib_i_border_hr',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .priceCon .icon_box_01 i',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_ib_i__shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .priceCon .icon_box_01 i',
                ]
        );
        $this->add_control(
                'icon_box_ib_i_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .priceCon .icon_box_01 i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->add_control(
                'icon_box_ib_i_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .priceCon .icon_box_01 i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_ib_title', [
                    'label'             => esc_html__('Icon Box Title Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'pricing_style',
                                    'operator'  => '==',
                                    'value'     => '3',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'tst_ib_title_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .priceCon .icon_box_01 h5'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_ib_title_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .priceCon .icon_box_01 h5',
                ]
        );
        $this->add_responsive_control(
                'tst_ib_title_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .priceCon .icon_box_01 h5'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_ib_box_desc', [
                    'label'             => esc_html__('Icon Box Content Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'pricing_style',
                                    'operator'  => '==',
                                    'value'     => '3',
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'tst_ib_desc_color',
                [
                        'label' => esc_html__( 'Color', 'themewar' ),
                        'type'  => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .priceCon .icon_box_01 span'  => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'tst_ib_desc_typo',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .priceCon .icon_box_01 span',
                ]
        );
        $this->add_responsive_control(
                'tst_ib_desc_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .priceCon .icon_box_01 span'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings       = $this->get_settings_for_display();
        
        $pricing_style  = (isset($settings['pricing_style']) && $settings['pricing_style'] > 0 ) ? $settings['pricing_style'] : 1;

        $yr_tab_title   = (isset($settings['yr_tab_title']) && $settings['yr_tab_title'] != '') ? $settings['yr_tab_title'] : esc_html__('Annual', 'themewar');
        $mn_tab_title   = (isset($settings['mn_tab_title']) && $settings['mn_tab_title'] != '') ? $settings['mn_tab_title'] : esc_html__('Monthly', 'themewar');
        $box_alignment   = (isset($settings['box_alignment']) && $settings['box_alignment'] !='') ? $settings['box_alignment'] : 'left';
        
        $list_item      = (isset($settings['list']) && !empty($settings['list'])) ? $settings['list'] : array();
        $list_item02    = (isset($settings['list02']) && !empty($settings['list02'])) ? $settings['list02'] : array();
        $list_item03    = (isset($settings['list03']) && !empty($settings['list03'])) ? $settings['list03'] : array();
        $list_item04    = (isset($settings['list04']) && !empty($settings['list04'])) ? $settings['list04'] : array();
        
        $pricing_btns2    = (isset($settings['pricing_btns2']) && $settings['pricing_btns2'] != '') ? $settings['pricing_btns2'] : '';
        $btns_url2        = (isset($settings['btns_url2']['url']) && $settings['btns_url2']['url'] != '') ? $settings['btns_url2']['url'] : '#';

        $sub_title          = $settings['sub_title'];
        $main_title         = $settings['main_title'];
        $description        = $settings['description'];
        $icons              = (isset($settings['icons']) && $settings['icons'] != '') ? $settings['icons'] : '';
        $box_title          = (isset($settings['box_title']) && $settings['box_title'] != '') ? $settings['box_title'] : '';
        $desc               = (isset($settings['box_desc']) && $settings['box_desc'] != '') ? $settings['box_desc'] : '';

        include dirname(__FILE__).'/style/pricing-table/style'.$pricing_style.'.php';
        
    }
    
    protected function content_template() {}
    
}