<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Pricing_Table_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-pricing-table';
    }
    
    public function get_title() {
        return esc_html__( 'Pricing Table (Normal)', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-price-table';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' => esc_html__( 'Pricing Table', 'themewar' ),
            ]
        );
        $this->add_control(
                'pricing_style',
                [
                        'label'         => esc_html__( 'Price Package Style', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'label_block'   => TRUE,
                        'default'       => 1,
                        'options'       => [
                                1       => esc_html__( 'Style 01', 'themewar' ),
                                2       => esc_html__( 'Style 02', 'themewar' ),
                                3       => esc_html__( 'Style 03', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'pr_img',
                [
                        'label'         => esc_html__( 'Pricing Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('upload pricing image.', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '!in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'pr_title',
                [
                        'label'         => esc_html__( 'Package Name', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => esc_html__('Basic Plan', 'themewar'),
                        'placeholder'   => esc_html__('Insert Name', 'themewar')
                ]
        );
        $this->add_control(
                'pr_currency',
                [
                        'label'         => esc_html__('Price Currency', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                ]
        );
        $this->add_control(
                'pr_price',
                [
                        'label'         => esc_html__('Price', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price', 'themewar'),
                ]
        );
        $this->add_control(
                'pr_unit',
                [
                        'label'         => esc_html__('Price Unit', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price Unit', 'themewar'),
                ]
        );
        $this->add_control(
                'pr_period',
                [
                        'label'         => esc_html__('Price Period', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Price Period', 'themewar'),
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => 'in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
                'twl_icons',
                [
                        'label'         => esc_html__( 'Icon', 'themewar' ),
                        'type'          => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                ]
        );
        $repeater->add_control(
                'twl_items', [
                        'label'         => esc_html__( 'Item Content', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'default'       => esc_html__( 'List Content' , 'themewar' ),
                        'label_block'   => true,
                ]
        );
        $repeater->add_control(
                'is_disable',
                [
                        'label'             => esc_html__( 'Is Disable?', 'themewar' ),
                        'type'              => Controls_Manager::SWITCHER,
                        'label_on'          => esc_html__( 'Yes', 'themewar' ),
                        'label_off'         => esc_html__( 'No', 'themewar' ),
                        'description'       => esc_html__('Do you want to make this this item disable color?', 'themewar'),
                        'return_value'      => 'yes',
                        'default'           => 'no',
                ]
        );
        $this->add_control(
                'twl_list',
                [
                        'label'         => esc_html__( 'List Items', 'themewar' ),
                        'type'          => Controls_Manager::REPEATER,
                        'fields'        => $repeater->get_controls(),
                        'default'       => [
                                [
                                        'is_disable'      => 'no',
                                        'twl_items'       => '',
                                        'twl_icons'       => '',

                                ],
                        ],
                        'title_field' => '{{{ twl_items }}}',
                ]
        );
        $this->add_control(
                'pricing_btn',
                [
                        'label'         => esc_html__( 'BTN Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert BTN Label', 'themewar'),
                ]
        );
        $this->add_control(
                'btn_url',
                [
                        'label'             => esc_html__( 'BTN URL', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'show_external'     => true,
                        'default'           => [
                                'url'           => '',
                                'is_external'   => true,
                                'nofollow'      => true,
                        ],
                ]
        );
        $this->add_responsive_control(
                'box_alignment', [
                        'label'                     => esc_html__('Box Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'       => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'     => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'      => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'                   => 'left',
                        'prefix_class'              => 'price_tb_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2',
            [
                'label'         => esc_html__('Package Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_responsive_control(
                'icon_box_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmpriceItem' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pricingTable' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmpriceItem' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pricingTable' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_content_box_padding',
                [
                        'label' => esc_html__( 'Content Area Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .price-detils' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => 'in',
                                        'value'     => ['1', '4'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmpriceItem' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pricingTable' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'ib_box_tot' );
            $this->start_controls_tab(
                'ib_box_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'icon_box_bg',
                                'label' => esc_html__( 'Box Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .cmpriceItem, {{WRAPPER}} .pricingTable',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'icon_box_shadow',
                                'label' => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .cmpriceItem, {{WRAPPER}} .pricingTable',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'box_border',
                                'label' => esc_html__( 'Box Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .cmpriceItem, {{WRAPPER}} .pricingTable',
                        ]
                );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_box_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'icon_box_bg_hr',
                                'label' => esc_html__( 'Box Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .cmpriceItem:hover, {{WRAPPER}} .pricingTable:hover',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'icon_box_shadow_hr',
                                'label' => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .cmpriceItem:hover, {{WRAPPER}} .pricingTable:hover',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name' => 'box_border_hr',
                                'label' => esc_html__( 'Box Border', 'themewar' ),
                                'selector' => '{{WRAPPER}} .cmpriceItem:hover, {{WRAPPER}} .pricingTable:hover',
                        ]
                );
                $this->add_responsive_control(
                        'icon_box_hover_all_con_color',[
                                'label'     => esc_html__( 'Hover All Content Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .cmpriceItem:hover *' => 'color: {{VALUE}}',
                                ]
                        ]
                );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_pt_image', [
                    'label'             => esc_html__('Price Image Styling', 'themewar'),
                    'tab'               => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_responsive_control(
                'pt_image_width', [
                        'label' => esc_html__( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 1,
                                        'max' => 1000,
                                        'step' => 1,
                                ]
                        ],
                        'default' => [
                                'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .price-thumb img' => 'width: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .tabContent03 img' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pt_image_height', [
                        'label' => esc_html__( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 1,
                                        'max' => 1000,
                                        'step' => 1,
                                ]
                        ],
                        'default' => [
                                'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .price-thumb img' => 'height: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .tabContent03 img' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pt_image_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .price-thumb img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .tabContent03 img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pricingTable' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pt_image_padding',
                [
                        'label' => esc_html__( 'Padding', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .price-thumb' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .tabContent03' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pt_image_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .price-thumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .tabContent03' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_3',
            [
                'label'         => esc_html__('Package Name Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_responsive_control(
                'pr_name_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .p-title' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_name_border_color',[
                        'label'     => esc_html__( 'Border Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .pricing-item-02 .p-title:after' => 'background: {{VALUE}}',
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => 'in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'pr_name_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .p-title',
                ]
        );
        $this->add_responsive_control(
                'pr_name_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .p-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_4',
            [
                'label'         => esc_html__('Price Currency Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'price_currency_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .currency',
                ]
        );
        $this->add_responsive_control(
                'price_currency_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .currency' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'price_currency_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .currency' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_5',
            [
                'label'         => esc_html__('Price Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'price_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .p-price',
                ]
        );
        $this->add_responsive_control(
                'price_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .p-price' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'price_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .p-price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_6',
            [
                'label'         => esc_html__('Price Unit Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'pr_unit_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .p-price sub',
                ]
        );
        $this->add_responsive_control(
                'pr_unit_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .p-price sub' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_unit_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .p-price sub' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_7',
            [
                'label'         => esc_html__('Period Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pricing_style',
                                'operator'  => 'in',
                                'value'     => ['2'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'period_heading_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .prperiod',
                ]
        );
        $this->add_responsive_control(
                'period_name_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .prperiod' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_period_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .prperiod' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_8',
            [
                'label'         => esc_html__('Features Listing Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'f_icon_style',
            [
                'label'     => esc_html__( 'Icon Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'f_icon_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ptlist li i',
                ]
        );
        $this->add_responsive_control(
                'f_icon_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .ptlist li i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'f_disable_icon_color',[
                        'label'     => esc_html__( 'Disable Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .ptlist li.disable i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
            'f_icon_gr_style',
            [
                'label'     => esc_html__( 'Icon Gradiant Color Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pricing_style',
                                'operator'  => '==',
                                'value'     => '3',
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'list_icon_gr_color',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .pricing-item-03 .price-detils ul li i',
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
            'f_icon_gr_diabel_style',
            [
                'label'     => esc_html__( 'Icon Gradiant Disable Color Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions'    => [
                    'terms'     => [
                        [
                                'name'      => 'pricing_style',
                                'operator'  => '==',
                                'value'     => '3',
                        ]
                    ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'list_icon_disable_gr_color',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .pricing-item-03 .price-detils ul li.disable i',
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'pricing_style',
                                        'operator'  => '==',
                                        'value'     => '3',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'f_icon_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .ptlist li i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
        );
        $this->add_control(
            'f_text_style',
            [
                'label'     => esc_html__( 'Text Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'pr_features',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ptlist li',
                ]
        );
        $this->add_responsive_control(
                'pr_features_color',[
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .ptlist li' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'f_disable_features_color',[
                        'label'     => esc_html__( 'Disable Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .ptlist li.disable' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name'      => 'pr_list_border',
                        'label'     => esc_html__( 'Border', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ptlist li',
                ]
        );
        $this->add_responsive_control(
                'pr_features_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ptlist li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_features_margin',
                [
                        'label' => esc_html__( 'Magins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ptlist li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'pr_features_area_margin',
                [
                        'label' => esc_html__( 'Area Magins', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ptlist' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_btn_9',
            [
                'label'         => esc_html__('Button Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs( 'style_tabs_25' );
                $this->start_controls_tab(
                        'btn_1_button_style_normal',
                        [
                                'label' => esc_html__( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_responsive_control(
                        'btn_1_label_color',
                        [
                                'label' => esc_html__( 'Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .berpo_btn'   => 'color: {{VALUE}}'
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'btn_1_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .berpo_btn',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name'      => 'btn_border',
                                'label'     => esc_html__( 'Border', 'themewar' ),
                                'selector'  => '{{WRAPPER}} .berpo_btn',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name'      => 'btn_box_shadow',
                                'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector'  => '{{WRAPPER}} .berpo_btn',
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'btn_1_button_style_hover',
                        [
                                'label' => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_responsive_control(
                        'btn_label_hover_color',
                        [
                                'label'     => esc_html__( 'Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .berpo_btn:hover'   => 'color: {{VALUE}}'
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'btn_1_hover_bg',
                            'label' => esc_html__( 'Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .berpo_btn .bp-shape, {{WRAPPER}} .berpo_btn.with_icon03:after',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                                'name'      => 'btn_hover_border',
                                'label'     => esc_html__( 'Border', 'themewar' ),
                                'selector'  => '{{WRAPPER}} .berpo_btn:hover',
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name'      => 'btn_hover_box_shadow',
                                'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                                'selector'  => '{{WRAPPER}} .berpo_btn:hover',
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
			'btn_1_width',
			     [
    				'label' => esc_html__( 'Width', 'themewar' ),
    				'type' => Controls_Manager::SLIDER,
    				'size_units' => [ 'px', '%' ],
    				'range' => [
    					'px' => [
    						'min' => 0,
    						'max' => 1000,
    						'step' => 1,
    					],
    					'%' => [
    						'min' => 0,
    						'max' => 100,
    					],
    				],
    				'default' => [],
    				'selectors' => [
    					'{{WRAPPER}} .berpo_btn' => 'width: {{SIZE}}{{UNIT}};'
    				],
    			]
		);
        $this->add_responsive_control(
			'btn_1_height',
			[
				'label' => esc_html__( 'Height', 'themewar' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [],
				'selectors' => [
                    '{{WRAPPER}} .berpo_btn' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'btn_1_typography',
                        'label' => esc_html__( 'Button Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .berpo_btn',
                ]
        );
        $this->add_responsive_control(
            'border_radius',
            [
                    'label' => esc_html__( 'Border Radius', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .berpo_btn'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .berpo_btn.with_icon03:after'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_padding',
            [
                    'label' => esc_html__( 'Paddings', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .berpo_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->add_responsive_control(
            'btn_1_margin',
            [
                    'label' => esc_html__( 'Margins', 'themewar' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                            '{{WRAPPER}} .berpo_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();

    }
    
    protected function render() {
        $settings       = $this->get_settings_for_display();
        
        $pricing_style  = (isset($settings['pricing_style']) && $settings['pricing_style'] > 0 ) ? $settings['pricing_style'] : 1;

        $pr_img         = (isset($settings['pr_img']['url']) && $settings['pr_img']['url'] != '') ? $settings['pr_img']['url'] : '';
        $pr_title       = (isset($settings['pr_title']) && $settings['pr_title'] != '') ? $settings['pr_title'] : esc_html__('Basic Plan', 'themewar');
        $currency       = (isset($settings['pr_currency']) && $settings['pr_currency'] != '') ? $settings['pr_currency'] : '';
        $pr_price       = (isset($settings['pr_price']) && $settings['pr_price'] != '') ? $settings['pr_price'] : esc_html__('116', 'themewar');
        $pr_unit        = (isset($settings['pr_unit']) && $settings['pr_unit'] != '') ? $settings['pr_unit'] : '';

        $lists           = (isset($settings['twl_list']) && !empty($settings['twl_list']) ? $settings['twl_list'] : array());

        $pr_period      = (isset($settings['pr_period']) && $settings['pr_period'] != '') ? $settings['pr_period'] : '';
        $pricing_btn    = (isset($settings['pricing_btn']) && $settings['pricing_btn'] != '') ? $settings['pricing_btn'] : '';
        $btn_url        = (isset($settings['btn_url']['url']) && $settings['btn_url']['url'] != '') ? $settings['btn_url']['url'] : '#';
        $target         = isset($settings['btn_url']['is_external']) ? ' target="_blank"' : '' ;
        $nofollow       = isset($settings['btn_url']['nofollow']) ? ' rel="nofollow"' : '' ;

        if($pricing_style == 2):
            ?>
            <div class="pricing-item-02 cmpriceItem normalPi02">
                <?php if($pr_title != ''): ?>
                    <h4 class="p-title"><?php echo esc_html($pr_title); ?></h4>
                <?php endif; ?>
                <?php if($pr_price != ''): ?>
                    <h3 class="p-price">
                        <sup class="currency"><?php echo wp_kses_post($currency); ?></sup><?php echo wp_kses_post($pr_price); ?><sub><?php echo wp_kses_post($pr_unit); ?></sub>
                    </h3>
                <?php endif; ?>
                <?php if($pr_period != ''): ?>
                    <p class="prperiod"><?php echo wp_kses_post($pr_period); ?></p>
                <?php endif; ?>
                <?php if(!empty($lists)): ?>
                    <ul class="ptlist">
                        <?php 
                        $i = 1; 
                        foreach ($lists as $item):
                            $is_disable = (isset($item['is_disable'])) ? $item['is_disable'] : 'no';
                            $icons      = (isset($item['twl_icons'])) ? $item['twl_icons'] : '';
                            $twl_items  = (isset($item['twl_items'])) ? $item['twl_items'] : '';
                        ?>
                        <li <?php if($is_disable == 'yes'): ?>class="disable"<?php endif;?>>
                            <?php if($icons != ''): ?>
                                <i class="<?php echo esc_attr($icons); ?>"></i>
                            <?php endif; ?>
                            <?php echo wp_kses_post($twl_items); ?>
                        </li>
                        <?php 
                        $i++;
                        endforeach;
                        ?>
                    </ul>
                <?php endif; ?>
                <?php if($pricing_btn != ''): ?>
                    <a class="berpo_btn" <?php echo esc_attr($target.' '.$nofollow); ?> href="<?php echo esc_url($btn_url); ?>">
                        <span class="bp-shape"></span>
                        <span class="bp-shape"></span>
                        <span class="bp-shape"></span>
                        <span class="bp-shape"></span>
                        <span class="bp-text"><?php echo esc_html($pricing_btn); ?></span>
                    </a>
                <?php endif; ?>
            </div>
            <?php
        elseif($pricing_style == 3):
            ?>
            <div class="pricing-item-03 cmpriceItem normalPi03">
                <?php if($pr_img != ''): ?>
                    <div class="price-thumb">
                        <img src="<?php echo esc_url($pr_img); ?>" alt="<?php echo esc_attr__('pricing_image', 'themewar'); ?>">
                    </div>
                <?php endif; ?>
                <div class="price-detils">
                    <?php if($pr_title != ''): ?>
                        <h4 class="p-title"><?php echo esc_html($pr_title); ?></h4>
                    <?php endif; ?>
                    <?php if($pr_price != ''): ?>
                    <h3 class="p-price">
                        <span class="price_period active">
                            <sup class="currency"><?php echo wp_kses_post($currency); ?></sup><?php echo wp_kses_post($pr_price); ?><sub><?php echo wp_kses_post($pr_unit); ?></sub>
                        </span>
                    </h3>
                    <?php endif; ?>
                    <?php if(!empty($lists)): ?>
                    <ul class="ptlist">
                        <?php 
                        $i = 1; 
                        foreach ($lists as $item):
                            $is_disable = (isset($item['is_disable'])) ? $item['is_disable'] : 'no';
                            $icons      = (isset($item['twl_icons'])) ? $item['twl_icons'] : '';
                            $twl_items  = (isset($item['twl_items'])) ? $item['twl_items'] : '';
                        ?>
                        <li <?php if($is_disable == 'yes'): ?>class="disable"<?php endif;?>>
                            <?php if($icons != ''): ?>
                                <i class="<?php echo esc_attr($icons); ?>"></i>
                            <?php endif; ?>
                            <?php echo wp_kses_post($twl_items); ?>
                        </li>
                        <?php 
                        $i++;
                        endforeach;
                        ?>
                    </ul>
                    <?php endif; ?>
                    <?php if($pricing_btn != ''): ?>
                        <a class="berpo_btn with_icon03" <?php echo esc_attr($target.' '.$nofollow); ?> href="<?php echo esc_url($btn_url); ?>"><?php echo esc_html($pricing_btn); ?><i class="twi-arrow-right1"></i></a>
                    <?php endif; ?>
                </div>
            </div>
            <?php
        else:
            ?>
            <div class="pricing-item-01 cmpriceItem normalPi01">
                <?php if($pr_img != ''): ?>
                    <div class="price-thumb">
                        <img src="<?php echo esc_url($pr_img); ?>" alt="<?php echo esc_attr__('pricing_image', 'themewar'); ?>">
                    </div>
                <?php endif; ?>
                <div class="price-detils">
                    <?php if($pr_title != ''): ?>
                        <h4 class="p-title"><?php echo esc_html($pr_title); ?></h4>
                    <?php endif; ?>
                    <?php if($pr_price != ''): ?>
                    <h3 class="p-price">
                        <span class="price_period active">
                            <sup class="currency"><?php echo wp_kses_post($currency); ?></sup><?php echo wp_kses_post($pr_price); ?><sub><?php echo wp_kses_post($pr_unit); ?></sub>
                        </span>
                    </h3>
                    <?php endif; ?>
                    <?php if(!empty($lists)): ?>
                    <ul class="ptlist">
                        <?php 
                        $i = 1; 
                        foreach ($lists as $item):
                            $is_disable = (isset($item['is_disable'])) ? $item['is_disable'] : 'no';
                            $icons      = (isset($item['twl_icons'])) ? $item['twl_icons'] : '';
                            $twl_items  = (isset($item['twl_items'])) ? $item['twl_items'] : '';
                        ?>
                        <li <?php if($is_disable == 'yes'): ?>class="disable"<?php endif;?>>
                            <?php if($icons != ''): ?>
                                <i class="<?php echo esc_attr($icons); ?>"></i>
                            <?php endif; ?>
                            <?php echo wp_kses_post($twl_items); ?>
                        </li>
                        <?php 
                        $i++;
                        endforeach;
                        ?>
                    </ul>
                    <?php endif; ?>
                    <?php if($pricing_btn != ''): ?>
                    <a class="berpo_btn" <?php echo esc_attr($target.' '.$nofollow); ?> href="<?php echo esc_url($btn_url); ?>">
                        <span class="bp-shape"></span>
                        <span class="bp-shape"></span>
                        <span class="bp-shape"></span>
                        <span class="bp-shape"></span>
                        <span class="bp-text"><?php echo esc_html($pricing_btn); ?></span>
                    </a>
                <?php endif; ?>
                </div>
            </div>
            <?php
        endif;
    }
    
    protected function content_template() {}
    
}