<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Post_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-post-widget';
    }
    
    public function get_title() {
        return esc_html__( 'Posts Widgets', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-post-list';
    }

    public function get_categories() {
        return [ 'bepro-footer-elements' ];
    }
    
    protected function register_controls() {

        $lb = array(
            'post_type'         => 'post',
            'post_status'       => 'publish',
            'order_by'          => 'date',
            'order'             => 'DESC',
            'posts_per_page'    => -1
        );
        $lbs = array();
        query_posts($lb);
            if(have_posts()):
                while (have_posts()):
                    the_post();
                    $lbs[get_the_ID()] = get_the_title();
                endwhile;
            endif;
        wp_reset_query();
        
        $this->start_controls_section(
            'section_tab', [
                'label' => esc_html__( 'Post', 'themewar' ),
            ]
        );
        $this->add_control(
                'lb_post_style',
                [
                        'label' => esc_html__( 'Post Style', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 1,
                        'options' => [
                                1                 => esc_html__( 'Style 01', 'themewar' ),
                                2                 => esc_html__( 'Style 02', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'sub_title', [
                    'label'             => esc_html__('Sub Title', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'label_block'       => TRUE,
                    'default'           => esc_html__('Clean & Flexible', 'themewar'),
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'lb_post_style',
                                    'operator'  => 'in',
                                    'value'     => ['1'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_control(
                'widget_title', [
                    'label'             => esc_html__('Widget Title', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'label_block'       => TRUE,
                    'default'           => esc_html__('Latest Post', 'themewar'),
                ]
        );
        $this->add_control(
                'lb_specific',
                [
                        'label'         => esc_html__( 'Specific Post', 'themewar' ),
                        'type'          => Controls_Manager::SELECT2,
                        'label_block'   => TRUE,
                        'multiple'      => true,
                        'default'       => array('0'),
                        'options'       => $lbs,
                ]
        );
        $this->add_control(
                'lb_post_item',
                [
                        'label'         => esc_html__( 'Number Of Item', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'min'           => 1,
                        'max'           => 200,
                        'step'          => 1,
                        'default'       => 3,
                        'description'   => esc_html__( 'How many item you want to show.', 'themewar' ),
                ]
        );
        $this->add_control(
                'lb_order_by',
                [
                        'label' => esc_html__( 'Order By', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 'date',
                        'options' => [
                                'date'                  => esc_html__( 'Date', 'themewar' ),
                                'title'                 => esc_html__( 'Title', 'themewar' ),
                                'rand'                  => esc_html__( 'Random', 'themewar' ),
                                'comment_count'         => esc_html__( 'Comment', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'lb_order',
                [
                        'label' => esc_html__( 'Order', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 'desc',
                        'options' => [
                                'asc'        => esc_html__( 'Ascending', 'themewar' ),
                                'desc'       => esc_html__( 'Descending', 'themewar' ),
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_sbtitle', [
                'label'         => esc_html__( 'Sub Title Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'        => [
                    'terms'         => [
                        [
                                'name'      => 'lb_post_style',
                                'operator'  => 'in',
                                'value'     => ['1'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
                'sbtitle_color', [
                        'label'      => esc_html__( 'Color', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .wsubtitle' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'sbtitle_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .wsubtitle',
                ]
        );
        $this->add_responsive_control(
                'sbtitle_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .wsubtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_2', [
                'label'         => esc_html__( 'Widget Title Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'st_color', [
                        'label'      => esc_html__( 'Color', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .fwtitle' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'st_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .fwtitle',
                ]
        );
        $this->add_responsive_control(
                'st_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .fwtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'st_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .fwtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'br_color_01', [
                        'label'      => esc_html__( 'Border Color 01', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .widget_title02:after' => 'background: {{VALUE}};'
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'lb_post_style',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'br_color_02', [
                        'label'      => esc_html__( 'Border Color 02', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .widget_title02:before' => 'background: {{VALUE}};'
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'lb_post_style',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'st_border_hr',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .fwtitle',
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'lb_post_style',
                                        'operator'  => '!in',
                                        'value'     => ['2'],
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_1', [
                    'label'         => esc_html__('Box Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
                'icon_box_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .pp_post_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pp_post_item02' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .pp_post_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pp_post_item02' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .pp_post_item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pp_post_item02' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'icon_box_bg',
                        'label' => esc_html__( 'Box Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .pp_post_item, {{WRAPPER}} .pp_post_item02',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'icon_box_shadow',
                        'label' => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .pp_post_item, {{WRAPPER}} .pp_post_item02',
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'box_border',
                        'label' => esc_html__( 'Box Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .pp_post_item, {{WRAPPER}} .pp_post_item02',
                ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_p_img', [
                'label'     => esc_html__( 'Image Styling', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'logo_box_height',
                [
                        'label'      => esc_html__( 'Height', 'themewar' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => 'px',
                        'range'      => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .pp_post_item img' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .pp_post_item02 img' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'logo_box_width',
                [
                        'label'      => esc_html__( 'Width', 'themewar' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => 'px',
                        'range'      => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .pp_post_item img' => 'width: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .pp_post_item02 img' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
            'post_img_radius',
            [
                    'label'      => esc_html__( 'Border Radius', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .pp_post_item img'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .pp_post_item02 img'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_p_title', [
                'label'  => esc_html__( 'Post Title Styling', 'themewar' ),
                'tab'    => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'p_title_color',
                [
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .pp_post_item a' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .pp_post_item02 a' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'p_title_hover_color',
                [
                        'label'     => esc_html__( 'Hover Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .pp_post_item a:hover' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .pp_post_item02 a:hover' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'p_title_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .pp_post_item a, {{WRAPPER}} .pp_post_item02 a',
                ]
        );
        $this->add_responsive_control(
                'p_title_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .pp_post_item a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pp_post_item02 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_p_desc', [
                'label'  => esc_html__( 'Date Styling', 'themewar' ),
                'tab'    => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'p_content_color',
                [
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .pp_post_item span' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .pp_post_item02 span' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'p_content_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .pp_post_item span, {{WRAPPER}} .pp_post_item02 span',
                ]
        );
        $this->add_responsive_control(
                'p_content_margin',
                [
                        'label' => esc_html__( 'Marign', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .pp_post_item span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .pp_post_item02 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'heading_date_icon',
            [
                'label'     => esc_html__( 'Icon Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after',
                'conditions'        => [
                    'terms'         => [
                        [
                                'name'      => 'lb_post_style',
                                'operator'  => '==',
                                'value'     => '2',
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
                'p_date_icon_color',
                [
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .pp_post_item02 span i' => 'color: {{VALUE}}',
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'lb_post_style',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'p_date_icon_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .pp_post_item02 span i',
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'lb_post_style',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_responsive_control(
                'p_date_icon_margin',
                [
                        'label' => esc_html__( 'Marign', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .pp_post_item02 span i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'conditions'        => [
                            'terms'         => [
                                [
                                        'name'      => 'lb_post_style',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings       = $this->get_settings_for_display();

        $lb_post_style  = (isset($settings['lb_post_style']) && $settings['lb_post_style'] > 0) ? $settings['lb_post_style'] : 1;

        $sub_title           = (isset($settings['sub_title']) && $settings['sub_title'] !='') ? $settings['sub_title'] : '';
        $widget_title        = (isset($settings['widget_title']) && $settings['widget_title'] !='') ? $settings['widget_title'] : '';

        $lb_specific    = (isset($settings['lb_specific']) && !empty($settings['lb_specific'])? $settings['lb_specific'] : array());
        
        $lb_post_item   = (isset($settings['lb_post_item']) && $settings['lb_post_item'] > 0) ? $settings['lb_post_item'] : 3;
        $lb_order_by    = (isset($settings['lb_order_by']) && $settings['lb_order_by'] != '') ? $settings['lb_order_by'] : 'date';
        $lb_order       = (isset($settings['lb_order']) && $settings['lb_order'] != '') ? $settings['lb_order'] : 'desc';

        include dirname(__FILE__).'/style/widget-post/style'.$lb_post_style.'.php';

    }
    
    protected function content_template() {}
}