<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Funfact_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-fun-facts';
    }
    
    public function get_title() {
        return esc_html__( 'Fun Fact', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-counter';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab_1', [
                'label' => esc_html__( 'Fun Fact', 'themewar' ),
            ]
        );
        $this->add_control(
                'funfact_style',
                [
                        'label'     => esc_html__( 'Fun Fact Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Style 01', 'themewar' ),
                                2       => esc_html__( 'Style 02', 'themewar' ),
                                3       => esc_html__( 'Style 03', 'themewar' ),
                                4       => esc_html__( 'Style 04', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'icon_or_image',
                [
                        'label'     => esc_html__( 'Icon Or Image', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Icon', 'themewar' ),
                                2       => esc_html__( 'Image', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'icons',
                [
                        'label'     => esc_html__( 'Icon', 'themewar' ),
                        'type'      => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'icon_or_image',
                                        'operator'  => '==',
                                        'value'     => '1',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'images',
                [
                        'label' => esc_html__( 'Choose Image', 'themewar' ),
                        'label_block'   => TRUE,
                        'type' => Controls_Manager::MEDIA,
                        'default' => [],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'icon_or_image',
                                        'operator'  => '==',
                                        'value'     => '2',
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'icon_position',
                [
                        'label'     => esc_html__( 'Icon Or Image Position', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Left', 'themewar' ),
                                2       => esc_html__( 'Right', 'themewar' ),
                                3       => esc_html__( 'Top', 'themewar' ),
                        ],
                        'conditions'    => [
                            'terms' => [
                                [
                                        'name'      => 'funfact_style',
                                        'operator'  => '!in',
                                        'value'     => ['3'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_control(
                'ff_number',
                [
                        'label'         => esc_html__( 'Fact Amount', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'default'       => esc_html__('1544', 'themewar'),
                        'placeholder'   => esc_html__('1544', 'themewar'),
                ]
        );
        $this->add_control(
                'yoe_suffix',
                [
                        'label'         => esc_html__( 'Number Suffix', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'description'   => esc_html__( 'Insert suffix for fact.', 'themewar' ),
                        'default'       => '',
                ]
        );
        $this->add_control(
                'ff_title',
                [
                        'label'         => esc_html__( 'Fact Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'label_block'   => TRUE,
                        'default'       => esc_html__('Satisfied Clients', 'themewar'),
                        'placeholder'   => esc_html__('fact title', 'themewar'),
                ]
        );
        $this->add_responsive_control(
                'ff_alignment', [
                        'label'                     => esc_html__( 'Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'       => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'     => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'      => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'                   => 'left',
                        'prefix_class'              => 'ff_content elementor%s-align-',
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_box', [
                    'label'         => esc_html__('Box Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
                'icon_box_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .countfact' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .countfact' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .countfact' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'ib_box_tot' );
            $this->start_controls_tab(
                'ib_box_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_bg',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .countfact',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .countfact',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'box_border',
                            'label' => esc_html__( 'Box Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .countfact',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_box_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_bg_hr',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .countfact:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_shadow_hr',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .countfact:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'box_border_hr',
                            'label' => esc_html__( 'Box Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .countfact:hover',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
                'icon_box_hover_all_con_color',[
                        'label'     => esc_html__( 'Hover All Content Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .countfact:hover *' => 'color: {{VALUE}}',
                        ]
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_2',[
                    'label'         => esc_html__('Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'icon_or_image',
                                    'operator'  => '!in',
                                    'value'     => ['2'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_i_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ffmeta'
                ]
        );
        $this->start_controls_tabs( 'ib_icon_tot' );
            $this->start_controls_tab(
                'ib_icon_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
            $this->add_responsive_control(
                    'icon_box_i_color',[
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .ffmeta' => 'color: {{VALUE}}',
                            ]
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_i_bg_color',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .ffmeta',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_icon_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_control(
                    'icon_box_i_color_hr',[
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .countfact:hover .ffmeta' => 'color: {{VALUE}}',
                            ]
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_i_bgcolor_hr',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .countfact:hover .ffmeta',
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
                'icon_box_i_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .ffmeta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_responsive_control(
                    'icon_box_i_width',
                    [
                            'label' => __( 'Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ffmeta' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_i_height',
                    [
                            'label' => __( 'Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ffmeta' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'icon_box_i_border_hr',
                            'label' => esc_html__( 'Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ffmeta',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_i__shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ffmeta',
                    ]
            );
            $this->add_control(
                    'icon_box_i_padding',
                    [
                            'label' => esc_html__( 'Paddings', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .ffmeta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
            $this->add_control(
                    'icon_box_i_margin',
                    [
                            'label' => esc_html__( 'Margins', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                    '{{WRAPPER}} .ffmeta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_img',[
                    'label'         => esc_html__('Image Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'icon_or_image',
                                    'operator'  => '!in',
                                    'value'     => ['1'],
                            ]
                        ],
                    ],
                ]
        );
        $this->start_controls_tabs( 'ib_img_tot' );
            $this->start_controls_tab(
                'ib_img_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_img_bgcolor',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .ffmeta',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_img_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_img_bgcolor_hr',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .countfact:hover .ffmeta',
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                    'icon_box_area_img_width',
                    [
                            'label' => esc_html__( 'Area Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ffmeta' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_area_img_height',
                    [
                            'label' => esc_html__( 'Area Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ffmeta' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_img_width',
                    [
                            'label' => esc_html__( 'Image Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ffmeta img' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_img_height',
                    [
                            'label' => esc_html__( 'Image Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ffmeta img' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_img_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ffmeta',
                    ]
            );
            $this->add_control(
                    'icon_box_img_radius',
                    [
                            'label' => esc_html__( 'Border Radius', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .ffmeta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
            $this->add_control(
                    'icon_box_img_padding',
                    [
                            'label' => esc_html__( 'Paddings', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .ffmeta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
            $this->add_control(
                    'icon_box_img_margin',
                    [
                            'label' => esc_html__( 'Margins', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .ffmeta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_3', [
                    'label'         => esc_html__('Count Number Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        ); 
        $this->add_responsive_control(
                'ff_num_color',
                [
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .fcount' => 'color: {{VALUE}}',
                        ],
                ]
        );    
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'ff_num_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .fcount',
                ]
        );
        $this->add_responsive_control(
                'ff_num_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .fcount' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
            'heading_un_one',
            [
                'label'     => esc_html__( 'Number Suffix Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
                'heading1_color', [
                        'label'      => esc_html__( 'Color', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .fcount sup' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'heading1_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .fcount sup',
                ]
        );
        $this->add_responsive_control(
                'mt_margin',
                [
                        'label' => esc_html__( 'Marign', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .fcount sup' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_4', [
                    'label'         => esc_html__('Fact Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        ); 
        $this->add_control(
                'ff_title_color',
                [
                        'label'     => esc_html__( 'Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ftitle' => 'color: {{VALUE}}',
                        ],
                ]
        );    
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'ff_title_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .ftitle',
                ]
        );
        $this->add_control(
                'ff_title_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .ftitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();

    }
    
    protected function render() {
        $settings        = $this->get_settings_for_display();

        $funfact_style   = (isset($settings['funfact_style']) && $settings['funfact_style'] > 0) ? $settings['funfact_style'] : 1;
        $icon_or_image   = (isset($settings['icon_or_image']) && $settings['icon_or_image'] > 0 ) ? $settings['icon_or_image'] : 1;
        $icons           = (isset($settings['icons']) && $settings['icons'] != '') ? $settings['icons'] : 'bpro-users';
        $images          = (isset($settings['images']['url']) && $settings['images']['url'] != '') ? $settings['images']['url'] : '';

        $ff_number    = (isset($settings['ff_number']) && $settings['ff_number'] != '') ? $settings['ff_number'] : 1544;
        $yoe_suffix   = (isset($settings['yoe_suffix']) && $settings['yoe_suffix'] != '') ? $settings['yoe_suffix'] : '';
        $f_icons      = (isset($settings['f_icons']) && $settings['f_icons'] != '') ? $settings['f_icons'] : 'icon-review';
        $ff_title     = (isset($settings['ff_title']) && $settings['ff_title'] != '') ? $settings['ff_title'] : esc_html__('Satisfied Clients', 'themewar');

        $icon_position   = (isset($settings['icon_position']) && $settings['icon_position'] > 0 ) ? $settings['icon_position'] : 1;

        $icpos = '';
        if($icon_position == 2):
            $icpos .= 'imRight';
        elseif ($icon_position == 3):
            $icpos .= 'imTop';
        else:
            $icpos .= 'imLeft';
        endif;

        if($funfact_style == 2):
        ?>
        <div class="funfact02 countfact <?php echo esc_attr($icpos); ?>" data-count="<?php echo esc_html($ff_number); ?>">
            <div class="ffmeta">
                <?php 
                    if($icon_or_image == 2 && $images != ''):
                        echo '<img src="'.esc_url($images).'" alt="'.esc_html__('Icon Image', 'themewar').'"/>';
                    else:
                        echo '<i class="'. esc_attr($icons).'"></i>';
                    endif;
                ?>
            </div>
            <h2 class="fcount"><span class="counter" data-count="<?php echo esc_attr($ff_number); ?>"><?php echo wp_kses_post($ff_number); ?></span><?php if($yoe_suffix != ''): ?><sup><?php echo esc_html($yoe_suffix); ?></sup><?php endif; ?></h2>
            <?php if($ff_title != ''): ?>
                <h5 class="ftitle"><?php echo wp_kses_post($ff_title); ?></h5>
            <?php endif; ?>
        </div>
        <?php
        elseif($funfact_style == 3):
        ?>
        <div class="funfact03 countfact" data-count="<?php echo esc_html($ff_number); ?>">
            <div class="ffmeta">
                <?php 
                    if($icon_or_image == 2 && $images != ''):
                        echo '<img src="'.esc_url($images).'" alt="'.esc_html__('Icon Image', 'themewar').'"/>';
                    else:
                        echo '<i class="'. esc_attr($icons).'"></i>';
                    endif;
                ?>
            </div>
            <h2 class="fcount"><span class="counter" data-count="<?php echo esc_attr($ff_number); ?>"><?php echo wp_kses_post($ff_number); ?></span><?php if($yoe_suffix != ''): ?><sup><?php echo esc_html($yoe_suffix); ?></sup><?php endif; ?></h2>
            <?php if($ff_title != ''): ?>
                <h5 class="ftitle"><?php echo wp_kses_post($ff_title); ?></h5>
            <?php endif; ?>
        </div>
        <?php
        elseif($funfact_style == 4):
        ?>
        <div class="funfact04 countfact <?php echo esc_attr($icpos); ?>" data-count="<?php echo esc_html($ff_number); ?>">
            <div class="ffmeta">
                <?php 
                    if($icon_or_image == 2 && $images != ''):
                        echo '<img src="'.esc_url($images).'" alt="'.esc_html__('Icon Image', 'themewar').'"/>';
                    else:
                        echo '<i class="'. esc_attr($icons).'"></i>';
                    endif;
                ?>
            </div>
            <h2 class="fcount"><span class="counter" data-count="<?php echo esc_attr($ff_number); ?>"><?php echo wp_kses_post($ff_number); ?></span><?php if($yoe_suffix != ''): ?><sup><?php echo esc_html($yoe_suffix); ?></sup><?php endif; ?></h2>
            <?php if($ff_title != ''): ?>
                <h5 class="ftitle"><?php echo wp_kses_post($ff_title); ?></h5>
            <?php endif; ?>
        </div>
        <?php
        else:
        ?>
        <div class="funfact countfact <?php echo esc_attr($icpos); ?>" data-count="<?php echo esc_html($ff_number); ?>">
            <div class="ffmeta">
                <?php 
                    if($icon_or_image == 2 && $images != ''):
                        echo '<img src="'.esc_url($images).'" alt="'.esc_html__('Icon Image', 'themewar').'"/>';
                    else:
                        echo '<i class="'. esc_attr($icons).'"></i>';
                    endif;
                ?>
            </div>
            <h2 class="fcount"><span class="counter" data-count="<?php echo esc_attr($ff_number); ?>"><?php echo wp_kses_post($ff_number); ?></span><?php if($yoe_suffix != ''): ?><sup><?php echo esc_html($yoe_suffix); ?></sup><?php endif; ?></h2>
            <?php if($ff_title != ''): ?>
                <h5 class="ftitle"><?php echo wp_kses_post($ff_title); ?></h5>
            <?php endif; ?>
        </div>
        <?php
        endif;
    }
    
    protected function content_template() {}
}