<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Contact_Info_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-contact-info';
    }
    
    public function get_title() {
        return esc_html__( 'Contact Info Box', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-icon-box';
    }

    public function get_categories() {
        return [ 'bepro-footer-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' => esc_html__( 'Info Box', 'themewar' ),
            ]
        );
        $this->add_control(
                'icon_box_style',
                [
                        'label'     => esc_html__( 'Box Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Style 01', 'themewar' ),
                                2       => esc_html__( 'Style 02', 'themewar' ),
                                3       => esc_html__( 'Style 03', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'widget_title', [
                    'label'             => esc_html__('Widget Title', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'label_block'       => TRUE,
                    'default'           => '',
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'icon_box_style',
                                    'operator'  => '!in',
                                    'value'     => ['2'],
                            ]
                        ],
                    ],
                ]
        );
        $repeaters = new \Elementor\Repeater();
        $repeaters->add_control(
                'icons',
                [
                        'label'         => esc_html__( 'Icon', 'themewar' ),
                        'type'          => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                        'description'   => esc_html__('This option work only style 02 and 03?', 'themewar'),
                ]
        );
        $repeaters->add_control(
                'box_title',
                [
                        'label'         => esc_html__( 'Box Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('Box Title', 'themewar'),
                        'description'   => esc_html__('This option work only style 01?', 'themewar'),
                ]
        );
        $repeaters->add_control(
                'box_desc',
                [
                        'label'         => esc_html__( 'Box Content', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'default'       => '',
                        'placeholder'   => esc_html__('Insert Content Here', 'themewar'),
                ]
        );
        $this->add_control(
            's_list',[
                    'label'         => esc_html__( 'Info Item', 'themewar' ),
                    'type'          => Controls_Manager::REPEATER,
                    'fields'        => $repeaters->get_controls(),
                    'default'       => [
                            [
                                    'icons'            => '',
                                    'box_title'        => '',
                                    'box_desc'         => '',
                            ],
                    ],
                    'title_field' => '{{{ box_title }}}',
            ]
        );
        $this->add_responsive_control(
                'box_alignment', [
                        'label'                     =>esc_html__( 'Box Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'       => [
                                        'title'  => esc_html__( 'Left', 'themewar' ),
                                        'icon'   => 'eicon-text-align-left',
                                ],
                                'center'     => [
                                        'title'  => esc_html__( 'Center', 'themewar' ),
                                        'icon'   => 'eicon-text-align-center',
                                ],
                                'right'      => [
                                        'title'  => esc_html__( 'Right', 'themewar' ),
                                        'icon'   => 'eicon-text-align-right',
                                ]
                        ],
                        'default'                   => 'left',
                        'prefix_class'              => 'box_holder elementor%s-align-',
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_wtitle', [
                'label'         => esc_html__( 'Widget Title Style', 'themewar' ),
                'tab'           => Controls_Manager::TAB_STYLE,
                'conditions'        => [
                    'terms'         => [
                        [
                                'name'      => 'icon_box_style',
                                'operator'  => '!in',
                                'value'     => ['2'],
                        ]
                    ],
                ],
            ]
        );
        $this->add_responsive_control(
                'st_color', [
                        'label'      => esc_html__( 'Color', 'themewar' ),
                        'type'       => Controls_Manager::COLOR,
                        'selectors'  => [
                            '{{WRAPPER}} .fwtitle' => 'color: {{VALUE}};'
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'st_typography',
                        'label'     => esc_html__( 'Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .fwtitle',
                ]
        );
        $this->add_responsive_control(
                'st_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .fwtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'st_margin',
                [
                        'label' => esc_html__( 'Marigns', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                            '{{WRAPPER}} .fwtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'st_border_hr',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .fwtitle',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_1', [
                    'label'         => esc_html__('Item Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_responsive_control(
                'icon_box_radius',
                [
                        'label' => esc_html__( 'Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cmiItem' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmiItem' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cmiItem' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'ib_box_tot' );
            $this->start_controls_tab(
                'ib_box_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_bg',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .cmiItem',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .cmiItem',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'box_border',
                            'label' => esc_html__( 'Box Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .cmiItem',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_box_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name' => 'icon_box_bg_hr',
                            'label' => esc_html__( 'Box Background', 'themewar' ),
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .cmiItem:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_shadow_hr',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .cmiItem:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                            'name' => 'box_border_hr',
                            'label' => esc_html__( 'Box Border', 'themewar' ),
                            'selector' => '{{WRAPPER}} .cmiItem:hover',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
                'icon_box_hover_all_con_color',[
                        'label'     => esc_html__( 'Hover All Content Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cmiItem:hover *' => 'color: {{VALUE}}',
                        ]
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_2',[
                    'label'         => esc_html__('Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'icon_box_style',
                                    'operator'  => '!in',
                                    'value'     => ['1'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_i_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cmiItem i'
                ]
        );
        $this->start_controls_tabs( 'ib_icon_tot' );
            $this->start_controls_tab(
                'ib_icon_nr', [ 'label' => esc_html__( 'Normal', 'themewar' )]
            );
            $this->add_control(
                    'icon_box_i_color',[
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .cmiItem i' => 'color: {{VALUE}}',
                            ]
                    ]
            );
            $this->add_control(
                    'icon_box_i_bgcolor',[
                            'label'     => esc_html__( 'Icon BG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .cmiItem i' => 'background: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                'ib_icon_hr', [ 'label' => esc_html__( 'Hover', 'themewar' )]
            );
            $this->add_control(
                    'icon_box_i_color_hr',[
                            'label'     => esc_html__( 'Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .cmiItem:hover i' => 'color: {{VALUE}}',
                            ]
                    ]
            );
            $this->add_control(
                    'icon_box_i_bgcolor_hr',[
                            'label'     => esc_html__( 'BG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .cmiItem:hover i' => 'background: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
                'icon_box_i_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .cmiItem i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_responsive_control(
                    'icon_box_i_width',
                    [
                            'label' => __( 'Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .cmiItem i' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_i_height',
                    [
                            'label' => __( 'Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .cmiItem i' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'icon_box_i__shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .cmiItem i',
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_i_padding',
                    [
                            'label' => esc_html__( 'Paddings', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .cmiItem i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
            $this->add_responsive_control(
                    'icon_box_i_margin',
                    [
                            'label' => esc_html__( 'Margins', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                    '{{WRAPPER}} .cmiItem i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ]
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_3',[
                    'label'         => esc_html__('Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'conditions'        => [
                        'terms'         => [
                            [
                                    'name'      => 'icon_box_style',
                                    'operator'  => '!in',
                                    'value'     => ['2', '3'],
                            ]
                        ],
                    ],
                ]
        );
        $this->add_responsive_control(
                'icon_box_title_color',[
                        'label'     => esc_html__( 'Title Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .contactbox h5' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .cmiItem span' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_title_typo',
                        'label'     => esc_html__( 'Title Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .contactbox h5, {{WRAPPER}} .cmiItem span',
                ]
        );
        $this->add_responsive_control(
                'icon_box_title_margin',
                [
                        'label'      => esc_html__( 'Title Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .contactbox h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .cmiItem span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_4', [
                    'label'         => esc_html__('Box Content Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_responsive_control(
                'icon_box_content_color',[
                        'label'     => esc_html__( 'Content Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .contactbox p' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .cmiItem' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_content_typo',
                        'label'     => esc_html__( 'Content Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .contactbox p, {{WRAPPER}} .cmiItem',
                ]
        );
        $this->add_responsive_control(
                'icon_box_content_margin',
                [
                        'label'      => esc_html__( 'Content Margin', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .contactbox p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .cmiItem' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings        = $this->get_settings_for_display();
        $icon_box_style  = (isset($settings['icon_box_style']) && $settings['icon_box_style'] > 0) ? $settings['icon_box_style'] : 1;
        $widget_title    = (isset($settings['widget_title']) && $settings['widget_title'] !='') ? $settings['widget_title'] : '';

        $s_list          = (isset($settings['s_list']) && !empty($settings['s_list'])) ? $settings['s_list'] : array();
        
        if($icon_box_style == 2):
            if(!empty($s_list)):
                foreach($s_list as $sl):
                    $icons          = (isset($sl['icons']) ? $sl['icons'] : '');
                    $box_title      = (isset($sl['box_title']) ? $sl['box_title'] : '');
                    $box_desc       = (isset($sl['box_desc']) ? $sl['box_desc'] : '');
                    
                    if($box_desc != ''):
                    ?>
                    <div class="abIcon cmiItem"><i class="<?php echo esc_attr($icons); ?>"></i><?php echo wp_kses_post($box_desc); ?></div>
                    <?php
                    endif;
                endforeach;
            endif;
        elseif($icon_box_style == 3):
            ?>
            <div class="widget">
                <?php if($widget_title != ''): ?>
                    <h3 class="widget_title04 fwtitle"><?php echo wp_kses_post($widget_title); ?></h3>
                <?php endif; ?>
                <?php
                    if(!empty($s_list)):
                        foreach($s_list as $sl):
                            $icons          = (isset($sl['icons']) ? $sl['icons'] : '');
                            $box_title      = (isset($sl['box_title']) ? $sl['box_title'] : '');
                            $box_desc       = (isset($sl['box_desc']) ? $sl['box_desc'] : '');
                            
                            if($box_desc != ''):
                            ?>
                            <div class="cinfo withIcon cmiItem"><i class="<?php echo esc_attr($icons); ?>"></i><?php echo wp_kses_post($box_desc); ?></div>
                            <?php
                            endif;
                        endforeach;
                    endif;
                ?>
            </div>
            <?php
        else:
            ?>
            <div class="widget">
                <?php if($widget_title != ''): ?>
                    <h3 class="widget_title03 fwtitle"><?php echo wp_kses_post($widget_title); ?></h3>
                <?php endif; ?>
                <?php 
                if(!empty($s_list)):
                    foreach($s_list as $sl):
                        $icons          = (isset($sl['icons']) ? $sl['icons'] : '');
                        $box_title      = (isset($sl['box_title']) ? $sl['box_title'] : '');
                        $box_desc       = (isset($sl['box_desc']) ? $sl['box_desc'] : '');
                        
                        if($box_desc != ''):
                        ?>
                        <div class="cinfo cmiItem"><?php if($box_title != ''): ?><span><?php echo wp_kses_post($box_title); ?></span><?php endif; ?><?php echo wp_kses_post($box_desc); ?></div>
                        <?php
                        endif;
                    endforeach;
                endif;
                ?>
            </div>
            <?php
        endif;
        
    }
    
    protected function content_template() {}
    
}