<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Accordion_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-accordion';
    }
    
    public function get_title() {
        return esc_html__( 'Accordion', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-accordion';
    }

    public function get_categories() {
        return [ 'bepro-elements' ];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'section_tab_1', [
                'label'     => esc_html__( 'Accordion', 'themewar' ),
            ]
        );
        $this->add_control(
                'acc_style',
                [
                        'label' => esc_html__( 'Accordion Style', 'themewar' ),
                        'type'  => Controls_Manager::SELECT,
                        'default' => 1,
                        'options' => [
                                1                 => esc_html__( 'Style 01', 'themewar' ),
                                2                 => esc_html__( 'Style 02', 'themewar' ),
                                3                 => esc_html__( 'Style 03', 'themewar' ),
                                4                 => esc_html__( 'Style 04', 'themewar' ),
                        ],
                ]
        );
        $repeater = new \Elementor\Repeater();
            $repeater->add_control(
                    'accr_title',
                    [
                            'label'         => esc_html__( 'Accordion Title', 'themewar' ),
                            'type'          => Controls_Manager::TEXT,
                            'default'       => esc_html__('Accordion Title', 'themewar'),
                            'label_block'   => true,
                            'placeholder'   => esc_html__('Insert accordion title', 'themewar')
                    ]
            );
            $repeater->add_control(
                    'is_expand',
                    [
                            'label'             => esc_html__( 'Is Expand?', 'themewar' ),
                            'type'              => Controls_Manager::SWITCHER,
                            'label_on'          => esc_html__( 'Yes', 'themewar' ),
                            'label_off'         => esc_html__( 'No', 'themewar' ),
                            'description'       => esc_html__('Do you want to make this item expand?', 'themewar'),
                            'return_value'      => 'yes',
                            'default'           => 'no',
                    ]
            );
            $repeater->add_control(
                    'accr_content',
                    [
                            'label'     => esc_html__( 'Content', 'themewar' ),
                            'type'      => Controls_Manager::WYSIWYG,
                            'default'   => esc_html__('Insert accordion content here.'),
                            'placeholder'   => esc_html__('Insert accordion content', 'themewar')
                    ]
        );
        $this->add_control(
                    'list',
                    [
                            'label'         => esc_html__( 'Accordion Item', 'themewar' ),
                            'type'          => Controls_Manager::REPEATER,
                            'fields'        => $repeater->get_controls(),
                            'default'       => [
                                    [
                                            'accr_title'       => esc_html__( '', 'themewar' ),
                                            'is_expand'        => 'no',
                                            'accr_content'     => esc_html__( '', 'themewar' ),

                                    ],
                            ],
                            'title_field' => '{{{ accr_title }}}',
                    ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2',
            [
                'label'     => esc_html__('Accordion Card Style', 'themewar'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
                'ac_card_margin',
                [
                        'label' => esc_html__( 'Card Margin', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .bepAccordion .card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_responsive_control(
                'ac_card_padding',
                [
                        'label' => esc_html__( 'Card Padding', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .bepAccordion .card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'ac_card_bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .bepAccordion .card',
                ]
        );
        $this->add_control(
            'heading_un_one',
            [
                'label'     => esc_html__( 'Hover BG Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'acc_style',
                                    'operator'  => 'in',
                                    'value'     => ['4'],
                            ]
                        ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'ac_hover_card_bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .bepAccordion .card:hover',
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'acc_style',
                                            'operator'  => 'in',
                                            'value'     => ['4'],
                                    ]
                                ],
                        ],
                ]
        );
        $this->add_control(
            'heading_un_active_one',
            [
                'label'     => esc_html__( 'Active BG Style', 'themewar' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions'    => [
                        'terms' => [
                            [
                                    'name'      => 'acc_style',
                                    'operator'  => 'in',
                                    'value'     => ['4'],
                            ]
                        ],
                ],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'ac_active_card_bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .bepAccordion .card.activeBg',
                        'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'acc_style',
                                            'operator'  => 'in',
                                            'value'     => ['4'],
                                    ]
                                ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'ac_card_border',
                        'label' => esc_html__( 'Card Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .bepAccordion .card',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name' => 'ac_card_shadow',
                        'label' => esc_html__( 'Card Shadow', 'themewar' ),
                        'selector' => '{{WRAPPER}} .bepAccordion .card',
                ]
        );
        $this->add_responsive_control(
            'ac_card_border_radius',
            [
                    'label'      => esc_html__( 'Border Radius', 'themewar' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .bepAccordion .card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_3',
            [
                'label'     => esc_html__('Card Head Style', 'themewar'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                            'name'      => 'ac_heading_typography',
                            'label'     => esc_html__( 'Card Heading Typo', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .bepAccordion .card .card-header h2 button',
                    ]
            );
            $this->add_responsive_control(
                    'ac_heading_padding',
                    [
                            'label' => esc_html__( 'Card Heading Padding', 'themewar' ),
                            'type'  => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .bepAccordion .card .card-header h2 button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_responsive_control(
                'btn_icon_margin',
                [
                        'label' => esc_html__( 'Plus Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px'],
                        'allowed_dimensions' => ['top', 'right'],
                        'selectors' => [
                            '{{WRAPPER}} .bepAccordion .card .card-header h2 button span' => 'right: {{RIGHT}}{{UNIT}}; top: {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->start_controls_tabs( 'ac_headeing_tabs' );
                $this->start_controls_tab(
                        'ac_head_tab_normal',
                        [
                                'label' => esc_html__( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_responsive_control(
                        'ac_heading_coolor',[
                                'label'     => esc_html__( 'Heading Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .bepAccordion .card .card-header h2 button.collapsed' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'ac_heading_number_coolor',[
                                'label'     => esc_html__( 'Number Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .bepAccordion .card .card-header h2 button.collapsed i' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'ac_plus_bg_coolor',[
                                'label'     => esc_html__( 'Plus BG Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .bepAccordion.peracc03 .card .card-header h2 button.collapsed span'  => 'background: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'acc_style',
                                                'operator'  => 'in',
                                                'value'     => ['3'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'ac_plus_card_shadow',
                                'label' => esc_html__( 'Card Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .bepAccordion.peracc03 .card .card-header h2 button.collapsed span',
                                'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'acc_style',
                                                'operator'  => 'in',
                                                'value'     => ['3'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_responsive_control(
                    'ac_plus_card_border_radius',
                    [
                            'label'      => esc_html__( 'Border Radius', 'themewar' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .bepAccordion.peracc03 .card .card-header h2 button.collapsed span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'conditions'    => [
                                'terms' => [
                                    [
                                            'name'      => 'acc_style',
                                            'operator'  => 'in',
                                            'value'     => ['3'],
                                    ]
                                ],
                            ],
                    ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'heading_normal_bg',
                                'label' => esc_html__( 'Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .bepAccordion .card .card-header h2 button.collapsed',
                                'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'acc_style',
                                                'operator'  => 'in',
                                                'value'     => ['2'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'ac_heading_bg',[
                                'label'     => esc_html__( 'Heading BG', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .bepAccordion .card .card-header h2 button.collapsed' => 'background: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'acc_style',
                                                'operator'  => '!in',
                                                'value'     => ['2'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'ac_head_tab_hover',
                        [
                                'label' => esc_html__( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_responsive_control(
                        'ac_heading_coolor_hov',[
                                'label'     => esc_html__( 'Heading Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .bepAccordion .card .card-header h2 button:hover' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'ac_heading_number_coolor_hov',[
                                'label'     => esc_html__( 'Number Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .bepAccordion .card .card-header h2 button:hover i' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'ac_icon_coolor_hov',[
                                'label'     => esc_html__( 'Plus Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .bepAccordion .card .card-header h2 button:hover span:after'   => 'background: {{VALUE}}',
                                    '{{WRAPPER}} .bepAccordion .card .card-header h2 button:hover span:before'  => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'ac_plus_hover_bg_coolor',[
                                'label'     => esc_html__( 'Plus BG Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .bepAccordion.peracc03 .card .card-header h2 button:hover span'  => 'background: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'acc_style',
                                                'operator'  => 'in',
                                                'value'     => ['3'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'ac_plus_hover_card_shadow',
                                'label' => esc_html__( 'Card Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .bepAccordion.peracc03 .card .card-header h2 button:hover span',
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'acc_style',
                                                'operator'  => 'in',
                                                'value'     => ['3'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'heading_hover_bg',
                                'label' => esc_html__( 'Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .bepAccordion .card .card-header h2 button:hover',
                                'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'acc_style',
                                                'operator'  => 'in',
                                                'value'     => ['2'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'ac_heading_bg_hov',[
                                'label'     => esc_html__( 'Heading BG', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .bepAccordion .card .card-header h2 button:hover' => 'background: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'acc_style',
                                                'operator'  => '!in',
                                                'value'     => ['2'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'ac_head_tab_active',
                        [
                                'label' => esc_html__( 'Active', 'themewar' ),
                        ]
                );
                $this->add_responsive_control(
                        'ac_heading_coolor_act',[
                                'label'     => esc_html__( 'Heading Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .bepAccordion .card .card-header h2 button:not(.collapsed)' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .bepAccordion .card.activeBg .card-header h2 button' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'ac_heading_normal_coolor_act',[
                                'label'     => esc_html__( 'Number Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .bepAccordion .card .card-header h2 button:not(.collapsed) i' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .bepAccordion .card.activeBg .card-header h2 button i' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'ac_icon_coolor_act',[
                                'label'     => esc_html__( 'Minus Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .bepAccordion .card .card-header h2 button:not(.collapsed) span:after'  => 'background: {{VALUE}}',
                                    '{{WRAPPER}} .bepAccordion .card.activeBg .card-header h2 button span:after'  => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'ac_plus_active_bg_coolor',[
                                'label'     => esc_html__( 'Plus BG Color', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .bepAccordion.peracc03 .card .card-header h2 button:not(.collapsed) span' => 'background: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'acc_style',
                                                'operator'  => 'in',
                                                'value'     => ['3'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                                'name' => 'ac_plus_active_card_shadow',
                                'label' => esc_html__( 'Card Shadow', 'themewar' ),
                                'selector' => '{{WRAPPER}} .bepAccordion.peracc03 .card .card-header h2 button:not(.collapsed) span',
                                'conditions'    => [
                                    'terms'     => [
                                        [
                                                'name'      => 'acc_style',
                                                'operator'  => 'in',
                                                'value'     => ['3'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                                'name' => 'heading_active_bg',
                                'label' => esc_html__( 'Background', 'themewar' ),
                                'types' => [ 'classic', 'gradient'],
                                'selector' => '{{WRAPPER}} .bepAccordion.peracc02 .card .card-header h2 button:before',
                                'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'acc_style',
                                                'operator'  => 'in',
                                                'value'     => ['2'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->add_responsive_control(
                        'ac_heading_bg_act',[
                                'label'     => esc_html__( 'Heading BG', 'themewar' ),
                                'type'      => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .bepAccordion .card .card-header h2 button:not(.collapsed)' => 'background: {{VALUE}}',
                                    '{{WRAPPER}} .bepAccordion .card.activeBg .card-header h2 button' => 'background: {{VALUE}}',
                                ],
                                'conditions'    => [
                                    'terms' => [
                                        [
                                                'name'      => 'acc_style',
                                                'operator'  => '!in',
                                                'value'     => ['2'],
                                        ]
                                    ],
                                ],
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_4',
            [
                'label'     => esc_html__('Card Body Style', 'themewar'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'ac_body_bg',
                        'label' => esc_html__( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .card-body',
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'ac_body_typography',
                        'label'     => esc_html__( 'Global Typo', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .card-body',
                ]
        );
        $this->add_responsive_control(
                'ac_body_color',[
                        'label'     => esc_html__( 'Global Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .card-body' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_responsive_control(
                'ac_body_active_coolor',[
                        'label'     => esc_html__( 'Active Body Content Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .bepAccordion .card.activeBg .card-body'  => 'color: {{VALUE}}',
                        ],
                        'conditions'    => [
                            'terms'     => [
                                [
                                        'name'      => 'acc_style',
                                        'operator'  => 'in',
                                        'value'     => ['4'],
                                ]
                            ],
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'ac_body_heading_typography',
                        'label'     => esc_html__( 'Card Heading Typo', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .card-body h1, {{WRAPPER}} .card-body h2, {{WRAPPER}} .card-body h3, {{WRAPPER}} .card-body h4, {{WRAPPER}} .card-body h5, {{WRAPPER}} .card-body h6',
                ]
        );
        $this->add_responsive_control(
                'ac_body_heading_color',[
                        'label'     => esc_html__( 'Card Heading Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .card-body h1' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .card-body h2' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .card-body h3' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .card-body h4' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .card-body h5' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .card-body h6' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'ac_body_card_border',
                        'label' => esc_html__( 'Card Body Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .card-body',
                ]
        );
        $this->add_responsive_control(
                'ac_card_body_padding',
                [
                        'label' => esc_html__( 'Card Body Padding', 'themewar' ),
                        'type'  => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .card-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings       = $this->get_settings_for_display();

        $acc_style      = (isset($settings['acc_style']) && $settings['acc_style'] > 0) ? $settings['acc_style'] : 1;
        
        $list           = (isset($settings['list']) && !empty($settings['list'])) ? $settings['list'] : array();
        $tabs_id        = uniqid('tw-accordion-');
        if($acc_style == 2):    
            if(count($list) > 0):
                ?>
                <div id="<?php echo esc_attr($tabs_id); ?>" class="accordion bepAccordion peracc02">
                    <?php 
                        $i = 1;
                        foreach ($list as $key => $item):
                            $accr_title    = (isset($item['accr_title'])) ? $item['accr_title'] : '';
                            $is_expand     = (isset($item['is_expand'])) ? $item['is_expand'] : 'no';
                            $accr_content  = (isset($item['accr_content'])) ? $item['accr_content'] : '';
                            if($accr_title != '' && $accr_content != ''):
                            ?>
                            <div class="card">
                                <div class="card-header" id="bp_ac_<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>">
                                    <h2 class="mb-0">
                                        <button class="<?php if($is_expand != 'yes'){ echo 'collapsed'; } ?>" type="button" data-toggle="collapse" data-target="#<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" data-aria-expanded="<?php if($is_expand == 'yes'){ echo 'true'; }else{ echo 'false'; } ?>" data-aria-controls="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>">
                                            <?php echo wp_kses_post($accr_title); ?>
                                            <span></span>
                                        </button>
                                    </h2>
                                </div>
                                <div id="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" class="collapse <?php if($is_expand == 'yes'){ echo 'show'; } ?>" data-parent="#<?php echo esc_attr($tabs_id); ?>">
                                    <div class="card-body">
                                        <?php echo do_shortcode($accr_content); ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                            $i++;
                            endif;
                        endforeach;
                    ?>
                </div>
                <?php
            endif;
        elseif($acc_style == 3):    
            if(count($list) > 0):
                ?>
                <div id="<?php echo esc_attr($tabs_id); ?>" class="accordion bepAccordion peracc03">
                    <?php 
                        $i = 1;
                        foreach ($list as $key => $item):
                            $accr_title    = (isset($item['accr_title'])) ? $item['accr_title'] : '';
                            $is_expand     = (isset($item['is_expand'])) ? $item['is_expand'] : 'no';
                            $accr_content  = (isset($item['accr_content'])) ? $item['accr_content'] : '';
                            if($accr_title != '' && $accr_content != ''):
                            ?>
                            <div class="card">
                                <div class="card-header" id="bp_ac_<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>">
                                    <h2 class="mb-0">
                                        <button class="<?php if($is_expand != 'yes'){ echo 'collapsed'; } ?>" type="button" data-toggle="collapse" data-target="#<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" data-aria-expanded="<?php if($is_expand == 'yes'){ echo 'true'; }else{ echo 'false'; } ?>" data-aria-controls="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>">
                                            <span></span>
                                            <?php echo wp_kses_post($accr_title); ?>
                                        </button>
                                    </h2>
                                </div>
                                <div id="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" class="collapse <?php if($is_expand == 'yes'){ echo 'show'; } ?>" data-parent="#<?php echo esc_attr($tabs_id); ?>">
                                    <div class="card-body">
                                        <?php echo do_shortcode($accr_content); ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                            $i++;
                            endif;
                        endforeach;
                    ?>
                </div>
                <?php
            endif;
        elseif($acc_style == 4):    
            if(count($list) > 0):
                ?>
                <div id="<?php echo esc_attr($tabs_id); ?>" class="accordion bepAccordion">
                    <?php 
                        $i = 1;
                        foreach ($list as $key => $item):
                            $accr_title    = (isset($item['accr_title'])) ? $item['accr_title'] : '';
                            $is_expand     = (isset($item['is_expand'])) ? $item['is_expand'] : 'no';
                            $accr_content  = (isset($item['accr_content'])) ? $item['accr_content'] : '';
                            if($accr_title != '' && $accr_content != ''):
                            ?>
                            <div class="card <?php if($is_expand == 'yes'){ echo 'activeBg'; } ?>">
                                <div class="faqInner">
                                    <div class="card-header" id="bp_ac_<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>">
                                        <h2 class="mb-0">
                                            <button class="<?php if($is_expand != 'yes'){ echo 'collapsed'; } ?>" type="button" data-toggle="collapse" data-target="#<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" data-aria-expanded="<?php if($is_expand == 'yes'){ echo 'true'; }else{ echo 'false'; } ?>" data-aria-controls="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>">
                                                <i><?php echo $i.'.'; ?></i> <?php echo wp_kses_post($accr_title); ?>
                                                <span></span>
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" class="collapse <?php if($is_expand == 'yes'){ echo 'show'; } ?>" data-parent="#<?php echo esc_attr($tabs_id); ?>">
                                        <div class="card-body">
                                            <?php echo do_shortcode($accr_content); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php
                            $i++;
                            endif;
                        endforeach;
                    ?>
                </div>
                <?php
            endif;
        else:
            if(count($list) > 0):
                ?>
                <div id="<?php echo esc_attr($tabs_id); ?>" class="accordion bepAccordion">
                    <?php 
                        $i = 1;
                        foreach ($list as $key => $item):
                            $accr_title    = (isset($item['accr_title'])) ? $item['accr_title'] : '';
                            $is_expand     = (isset($item['is_expand'])) ? $item['is_expand'] : 'no';
                            $accr_content  = (isset($item['accr_content'])) ? $item['accr_content'] : '';
                            if($accr_title != '' && $accr_content != ''):
                            ?>
                            <div class="card">
                                <div class="card-header" id="bp_ac_<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>">
                                    <h2 class="mb-0">
                                        <button class="<?php if($is_expand != 'yes'){ echo 'collapsed'; } ?>" type="button" data-toggle="collapse" data-target="#<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" data-aria-expanded="<?php if($is_expand == 'yes'){ echo 'true'; }else{ echo 'false'; } ?>" data-aria-controls="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>">
                                            <i><?php echo $i.'.'; ?></i> <?php echo wp_kses_post($accr_title); ?>
                                            <span></span>
                                        </button>
                                    </h2>
                                </div>
                                <div id="<?php echo esc_attr($tabs_id . '-' . ($key + 1)); ?>" class="collapse <?php if($is_expand == 'yes'){ echo 'show'; } ?>" data-parent="#<?php echo esc_attr($tabs_id); ?>">
                                    <div class="card-body">
                                        <?php echo do_shortcode($accr_content); ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                            $i++;
                            endif;
                        endforeach;
                    ?>
                </div>
                <?php
            endif;
        endif;
    }
    
    protected function content_template() {}
}