<?php
    $pro = array(
        'post_type'         => array('product'),
        'post_status'       => array('publish'),
        'posts_per_page'    => $post_item
    );
    if (($key = array_search(0, $product_category)) !== false) {
        unset($product_category[$key]);
    }
    if(!empty($product_category)){
        $pro['tax_query']   = array(
            'relation'      => 'AND', 
            array(
                'taxonomy'  => 'product_cat', 
                'field'     => 'id', 
                'terms'     => $product_category,
                'operator'  => 'IN'
            ) 
        );
    }
    
    if($product_type == 2){
        if(isset($pro['tax_query'])):
            $pro['tax_query'][] = array(
                    'taxonomy' => 'product_visibility', 
                    'field' => 'name', 
                    'terms' => 'featured',
                    'operator' => 'IN',
            );
        else:
            $pro['tax_query']   = array(
                'relation' => 'AND', 
                array(
                    'taxonomy' => 'product_visibility', 
                    'field' => 'name', 
                    'terms' => 'featured',
                    'operator' => 'IN',
                ) 
            );
        endif;
        $pro['orderby'] = 'date';
        $pro['order']   = 'DESC';
    }
    elseif($product_type == 3){
        $pro['meta_query'] = array(
            array(
                'key' => '_sale_price',
                'value' => '',
                'compare' => '!='
            ),
        );
        $pro['orderby'] = 'date';
        $pro['order'] = 'DESC';
    }
    elseif($product_type == 4){
        $pro['meta_key']  = '_bepro_post_view';
        $pro['orderby'] = 'meta_value_num';
        $pro['order'] = 'DESC';
    }
    elseif($product_type == 5){
        $pro['meta_query'] = array(
            array(
                'key'   => 'total_sales',
                'value' => 0,
                'compare' => '>',
                'type' => 'DECIMAL',
            ),
        );
        $pro['orderby'] = 'meta_value_num';
        $pro['order'] = 'DESC';
    }
    elseif($product_type == 6){
        $pro['meta_query'] = array(
            array(
                'key' => '_wc_average_rating',
                'value' => 0,
                'compare' => '>',
                'type' => 'DECIMAL',
            ),
        );
        $pro['orderby'] = 'meta_value_num';
        $pro['order'] = 'DESC';
    }
    elseif($product_type == 7){
        $pro['orderby'] = 'rand';
    }
    else{
        $pro['orderby']           = 'date';
        $pro['order']             = 'DESC';
    }
    
    $pros = new WP_Query($pro);
    if($pros->have_posts()):
        $i = 1;
        ?>
        <div class="row woocommerce">
            <?php
                while($pros->have_posts()):
                    $pros->the_post();
                    $product = wc_get_product(get_the_ID());
                    ?>
                    <div class="col-xl-<?php echo (12 / $pr_column); ?> col-lg-4 col-md-6">
                        <div <?php wc_product_class('bepro_product_wrapper', $product); ?>>
                            <div class="productItem01">
                                <div class="proThumb">
                                    <img src="<?php echo bepro_post_thumbnail(get_the_ID(), 386, 400); ?>" alt="<?php echo get_the_title(); ?>">
                                    <?php if ($show_flashlabels == 'yes'): ?>
                                    <?php echo(function_exists('bepro_product_flash_notice_label') ? bepro_product_flash_notice_label() : '') ?>
                                    <?php endif; ?>
                                    <div class="piActionBtns">
                                        <?php if (shortcode_exists('yith_wcwl_add_to_wishlist') && $shop_is_wishlist_btn == 'yes'): ?>
                                            <?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
                                        <?php endif; ?>
                                        <?php function_exists('bepro_add_to_cart') ? bepro_add_to_cart() : '' ?>
                                        <a class="quickview" href="<?php echo get_the_permalink() ?>"><i class="bpro-search-icon"></i></a>
                                    </div>
                                </div>
                                <div class="product_content">
                                    <div class="ratings">
                                        <?php if (function_exists('woocommerce_template_loop_rating')): ?>
                                            <?php echo woocommerce_template_loop_rating(); ?>
                                        <?php endif; ?>
                                    </div>
                                    <h3><a href="<?php echo get_the_permalink() ?>"><?php echo get_the_title() ?></a></h3>
                                    <div class="pi01Price">
                                        <?php echo bepro_kses($product->get_price_html()); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    $i++;
                endwhile;
            ?>
        </div>
<?php endif; wp_reset_postdata(); ?>