<?php if ($is_header == 'yes'): ?>
    <!-- Header Start -->
    <header class="header02 <?php if ($is_sticky == 'yes'): ?>isSticky<?php endif; ?>">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="navbar01">
                        <div class="logo">
                            <?php if (!empty($logo)): ?>
                                <a href="<?php echo esc_url(home_url('/')); ?>">
                                    <img src="<?php echo esc_url($logo); ?>" alt="<?php echo get_bloginfo(); ?>"/>
                                </a>
                            <?php else: ?>
                                <a class="text" href="<?php echo esc_url(home_url('/')); ?>"><?php echo get_bloginfo('name'); ?></a>
                            <?php endif; ?>
                        </div>
                        <a href="javascript:void(0)" class="menu_btn"><i class="twi-bars2"></i></a>
                        <nav class="mainMenu">
                            <?php
                            if (has_nav_menu('primary-menu')) {
                                wp_nav_menu(array(
                                    'theme_location' => 'primary-menu',
                                    'container' => FALSE,
                                    'menu_class' => '',
                                    'menu_id' => '',
                                    'echo' => true
                                ));
                            } else {
                                if(is_user_logged_in()){
                                    echo '<ul>';
                                    echo '<li><a href="javascript:void(0)">' . esc_html__('No Menu', 'themewar') . '</a></li>';
                                    echo '</ul>';
                                }
                            }
                            ?>
                        </nav>
                        <div class="accessNav">
                            <?php if (!empty($s2_list)): ?>
                            <div class="topsocial">
                                <?php
                                    foreach ($s2_list as $sl):
                                        $s2_icons = (isset($sl['s2_icons']) ? $sl['s2_icons'] : '');
                                        $s2_url   = (isset($sl['s2_url']['url']) ? $sl['s2_url']['url'] : '');
                                        $target   = $sl['s2_url']['is_external'] ? ' target="_blank"' : '';
                                        $nofollow = $sl['s2_url']['nofollow'] ? ' rel="nofollow"' : '';

                                        if ($s2_icons != ''):
                                            ?>
                                            <a <?php echo esc_attr($target . ' ' . $nofollow); ?> href="<?php echo esc_url($s2_url); ?>"><i class="<?php echo esc_attr($s2_icons); ?>"></i></a>
                                        <?php
                                        endif;
                                    endforeach;
                                ?>
                            </div>
                            <?php endif; ?>
                            <?php if ($is_serch == 'yes'): ?>
                                <a class="search_btn" href="javascript:void(0);"><i class="twi-search1"></i></a>
                            <?php endif; ?>
                            <?php if ($is_info_boxs == 'yes'): ?>
                                <div class="infoHead">
                                    <?php if ($i_iconss != ''): ?>
                                        <i class="<?php echo esc_attr($i_iconss); ?>"></i>
                                    <?php endif; ?>
                                    <h5>
                                        <?php if ($i_labels != ''): ?><?php echo wp_kses_post($i_labels); ?><?php endif; ?>
                                        <?php if ($i_values != ''): ?><span><?php echo wp_kses_post($i_values); ?></span><?php endif; ?>
                                    </h5>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header End -->
<?php endif; ?>

<?php if ($is_serch == 'yes'): ?>
<!-- Search Popup Start -->
<section class="popup_search_sec">
    <div class="popup_search_overlay"></div>
    <div class="pop_search_background">
        <div class="middle_search">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 text-center">
                        <div class="popup_search_form">
                            <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                                <input type="search" name="s" value="<?php echo get_search_query(); ?>" placeholder="<?php echo esc_attr_x( 'Type Words and Hit Enter', 'placeholder', 'themewar' ); ?>">
                                <button type="submit"><i class="twi-search1"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Search Popup End -->
<?php endif; ?>