<?php
/**
 * @Packge     : consua
 * @Version    : 1.0
 * @Author     : consua
 * @Author URI : https://themeforest.net/user/validthemes/portfolio
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }
    consua_setPostViews( get_the_ID() );
    ?>
    <div <?php post_class(); ?> >
        <div class="blog-item-box">
        <?php
            if( class_exists('ReduxFramework') ) {
                $consua_post_details_title_position = consua_opt('consua_post_details_title_position');
            } else {
                $consua_post_details_title_position = 'header';
            }

            $allowhtml = array(
                'p'         => array(
                    'class'     => array()
                ),
                'span'      => array(),
                'a'         => array(
                    'href'      => array(),
                    'title'     => array()
                ),
                'br'        => array(),
                'em'        => array(),
                'strong'    => array(),
                'b'         => array(),
            );

            // Blog Post Thumbnail
            do_action( 'consua_blog_post_thumb' );

            if( $consua_post_details_title_position != 'header' ) {
                echo '<h3>'.wp_kses( get_the_title(), $allowhtml ).'</h3>';
            }
            echo '<div class="info">';
                // Blog Post Meta
                do_action( 'consua_blog_post_meta' );

                if( get_the_content() ){
                    echo '<div class="blog-content">';
                        the_content();
                        // Link Pages
                        consua_link_pages();
                    echo '</div>';
                }
            echo '</div>';        
        echo '</div>';
    echo '</div>';
    /**
    *
    * Hook for Blog Details Author Bio
    *
    * Hook consua_blog_details_author_bio
    *
    * @Hooked consua_blog_details_author_bio_cb 10
    *
    */
    do_action( 'consua_blog_details_author_bio' );

    $consua_post_tag = get_the_tags();
    if( class_exists('ReduxFramework') ) {
        $consua_post_details_share_options = consua_opt('consua_post_details_share_options');
        $consua_show_post_tag = consua_opt( 'consua_display_post_tags' );
    } else {
        $consua_show_post_tag = true;
        $consua_post_details_share_options = false;
    }

    if( ! empty( $consua_post_tag ) && $consua_show_post_tag || $consua_post_details_share_options ){
        echo '<div class="post-tags share">';
            if( $consua_show_post_tag  && is_array( $consua_post_tag ) && ! empty( $consua_post_tag ) ){
                if( count( $consua_post_tag ) > 1 ){
                    $tag_text = __( 'Tags: ', 'consua' );
                }else{
                    $tag_text = __( 'Tag: ', 'consua' );
                }
                echo '<div class="tags">';
                    echo '<h4>'.esc_html( $tag_text ).'</h4>';
                    foreach( $consua_post_tag as $tags ){
                        echo '<a href="'.esc_url( get_tag_link( $tags->term_id ) ).'">'.esc_html( $tags->name ).'</a> ';
                    }
                echo '</div>';
            }
            /**
            *
            * Hook for Blog Social Share Options
            *
            * Hook consua_blog_details_share_options
            *
            * @Hooked consua_blog_details_share_options_cb 10
            *
            */
            do_action( 'consua_blog_details_share_options' );
            
        echo '</div>';
        
    }

    /**
    *
    * Hook for Blog Navigation
    *
    * Hook consua_blog_details_post_navigation
    *
    * @Hooked consua_blog_details_post_navigation_cb 10
    *
    */
    do_action( 'consua_blog_details_post_navigation' );

    /**
    *
    * Hook for Blog Details Comments
    *
    * Hook consua_blog_details_comments
    *
    * @Hooked consua_blog_details_comments_cb 10
    *
    */
    do_action( 'consua_blog_details_comments' );