<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.8.0
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;

$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters(
	'woocommerce_single_product_image_gallery_classes',
	array(
		'woocommerce-product-gallery',
		'woocommerce-product-gallery--' . ( $product->get_image_id() ? 'with-images' : 'without-images' ),
		'woocommerce-product-gallery--columns-' . absint( $columns ),
		'images',
	)
);
$attachment_ids = $product->get_gallery_image_ids();
$gallery_status = (empty($attachment_ids) ? 1 : 2);
if(has_post_thumbnail() && empty($attachment_ids)):
    array_unshift($attachment_ids, $post_thumbnail_id);
endif;


echo '<div class="proSliderWrapper">';
    echo bepro_product_flash_notice_label();
    echo '<div class="productSlide">';
    foreach($attachment_ids as $attachment_id):
        if($attachment_id > 0):
            ?>
            <div class="sp_img"> 
                <img src="<?php echo bepro_attachment_url($attachment_id, 638, 543) ?>" alt="<?php echo esc_attr__('Gallery Image', 'bepro') ?>" />
            </div>
            <?php 
        endif;
    endforeach;
    echo '</div>';
    echo '<ul class="indicator_slider">';
    foreach($attachment_ids as $attachment_id):
        if($attachment_id > 0):
            ?>
            <li role="presentation"> 
                <div class="idItem">
                    <img src="<?php echo bepro_attachment_url($attachment_id, 72, 72) ?>" alt="<?php echo esc_attr__('Gallery Image', 'bepro') ?>" />
                </div>
            </li>
            <?php 
        endif;
    endforeach;
    echo '</ul>';
echo '</div>';
