<?php
/**
 * Product quantity inputs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/quantity-input.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.8.0
 */

defined('ABSPATH') || exit;


/* translators: %s: Quantity. */
$label = !empty($args['product_name']) ? sprintf(esc_html__('%s quantity', 'bepro'), wp_strip_all_tags($args['product_name'])) : esc_html__('Quantity', 'bepro');
?>
<div class="quantity quantityd clearfix">
    <?php do_action('woocommerce_before_quantity_input_field'); ?>
    <div class="pdq_main">
        <button type="button" class="minus qtyBtn btnMinus"><?php echo esc_html__('-', 'bepro'); ?></button>
        <input
                type="number"
                id="<?php echo esc_attr($input_id); ?>"
                class="carqty <?php echo esc_attr(join(' ', (array)$classes)); ?>"
                step="<?php echo esc_attr($step); ?>"
                min="<?php echo esc_attr($min_value); ?>"
                max="<?php echo esc_attr(0 < $max_value ? $max_value : ''); ?>"
                name="<?php echo esc_attr($input_name); ?>"
                value="<?php echo esc_attr($input_value); ?>"
                title="<?php echo esc_attr_x('Qty', 'Product quantity input tooltip', 'timrota'); ?>"
                size="4"
                placeholder="<?php echo esc_attr($placeholder); ?>"
                inputmode="<?php echo esc_attr($inputmode); ?>"
                autocomplete="<?php echo esc_attr(isset($autocomplete) ? $autocomplete : 'on'); ?>"
        />
        <button type="button" class="plus qtyBtn btnPlus"><?php echo esc_html__('+', 'bepro'); ?></button>
    </div>
    <?php do_action('woocommerce_after_quantity_input_field'); ?>
</div>

