<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

// Ensure visibility.
if (empty($product) || !$product->is_visible()) {
    return;
}
$shop_sidebar = get_theme_mod('shop_sidebar', 1);
$shop_is_flashlabels = get_theme_mod('shop_is_flashlabels', FALSE);
$shop_is_wishlist = get_theme_mod('shop_is_wishlist', FALSE);

$colmns = ($shop_sidebar == 1 || !is_active_sidebar('sidebar-3') ? 'col-xl-3 col-lg-4 col-md-6' : 'col-xl-4 col-lg-6 col-md-6');

?>
<div class="<?php echo esc_attr($colmns); ?>">
    <div <?php wc_product_class('bepro_product_wrapper', $product); ?>>
        <div class="productItem01">
            <div class="proThumb">
                <img src="<?php echo bepro_post_thumbnail(get_the_ID(), 282, 287); ?>" alt="<?php the_title_attribute() ?>">
                <?php echo(function_exists('bepro_product_flash_notice_label') && $shop_is_flashlabels ? bepro_product_flash_notice_label() : '') ?>
                <div class="piActionBtns">
                    <?php if (shortcode_exists('yith_wcwl_add_to_wishlist') && $shop_is_wishlist): ?>
                        <?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
                    <?php endif; ?>
                    <?php function_exists('bepro_add_to_cart') ? bepro_add_to_cart() : '' ?>
                    <a class="quickview" href="<?php echo get_the_permalink() ?>"><i class="bpro-search-icon"></i></a>
                </div>
            </div>
            <div class="product_content">
                <div class="ratings">
                    <?php if (function_exists('woocommerce_template_loop_rating')): ?>
                        <?php echo woocommerce_template_loop_rating(); ?>
                    <?php endif; ?>
                </div>
                <h3><a href="<?php echo get_the_permalink() ?>"><?php echo get_the_title() ?></a></h3>
                <div class="pi01Price">
                    <?php echo bepro_kses($product->get_price_html()); ?>
                </div>
            </div>
        </div>
    </div>
</div>
